/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.utils;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public final class FormationTypes {
    public static final String NONE = "none";
    public static final String DEFAULT_FORMATION = "tight";
    private static final Set<String> SUPPORTED_FORMATIONS;

    private FormationTypes() {
    }

    public static Set<String> getAll() {
        return SUPPORTED_FORMATIONS;
    }

    public static boolean isValid(String formationId) {
        return formationId != null && SUPPORTED_FORMATIONS.contains(formationId);
    }

    public static String sanitize(String formationId) {
        if (formationId == null) {
            return DEFAULT_FORMATION;
        }
        return FormationTypes.isValid(formationId) ? formationId : DEFAULT_FORMATION;
    }

    public static String sanitizeNonNone(String formationId) {
        String sanitized = FormationTypes.sanitize(formationId);
        return NONE.equals(sanitized) ? DEFAULT_FORMATION : sanitized;
    }

    public static boolean isActive(String formationId) {
        return !NONE.equals(formationId);
    }

    static {
        LinkedHashSet<String> formations = new LinkedHashSet<String>();
        formations.add(NONE);
        formations.add(DEFAULT_FORMATION);
        formations.add("loose");
        formations.add("line");
        formations.add("circle");
        formations.add("wedge");
        SUPPORTED_FORMATIONS = Collections.unmodifiableSet(formations);
    }
}

