/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import ydmsama.hundred_years_war.main.utils.RelationData;

public class TeamRelationData
extends RelationData {
    private String teamName;
    private final Map<UUID, MemberType> members = new HashMap<UUID, MemberType>();
    private final Set<UUID> pendingApplications = new HashSet<UUID>();

    public TeamRelationData(UUID uuid, String teamName) {
        super(uuid);
        this.teamName = teamName;
    }

    public String getTeamName() {
        return this.teamName;
    }

    public void setTeamName(String teamName) {
        this.teamName = teamName;
    }

    public void addMember(UUID playerUuid, MemberType memberType) {
        this.members.put(playerUuid, memberType);
        this.pendingApplications.remove(playerUuid);
    }

    public boolean removeMember(UUID playerUuid) {
        return this.members.remove(playerUuid) != null;
    }

    public boolean updateMemberType(UUID playerUuid, MemberType memberType) {
        if (this.members.containsKey(playerUuid)) {
            this.members.put(playerUuid, memberType);
            return true;
        }
        return false;
    }

    public MemberType getMemberType(UUID playerUuid) {
        return this.members.get(playerUuid);
    }

    public boolean isMember(UUID playerUuid) {
        return this.members.containsKey(playerUuid);
    }

    public Map<UUID, MemberType> getAllMembers() {
        return Collections.unmodifiableMap(this.members);
    }

    public List<UUID> getMembersByType(MemberType type) {
        ArrayList<UUID> result = new ArrayList<UUID>();
        for (Map.Entry<UUID, MemberType> entry : this.members.entrySet()) {
            if (entry.getValue() != type) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    public List<UUID> getOwners() {
        return this.getMembersByType(MemberType.OWNER);
    }

    public List<UUID> getAdmins() {
        return this.getMembersByType(MemberType.ADMIN);
    }

    public boolean addApplication(UUID playerUuid) {
        if (this.isMember(playerUuid)) {
            return false;
        }
        return this.pendingApplications.add(playerUuid);
    }

    public boolean removeApplication(UUID playerUuid) {
        return this.pendingApplications.remove(playerUuid);
    }

    public boolean approveApplication(UUID playerUuid, MemberType memberType) {
        if (this.pendingApplications.contains(playerUuid)) {
            this.pendingApplications.remove(playerUuid);
            return true;
        }
        return false;
    }

    public boolean rejectApplication(UUID playerUuid) {
        return this.pendingApplications.remove(playerUuid);
    }

    public boolean hasApplication(UUID playerUuid) {
        return this.pendingApplications.contains(playerUuid);
    }

    public Set<UUID> getPendingApplications() {
        return Collections.unmodifiableSet(this.pendingApplications);
    }

    @Override
    public class_2487 saveToNbt() {
        class_2487 tag = new class_2487();
        tag.method_10582("UUID", this.uuid.toString());
        tag.method_10582("TeamName", this.teamName);
        class_2499 membersTag = new class_2499();
        for (Map.Entry<UUID, MemberType> entry : this.members.entrySet()) {
            class_2487 memberTag = new class_2487();
            memberTag.method_10582("UUID", entry.getKey().toString());
            memberTag.method_10582("Type", entry.getValue().name());
            membersTag.add((Object)memberTag);
        }
        tag.method_10566("Members", (class_2520)membersTag);
        class_2499 applicationsTag = new class_2499();
        for (UUID applicantUuid : this.pendingApplications) {
            applicationsTag.add((Object)class_2519.method_23256((String)applicantUuid.toString()));
        }
        tag.method_10566("Applications", (class_2520)applicationsTag);
        return tag;
    }

    @Override
    public void loadFromNbt(class_2487 tag) {
        int i;
        this.teamName = tag.method_10558("TeamName");
        this.members.clear();
        this.pendingApplications.clear();
        if (tag.method_10545("Members")) {
            class_2499 membersTag = tag.method_10554("Members", 10);
            for (i = 0; i < membersTag.size(); ++i) {
                class_2487 memberTag = membersTag.method_10602(i);
                UUID memberUuid = UUID.fromString(memberTag.method_10558("UUID"));
                MemberType memberType = MemberType.valueOf(memberTag.method_10558("Type"));
                this.members.put(memberUuid, memberType);
            }
        }
        if (tag.method_10545("Applications")) {
            class_2499 applicationsTag = tag.method_10554("Applications", 8);
            for (i = 0; i < applicationsTag.size(); ++i) {
                UUID applicantUuid = UUID.fromString(applicationsTag.method_10608(i));
                this.pendingApplications.add(applicantUuid);
            }
        }
    }

    public static enum MemberType {
        OWNER,
        ADMIN,
        MEMBER;

    }
}

