/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.zombierush.entity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.mcreator.zombierush.ElementsZombieRushMod;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ElementsZombieRushMod.ModElement.Tag
public class EntityElectroZombie
extends ElementsZombieRushMod.ModElement {
    public static final int ENTITYID = 14;
    public static final int ENTITYID_RANGED = 15;

    public EntityElectroZombie(ElementsZombieRushMod instance) {
        super(instance, 11);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EntityCustom.class).id(new ResourceLocation("zombie_rush", "electro_zombie"), 14).name("electro_zombie").tracker(64, 3, true).egg(-3381760, -13408768).build());
    }

    @Override
    public void init(FMLInitializationEvent event) {
        Biome[] spawnBiomes = this.allbiomes((RegistryNamespaced<ResourceLocation, Biome>)Biome.field_185377_q);
        EntityRegistry.addSpawn(EntityCustom.class, (int)10, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])spawnBiomes);
    }

    private Biome[] allbiomes(RegistryNamespaced<ResourceLocation, Biome> in) {
        Iterator itr = in.iterator();
        ArrayList ls = new ArrayList();
        while (itr.hasNext()) {
            ls.add(itr.next());
        }
        return ls.toArray(new Biome[ls.size()]);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInit(FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EntityCustom.class, renderManager -> new RenderLiving(renderManager, new ModelzombieElectro(), 0.5f){

            protected ResourceLocation func_110775_a(Entity entity) {
                return new ResourceLocation("zombie_rush:textures/zombie_elektro.png");
            }
        });
    }

    public static class ModelzombieElectro
    extends ModelBase {
        private final ModelRenderer Waist;
        private final ModelRenderer Head;
        private final ModelRenderer cube_r1;
        private final ModelRenderer cube_r2;
        private final ModelRenderer Body;
        private final ModelRenderer RightArm;
        private final ModelRenderer LeftArm;
        private final ModelRenderer RightLeg;
        private final ModelRenderer LeftLeg;
        private final ModelRenderer cube_r3;
        private final ModelRenderer cube_r4;

        public ModelzombieElectro() {
            this.field_78090_t = 64;
            this.field_78089_u = 64;
            this.Waist = new ModelRenderer((ModelBase)this);
            this.Waist.func_78793_a(0.0f, 12.0f, 0.0f);
            this.Head = new ModelRenderer((ModelBase)this);
            this.Head.func_78793_a(0.0f, -12.0f, 0.0f);
            this.Waist.func_78792_a(this.Head);
            this.Head.field_78804_l.add(new ModelBox(this.Head, 0, 0, -4.0f, -8.0f, -4.0f, 8, 8, 8, 0.0f, false));
            this.Head.field_78804_l.add(new ModelBox(this.Head, 14, 38, -4.0f, -5.0f, -4.25f, 8, 2, 1, 0.0f, false));
            this.Head.field_78804_l.add(new ModelBox(this.Head, 3, 24, 1.0f, -5.0f, -5.25f, 2, 2, 1, 0.0f, false));
            this.Head.field_78804_l.add(new ModelBox(this.Head, 8, 24, -3.0f, -5.0f, -5.25f, 2, 2, 1, 0.0f, false));
            this.Head.field_78804_l.add(new ModelBox(this.Head, 26, 33, -4.0f, -8.0f, -4.0f, 0, 2, 8, 0.0f, false));
            this.Head.field_78804_l.add(new ModelBox(this.Head, 27, 42, -4.0f, -5.0f, 3.25f, 8, 2, 1, 0.0f, false));
            this.Head.field_78804_l.add(new ModelBox(this.Head, 0, 34, -4.0f, -9.0f, -4.0f, 8, 2, 8, 0.0f, false));
            this.Head.field_78804_l.add(new ModelBox(this.Head, 54, 37, -0.5f, -13.0f, -0.5f, 1, 4, 1, 0.0f, false));
            this.Head.field_78804_l.add(new ModelBox(this.Head, 24, 37, -1.0f, -15.0f, -1.0f, 2, 2, 2, 0.0f, false));
            this.Head.field_78804_l.add(new ModelBox(this.Head, 0, 42, -4.0f, -5.0f, -4.0f, 0, 2, 8, 0.0f, false));
            this.Head.field_78804_l.add(new ModelBox(this.Head, 30, 40, -4.0f, -8.0f, -4.25f, 8, 2, 1, 0.0f, false));
            this.Head.field_78804_l.add(new ModelBox(this.Head, 22, 41, -4.0f, -8.0f, 3.25f, 8, 2, 1, 0.0f, false));
            this.cube_r1 = new ModelRenderer((ModelBase)this);
            this.cube_r1.func_78793_a(5.0f, -8.0f, -3.0f);
            this.Head.func_78792_a(this.cube_r1);
            this.setRotationAngle(this.cube_r1, 0.0f, 0.0f, -3.1416f);
            this.cube_r1.field_78804_l.add(new ModelBox(this.cube_r1, 24, 30, 1.0f, -2.0f, -1.0f, 0, 2, 8, 0.0f, false));
            this.cube_r2 = new ModelRenderer((ModelBase)this);
            this.cube_r2.func_78793_a(5.0f, -5.0f, -3.0f);
            this.Head.func_78792_a(this.cube_r2);
            this.setRotationAngle(this.cube_r2, 0.0f, 0.0f, -3.1416f);
            this.cube_r2.field_78804_l.add(new ModelBox(this.cube_r2, 39, 34, 1.0f, -2.0f, -1.0f, 0, 2, 8, 0.0f, false));
            this.Body = new ModelRenderer((ModelBase)this);
            this.Body.func_78793_a(0.0f, -12.0f, 0.0f);
            this.Waist.func_78792_a(this.Body);
            this.Body.field_78804_l.add(new ModelBox(this.Body, 16, 16, -4.0f, 0.0f, -2.0f, 8, 12, 4, 0.0f, false));
            this.Body.field_78804_l.add(new ModelBox(this.Body, 1, 38, -4.0f, 2.0f, -3.0f, 8, 10, 1, 0.0f, false));
            this.Body.field_78804_l.add(new ModelBox(this.Body, 1, 34, -4.0f, 0.0f, 2.0f, 8, 10, 4, 0.0f, false));
            this.Body.field_78804_l.add(new ModelBox(this.Body, 25, 41, -4.0f, 0.0f, -3.0f, 2, 2, 1, 0.0f, false));
            this.Body.field_78804_l.add(new ModelBox(this.Body, 25, 41, 2.0f, 0.0f, -3.0f, 2, 2, 1, 0.0f, false));
            this.RightArm = new ModelRenderer((ModelBase)this);
            this.RightArm.func_78793_a(-5.0f, -10.0f, 0.0f);
            this.Waist.func_78792_a(this.RightArm);
            this.RightArm.field_78804_l.add(new ModelBox(this.RightArm, 40, 16, -3.0f, -2.0f, -2.0f, 4, 12, 4, 0.0f, false));
            this.RightArm.field_78804_l.add(new ModelBox(this.RightArm, 12, 36, -4.0f, -3.0f, -3.0f, 5, 1, 6, 0.0f, false));
            this.LeftArm = new ModelRenderer((ModelBase)this);
            this.LeftArm.func_78793_a(5.0f, -10.0f, 0.0f);
            this.Waist.func_78792_a(this.LeftArm);
            this.LeftArm.field_78804_l.add(new ModelBox(this.LeftArm, 32, 48, -1.0f, -2.0f, -2.0f, 4, 12, 4, 0.0f, false));
            this.LeftArm.field_78804_l.add(new ModelBox(this.LeftArm, 0, 37, -1.0f, -3.0f, -3.0f, 5, 1, 6, 0.0f, false));
            this.RightLeg = new ModelRenderer((ModelBase)this);
            this.RightLeg.func_78793_a(-1.9f, 12.0f, 0.0f);
            this.RightLeg.field_78804_l.add(new ModelBox(this.RightLeg, 0, 16, -2.0f, 0.0f, -2.0f, 4, 12, 4, 0.0f, false));
            this.RightLeg.field_78804_l.add(new ModelBox(this.RightLeg, 24, 41, -1.6f, 5.0f, -3.0f, 3, 2, 1, 0.0f, false));
            this.RightLeg.field_78804_l.add(new ModelBox(this.RightLeg, 15, 39, -2.1f, 5.0f, -2.25f, 4, 2, 0, 0.0f, false));
            this.RightLeg.field_78804_l.add(new ModelBox(this.RightLeg, 3, 45, -2.1f, 5.0f, -2.25f, 0, 2, 5, 0.0f, false));
            this.RightLeg.field_78804_l.add(new ModelBox(this.RightLeg, 15, 39, -2.1f, 5.0f, 2.0f, 4, 2, 0, 0.0f, false));
            this.LeftLeg = new ModelRenderer((ModelBase)this);
            this.LeftLeg.func_78793_a(1.9f, 12.0f, 0.0f);
            this.LeftLeg.field_78804_l.add(new ModelBox(this.LeftLeg, 16, 48, -2.0f, 0.0f, -2.0f, 4, 12, 4, 0.0f, false));
            this.LeftLeg.field_78804_l.add(new ModelBox(this.LeftLeg, 24, 41, -1.65f, 5.0f, -3.0f, 3, 2, 1, 0.0f, false));
            this.LeftLeg.field_78804_l.add(new ModelBox(this.LeftLeg, 15, 39, -1.9f, 5.0f, -2.25f, 4, 2, 0, 0.0f, false));
            this.LeftLeg.field_78804_l.add(new ModelBox(this.LeftLeg, 3, 45, 2.1f, 5.0f, -2.25f, 0, 2, 5, 0.0f, false));
            this.LeftLeg.field_78804_l.add(new ModelBox(this.LeftLeg, 15, 39, -1.9f, 5.0f, 2.0f, 4, 2, 0, 0.0f, false));
            this.cube_r3 = new ModelRenderer((ModelBase)this);
            this.cube_r3.func_78793_a(-0.65f, 5.0f, -1.25f);
            this.LeftLeg.func_78792_a(this.cube_r3);
            this.setRotationAngle(this.cube_r3, 0.0f, 0.0f, -3.1416f);
            this.cube_r3.field_78804_l.add(new ModelBox(this.cube_r3, 3, 45, 1.0f, -2.0f, -1.0f, 0, 2, 5, 0.0f, false));
            this.cube_r4 = new ModelRenderer((ModelBase)this);
            this.cube_r4.func_78793_a(-1.15f, 5.0f, -1.25f);
            this.LeftLeg.func_78792_a(this.cube_r4);
            this.setRotationAngle(this.cube_r4, 0.0f, 0.0f, -3.1416f);
            this.cube_r4.field_78804_l.add(new ModelBox(this.cube_r4, 3, 45, 1.0f, -2.0f, -1.0f, 0, 2, 5, 0.0f, false));
        }

        public void func_78088_a(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
            this.Waist.func_78785_a(f5);
            this.RightLeg.func_78785_a(f5);
            this.LeftLeg.func_78785_a(f5);
        }

        public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
            modelRenderer.field_78795_f = x;
            modelRenderer.field_78796_g = y;
            modelRenderer.field_78808_h = z;
        }

        public void func_78087_a(float f, float f1, float f2, float f3, float f4, float f5, Entity e) {
            super.func_78087_a(f, f1, f2, f3, f4, f5, e);
            this.RightArm.field_78795_f = MathHelper.func_76134_b((float)(f * 0.6662f + (float)Math.PI)) * f1;
            this.LeftLeg.field_78795_f = MathHelper.func_76134_b((float)(f * 1.0f)) * -1.0f * f1;
            this.Head.field_78796_g = f3 / 57.295776f;
            this.Head.field_78795_f = f4 / 57.295776f;
            this.LeftArm.field_78795_f = MathHelper.func_76134_b((float)(f * 0.6662f)) * f1;
            this.RightLeg.field_78795_f = MathHelper.func_76134_b((float)(f * 1.0f)) * 1.0f * f1;
        }
    }

    public static class EntityCustom
    extends EntityZombie {
        private int lightningCooldown = 0;
        private static final int LIGHTNING_COOLDOWN_MAX = 60;
        private static final double LIGHTNING_RANGE = 8.0;
        private static final float EXPLOSION_POWER = 2.0f;

        public EntityCustom(World world) {
            super(world);
            this.func_70105_a(0.6f, 1.8f);
            this.field_70728_aV = 5;
            this.field_70178_ae = false;
            this.func_94061_f(false);
            this.func_82227_f(false);
            this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(Items.field_151078_bh, 1));
            this.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(Items.field_151137_ax, 1));
            this.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack(Items.field_151078_bh, 1));
            this.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack(Items.field_151078_bh, 1));
        }

        protected void func_184651_r() {
            super.func_184651_r();
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.2, false){

                protected double func_179512_a(EntityLivingBase entity) {
                    return this.field_75441_b.field_70130_N * this.field_75441_b.field_70130_N + entity.field_70130_N;
                }
            });
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
            this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        }

        public void func_70636_d() {
            double distance;
            EntityLivingBase target;
            super.func_70636_d();
            if (this.lightningCooldown > 0) {
                --this.lightningCooldown;
            }
            if ((target = this.func_70638_az()) != null && !this.field_70170_p.field_72995_K && (distance = (double)this.func_70032_d((Entity)target)) <= 8.0 && this.lightningCooldown <= 0) {
                this.performLightningAttack();
                this.lightningCooldown = 60;
            }
        }

        private void performLightningAttack() {
            EntityLightningBolt lightning = new EntityLightningBolt(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, false);
            this.field_70170_p.func_72942_c((Entity)lightning);
            this.spawnLightningParticles();
            this.field_70170_p.func_184133_a(null, this.func_180425_c(), SoundEvents.field_187754_de, SoundCategory.HOSTILE, 1.0f, 1.0f);
            this.field_70170_p.func_184133_a(null, this.func_180425_c(), SoundEvents.field_187752_dd, SoundCategory.HOSTILE, 1.0f, 1.0f);
            this.createShockwave();
        }

        private void spawnLightningParticles() {
            for (int i = 0; i < 50; ++i) {
                double offsetX = (this.field_70146_Z.nextDouble() - 0.5) * 4.0;
                double offsetY = this.field_70146_Z.nextDouble() * 4.0;
                double offsetZ = (this.field_70146_Z.nextDouble() - 0.5) * 4.0;
                this.field_70170_p.func_175688_a(EnumParticleTypes.CRIT_MAGIC, this.field_70165_t + offsetX, this.field_70163_u + offsetY, this.field_70161_v + offsetZ, 0.0, 0.1, 0.0, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + offsetX * 0.5, this.field_70163_u + offsetY * 0.5, this.field_70161_v + offsetZ * 0.5, 0.0, 0.05, 0.0, new int[0]);
            }
        }

        private void createShockwave() {
            List entities = this.field_70170_p.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(this.field_70165_t - 8.0, this.field_70163_u - 2.0, this.field_70161_v - 8.0, this.field_70165_t + 8.0, this.field_70163_u + 4.0, this.field_70161_v + 8.0));
            for (EntityLivingBase entity : entities) {
                if (entity == this) continue;
                Vec3d direction = new Vec3d(entity.field_70165_t - this.field_70165_t, entity.field_70163_u - this.field_70163_u, entity.field_70161_v - this.field_70161_v).func_72432_b();
                double knockbackStrength = 2.0 * (1.0 - (double)this.func_70032_d((Entity)entity) / 8.0);
                entity.field_70159_w += direction.field_72450_a * knockbackStrength;
                entity.field_70181_x += direction.field_72448_b * knockbackStrength + 0.3;
                entity.field_70179_y += direction.field_72449_c * knockbackStrength;
                if (entity instanceof EntityPlayer || entity instanceof EntityZombie && !(entity instanceof EntityCustom)) {
                    entity.func_70097_a(DamageSource.field_76376_m, 3.0f);
                }
                this.spawnShockwaveParticles(entity);
            }
            this.spawnShockwaveRingParticles();
        }

        private void spawnShockwaveParticles(EntityLivingBase entity) {
            if (this.field_70170_p.field_72995_K) {
                for (int i = 0; i < 10; ++i) {
                    double offsetX = (this.field_70146_Z.nextDouble() - 0.5) * (double)entity.field_70130_N;
                    double offsetY = this.field_70146_Z.nextDouble() * (double)entity.field_70131_O;
                    double offsetZ = (this.field_70146_Z.nextDouble() - 0.5) * (double)entity.field_70130_N;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, entity.field_70165_t + offsetX, entity.field_70163_u + offsetY, entity.field_70161_v + offsetZ, 0.0, 0.1, 0.0, new int[0]);
                    this.field_70170_p.func_175688_a(EnumParticleTypes.CRIT, entity.field_70165_t + offsetX, entity.field_70163_u + offsetY, entity.field_70161_v + offsetZ, (this.field_70146_Z.nextDouble() - 0.5) * 0.5, 0.2, (this.field_70146_Z.nextDouble() - 0.5) * 0.5, new int[0]);
                }
            }
        }

        private void spawnShockwaveRingParticles() {
            int i;
            int particlesCount = 30;
            for (i = 0; i < particlesCount; ++i) {
                double angle = Math.PI * 2 * (double)i / (double)particlesCount;
                double radius = 8.0;
                double particleX = this.field_70165_t + Math.cos(angle) * radius;
                double particleZ = this.field_70161_v + Math.sin(angle) * radius;
                this.field_70170_p.func_175688_a(EnumParticleTypes.CLOUD, particleX, this.field_70163_u + 0.5, particleZ, 0.0, 0.2, 0.0, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, particleX, this.field_70163_u + 0.2, particleZ, Math.cos(angle) * 0.1, 0.1, Math.sin(angle) * 0.1, new int[0]);
            }
            for (i = 0; i < 15; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 2.0, this.field_70163_u + this.field_70146_Z.nextDouble() * 2.0, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 2.0, 0.0, 0.1, 0.0, new int[0]);
            }
        }

        public boolean func_70601_bi() {
            if (!this.field_70170_p.func_72911_I()) {
                return false;
            }
            return super.func_70601_bi();
        }

        public boolean func_70631_g_() {
            return false;
        }

        public void func_82227_f(boolean childZombie) {
            super.func_82227_f(false);
        }

        public EnumCreatureAttribute func_70668_bt() {
            return EnumCreatureAttribute.UNDEAD;
        }

        protected Item func_146068_u() {
            return new ItemStack(Items.field_151078_bh, 1).func_77973_b();
        }

        public SoundEvent func_184639_G() {
            return (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("entity.zombie.ambient"));
        }

        public SoundEvent func_184601_bQ(DamageSource ds) {
            return (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("entity.zombie.hurt"));
        }

        public SoundEvent func_184615_bR() {
            return (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("entity.zombie.death"));
        }

        protected float func_70599_aP() {
            return 1.0f;
        }

        public boolean func_70097_a(DamageSource source, float amount) {
            if (source == DamageSource.field_180137_b) {
                return false;
            }
            return super.func_70097_a(source, amount);
        }

        protected void func_110147_ax() {
            super.func_110147_ax();
            if (this.func_110148_a(SharedMonsterAttributes.field_188791_g) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(9.0);
            }
            if (this.func_110148_a(SharedMonsterAttributes.field_111263_d) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
            }
            if (this.func_110148_a(SharedMonsterAttributes.field_111267_a) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
            }
            if (this.func_110148_a(SharedMonsterAttributes.field_111264_e) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
            }
        }
    }
}

