/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.zombierush.entity;

import net.mcreator.zombierush.ElementsZombieRushMod;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ElementsZombieRushMod.ModElement.Tag
public class EntityGoroshena
extends ElementsZombieRushMod.ModElement {
    public static final int ENTITYID = 131;

    public EntityGoroshena(ElementsZombieRushMod instance) {
        super(instance, 62);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EntityCustom.class).id(new ResourceLocation("zombie_rush", "goroshena"), 131).name("goroshena").tracker(64, 3, true).egg(-16724992, -16724992).build());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInit(FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EntityCustom.class, renderManager -> new RenderLiving(renderManager, new Modelgoroshena(), 0.5f){

            protected ResourceLocation func_110775_a(Entity entity) {
                return new ResourceLocation("zombie_rush:textures/ghoroshiena.png");
            }
        });
    }

    public static class Modelgoroshena
    extends ModelBase {
        private final ModelRenderer Waist;
        private final ModelRenderer Body;

        public Modelgoroshena() {
            this.field_78090_t = 10;
            this.field_78089_u = 10;
            this.Waist = new ModelRenderer((ModelBase)this);
            this.Waist.func_78793_a(0.0f, 12.0f, 0.0f);
            this.Body = new ModelRenderer((ModelBase)this);
            this.Body.func_78793_a(0.0f, -12.0f, 0.0f);
            this.Waist.func_78792_a(this.Body);
            this.Body.field_78804_l.add(new ModelBox(this.Body, 0, 0, -5.0f, 4.0f, 0.0f, 10, 9, 0, 0.0f, false));
        }

        public void func_78088_a(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
            this.Waist.func_78785_a(f5);
        }

        public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
            modelRenderer.field_78795_f = x;
            modelRenderer.field_78796_g = y;
            modelRenderer.field_78808_h = z;
        }

        public void func_78087_a(float f, float f1, float f2, float f3, float f4, float f5, Entity e) {
            super.func_78087_a(f, f1, f2, f3, f4, f5, e);
        }
    }

    public static class EntityCustom
    extends EntityMob {
        private EntityLivingBase target;
        private int flightTimer = 100;
        private float flySpeed = 1.2f;
        private boolean hasHit = false;

        public EntityCustom(World world) {
            super(world);
            this.func_70105_a(0.6f, 1.8f);
            this.field_70178_ae = false;
            this.field_70728_aV = 0;
        }

        protected void func_184651_r() {
        }

        public void func_70071_h_() {
            this.func_70030_z();
            if (!this.field_70170_p.field_72995_K) {
                this.func_189654_d(true);
            }
            this.field_70143_R = 0.0f;
            if (this.field_70170_p.field_72995_K) {
                this.spawnFlightParticles();
            }
            if (this.hasHit) {
                return;
            }
            if (this.target == null || !this.target.func_70089_S() || this.target.func_70032_d((Entity)this) > 30.0f) {
                this.findTarget();
            }
            if (this.target != null && this.target.func_70089_S()) {
                this.moveTowardsTarget();
            } else {
                this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) * this.flySpeed;
                this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * this.flySpeed;
            }
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            if (!this.field_70170_p.field_72995_K) {
                --this.flightTimer;
                if (this.flightTimer <= 0) {
                    this.func_70106_y();
                    return;
                }
            }
            if (!this.field_70170_p.field_72995_K && (this.field_70123_F || this.field_70124_G)) {
                this.onHit();
                return;
            }
            if (!this.field_70170_p.field_72995_K && this.target != null && this.target.func_70089_S() && this.target.func_70032_d((Entity)this) < 2.0f) {
                this.onHitTarget();
                return;
            }
        }

        public void func_70100_b_(EntityPlayer player) {
            if (!this.field_70170_p.field_72995_K && !this.hasHit) {
                this.onHitTarget();
            }
        }

        private void findTarget() {
            this.target = this.field_70170_p.func_184142_a((Entity)this, 25.0, 25.0);
        }

        private void moveTowardsTarget() {
            double dz;
            double dx = this.target.field_70165_t - this.field_70165_t;
            double dy = this.target.field_70163_u + (double)this.target.func_70047_e() * 0.5 - (this.field_70163_u + (double)this.func_70047_e());
            double distance = MathHelper.func_76133_a((double)(dx * dx + dy * dy + (dz = this.target.field_70161_v - this.field_70161_v) * dz));
            if (distance > 0.0) {
                dx /= distance;
                dy /= distance;
                dz /= distance;
            }
            this.field_70159_w = dx * (double)this.flySpeed;
            this.field_70181_x = dy * (double)this.flySpeed;
            this.field_70179_y = dz * (double)this.flySpeed;
            if (distance > 0.1) {
                this.field_70177_z = (float)(MathHelper.func_181159_b((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
            }
        }

        private void onHitTarget() {
            if (this.hasHit) {
                return;
            }
            this.hasHit = true;
            if (!this.field_70170_p.field_72995_K) {
                if (this.target != null && this.target.func_70089_S()) {
                    this.target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 5.0f);
                }
                this.spawnHitParticles();
                this.func_70106_y();
            }
        }

        private void onHit() {
            if (this.hasHit) {
                return;
            }
            this.hasHit = true;
            if (!this.field_70170_p.field_72995_K) {
                this.spawnHitParticles();
                this.func_70106_y();
            }
        }

        private void spawnFlightParticles() {
            for (int i = 0; i < 1; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 0.5, this.field_70163_u + 0.5 + (this.field_70146_Z.nextDouble() - 0.5) * 0.5, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 0.5, (this.field_70146_Z.nextDouble() - 0.5) * 0.1, (this.field_70146_Z.nextDouble() - 0.5) * 0.1, (this.field_70146_Z.nextDouble() - 0.5) * 0.1, new int[0]);
            }
        }

        private void spawnHitParticles() {
            if (this.field_70170_p.field_72995_K) {
                for (int i = 0; i < 8; ++i) {
                    double offsetX = (this.field_70146_Z.nextDouble() - 0.5) * 1.5;
                    double offsetY = (this.field_70146_Z.nextDouble() - 0.5) * 1.5;
                    double offsetZ = (this.field_70146_Z.nextDouble() - 0.5) * 1.5;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + offsetX, this.field_70163_u + offsetY, this.field_70161_v + offsetZ, offsetX * 0.1, offsetY * 0.1, offsetZ * 0.1, new int[0]);
                }
            }
        }

        public boolean func_70097_a(DamageSource source, float amount) {
            if (!this.field_70170_p.field_72995_K && !this.hasHit) {
                this.onHit();
            }
            return true;
        }

        protected void func_70619_bc() {
        }

        public void func_70636_d() {
            this.func_70071_h_();
        }
    }
}

