/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.zombierush.entity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.mcreator.zombierush.ElementsZombieRushMod;
import net.mcreator.zombierush.item.ItemFearlessWarriorArmor;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ElementsZombieRushMod.ModElement.Tag
public class EntityMegaKnight
extends ElementsZombieRushMod.ModElement {
    public static final int ENTITYID = 153;
    public static final int ENTITYID_RANGED = 154;

    public EntityMegaKnight(ElementsZombieRushMod instance) {
        super(instance, 66);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EntityCustom.class).id(new ResourceLocation("zombie_rush", "mega_knight"), 153).name("mega_knight").tracker(64, 3, true).egg(-13421773, -13408768).build());
    }

    @Override
    public void init(FMLInitializationEvent event) {
        Biome[] spawnBiomes = this.allbiomes((RegistryNamespaced<ResourceLocation, Biome>)Biome.field_185377_q);
        EntityRegistry.addSpawn(EntityCustom.class, (int)8, (int)2, (int)5, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])spawnBiomes);
    }

    private Biome[] allbiomes(RegistryNamespaced<ResourceLocation, Biome> in) {
        Iterator itr = in.iterator();
        ArrayList ls = new ArrayList();
        while (itr.hasNext()) {
            ls.add(itr.next());
        }
        return ls.toArray(new Biome[ls.size()]);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInit(FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EntityCustom.class, renderManager -> new RenderLiving(renderManager, new ModelmegaNait(), 0.5f){

            protected ResourceLocation func_110775_a(Entity entity) {
                return new ResourceLocation("zombie_rush:textures/dbdbea961d77431afb0b22169748714dc83f8b15-15835807.png");
            }
        });
    }

    public static class ModelmegaNait
    extends ModelBase {
        private final ModelRenderer Waist;
        private final ModelRenderer Head;
        private final ModelRenderer Body;
        private final ModelRenderer RightArm;
        private final ModelRenderer LeftArm;
        private final ModelRenderer RightLeg;
        private final ModelRenderer LeftLeg;
        private float jumpProgress = 0.0f;
        private boolean isSlamming = false;
        private float slamProgress = 0.0f;

        public ModelmegaNait() {
            this.field_78090_t = 64;
            this.field_78089_u = 128;
            this.Waist = new ModelRenderer((ModelBase)this);
            this.Waist.func_78793_a(0.0f, 12.0f, 0.0f);
            this.Head = new ModelRenderer((ModelBase)this);
            this.Head.func_78793_a(0.0f, -12.0f, 0.0f);
            this.Waist.func_78792_a(this.Head);
            this.Head.field_78804_l.add(new ModelBox(this.Head, 0, 64, -4.0f, -8.0f, -4.0f, 8, 8, 8, 0.0f, false));
            this.Head.field_78804_l.add(new ModelBox(this.Head, 32, 64, -4.0f, -8.0f, -4.0f, 8, 8, 8, 0.5f, false));
            this.Body = new ModelRenderer((ModelBase)this);
            this.Body.func_78793_a(0.0f, -12.0f, 0.0f);
            this.Waist.func_78792_a(this.Body);
            this.Body.field_78804_l.add(new ModelBox(this.Body, 16, 80, -4.0f, 0.0f, -2.0f, 8, 12, 4, 0.0f, false));
            this.Body.field_78804_l.add(new ModelBox(this.Body, 16, 96, -4.0f, 0.0f, -2.0f, 8, 12, 4, 0.25f, false));
            this.RightArm = new ModelRenderer((ModelBase)this);
            this.RightArm.func_78793_a(-5.0f, -10.0f, 0.0f);
            this.Waist.func_78792_a(this.RightArm);
            this.setRotationAngle(this.RightArm, 0.0f, 0.0f, 0.1309f);
            this.RightArm.field_78804_l.add(new ModelBox(this.RightArm, 40, 80, -3.0f, -2.0f, -2.0f, 4, 12, 4, 0.0f, false));
            this.RightArm.field_78804_l.add(new ModelBox(this.RightArm, 40, 96, -3.0f, -2.0f, -2.0f, 4, 12, 4, 0.25f, false));
            this.RightArm.field_78804_l.add(new ModelBox(this.RightArm, 0, 50, -4.0f, 6.0f, -3.0f, 6, 5, 6, 0.0f, false));
            this.LeftArm = new ModelRenderer((ModelBase)this);
            this.LeftArm.func_78793_a(5.0f, -10.0f, 0.0f);
            this.Waist.func_78792_a(this.LeftArm);
            this.setRotationAngle(this.LeftArm, 0.0f, 0.0f, -0.1309f);
            this.LeftArm.field_78804_l.add(new ModelBox(this.LeftArm, 32, 112, -1.0f, -2.0f, -2.0f, 4, 12, 4, 0.0f, false));
            this.LeftArm.field_78804_l.add(new ModelBox(this.LeftArm, 48, 112, -1.0f, -2.0f, -2.0f, 4, 12, 4, 0.25f, false));
            this.LeftArm.field_78804_l.add(new ModelBox(this.LeftArm, 22, 45, -2.0f, 6.0f, -3.0f, 6, 5, 6, 0.0f, false));
            this.RightLeg = new ModelRenderer((ModelBase)this);
            this.RightLeg.func_78793_a(-1.9f, 0.0f, 0.0f);
            this.Waist.func_78792_a(this.RightLeg);
            this.RightLeg.field_78804_l.add(new ModelBox(this.RightLeg, 0, 80, -2.0f, 0.0f, -2.0f, 4, 12, 4, 0.0f, false));
            this.RightLeg.field_78804_l.add(new ModelBox(this.RightLeg, 0, 96, -2.0f, 0.0f, -2.0f, 4, 12, 4, 0.25f, false));
            this.LeftLeg = new ModelRenderer((ModelBase)this);
            this.LeftLeg.func_78793_a(1.9f, 0.0f, 0.0f);
            this.Waist.func_78792_a(this.LeftLeg);
            this.LeftLeg.field_78804_l.add(new ModelBox(this.LeftLeg, 16, 112, -2.0f, 0.0f, -2.0f, 4, 12, 4, 0.0f, false));
            this.LeftLeg.field_78804_l.add(new ModelBox(this.LeftLeg, 0, 112, -2.0f, 0.0f, -2.0f, 4, 12, 4, 0.25f, false));
        }

        public void func_78088_a(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
            this.Waist.func_78785_a(f5);
        }

        public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
            modelRenderer.field_78795_f = x;
            modelRenderer.field_78796_g = y;
            modelRenderer.field_78808_h = z;
        }

        public void func_78087_a(float f, float f1, float f2, float f3, float f4, float f5, Entity e) {
            super.func_78087_a(f, f1, f2, f3, f4, f5, e);
            this.RightArm.field_78795_f = MathHelper.func_76134_b((float)(f * 0.6662f + (float)Math.PI)) * f1 * 0.5f;
            this.LeftArm.field_78795_f = MathHelper.func_76134_b((float)(f * 0.6662f)) * f1 * 0.5f;
            this.RightArm.field_78808_h = 0.13f;
            this.LeftArm.field_78808_h = -0.13f;
            this.RightArm.field_78796_g = 0.0f;
            this.LeftArm.field_78796_g = 0.0f;
            this.LeftLeg.field_78795_f = MathHelper.func_76134_b((float)(f * 1.0f)) * -1.0f * f1;
            this.RightLeg.field_78795_f = MathHelper.func_76134_b((float)(f * 1.0f)) * 1.0f * f1;
            if (e instanceof EntityCustom) {
                EntityCustom megaKnight = (EntityCustom)e;
                if (megaKnight.attackTimer > 0) {
                    float swingProgress = (float)(10 - megaKnight.attackTimer) / 10.0f;
                    float armSwing = (float)Math.sin((double)swingProgress * Math.PI) * 1.5f;
                    this.RightArm.field_78795_f = -1.8f - armSwing * 1.2f;
                    this.LeftArm.field_78795_f = -1.8f - armSwing * 1.2f;
                    this.RightArm.field_78808_h = 0.13f + armSwing * 0.2f;
                    this.LeftArm.field_78808_h = -0.13f - armSwing * 0.2f;
                    this.RightLeg.field_78795_f = 0.3f + armSwing * 0.1f;
                    this.LeftLeg.field_78795_f = 0.3f + armSwing * 0.1f;
                }
                if (megaKnight.isJumping) {
                    if (!megaKnight.field_70122_E) {
                        this.jumpProgress = Math.min(this.jumpProgress + 0.1f, 1.0f);
                        this.isSlamming = false;
                        float armUp = this.jumpProgress * 1.5f;
                        this.RightArm.field_78795_f = -1.8f - armUp * 1.2f;
                        this.LeftArm.field_78795_f = -1.8f - armUp * 1.2f;
                        this.RightArm.field_78808_h = 0.13f;
                        this.LeftArm.field_78808_h = -0.13f;
                        this.RightLeg.field_78795_f = 0.8f;
                        this.LeftLeg.field_78795_f = 0.8f;
                    } else if (megaKnight.wasInAir) {
                        if (!this.isSlamming) {
                            this.isSlamming = true;
                            this.slamProgress = 0.0f;
                        }
                        this.slamProgress = Math.min(this.slamProgress + 0.3f, 1.0f);
                        float slam = (float)Math.sin((double)this.slamProgress * Math.PI) * 1.0f;
                        this.RightArm.field_78795_f = -0.5f + slam * 0.7f;
                        this.LeftArm.field_78795_f = -0.5f + slam * 0.7f;
                        this.RightArm.field_78796_g = -0.5f - slam * 0.8f;
                        this.LeftArm.field_78796_g = 0.5f + slam * 0.8f;
                        this.RightLeg.field_78795_f = 0.5f + slam * 0.3f;
                        this.LeftLeg.field_78795_f = 0.5f + slam * 0.3f;
                    }
                } else {
                    this.jumpProgress = Math.max(this.jumpProgress - 0.1f, 0.0f);
                    this.isSlamming = false;
                    this.slamProgress = 0.0f;
                }
            }
            this.Head.field_78796_g = f3 / 57.295776f;
            this.Head.field_78795_f = f4 / 57.295776f;
        }
    }

    public static class EntityCustom
    extends EntityZombie {
        private int jumpCooldown = 0;
        private boolean isJumping = false;
        private boolean wasInAir = false;
        public int attackTimer = 0;
        private static final int JUMP_COOLDOWN_MAX = 100;
        private static final float JUMP_HEIGHT = 1.8f;
        private static final double JUMP_DISTANCE = 12.0;
        private static final double SHOCKWAVE_RANGE = 8.0;
        private static final float SHOCKWAVE_DAMAGE = 12.0f;
        private static final float SHOCKWAVE_KNOCKBACK = 2.0f;
        private static final float NORMAL_ATTACK_KNOCKBACK = 2.0f;
        private static final double AOE_ATTACK_RANGE = 4.0;

        public EntityCustom(World world) {
            super(world);
            this.func_70105_a(0.6f, 1.8f);
            this.field_70728_aV = 20;
            this.field_70178_ae = false;
            this.func_94061_f(false);
            this.func_82227_f(false);
            this.func_98053_h(false);
            this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)Items.field_151028_Y, 1));
            this.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(ItemFearlessWarriorArmor.body, 1));
            this.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack(ItemFearlessWarriorArmor.legs, 1));
            this.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack(ItemFearlessWarriorArmor.boots, 1));
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
            this.func_184201_a(EntityEquipmentSlot.OFFHAND, ItemStack.field_190927_a);
        }

        public void func_70636_d() {
            double distance;
            EntityLivingBase target;
            super.func_70636_d();
            if (this.attackTimer > 0) {
                --this.attackTimer;
            }
            if (this.jumpCooldown > 0) {
                --this.jumpCooldown;
            }
            if (this.isJumping && this.wasInAir && this.field_70122_E) {
                this.createShockwave();
                this.isJumping = false;
                this.wasInAir = false;
                this.jumpCooldown = 100;
            }
            if (this.isJumping && !this.field_70122_E) {
                this.wasInAir = true;
            }
            if (!this.isJumping && this.jumpCooldown <= 0 && this.field_70122_E && (target = this.func_70638_az()) != null && !this.field_70170_p.field_72995_K && (distance = (double)this.func_70032_d((Entity)target)) <= 12.0) {
                this.performJump(target);
            }
        }

        public boolean func_70652_k(Entity entityIn) {
            this.attackTimer = 10;
            boolean attacked = super.func_70652_k(entityIn);
            if (attacked) {
                this.createAOEAttack();
                if (entityIn instanceof EntityLivingBase) {
                    EntityLivingBase target = (EntityLivingBase)entityIn;
                    Vec3d direction = new Vec3d(target.field_70165_t - this.field_70165_t, 0.4, target.field_70161_v - this.field_70161_v).func_72432_b();
                    target.field_70159_w += direction.field_72450_a * 2.0;
                    target.field_70181_x += direction.field_72448_b * 2.0;
                    target.field_70179_y += direction.field_72449_c * 2.0;
                    this.func_184185_a(SoundEvents.field_187596_cD, 1.2f, 0.7f);
                }
            }
            return attacked;
        }

        private void createAOEAttack() {
            if (!this.field_70170_p.field_72995_K) {
                List entities = this.field_70170_p.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(this.field_70165_t - 4.0, this.field_70163_u - 2.0, this.field_70161_v - 4.0, this.field_70165_t + 4.0, this.field_70163_u + 4.0, this.field_70161_v + 4.0));
                for (EntityLivingBase entity : entities) {
                    double distance;
                    if (entity == this || entity == this.func_70638_az() || !((distance = (double)this.func_70032_d((Entity)entity)) <= 4.0)) continue;
                    Vec3d direction = new Vec3d(entity.field_70165_t - this.field_70165_t, 0.3, entity.field_70161_v - this.field_70161_v).func_72432_b();
                    double knockbackStrength = 1.4 * (1.0 - distance / 4.0);
                    entity.field_70159_w += direction.field_72450_a * knockbackStrength;
                    entity.field_70181_x += direction.field_72448_b * knockbackStrength;
                    entity.field_70179_y += direction.field_72449_c * knockbackStrength;
                    float damage = 8.0f * (1.0f - (float)(distance / 4.0));
                    if (damage < 3.0f) {
                        damage = 3.0f;
                    }
                    entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), damage);
                }
                this.func_184185_a(SoundEvents.field_187928_hb, 1.0f, 0.6f);
            }
            if (this.field_70170_p.field_72995_K) {
                for (int i = 0; i < 15; ++i) {
                    double angle = Math.PI * 2 * (double)i / 15.0;
                    double radius = 2.8;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.CRIT, this.field_70165_t + Math.cos(angle) * radius, this.field_70163_u + 0.5, this.field_70161_v + Math.sin(angle) * radius, Math.cos(angle) * 0.2, 0.1, Math.sin(angle) * 0.2, new int[0]);
                }
            }
        }

        private void performJump(EntityLivingBase target) {
            double dz;
            double dx;
            double distance;
            this.isJumping = true;
            this.wasInAir = false;
            try {
                SoundEvent jumpSound = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("zombie_rush:evolution-mega-knight"));
                if (jumpSound != null) {
                    this.func_184185_a(jumpSound, 2.0f, 1.0f);
                } else {
                    this.func_184185_a(SoundEvents.field_187596_cD, 2.0f, 0.7f);
                }
            }
            catch (Exception e) {
                this.func_184185_a(SoundEvents.field_187596_cD, 2.0f, 0.7f);
            }
            this.field_70181_x = 1.8f;
            if (target != null && (distance = (double)MathHelper.func_76133_a((double)((dx = target.field_70165_t - this.field_70165_t) * dx + (dz = target.field_70161_v - this.field_70161_v) * dz))) > 0.0) {
                double speed = 0.6;
                this.field_70159_w = dx / distance * speed;
                this.field_70179_y = dz / distance * speed;
            }
            if (this.field_70170_p.field_72995_K) {
                for (int i = 0; i < 30; ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.CLOUD, this.field_70165_t, this.field_70163_u, this.field_70161_v, (this.field_70146_Z.nextDouble() - 0.5) * 0.8, 0.2, (this.field_70146_Z.nextDouble() - 0.5) * 0.8, new int[0]);
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_INSTANT, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, (this.field_70146_Z.nextDouble() - 0.5) * 0.5, 0.3, (this.field_70146_Z.nextDouble() - 0.5) * 0.5, new int[0]);
                }
            }
        }

        private void createShockwave() {
            if (this.field_70170_p.field_72995_K) {
                int i;
                for (i = 0; i < 50; ++i) {
                    double angle = Math.PI * 2 * (double)i / 50.0;
                    double radius = 8.0;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + Math.cos(angle) * radius, this.field_70163_u + 0.1, this.field_70161_v + Math.sin(angle) * radius, Math.cos(angle) * 0.4, 0.15, Math.sin(angle) * 0.4, new int[0]);
                    this.field_70170_p.func_175688_a(EnumParticleTypes.CLOUD, this.field_70165_t + Math.cos(angle) * radius * 0.7, this.field_70163_u + 0.05, this.field_70161_v + Math.sin(angle) * radius * 0.7, Math.cos(angle) * 0.25, 0.1, Math.sin(angle) * 0.25, new int[0]);
                }
                for (i = 0; i < 20; ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 3.0, this.field_70163_u + 0.2, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 3.0, 0.0, 0.2, 0.0, new int[0]);
                }
                for (i = 0; i < 40; ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.CRIT_MAGIC, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 4.0, this.field_70163_u + 0.5, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 4.0, (this.field_70146_Z.nextDouble() - 0.5) * 0.5, 0.4, (this.field_70146_Z.nextDouble() - 0.5) * 0.5, new int[0]);
                }
            }
            if (!this.field_70170_p.field_72995_K) {
                List entities = this.field_70170_p.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(this.field_70165_t - 8.0, this.field_70163_u - 2.0, this.field_70161_v - 8.0, this.field_70165_t + 8.0, this.field_70163_u + 4.0, this.field_70161_v + 8.0));
                for (EntityLivingBase entity : entities) {
                    double distance;
                    if (entity == this || !((distance = (double)this.func_70032_d((Entity)entity)) <= 8.0)) continue;
                    Vec3d direction = new Vec3d(entity.field_70165_t - this.field_70165_t, 0.4, entity.field_70161_v - this.field_70161_v).func_72432_b();
                    double knockbackStrength = 2.0 * (1.0 - distance / 8.0);
                    entity.field_70159_w += direction.field_72450_a * knockbackStrength;
                    entity.field_70181_x += direction.field_72448_b * knockbackStrength;
                    entity.field_70179_y += direction.field_72449_c * knockbackStrength;
                    float damage = 12.0f * (1.0f - (float)(distance / 8.0));
                    if (damage < 4.0f) {
                        damage = 4.0f;
                    }
                    entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), damage);
                    if (!(entity instanceof EntityPlayer)) continue;
                    ((EntityPlayer)entity).func_71020_j(1.0f);
                }
                this.func_184185_a(SoundEvents.field_187539_bB, 2.5f, 0.8f);
                this.func_184185_a(SoundEvents.field_187605_cG, 2.0f, 0.5f);
                this.func_184185_a(SoundEvents.field_187689_f, 1.5f, 0.6f);
            }
        }

        public void func_70653_a(Entity entityIn, float strength, double xRatio, double zRatio) {
        }

        public boolean func_70104_M() {
            return false;
        }

        public boolean func_70631_g_() {
            return false;
        }

        public void func_82227_f(boolean childZombie) {
            super.func_82227_f(false);
        }

        public boolean func_98052_bS() {
            return false;
        }

        protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
        }

        protected void func_184651_r() {
            super.func_184651_r();
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.4, false){

                protected double func_179512_a(EntityLivingBase entity) {
                    return (double)(this.field_75441_b.field_70130_N * this.field_75441_b.field_70130_N + entity.field_70130_N) + 1.2;
                }
            });
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        }

        public EnumCreatureAttribute func_70668_bt() {
            return EnumCreatureAttribute.UNDEAD;
        }

        protected Item func_146068_u() {
            return null;
        }

        protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        }

        public SoundEvent func_184639_G() {
            return (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("entity.zombie.ambient"));
        }

        public SoundEvent func_184601_bQ(DamageSource ds) {
            return (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("entity.zombie.hurt"));
        }

        public SoundEvent func_184615_bR() {
            return (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("entity.zombie.death"));
        }

        protected float func_70599_aP() {
            return 1.8f;
        }

        public boolean func_70097_a(DamageSource source, float amount) {
            if (source == DamageSource.field_76367_g) {
                return false;
            }
            if (source == DamageSource.field_76379_h) {
                return false;
            }
            return super.func_70097_a(source, amount);
        }

        protected void func_110147_ax() {
            super.func_110147_ax();
            if (this.func_110148_a(SharedMonsterAttributes.field_188791_g) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(40.0);
            }
            if (this.func_110148_a(SharedMonsterAttributes.field_111263_d) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.23);
            }
            if (this.func_110148_a(SharedMonsterAttributes.field_111267_a) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(400.0);
            }
            if (this.func_110148_a(SharedMonsterAttributes.field_111264_e) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(18.0);
            }
            if (this.func_110148_a(SharedMonsterAttributes.field_111266_c) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
            }
            if (this.func_110148_a(SharedMonsterAttributes.field_111265_b) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(50.0);
            }
        }
    }
}

