/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.zombierush.entity;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import net.mcreator.zombierush.ElementsZombieRushMod;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ElementsZombieRushMod.ModElement.Tag
public class EntitySpamtonNeo
extends ElementsZombieRushMod.ModElement {
    public static final int ENTITYID = 85;
    public static final int ENTITYID_RANGED = 86;

    public EntitySpamtonNeo(ElementsZombieRushMod instance) {
        super(instance, 51);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EntityCustom.class).id(new ResourceLocation("zombie_rush", "spamton_neo"), 85).name("spamton_neo").tracker(64, 3, true).egg(-39169, -205).build());
    }

    @Override
    public void init(FMLInitializationEvent event) {
        Biome[] spawnBiomes = this.allbiomes((RegistryNamespaced<ResourceLocation, Biome>)Biome.field_185377_q);
        EntityRegistry.addSpawn(EntityCustom.class, (int)1, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])spawnBiomes);
    }

    private Biome[] allbiomes(RegistryNamespaced<ResourceLocation, Biome> in) {
        Iterator itr = in.iterator();
        ArrayList ls = new ArrayList();
        while (itr.hasNext()) {
            ls.add(itr.next());
        }
        return ls.toArray(new Biome[ls.size()]);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInit(FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EntityCustom.class, renderManager -> new RenderLiving(renderManager, new ModelspamtonNEO(), 1.0f){

            protected ResourceLocation func_110775_a(Entity entity) {
                return new ResourceLocation("zombie_rush:textures/texture.png");
            }
        });
    }

    public static class ModelspamtonNEO
    extends ModelBase {
        private final ModelRenderer Waist;
        private final ModelRenderer Head;
        private final ModelRenderer Body;
        private final ModelRenderer bone2;
        private final ModelRenderer cube_r1;
        private final ModelRenderer cube_r2;
        private final ModelRenderer cube_r3;
        private final ModelRenderer bone;
        private final ModelRenderer cube_r4;
        private final ModelRenderer cube_r5;
        private final ModelRenderer cube_r6;
        private final ModelRenderer RightArm;
        private final ModelRenderer RightArm2;
        private final ModelRenderer LeftArm;
        private final ModelRenderer RightLeg;
        private final ModelRenderer cube_r7;
        private final ModelRenderer LeftLeg;
        private final ModelRenderer cube_r8;

        public ModelspamtonNEO() {
            this.field_78090_t = 128;
            this.field_78089_u = 128;
            this.Waist = new ModelRenderer((ModelBase)this);
            this.Waist.func_78793_a(0.0f, 0.75f, 0.0f);
            this.Head = new ModelRenderer((ModelBase)this);
            this.Head.func_78793_a(0.0f, -12.0f, 0.0f);
            this.Waist.func_78792_a(this.Head);
            this.Head.field_78804_l.add(new ModelBox(this.Head, 53, 0, -5.0f, -9.0f, -5.0f, 10, 10, 10, 0.0f, false));
            this.Head.field_78804_l.add(new ModelBox(this.Head, 54, 20, -4.0f, -8.0f, -4.0f, 8, 8, 8, 0.5f, false));
            this.Head.field_78804_l.add(new ModelBox(this.Head, 100, 43, -1.0f, -3.0f, -9.0f, 2, 1, 5, 0.0f, false));
            this.Head.field_78804_l.add(new ModelBox(this.Head, 48, 100, -3.0f, -2.0f, -5.0f, 6, 4, 1, 0.0f, false));
            this.Head.field_78804_l.add(new ModelBox(this.Head, 58, 48, -1.0f, 0.0f, -1.0f, 2, 3, 2, 0.0f, false));
            this.Body = new ModelRenderer((ModelBase)this);
            this.Body.func_78793_a(6.0f, -8.0f, 0.0f);
            this.Waist.func_78792_a(this.Body);
            this.setRotationAngle(this.Body, 0.0f, 0.0f, 1.5708f);
            this.Body.field_78804_l.add(new ModelBox(this.Body, 0, 56, -1.0f, 0.0f, -2.0f, 10, 12, 4, 0.25f, false));
            this.Body.field_78804_l.add(new ModelBox(this.Body, 57, 36, 9.0f, 2.0f, -2.0f, 5, 8, 4, 0.0f, false));
            this.Body.field_78804_l.add(new ModelBox(this.Body, 86, 20, 14.0f, 1.0f, -3.0f, 2, 10, 6, 0.0f, false));
            this.Body.field_78804_l.add(new ModelBox(this.Body, 100, 36, 14.0f, 3.0f, -4.0f, 6, 6, 1, 0.0f, false));
            this.Body.field_78804_l.add(new ModelBox(this.Body, 32, 90, -1.0f, -7.0f, -3.0f, 2, 7, 6, 0.0f, false));
            this.Body.field_78804_l.add(new ModelBox(this.Body, 94, 0, -1.0f, 12.0f, -3.0f, 2, 7, 6, 0.0f, false));
            this.Body.field_78804_l.add(new ModelBox(this.Body, 88, 84, -3.0f, -8.0f, -3.0f, 2, 8, 6, 0.0f, false));
            this.Body.field_78804_l.add(new ModelBox(this.Body, 0, 90, -3.0f, 12.0f, -3.0f, 2, 8, 6, 0.0f, false));
            this.Body.field_78804_l.add(new ModelBox(this.Body, 88, 98, -3.0f, 3.0f, 2.25f, 8, 6, 2, 0.0f, false));
            this.Body.field_78804_l.add(new ModelBox(this.Body, 16, 98, -1.0f, 1.0f, -5.0f, 6, 10, 2, 0.0f, false));
            this.bone2 = new ModelRenderer((ModelBase)this);
            this.bone2.func_78793_a(0.0f, 7.0f, 4.25f);
            this.Body.func_78792_a(this.bone2);
            this.bone2.field_78804_l.add(new ModelBox(this.bone2, 62, 100, -25.25f, 16.5f, -0.75f, 6, 2, 1, 0.0f, false));
            this.cube_r1 = new ModelRenderer((ModelBase)this);
            this.cube_r1.func_78793_a(0.0f, 2.0f, -1.25f);
            this.bone2.func_78792_a(this.cube_r1);
            this.setRotationAngle(this.cube_r1, 0.0f, 0.0f, -0.6981f);
            this.cube_r1.field_78804_l.add(new ModelBox(this.cube_r1, 0, 48, -26.0f, -2.0f, 0.0f, 27, 2, 2, 0.0f, false));
            this.cube_r1.field_78804_l.add(new ModelBox(this.cube_r1, 0, 12, -26.0f, 0.0f, 1.0f, 27, 12, 0, 0.0f, false));
            this.cube_r2 = new ModelRenderer((ModelBase)this);
            this.cube_r2.func_78793_a(-1.5321f, 19.2856f, -1.25f);
            this.bone2.func_78792_a(this.cube_r2);
            this.setRotationAngle(this.cube_r2, 0.2618f, 0.0f, -0.6981f);
            this.cube_r2.field_78804_l.add(new ModelBox(this.cube_r2, 0, 24, -13.7154f, -3.2567f, 2.0f, 27, 12, 0, 0.0f, false));
            this.cube_r3 = new ModelRenderer((ModelBase)this);
            this.cube_r3.func_78793_a(2.5f, 16.5f, -1.25f);
            this.bone2.func_78792_a(this.cube_r3);
            this.setRotationAngle(this.cube_r3, 0.0f, 0.0f, 0.7854f);
            this.cube_r3.field_78804_l.add(new ModelBox(this.cube_r3, 100, 62, -24.0f, 19.0f, 0.5f, 6, 2, 1, 0.0f, false));
            this.bone = new ModelRenderer((ModelBase)this);
            this.bone.func_78793_a(0.0f, 7.0f, -3.0f);
            this.Body.func_78792_a(this.bone);
            this.bone.field_78804_l.add(new ModelBox(this.bone, 100, 59, -25.25f, -20.5f, 6.5f, 6, 2, 1, 0.0f, false));
            this.cube_r4 = new ModelRenderer((ModelBase)this);
            this.cube_r4.func_78793_a(-1.25f, -2.5f, 6.0f);
            this.bone.func_78792_a(this.cube_r4);
            this.setRotationAngle(this.cube_r4, 0.0f, 0.0f, 0.6981f);
            this.cube_r4.field_78804_l.add(new ModelBox(this.cube_r4, 0, 52, -26.0f, -2.0f, 0.0f, 27, 2, 2, 0.0f, false));
            this.cube_r4.field_78804_l.add(new ModelBox(this.cube_r4, 0, 0, -26.0f, -14.0f, 1.0f, 27, 12, 0, 0.0f, false));
            this.cube_r5 = new ModelRenderer((ModelBase)this);
            this.cube_r5.func_78793_a(-25.75f, -47.0f, 6.0f);
            this.bone.func_78792_a(this.cube_r5);
            this.setRotationAngle(this.cube_r5, 0.0f, 0.0f, -0.7854f);
            this.cube_r5.field_78804_l.add(new ModelBox(this.cube_r5, 100, 65, -24.0f, 19.0f, 0.5f, 6, 2, 1, 0.0f, false));
            this.cube_r6 = new ModelRenderer((ModelBase)this);
            this.cube_r6.func_78793_a(-1.25f, -21.5f, 6.0f);
            this.bone.func_78792_a(this.cube_r6);
            this.setRotationAngle(this.cube_r6, -0.2618f, 0.0f, 0.6981f);
            this.cube_r6.field_78804_l.add(new ModelBox(this.cube_r6, 0, 36, -13.787f, -8.4452f, 2.0f, 27, 12, 0, 0.0f, false));
            this.RightArm = new ModelRenderer((ModelBase)this);
            this.RightArm.func_78793_a(-10.0f, -7.0f, 0.0f);
            this.Waist.func_78792_a(this.RightArm);
            this.RightArm.field_78804_l.add(new ModelBox(this.RightArm, 94, 13, -2.0f, 18.0f, -2.0f, 4, 2, 4, 0.0f, false));
            this.RightArm2 = new ModelRenderer((ModelBase)this);
            this.RightArm2.func_78793_a(0.0f, 0.0f, 0.0f);
            this.RightArm.func_78792_a(this.RightArm2);
            this.RightArm2.field_78804_l.add(new ModelBox(this.RightArm2, 40, 74, -2.0f, 0.0f, -2.0f, 4, 12, 4, 0.0f, false));
            this.RightArm2.field_78804_l.add(new ModelBox(this.RightArm2, 72, 84, -2.0f, 2.0f, -2.0f, 4, 12, 4, 0.25f, false));
            this.RightArm2.field_78804_l.add(new ModelBox(this.RightArm2, 16, 72, -3.0f, 14.0f, -3.0f, 6, 4, 6, 0.0f, false));
            this.LeftArm = new ModelRenderer((ModelBase)this);
            this.LeftArm.func_78793_a(10.0f, -7.0f, 0.0f);
            this.Waist.func_78792_a(this.LeftArm);
            this.LeftArm.field_78804_l.add(new ModelBox(this.LeftArm, 84, 36, -2.0f, 0.0f, -2.0f, 4, 12, 4, 0.0f, false));
            this.LeftArm.field_78804_l.add(new ModelBox(this.LeftArm, 84, 52, -2.0f, 2.0f, -2.0f, 4, 12, 4, 0.25f, false));
            this.LeftArm.field_78804_l.add(new ModelBox(this.LeftArm, 56, 84, -2.0f, 7.0f, -2.0f, 4, 12, 4, 0.0f, false));
            this.RightLeg = new ModelRenderer((ModelBase)this);
            this.RightLeg.func_78793_a(-2.4f, 8.0f, 1.0f);
            this.Waist.func_78792_a(this.RightLeg);
            this.RightLeg.field_78804_l.add(new ModelBox(this.RightLeg, 52, 56, -2.0f, 0.0f, -3.0f, 4, 14, 4, 0.0f, false));
            this.RightLeg.field_78804_l.add(new ModelBox(this.RightLeg, 68, 48, -2.0f, 1.0f, -3.0f, 4, 12, 4, 0.25f, false));
            this.RightLeg.field_78804_l.add(new ModelBox(this.RightLeg, 100, 54, -1.95f, 13.25f, -2.0f, 4, 2, 3, 0.0f, false));
            this.cube_r7 = new ModelRenderer((ModelBase)this);
            this.cube_r7.func_78793_a(-0.2f, 14.5f, -3.5f);
            this.RightLeg.func_78792_a(this.cube_r7);
            this.setRotationAngle(this.cube_r7, 0.3491f, 0.0f, 0.0f);
            this.cube_r7.field_78804_l.add(new ModelBox(this.cube_r7, 100, 54, -1.75f, -1.0f, -2.0f, 4, 1, 3, 0.0f, false));
            this.LeftLeg = new ModelRenderer((ModelBase)this);
            this.LeftLeg.func_78793_a(2.4f, 8.0f, 0.0f);
            this.Waist.func_78792_a(this.LeftLeg);
            this.LeftLeg.field_78804_l.add(new ModelBox(this.LeftLeg, 68, 66, -2.0f, 0.0f, -2.0f, 4, 14, 4, 0.0f, false));
            this.LeftLeg.field_78804_l.add(new ModelBox(this.LeftLeg, 0, 72, -2.0f, 1.0f, -2.0f, 4, 12, 4, 0.25f, false));
            this.LeftLeg.field_78804_l.add(new ModelBox(this.LeftLeg, 100, 54, -2.0f, 13.25f, -1.0f, 4, 2, 3, 0.0f, false));
            this.cube_r8 = new ModelRenderer((ModelBase)this);
            this.cube_r8.func_78793_a(-0.25f, 14.5f, -2.5f);
            this.LeftLeg.func_78792_a(this.cube_r8);
            this.setRotationAngle(this.cube_r8, 0.3491f, 0.0f, 0.0f);
            this.cube_r8.field_78804_l.add(new ModelBox(this.cube_r8, 100, 54, -1.75f, -1.0f, -2.0f, 4, 1, 3, 0.0f, false));
        }

        public void func_78088_a(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
            this.Waist.func_78785_a(f5);
        }

        public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
            modelRenderer.field_78795_f = x;
            modelRenderer.field_78796_g = y;
            modelRenderer.field_78808_h = z;
        }

        public void func_78087_a(float f, float f1, float f2, float f3, float f4, float f5, Entity e) {
            super.func_78087_a(f, f1, f2, f3, f4, f5, e);
            this.RightArm.field_78795_f = MathHelper.func_76134_b((float)(f * 0.6662f + (float)Math.PI)) * f1;
            this.LeftLeg.field_78795_f = MathHelper.func_76134_b((float)(f * 1.0f)) * -1.0f * f1;
            this.Head.field_78796_g = f3 / 57.295776f;
            this.Head.field_78795_f = f4 / 57.295776f;
            this.LeftArm.field_78795_f = MathHelper.func_76134_b((float)(f * 0.6662f)) * f1;
            this.RightLeg.field_78795_f = MathHelper.func_76134_b((float)(f * 1.0f)) * 1.0f * f1;
        }
    }

    public static class EntityCustom
    extends EntityMob {
        private int pipisSpawnTimer = 0;
        private int spamtomataSpawnTimer = 0;
        private int pushTimer = 0;
        private int dashTimer = 0;
        private boolean isDashing = false;
        private EntityLivingBase dashTarget;
        private int soundCooldown = 0;
        private static final int PIPIS_SPAWN_INTERVAL = 100;
        private static final int SPAMTOMATA_SPAWN_INTERVAL = 400;
        private static final int PUSH_INTERVAL = 800;
        private static final int DASH_INTERVAL = 200;
        private static final int SOUND_COOLDOWN_TIME = 40;
        private static final ResourceLocation SPAM1_SOUND = new ResourceLocation("zombie_rush", "spam1");
        private static final ResourceLocation SPAM2_SOUND = new ResourceLocation("zombie_rush", "spam2");
        private static final ResourceLocation SPAM3_SOUND = new ResourceLocation("zombie_rush", "spam3");

        public EntityCustom(World world) {
            super(world);
            this.func_70105_a(1.2f, 3.0f);
            this.field_70728_aV = 100;
            this.field_70178_ae = true;
            this.func_94061_f(false);
        }

        protected void func_184651_r() {
            super.func_184651_r();
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.2, false){

                protected double func_179512_a(EntityLivingBase entity) {
                    return this.field_75441_b.field_70130_N * this.field_75441_b.field_70130_N + entity.field_70130_N;
                }
            });
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
            this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
            this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
            this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        }

        public void func_70636_d() {
            SoundEvent soundevent;
            super.func_70636_d();
            if (this.soundCooldown > 0) {
                --this.soundCooldown;
            }
            if (!this.field_70170_p.field_72995_K && this.soundCooldown == 0 && this.field_70146_Z.nextInt(200) == 0 && (soundevent = this.func_184639_G()) != null) {
                this.func_184185_a(soundevent, this.func_70599_aP(), this.func_70647_i());
                this.soundCooldown = 40;
            }
            if (!this.field_70170_p.field_72995_K) {
                ++this.pipisSpawnTimer;
                ++this.spamtomataSpawnTimer;
                ++this.pushTimer;
                ++this.dashTimer;
                if (this.pipisSpawnTimer >= 100) {
                    this.spawnPipis();
                    this.pipisSpawnTimer = 0;
                }
                if (this.spamtomataSpawnTimer >= 400) {
                    this.spawnSpamtomata();
                    this.spamtomataSpawnTimer = 0;
                }
                if (this.pushTimer >= 800) {
                    this.performPush();
                    this.pushTimer = 0;
                }
                if (this.dashTimer >= 200 && !this.isDashing) {
                    this.startDash();
                    this.dashTimer = 0;
                }
                if (this.isDashing) {
                    this.performDash();
                }
            } else if (this.field_70173_aa % 5 == 0) {
                this.spawnBossParticles();
            }
        }

        private void spawnPipis() {
            EntityPlayer target = this.field_70170_p.func_184142_a((Entity)this, 20.0, 20.0);
            if (target != null && this.func_70685_l((Entity)target)) {
                int count = 2 + this.field_70146_Z.nextInt(2);
                for (int i = 0; i < count; ++i) {
                    try {
                        Class<?> pipisClass = Class.forName("net.mcreator.zombierush.entity.EntityPipis$EntityCustom");
                        EntityLivingBase pipis = (EntityLivingBase)pipisClass.getConstructor(World.class).newInstance(this.field_70170_p);
                        double angle = (double)i / (double)count * Math.PI * 2.0;
                        double radius = 3.0;
                        double x = this.field_70165_t + Math.cos(angle) * radius;
                        double z = this.field_70161_v + Math.sin(angle) * radius;
                        pipis.func_70107_b(x, this.field_70163_u, z);
                        if (target != null) {
                            try {
                                Field targetField = pipisClass.getDeclaredField("target");
                                targetField.setAccessible(true);
                                targetField.set(pipis, target);
                            }
                            catch (Exception targetField) {
                                // empty catch block
                            }
                        }
                        this.field_70170_p.func_72838_d((Entity)pipis);
                        if (!this.field_70170_p.field_72995_K) continue;
                        for (int j = 0; j < 10; ++j) {
                            this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_WITCH, x, this.field_70163_u + 1.0, z, (this.field_70146_Z.nextDouble() - 0.5) * 0.5, this.field_70146_Z.nextDouble() * 0.5, (this.field_70146_Z.nextDouble() - 0.5) * 0.5, new int[0]);
                        }
                        continue;
                    }
                    catch (Exception e) {
                        System.out.println("Pipis entity not found: " + e.getMessage());
                    }
                }
            }
        }

        private void spawnSpamtomata() {
            try {
                Class<?> spamtomataClass = Class.forName("net.mcreator.zombierush.entity.EntitySpamtomata$EntityCustom");
                EntityLivingBase spamtomata = (EntityLivingBase)spamtomataClass.getConstructor(World.class).newInstance(this.field_70170_p);
                double angle = this.field_70146_Z.nextDouble() * Math.PI * 2.0;
                double radius = 4.0;
                double x = this.field_70165_t + Math.cos(angle) * radius;
                double z = this.field_70161_v + Math.sin(angle) * radius;
                spamtomata.func_70107_b(x, this.field_70163_u, z);
                this.field_70170_p.func_72838_d((Entity)spamtomata);
                if (this.field_70170_p.field_72995_K) {
                    for (int i = 0; i < 20; ++i) {
                        this.field_70170_p.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, x, this.field_70163_u + 1.0, z, (this.field_70146_Z.nextDouble() - 0.5) * 1.0, this.field_70146_Z.nextDouble() * 1.0, (this.field_70146_Z.nextDouble() - 0.5) * 1.0, new int[0]);
                    }
                }
            }
            catch (Exception e) {
                System.out.println("Spamtomata entity not found: " + e.getMessage());
            }
        }

        private void performPush() {
            if (this.field_70170_p.field_72995_K) {
                for (int i = 0; i < 50; ++i) {
                    double angle = (double)i / 50.0 * Math.PI * 2.0;
                    double distance = 8.0;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.field_70165_t + Math.cos(angle) * distance, this.field_70163_u + 1.0, this.field_70161_v + Math.sin(angle) * distance, 0.0, 0.0, 0.0, new int[0]);
                }
            } else {
                for (EntityLivingBase entity : this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ().func_186662_g(8.0))) {
                    double dz;
                    double dx;
                    double distance;
                    if (entity == this || !(entity instanceof EntityPlayer) || !((distance = (double)MathHelper.func_76133_a((double)((dx = entity.field_70165_t - this.field_70165_t) * dx + (dz = entity.field_70161_v - this.field_70161_v) * dz))) > 0.0)) continue;
                    double strength = 2.0;
                    entity.field_70159_w = dx / distance * strength;
                    entity.field_70179_y = dz / distance * strength;
                    entity.field_70181_x = 0.5;
                    entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 2.0f);
                }
            }
        }

        private void startDash() {
            EntityPlayer target = this.field_70170_p.func_184142_a((Entity)this, 15.0, 15.0);
            if (target != null) {
                this.isDashing = true;
                this.dashTarget = target;
                this.func_70661_as().func_75499_g();
            }
        }

        private void performDash() {
            if (this.dashTarget != null && this.dashTarget.func_70089_S()) {
                double dx = this.dashTarget.field_70165_t - this.field_70165_t;
                double dz = this.dashTarget.field_70161_v - this.field_70161_v;
                double distance = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
                if (distance > 0.0 && distance < 15.0) {
                    double dashSpeed = 2.0;
                    this.field_70159_w = dx / distance * dashSpeed;
                    this.field_70179_y = dz / distance * dashSpeed;
                    if (this.field_70170_p.field_72995_K) {
                        for (int i = 0; i < 5; ++i) {
                            this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, (this.field_70146_Z.nextDouble() - 0.5) * 0.2, 0.1, (this.field_70146_Z.nextDouble() - 0.5) * 0.2, new int[0]);
                        }
                    }
                    if ((double)this.func_70032_d((Entity)this.dashTarget) < 3.0) {
                        this.dashTarget.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 10.0f);
                        this.isDashing = false;
                        this.dashTarget = null;
                    }
                } else {
                    this.isDashing = false;
                    this.dashTarget = null;
                }
            } else {
                this.isDashing = false;
                this.dashTarget = null;
            }
            if (this.field_70173_aa % 40 == 0 && this.isDashing) {
                this.isDashing = false;
                this.dashTarget = null;
            }
        }

        private void spawnBossParticles() {
            for (int i = 0; i < 3; ++i) {
                double angle = this.field_70146_Z.nextDouble() * Math.PI * 2.0;
                double radius = 1.5 + this.field_70146_Z.nextDouble() * 1.0;
                double height = this.field_70146_Z.nextDouble() * 3.0;
                this.field_70170_p.func_175688_a(EnumParticleTypes.CRIT_MAGIC, this.field_70165_t + Math.cos(angle) * radius, this.field_70163_u + height, this.field_70161_v + Math.sin(angle) * radius, 0.0, 0.1, 0.0, new int[0]);
            }
        }

        public EnumCreatureAttribute func_70668_bt() {
            return EnumCreatureAttribute.UNDEFINED;
        }

        protected Item func_146068_u() {
            return null;
        }

        public SoundEvent func_184639_G() {
            int soundChoice = this.field_70146_Z.nextInt(3);
            switch (soundChoice) {
                case 0: {
                    return (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)SPAM1_SOUND);
                }
                case 1: {
                    return (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)SPAM2_SOUND);
                }
                case 2: {
                    return (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)SPAM3_SOUND);
                }
            }
            return (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)SPAM1_SOUND);
        }

        public SoundEvent func_184601_bQ(DamageSource ds) {
            return (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("entity.generic.hurt"));
        }

        public SoundEvent func_184615_bR() {
            return (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("entity.generic.death"));
        }

        protected float func_70599_aP() {
            return 2.0f;
        }

        protected void func_110147_ax() {
            super.func_110147_ax();
            if (this.func_110148_a(SharedMonsterAttributes.field_188791_g) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(20.0);
            }
            if (this.func_110148_a(SharedMonsterAttributes.field_111263_d) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
            }
            if (this.func_110148_a(SharedMonsterAttributes.field_111267_a) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(500.0);
            }
            if (this.func_110148_a(SharedMonsterAttributes.field_111264_e) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(15.0);
            }
            if (this.func_110148_a(SharedMonsterAttributes.field_111265_b) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
            }
            if (this.func_110148_a(SharedMonsterAttributes.field_111266_c) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
            }
        }
    }
}

