/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.zombierush.entity;

import java.util.ArrayList;
import java.util.Iterator;
import net.mcreator.zombierush.ElementsZombieRushMod;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ElementsZombieRushMod.ModElement.Tag
public class EntityStoneGolem
extends ElementsZombieRushMod.ModElement {
    public static final int ENTITYID = 157;
    public static final int ENTITYID_RANGED = 158;

    public EntityStoneGolem(ElementsZombieRushMod instance) {
        super(instance, 68);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EntityCustom.class).id(new ResourceLocation("zombie_rush", "stone_golem"), 157).name("stone_golem").tracker(64, 3, true).egg(-10066330, -6750208).build());
    }

    @Override
    public void init(FMLInitializationEvent event) {
        Biome[] spawnBiomes = this.allbiomes((RegistryNamespaced<ResourceLocation, Biome>)Biome.field_185377_q);
        EntityRegistry.addSpawn(EntityCustom.class, (int)3, (int)1, (int)3, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])spawnBiomes);
    }

    private Biome[] allbiomes(RegistryNamespaced<ResourceLocation, Biome> in) {
        Iterator itr = in.iterator();
        ArrayList ls = new ArrayList();
        while (itr.hasNext()) {
            ls.add(itr.next());
        }
        return ls.toArray(new Biome[ls.size()]);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInit(FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EntityCustom.class, renderManager -> new RenderLiving(renderManager, new ModelkameniGolem(), 2.0f){

            protected ResourceLocation func_110775_a(Entity entity) {
                return new ResourceLocation("zombie_rush:textures/kamengolem.png");
            }
        });
    }

    public static class ModelkameniGolem
    extends ModelBase {
        private final ModelRenderer bone;
        private final ModelRenderer leg3;
        private final ModelRenderer leg2_r1;
        private final ModelRenderer leg2_r2;
        private final ModelRenderer leg2_r3;
        private final ModelRenderer leg2_r4;
        private final ModelRenderer leg2;
        private final ModelRenderer leg4;
        private final ModelRenderer leg2_r5;
        private final ModelRenderer leg2_r6;
        private final ModelRenderer leg2_r7;
        private final ModelRenderer leg2_r8;
        private final ModelRenderer leg1;
        private final ModelRenderer leg1_r1;
        private final ModelRenderer leg1_r2;
        private final ModelRenderer leg0;
        private final ModelRenderer leg1_r3;
        private final ModelRenderer leg1_r4;
        private final ModelRenderer head;
        private final ModelRenderer body;
        private final ModelRenderer leg2_r9;
        private final ModelRenderer leg2_r10;
        private final ModelRenderer leg2_r11;
        private final ModelRenderer leg2_r12;
        private final ModelRenderer body_r1;
        private final ModelRenderer body_r2;
        private final ModelRenderer body_r3;
        private final ModelRenderer body_r4;

        public ModelkameniGolem() {
            this.field_78090_t = 128;
            this.field_78089_u = 128;
            this.bone = new ModelRenderer((ModelBase)this);
            this.bone.func_78793_a(0.0f, 14.0f, 0.0f);
            this.leg3 = new ModelRenderer((ModelBase)this);
            this.leg3.func_78793_a(7.25f, -16.5f, -6.75f);
            this.bone.func_78792_a(this.leg3);
            this.leg3.field_78804_l.add(new ModelBox(this.leg3, 89, 31, 0.25f, -2.0f, -2.25f, 7, 6, 5, 0.0f, false));
            this.leg3.field_78804_l.add(new ModelBox(this.leg3, 50, 25, -0.75f, 4.0f, -4.25f, 9, 4, 8, 0.0f, false));
            this.leg3.field_78804_l.add(new ModelBox(this.leg3, 56, 0, -0.25f, 8.0f, -3.25f, 8, 12, 6, 0.0f, false));
            this.leg2_r1 = new ModelRenderer((ModelBase)this);
            this.leg2_r1.func_78793_a(5.25f, 23.0f, 1.25f);
            this.leg3.func_78792_a(this.leg2_r1);
            this.setRotationAngle(this.leg2_r1, 0.0f, 0.0f, 1.5708f);
            this.leg2_r1.field_78804_l.add(new ModelBox(this.leg2_r1, 94, 102, 1.2721f, -1.7349f, -1.5f, 3, 5, 5, 0.0f, false));
            this.leg2_r2 = new ModelRenderer((ModelBase)this);
            this.leg2_r2.func_78793_a(2.25f, 20.0f, 5.75f);
            this.leg3.func_78792_a(this.leg2_r2);
            this.setRotationAngle(this.leg2_r2, 0.0f, 0.0f, -0.0873f);
            this.leg2_r2.field_78804_l.add(new ModelBox(this.leg2_r2, 70, 107, -3.1816f, -1.4342f, -11.0f, 3, 5, 3, 0.0f, false));
            this.leg2_r3 = new ModelRenderer((ModelBase)this);
            this.leg2_r3.func_78793_a(5.25f, 23.0f, -2.25f);
            this.leg3.func_78792_a(this.leg2_r3);
            this.setRotationAngle(this.leg2_r3, 0.0f, 0.0f, 1.5272f);
            this.leg2_r3.field_78804_l.add(new ModelBox(this.leg2_r3, 70, 65, -4.7279f, -1.7349f, -3.0f, 3, 5, 10, 0.0f, false));
            this.leg2_r3.field_78804_l.add(new ModelBox(this.leg2_r3, 38, 100, 1.2721f, -1.7349f, -3.0f, 3, 5, 4, 0.0f, false));
            this.leg2_r4 = new ModelRenderer((ModelBase)this);
            this.leg2_r4.func_78793_a(6.25f, 20.0f, -0.25f);
            this.leg3.func_78792_a(this.leg2_r4);
            this.setRotationAngle(this.leg2_r4, 0.0f, 0.0f, 0.0873f);
            this.leg2_r4.field_78804_l.add(new ModelBox(this.leg2_r4, 70, 80, -0.4429f, -0.2425f, -5.0f, 2, 7, 10, 0.0f, false));
            this.leg2 = new ModelRenderer((ModelBase)this);
            this.leg2.func_78793_a(-7.0f, -16.25f, -7.0f);
            this.bone.func_78792_a(this.leg2);
            this.leg4 = new ModelRenderer((ModelBase)this);
            this.leg4.func_78793_a(-0.5f, -0.25f, 0.5f);
            this.leg2.func_78792_a(this.leg4);
            this.setRotationAngle(this.leg4, 0.0f, 3.1416f, 0.0f);
            this.leg4.field_78804_l.add(new ModelBox(this.leg4, 86, 0, 0.0f, -2.0f, -2.5f, 7, 6, 5, 0.0f, false));
            this.leg4.field_78804_l.add(new ModelBox(this.leg4, 50, 37, -1.0f, 4.0f, -4.5f, 9, 4, 8, 0.0f, false));
            this.leg4.field_78804_l.add(new ModelBox(this.leg4, 42, 65, -0.5f, 8.0f, -3.5f, 8, 12, 6, 0.0f, false));
            this.leg2_r5 = new ModelRenderer((ModelBase)this);
            this.leg2_r5.func_78793_a(5.0f, 23.0f, 1.0f);
            this.leg4.func_78792_a(this.leg2_r5);
            this.setRotationAngle(this.leg2_r5, 0.0f, 0.0f, 1.5708f);
            this.leg2_r5.field_78804_l.add(new ModelBox(this.leg2_r5, 0, 106, 1.2721f, -1.7349f, -1.5f, 3, 5, 5, 0.0f, false));
            this.leg2_r6 = new ModelRenderer((ModelBase)this);
            this.leg2_r6.func_78793_a(2.0f, 20.0f, 5.5f);
            this.leg4.func_78792_a(this.leg2_r6);
            this.setRotationAngle(this.leg2_r6, 0.0f, 0.0f, -0.0873f);
            this.leg2_r6.field_78804_l.add(new ModelBox(this.leg2_r6, 108, 28, -3.1816f, -1.4342f, -4.0f, 3, 5, 3, 0.0f, false));
            this.leg2_r7 = new ModelRenderer((ModelBase)this);
            this.leg2_r7.func_78793_a(5.0f, 23.0f, -2.5f);
            this.leg4.func_78792_a(this.leg2_r7);
            this.setRotationAngle(this.leg2_r7, 0.0f, 0.0f, 1.5272f);
            this.leg2_r7.field_78804_l.add(new ModelBox(this.leg2_r7, 0, 78, -4.7279f, -1.7349f, -3.0f, 3, 5, 10, 0.0f, false));
            this.leg2_r7.field_78804_l.add(new ModelBox(this.leg2_r7, 106, 103, 1.2721f, -1.7349f, -3.0f, 3, 5, 4, 0.0f, false));
            this.leg2_r8 = new ModelRenderer((ModelBase)this);
            this.leg2_r8.func_78793_a(6.0f, 20.0f, -0.5f);
            this.leg4.func_78792_a(this.leg2_r8);
            this.setRotationAngle(this.leg2_r8, 0.0f, 0.0f, 0.0873f);
            this.leg2_r8.field_78804_l.add(new ModelBox(this.leg2_r8, 28, 83, -0.4429f, -0.2425f, -5.0f, 2, 7, 10, 0.0f, false));
            this.leg1 = new ModelRenderer((ModelBase)this);
            this.leg1.func_78793_a(4.0f, -6.0f, 13.0f);
            this.bone.func_78792_a(this.leg1);
            this.leg1.field_78804_l.add(new ModelBox(this.leg1, 98, 68, -3.0f, 0.0f, -2.0f, 6, 5, 4, 0.0f, false));
            this.leg1_r1 = new ModelRenderer((ModelBase)this);
            this.leg1_r1.func_78793_a(-3.0f, 5.0f, -4.0f);
            this.leg1.func_78792_a(this.leg1_r1);
            this.setRotationAngle(this.leg1_r1, -1.5708f, 0.0f, 0.0f);
            this.leg1_r1.field_78804_l.add(new ModelBox(this.leg1_r1, 94, 93, 0.0f, -6.0f, 7.0f, 6, 6, 4, 0.0f, false));
            this.leg1_r2 = new ModelRenderer((ModelBase)this);
            this.leg1_r2.func_78793_a(-3.0f, 12.0f, -6.0f);
            this.leg1.func_78792_a(this.leg1_r2);
            this.setRotationAngle(this.leg1_r2, 0.2618f, 0.0f, 0.0f);
            this.leg1_r2.field_78804_l.add(new ModelBox(this.leg1_r2, 0, 93, 0.0f, -6.0f, 5.0f, 6, 9, 4, 0.0f, false));
            this.leg0 = new ModelRenderer((ModelBase)this);
            this.leg0.func_78793_a(-4.0f, -6.0f, 13.0f);
            this.bone.func_78792_a(this.leg0);
            this.leg0.field_78804_l.add(new ModelBox(this.leg0, 98, 59, -3.0f, 0.0f, -2.0f, 6, 5, 4, 0.0f, false));
            this.leg1_r3 = new ModelRenderer((ModelBase)this);
            this.leg1_r3.func_78793_a(-3.0f, 5.0f, -4.0f);
            this.leg0.func_78792_a(this.leg1_r3);
            this.setRotationAngle(this.leg1_r3, -1.5708f, 0.0f, 0.0f);
            this.leg1_r3.field_78804_l.add(new ModelBox(this.leg1_r3, 70, 97, 0.0f, -6.0f, 7.0f, 6, 6, 4, 0.0f, false));
            this.leg1_r4 = new ModelRenderer((ModelBase)this);
            this.leg1_r4.func_78793_a(-3.0f, 12.0f, -5.5f);
            this.leg0.func_78792_a(this.leg1_r4);
            this.setRotationAngle(this.leg1_r4, 0.3054f, 0.0f, 0.0f);
            this.leg1_r4.field_78804_l.add(new ModelBox(this.leg1_r4, 94, 80, 0.0f, -6.0f, 5.0f, 6, 9, 4, 0.0f, false));
            this.head = new ModelRenderer((ModelBase)this);
            this.head.func_78793_a(0.0f, -20.0f, -8.0f);
            this.bone.func_78792_a(this.head);
            this.head.field_78804_l.add(new ModelBox(this.head, 6, 10, -5.0f, -5.0f, -8.0f, 10, 9, 8, 0.0f, false));
            this.head.field_78804_l.add(new ModelBox(this.head, 0, 0, -6.0f, 0.0f, -9.0f, 12, 5, 5, 0.0f, false));
            this.body = new ModelRenderer((ModelBase)this);
            this.body.func_78793_a(0.0f, -1.0f, 3.0f);
            this.bone.func_78792_a(this.body);
            this.setRotationAngle(this.body, 2.5744f, 0.0f, 0.0f);
            this.body.field_78804_l.add(new ModelBox(this.body, 0, 25, -6.0f, 7.0f, 8.0f, 12, 11, 13, 0.0f, false));
            this.leg2_r9 = new ModelRenderer((ModelBase)this);
            this.leg2_r9.func_78793_a(4.0f, 19.0f, 24.0f);
            this.body.func_78792_a(this.leg2_r9);
            this.setRotationAngle(this.leg2_r9, -0.1309f, 0.0f, 0.0f);
            this.leg2_r9.field_78804_l.add(new ModelBox(this.leg2_r9, 110, 117, -5.0f, -1.0f, -13.0f, 5, 7, 4, 0.0f, false));
            this.leg2_r10 = new ModelRenderer((ModelBase)this);
            this.leg2_r10.func_78793_a(4.0f, 19.0f, 24.0f);
            this.body.func_78792_a(this.leg2_r10);
            this.setRotationAngle(this.leg2_r10, 0.0f, 0.0f, 0.1745f);
            this.leg2_r10.field_78804_l.add(new ModelBox(this.leg2_r10, 110, 117, -8.0f, -1.0f, -9.0f, 5, 7, 4, 0.0f, false));
            this.leg2_r11 = new ModelRenderer((ModelBase)this);
            this.leg2_r11.func_78793_a(4.0f, 19.0f, 24.0f);
            this.body.func_78792_a(this.leg2_r11);
            this.setRotationAngle(this.leg2_r11, 0.0f, 0.0f, -0.2182f);
            this.leg2_r11.field_78804_l.add(new ModelBox(this.leg2_r11, 110, 113, -4.0f, -2.0f, -9.0f, 5, 11, 4, 0.0f, false));
            this.leg2_r12 = new ModelRenderer((ModelBase)this);
            this.leg2_r12.func_78793_a(-7.0f, 11.75f, 26.0f);
            this.body.func_78792_a(this.leg2_r12);
            this.setRotationAngle(this.leg2_r12, -0.3927f, 0.0f, 0.0f);
            this.leg2_r12.field_78804_l.add(new ModelBox(this.leg2_r12, 96, 114, -9.0f, -2.0f, -9.0f, 13, 8, 2, 0.0f, false));
            this.leg2_r12.field_78804_l.add(new ModelBox(this.leg2_r12, 97, 114, 10.0f, -2.0f, -9.0f, 13, 8, 2, 0.0f, false));
            this.body_r1 = new ModelRenderer((ModelBase)this);
            this.body_r1.func_78793_a(0.0f, 12.0f, -2.0f);
            this.body.func_78792_a(this.body_r1);
            this.setRotationAngle(this.body_r1, -1.5708f, 0.0f, 0.0f);
            this.body_r1.field_78804_l.add(new ModelBox(this.body_r1, 69, 10, -9.0f, -21.0f, -7.0f, 18, 14, 11, 0.0f, false));
            this.body_r2 = new ModelRenderer((ModelBase)this);
            this.body_r2.func_78793_a(0.0f, 12.0f, -14.0f);
            this.body.func_78792_a(this.body_r2);
            this.setRotationAngle(this.body_r2, -1.5708f, 0.0f, 0.0f);
            this.body_r2.field_78804_l.add(new ModelBox(this.body_r2, 0, 49, -7.0f, -19.0f, -5.0f, 14, 12, 7, 0.0f, false));
            this.body_r3 = new ModelRenderer((ModelBase)this);
            this.body_r3.func_78793_a(0.0f, 2.0f, -18.0f);
            this.body.func_78792_a(this.body_r3);
            this.setRotationAngle(this.body_r3, -1.5708f, 0.0f, 0.0f);
            this.body_r3.field_78804_l.add(new ModelBox(this.body_r3, 58, 18, -4.0f, -16.0f, 4.0f, 8, 4, 1, 0.0f, false));
            this.body_r4 = new ModelRenderer((ModelBase)this);
            this.body_r4.func_78793_a(0.0f, 2.0f, -14.0f);
            this.body.func_78792_a(this.body_r4);
            this.setRotationAngle(this.body_r4, -1.5708f, 0.0f, 0.0f);
            this.body_r4.field_78804_l.add(new ModelBox(this.body_r4, 84, 39, -6.0f, -19.0f, 4.0f, 12, 7, 1, 0.0f, false));
        }

        public void func_78088_a(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
            this.bone.func_78785_a(f5);
        }

        public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
            modelRenderer.field_78795_f = x;
            modelRenderer.field_78796_g = y;
            modelRenderer.field_78808_h = z;
        }

        public void func_78087_a(float f, float f1, float f2, float f3, float f4, float f5, Entity e) {
            super.func_78087_a(f, f1, f2, f3, f4, f5, e);
            this.leg0.field_78795_f = MathHelper.func_76134_b((float)(f * 1.0f)) * 1.0f * f1;
            this.head.field_78796_g = f3 / 57.295776f;
            this.head.field_78795_f = f4 / 57.295776f;
            this.leg1.field_78795_f = MathHelper.func_76134_b((float)(f * 1.0f)) * -1.0f * f1;
            this.leg2.field_78795_f = MathHelper.func_76134_b((float)(f * 0.6662f + (float)Math.PI)) * f1;
            this.leg3.field_78795_f = MathHelper.func_76134_b((float)(f * 0.6662f)) * f1;
        }
    }

    public static class EntityCustom
    extends EntityCreature {
        private int blockBreakCooldown = 0;
        private BlockPos targetBlock = null;
        private int breakAnimation = 0;
        private int stepSoundTimer = 0;

        public EntityCustom(World world) {
            super(world);
            this.func_70105_a(2.0f, 2.0f);
            this.field_70728_aV = 30;
            this.field_70178_ae = true;
            this.func_94061_f(false);
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151056_x, 1));
            this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(Blocks.field_150347_e, 1));
            this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(Blocks.field_150347_e, 1));
            this.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(Blocks.field_150347_e, 1));
            this.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack(Blocks.field_150347_e, 1));
            this.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack(Blocks.field_150347_e, 1));
            this.func_110163_bv();
        }

        protected void func_184651_r() {
            super.func_184651_r();
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIBreakBlocks(this));
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.9));
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        }

        public EnumCreatureAttribute func_70668_bt() {
            return EnumCreatureAttribute.UNDEAD;
        }

        public boolean func_70601_bi() {
            if (this.field_70170_p.func_72935_r()) {
                return false;
            }
            return super.func_70601_bi();
        }

        protected boolean isValidLightLevel() {
            return true;
        }

        protected Item func_146068_u() {
            return new ItemStack(Items.field_151137_ax, 3).func_77973_b();
        }

        protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
            super.func_70628_a(wasRecentlyHit, lootingModifier);
            if (this.field_70146_Z.nextInt(4) == 0) {
                this.func_70099_a(new ItemStack(Items.field_151056_x, 1), 0.0f);
            }
            if (this.field_70146_Z.nextInt(2) == 0) {
                this.func_70099_a(new ItemStack(Blocks.field_150347_e, this.field_70146_Z.nextInt(5) + 3), 0.0f);
            }
        }

        public SoundEvent func_184639_G() {
            return SoundEvents.field_187902_gb;
        }

        public SoundEvent func_184601_bQ(DamageSource ds) {
            return SoundEvents.field_187843_fX;
        }

        public SoundEvent func_184615_bR() {
            return SoundEvents.field_187835_fT;
        }

        protected void func_180429_a(BlockPos pos, Block blockIn) {
            this.func_184185_a(SoundEvents.field_187902_gb, 0.8f, 0.6f);
        }

        protected float func_70599_aP() {
            return 1.2f;
        }

        protected float func_70647_i() {
            return 0.7f + this.field_70146_Z.nextFloat() * 0.3f;
        }

        public void func_70636_d() {
            super.func_70636_d();
            if (!this.func_174814_R() && this.field_70122_E && !this.func_70090_H()) {
                ++this.stepSoundTimer;
                if (this.stepSoundTimer > 10 && (this.field_82151_R != this.field_70141_P || this.field_70703_bu)) {
                    this.func_180429_a(this.func_180425_c(), this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b()).func_177230_c());
                    this.stepSoundTimer = 0;
                }
            }
            if (this.blockBreakCooldown > 0) {
                --this.blockBreakCooldown;
            }
            if (this.breakAnimation > 0) {
                --this.breakAnimation;
                if (this.field_70170_p.field_72995_K) {
                    this.spawnBreakParticles();
                }
            }
            if (this.func_184614_ca().func_190926_b()) {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151056_x, 1));
            }
            if (this.field_70146_Z.nextInt(200) == 0) {
                this.func_184185_a(SoundEvents.field_187901_ga, 0.5f, 0.6f);
            }
        }

        private void spawnBreakParticles() {
            if (this.targetBlock != null) {
                double z;
                double y;
                double x;
                int i;
                for (i = 0; i < 8; ++i) {
                    x = (double)this.targetBlock.func_177958_n() + 0.5 + (this.field_70146_Z.nextDouble() - 0.5);
                    y = (double)this.targetBlock.func_177956_o() + 0.5 + (this.field_70146_Z.nextDouble() - 0.5);
                    z = (double)this.targetBlock.func_177952_p() + 0.5 + (this.field_70146_Z.nextDouble() - 0.5);
                    this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, x, y, z, (this.field_70146_Z.nextDouble() - 0.5) * 0.5, (this.field_70146_Z.nextDouble() - 0.5) * 0.5, (this.field_70146_Z.nextDouble() - 0.5) * 0.5, new int[]{Block.func_176210_f((IBlockState)this.field_70170_p.func_180495_p(this.targetBlock))});
                }
                for (i = 0; i < 3; ++i) {
                    x = (double)this.targetBlock.func_177958_n() + 0.5 + (this.field_70146_Z.nextDouble() - 0.5) * 2.0;
                    y = (double)this.targetBlock.func_177956_o() + 0.5 + (this.field_70146_Z.nextDouble() - 0.5);
                    z = (double)this.targetBlock.func_177952_p() + 0.5 + (this.field_70146_Z.nextDouble() - 0.5) * 2.0;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x, y, z, (this.field_70146_Z.nextDouble() - 0.5) * 0.1, 0.05, (this.field_70146_Z.nextDouble() - 0.5) * 0.1, new int[0]);
                }
            }
        }

        public boolean func_70097_a(DamageSource source, float amount) {
            if (source == DamageSource.field_76379_h) {
                return false;
            }
            if (source == DamageSource.field_76367_g) {
                return false;
            }
            if (source == DamageSource.field_76369_e) {
                return false;
            }
            if (source.func_76352_a() || source.func_76355_l().contains("arrow")) {
                amount *= 0.7f;
            }
            if (!this.field_70170_p.field_72995_K) {
                this.field_70172_ad = 10;
            }
            if (!this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(3) == 0) {
                this.func_184185_a(SoundEvents.field_187689_f, 0.3f, 0.8f);
            }
            return super.func_70097_a(source, amount);
        }

        public void func_70653_a(Entity entityIn, float strength, double xRatio, double zRatio) {
            this.field_70160_al = false;
            this.field_70159_w *= 0.05;
            this.field_70181_x *= 0.05;
            this.field_70179_y *= 0.05;
        }

        protected void func_110147_ax() {
            super.func_110147_ax();
            if (this.func_110148_a(SharedMonsterAttributes.field_188791_g) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(25.0);
            }
            if (this.func_110148_a(SharedMonsterAttributes.field_111263_d) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.18);
            }
            if (this.func_110148_a(SharedMonsterAttributes.field_111267_a) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(300.0);
            }
            if (this.func_110148_a(SharedMonsterAttributes.field_111264_e) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(8.0);
            }
            if (this.func_110148_a(SharedMonsterAttributes.field_111265_b) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
            }
            if (this.func_110148_a(SharedMonsterAttributes.field_111266_c) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
            }
        }

        private boolean canBreakBlock(IBlockState state, BlockPos pos) {
            if (state == null || this.field_70170_p.func_175623_d(pos) || this.field_70170_p.func_175625_s(pos) != null) {
                return false;
            }
            Block block = state.func_177230_c();
            Material material = state.func_185904_a();
            if (block == Blocks.field_150349_c || block == Blocks.field_150329_H || block == Blocks.field_150398_cm || block == Blocks.field_150330_I || block == Blocks.field_150327_N || block == Blocks.field_150328_O) {
                return false;
            }
            if (block == Blocks.field_150343_Z || block == Blocks.field_150336_V || block == Blocks.field_150417_aV || block == Blocks.field_150357_h || block == Blocks.field_150477_bB || block == Blocks.field_150381_bn || block == Blocks.field_150467_bQ || block.func_149739_a().toLowerCase().contains("ore") || block == Blocks.field_150462_ai || block == Blocks.field_150460_al || block == Blocks.field_150470_am || block == Blocks.field_150486_ae || block == Blocks.field_150447_bR || block == Blocks.field_150438_bZ || block == Blocks.field_150367_z || block == Blocks.field_150409_cd || block == Blocks.field_150348_b || block == Blocks.field_150346_d || block == Blocks.field_185774_da || block == Blocks.field_150351_n || block == Blocks.field_150354_m || block == Blocks.field_150322_A || block == Blocks.field_150424_aL || block == Blocks.field_150377_bs || block == Blocks.field_150341_Y || block.func_149739_a().toLowerCase().contains("stone_stairs") || block.func_149739_a().toLowerCase().contains("stone_slab")) {
                return false;
            }
            if (block.func_149739_a().toLowerCase().contains("log") || block.func_149739_a().toLowerCase().contains("wood") || block.func_149739_a().toLowerCase().contains("planks")) {
                return true;
            }
            if (block == Blocks.field_150347_e || block.func_149739_a().toLowerCase().contains("cobblestone_stairs")) {
                return true;
            }
            if (block.func_149739_a().toLowerCase().contains("door")) {
                return true;
            }
            if (block.func_149739_a().toLowerCase().contains("fence") || block.func_149739_a().toLowerCase().contains("gate")) {
                return true;
            }
            if (block.func_149739_a().toLowerCase().contains("glass")) {
                return true;
            }
            return material == Material.field_151575_d || material == Material.field_151585_k || material == Material.field_151582_l || material == Material.field_151570_A || material == Material.field_151580_n || material == Material.field_151593_r || material == Material.field_151572_C || material == Material.field_151584_j || material == Material.field_151583_m || material == Material.field_151592_s || material == Material.field_151591_t || material == Material.field_151594_q || material == Material.field_151588_w || material == Material.field_151598_x;
        }

        private void breakBlocksInArea(BlockPos center) {
            int radius = 1;
            int blocksBroken = 0;
            ArrayList<BlockPos> blocksToBreak = new ArrayList<BlockPos>();
            for (int x = -radius; x <= radius; ++x) {
                for (int y = -radius; y <= radius; ++y) {
                    for (int z = -radius; z <= radius; ++z) {
                        BlockPos pos = center.func_177982_a(x, y, z);
                        IBlockState state = this.field_70170_p.func_180495_p(pos);
                        if (!this.canBreakBlock(state, pos)) continue;
                        blocksToBreak.add(pos);
                    }
                }
            }
            for (BlockPos pos : blocksToBreak) {
                if (!(this.field_70170_p.func_180495_p(pos).func_185887_b(this.field_70170_p, pos) >= 0.0f)) continue;
                this.field_70170_p.func_175655_b(pos, true);
                ++blocksBroken;
                if (this.field_70170_p.field_72995_K) continue;
                Material material = this.field_70170_p.func_180495_p(pos).func_185904_a();
                if (material == Material.field_151575_d || material == Material.field_151585_k) {
                    this.field_70170_p.func_184133_a(null, pos, SoundEvents.field_187881_gQ, this.func_184176_by(), 0.7f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
                    continue;
                }
                if (material == Material.field_151592_s) {
                    this.field_70170_p.func_184133_a(null, pos, SoundEvents.field_187561_bM, this.func_184176_by(), 0.7f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
                    continue;
                }
                this.field_70170_p.func_184133_a(null, pos, SoundEvents.field_187835_fT, this.func_184176_by(), 0.7f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
            }
            if (blocksBroken > 1 && !this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_184133_a(null, center, SoundEvents.field_187539_bB, this.func_184176_by(), 0.5f, 0.6f + this.field_70146_Z.nextFloat() * 0.3f);
                for (int i = 0; i < 10; ++i) {
                    double x = (double)center.func_177958_n() + 0.5 + (this.field_70146_Z.nextDouble() - 0.5) * 3.0;
                    double y = (double)center.func_177956_o() + 0.5 + (this.field_70146_Z.nextDouble() - 0.5);
                    double z = (double)center.func_177952_p() + 0.5 + (this.field_70146_Z.nextDouble() - 0.5) * 3.0;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.CLOUD, x, y, z, (this.field_70146_Z.nextDouble() - 0.5) * 0.2, 0.1, (this.field_70146_Z.nextDouble() - 0.5) * 0.2, new int[0]);
                }
            }
        }

        public void func_70645_a(DamageSource cause) {
            super.func_70645_a(cause);
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187599_cE, this.func_184176_by(), 1.5f, 0.6f);
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187689_f, this.func_184176_by(), 0.8f, 0.5f);
            }
        }

        public boolean func_70686_a(Class<? extends EntityLivingBase> cls) {
            return false;
        }

        public boolean func_70652_k(Entity entityIn) {
            return false;
        }

        public void func_70624_b(EntityLivingBase entitylivingbaseIn) {
        }

        public EntityLivingBase func_70638_az() {
            return null;
        }

        class EntityAIBreakBlocks
        extends EntityAIBase {
            private final EntityCustom golem;
            private BlockPos targetPos;
            private int breakTime;

            public EntityAIBreakBlocks(EntityCustom golem) {
                this.golem = golem;
                this.func_75248_a(3);
            }

            public boolean func_75250_a() {
                if (this.golem.func_70638_az() != null || EntityCustom.this.blockBreakCooldown > 0) {
                    return false;
                }
                int range = 12;
                BlockPos currentPos = this.golem.func_180425_c();
                BlockPos bestPos = null;
                double bestDistance = Double.MAX_VALUE;
                EnumFacing facing = this.golem.func_174811_aO();
                BlockPos frontPos = currentPos.func_177967_a(facing, 2);
                for (int x = -range; x <= range; ++x) {
                    for (int y = -2; y <= 3; ++y) {
                        for (int z = -range; z <= range; ++z) {
                            BlockPos checkPos = currentPos.func_177982_a(x, y, z);
                            IBlockState state = EntityCustom.this.field_70170_p.func_180495_p(checkPos);
                            if (!EntityCustom.this.canBreakBlock(state, checkPos)) continue;
                            double distance = this.golem.func_174818_b(checkPos);
                            if (checkPos.equals((Object)frontPos)) {
                                distance *= 0.5;
                            }
                            if (!(distance < bestDistance)) continue;
                            bestDistance = distance;
                            bestPos = checkPos;
                        }
                    }
                }
                if (bestPos != null) {
                    this.targetPos = bestPos;
                    this.breakTime = 0;
                    this.golem.targetBlock = bestPos;
                    return true;
                }
                return false;
            }

            public boolean func_75253_b() {
                return this.targetPos != null && !EntityCustom.this.field_70170_p.func_175623_d(this.targetPos) && EntityCustom.this.canBreakBlock(EntityCustom.this.field_70170_p.func_180495_p(this.targetPos), this.targetPos) && this.golem.func_70638_az() == null && EntityCustom.this.blockBreakCooldown == 0;
            }

            public void func_75249_e() {
                this.golem.func_70661_as().func_75492_a((double)this.targetPos.func_177958_n(), (double)this.targetPos.func_177956_o(), (double)this.targetPos.func_177952_p(), 1.0);
            }

            public void func_75251_c() {
                this.targetPos = null;
                this.breakTime = 0;
                this.golem.targetBlock = null;
                this.golem.breakAnimation = 0;
                this.golem.func_70661_as().func_75499_g();
            }

            public void func_75246_d() {
                if (this.targetPos == null) {
                    return;
                }
                double distance = this.golem.func_174818_b(this.targetPos);
                if (distance <= 6.0) {
                    this.golem.func_70661_as().func_75499_g();
                    this.golem.func_70671_ap().func_75650_a((double)this.targetPos.func_177958_n() + 0.5, (double)this.targetPos.func_177956_o() + 0.5, (double)this.targetPos.func_177952_p() + 0.5, 10.0f, (float)this.golem.func_70646_bf());
                    this.golem.func_184609_a(EnumHand.MAIN_HAND);
                    this.golem.breakAnimation = 5;
                    ++this.breakTime;
                    if (this.breakTime % 3 == 0 && !EntityCustom.this.field_70170_p.field_72995_K) {
                        EntityCustom.this.field_70170_p.func_184133_a(null, this.targetPos, SoundEvents.field_187843_fX, this.golem.func_184176_by(), 0.6f, 0.7f + EntityCustom.this.field_70146_Z.nextFloat() * 0.3f);
                    }
                    if (this.breakTime >= 10) {
                        this.golem.breakBlocksInArea(this.targetPos);
                        EntityCustom.this.blockBreakCooldown = 30;
                        this.func_75251_c();
                    }
                } else {
                    this.golem.func_70661_as().func_75492_a((double)this.targetPos.func_177958_n(), (double)this.targetPos.func_177956_o(), (double)this.targetPos.func_177952_p(), 1.0);
                }
            }
        }
    }
}

