/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.zombierush.entity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.mcreator.zombierush.ElementsZombieRushMod;
import net.mcreator.zombierush.entity.EntityZombiePvz2;
import net.mcreator.zombierush.item.ItemFlag;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.entity.RenderBiped;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerBipedArmor;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ElementsZombieRushMod.ModElement.Tag
public class EntityZombieFlag
extends ElementsZombieRushMod.ModElement {
    public static final int ENTITYID = 117;
    public static final int ENTITYID_RANGED = 118;

    public EntityZombieFlag(ElementsZombieRushMod instance) {
        super(instance, 59);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EntityCustom.class).id(new ResourceLocation("zombie_rush", "zombie_flag"), 117).name("zombie_flag").tracker(64, 3, true).egg(-10079488, -65536).build());
    }

    @Override
    public void init(FMLInitializationEvent event) {
        Biome[] spawnBiomes = this.allbiomes((RegistryNamespaced<ResourceLocation, Biome>)Biome.field_185377_q);
        EntityRegistry.addSpawn(EntityCustom.class, (int)2, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])spawnBiomes);
    }

    private Biome[] allbiomes(RegistryNamespaced<ResourceLocation, Biome> in) {
        Iterator itr = in.iterator();
        ArrayList ls = new ArrayList();
        while (itr.hasNext()) {
            ls.add(itr.next());
        }
        return ls.toArray(new Biome[ls.size()]);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInit(FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EntityCustom.class, renderManager -> {
            RenderBiped customRender = new RenderBiped(renderManager, new ModelBiped(){

                public void func_78087_a(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, Entity entityIn) {
                    super.func_78087_a(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, entityIn);
                    this.field_178723_h.field_78795_f = (float)(-Math.PI);
                    this.field_178723_h.field_78796_g = 0.0f;
                    this.field_178723_h.field_78808_h = 0.0f;
                    this.field_178724_i.field_78795_f = 0.0f;
                }
            }, 0.5f){

                protected ResourceLocation func_110775_a(Entity entity) {
                    return new ResourceLocation("zombie_rush:textures/zombie_pvz_.png");
                }
            };
            customRender.func_177094_a((LayerRenderer)new LayerBipedArmor((RenderLivingBase)customRender){

                protected void func_177177_a() {
                    this.field_177189_c = new ModelBiped(0.5f);
                    this.field_177186_d = new ModelBiped(1.0f);
                }
            });
            return customRender;
        });
    }

    public static class EntityCustom
    extends EntityZombie {
        private int abilityCooldown = 0;
        private final int abilityMaxCooldown = 200;
        private boolean isCastingAbility = false;
        private int castTime = 0;
        private List<EntityLivingBase> affectedZombies = new ArrayList<EntityLivingBase>();
        private final UUID AURA_DAMAGE_MODIFIER_ID = UUID.fromString("12345678-1234-1234-1234-123456789abc");
        private final UUID AURA_SPEED_MODIFIER_ID = UUID.fromString("12345678-1234-1234-1234-123456789abd");
        private final UUID VENGEANCE_DAMAGE_MODIFIER_ID = UUID.fromString("12345678-1234-1234-1234-123456789abe");
        private final UUID VENGEANCE_SPEED_MODIFIER_ID = UUID.fromString("12345678-1234-1234-1234-123456789abf");

        public EntityCustom(World world) {
            super(world);
            this.func_70105_a(0.6f, 2.0f);
            this.field_70728_aV = 15;
            this.field_70178_ae = false;
            this.func_94061_f(false);
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(ItemFlag.block, 1));
            this.func_184195_f(true);
        }

        public boolean func_70601_bi() {
            BlockPos surfacePos = this.field_70170_p.func_175672_r(new BlockPos((Entity)this));
            boolean isOnSurface = this.field_70163_u >= (double)(surfacePos.func_177956_o() - 2);
            boolean canSpawn = super.func_70601_bi();
            return isOnSurface && canSpawn;
        }

        protected void func_184651_r() {
            super.func_184651_r();
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true){

                protected double func_179512_a(EntityLivingBase entity) {
                    return this.field_75441_b.field_70130_N * this.field_75441_b.field_70130_N + entity.field_70130_N;
                }
            });
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8));
        }

        public void func_70636_d() {
            super.func_70636_d();
            if (!this.field_70170_p.field_72995_K && this.field_70173_aa == 1) {
                BlockPos currentPos = new BlockPos((Entity)this);
                BlockPos surfacePos = this.field_70170_p.func_175672_r(currentPos);
                if (currentPos.func_177956_o() < surfacePos.func_177956_o() - 2) {
                    this.func_70107_b((double)surfacePos.func_177958_n() + 0.5, surfacePos.func_177956_o(), (double)surfacePos.func_177952_p() + 0.5);
                }
            }
            if (!this.field_70128_L) {
                this.updateAura();
            }
            if (!this.field_70170_p.field_72995_K) {
                this.updateAbility();
                if (this.field_70173_aa % 200 == 0 && this.field_70146_Z.nextFloat() < 0.02f) {
                    this.spawnZombieMiner2();
                }
            }
            if (this.field_70170_p.field_72995_K && this.field_70173_aa % 5 == 0) {
                this.spawnAuraParticles();
            }
        }

        private void spawnZombieMiner2() {
            try {
                Class<?> minerClass = Class.forName("net.mcreator.zombierush.entity.EntityZombieMiner2$EntityCustom");
                EntityLivingBase miner = (EntityLivingBase)minerClass.getConstructor(World.class).newInstance(this.field_70170_p);
                double angle = this.field_70146_Z.nextDouble() * 2.0 * Math.PI;
                double distance = 3.0 + this.field_70146_Z.nextDouble() * 4.0;
                double x = this.field_70165_t + Math.cos(angle) * distance;
                double z = this.field_70161_v + Math.sin(angle) * distance;
                BlockPos spawnPos = new BlockPos(x, this.field_70163_u, z);
                spawnPos = this.field_70170_p.func_175672_r(spawnPos);
                miner.func_70107_b((double)spawnPos.func_177958_n() + 0.5, (double)spawnPos.func_177956_o(), (double)spawnPos.func_177952_p() + 0.5);
                if (miner instanceof EntityZombie) {
                    ((EntityZombie)miner).func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)miner)), null);
                }
                if (miner instanceof EntityZombie && (double)miner.func_70032_d((Entity)this) <= 15.0) {
                    this.applyAuraEffects((EntityZombie)miner);
                    this.affectedZombies.add(miner);
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72838_d((Entity)miner);
                    this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187845_fY, SoundCategory.HOSTILE, 1.0f, 0.8f);
                }
            }
            catch (Exception e) {
                System.out.println("Zombie miner 2 not found: " + e.getMessage());
            }
        }

        private void updateAura() {
            if (!this.field_70170_p.field_72995_K) {
                double radius = 15.0;
                List entities = this.field_70170_p.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(this.field_70165_t - radius, this.field_70163_u - radius, this.field_70161_v - radius, this.field_70165_t + radius, this.field_70163_u + radius, this.field_70161_v + radius));
                ArrayList<EntityLivingBase> newAffectedZombies = new ArrayList<EntityLivingBase>();
                for (EntityLivingBase entity : entities) {
                    EntityZombie zombie;
                    if (!(entity instanceof EntityZombie) || !entity.func_70089_S() || !((double)(zombie = (EntityZombie)entity).func_70032_d((Entity)this) <= radius)) continue;
                    this.applyAuraEffects(zombie);
                    newAffectedZombies.add((EntityLivingBase)zombie);
                }
                for (EntityLivingBase oldZombie : this.affectedZombies) {
                    if (newAffectedZombies.contains(oldZombie) || oldZombie == null || oldZombie.field_70128_L) continue;
                    this.removeAuraEffects(oldZombie);
                }
                this.affectedZombies = newAffectedZombies;
            }
        }

        private void applyAuraEffects(EntityZombie zombie) {
            PotionEffect effect;
            if (zombie.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111127_a(this.AURA_DAMAGE_MODIFIER_ID) == null) {
                zombie.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(new AttributeModifier(this.AURA_DAMAGE_MODIFIER_ID, "Banner damage boost", 0.3, 1));
            }
            if (zombie.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111127_a(this.AURA_SPEED_MODIFIER_ID) == null) {
                zombie.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(new AttributeModifier(this.AURA_SPEED_MODIFIER_ID, "Banner speed boost", 0.15, 1));
            }
            if (zombie.func_70644_a(MobEffects.field_76421_d) && (effect = zombie.func_70660_b(MobEffects.field_76421_d)) != null && effect.func_76459_b() > 20) {
                zombie.func_184589_d(MobEffects.field_76421_d);
                zombie.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 20, effect.func_76458_c()));
            }
            if (zombie.func_70644_a(MobEffects.field_76436_u) && (effect = zombie.func_70660_b(MobEffects.field_76436_u)) != null && effect.func_76459_b() > 20) {
                zombie.func_184589_d(MobEffects.field_76436_u);
                zombie.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 20, effect.func_76458_c()));
            }
            if (zombie.func_70644_a(MobEffects.field_76437_t) && (effect = zombie.func_70660_b(MobEffects.field_76437_t)) != null && effect.func_76459_b() > 20) {
                zombie.func_184589_d(MobEffects.field_76437_t);
                zombie.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 20, effect.func_76458_c()));
            }
            if (zombie != this) {
                zombie.func_184195_f(false);
            }
        }

        private void removeAuraEffects(EntityLivingBase zombie) {
            if (zombie.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111127_a(this.AURA_DAMAGE_MODIFIER_ID) != null) {
                zombie.func_110148_a(SharedMonsterAttributes.field_111264_e).func_188479_b(this.AURA_DAMAGE_MODIFIER_ID);
            }
            if (zombie.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111127_a(this.AURA_SPEED_MODIFIER_ID) != null) {
                zombie.func_110148_a(SharedMonsterAttributes.field_111263_d).func_188479_b(this.AURA_SPEED_MODIFIER_ID);
            }
        }

        private void updateAbility() {
            if (this.isCastingAbility) {
                ++this.castTime;
                if (this.castTime >= 20) {
                    this.castAbility();
                    this.isCastingAbility = false;
                    this.castTime = 0;
                    this.abilityCooldown = 200;
                }
            } else if (this.abilityCooldown <= 0) {
                this.isCastingAbility = true;
                this.castTime = 0;
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187899_gZ, SoundCategory.HOSTILE, 2.0f, 0.5f);
            } else {
                --this.abilityCooldown;
            }
        }

        private void castAbility() {
            int zombiesToSpawn = 8 + this.field_70146_Z.nextInt(5);
            for (int i = 0; i < zombiesToSpawn; ++i) {
                try {
                    EntityZombiePvz2.EntityCustom zombie = new EntityZombiePvz2.EntityCustom(this.field_70170_p);
                    double angle = Math.PI * 2 * (double)i / (double)zombiesToSpawn;
                    double x = this.field_70165_t + Math.cos(angle) * 5.0;
                    double z = this.field_70161_v + Math.sin(angle) * 5.0;
                    double y = this.field_70163_u;
                    BlockPos spawnPos = new BlockPos(x, y, z);
                    spawnPos = this.field_70170_p.func_175672_r(spawnPos);
                    zombie.func_70107_b((double)spawnPos.func_177958_n() + 0.5, spawnPos.func_177956_o(), (double)spawnPos.func_177952_p() + 0.5);
                    zombie.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)zombie)), null);
                    if ((double)zombie.func_70032_d((Entity)this) <= 15.0) {
                        this.applyAuraEffects(zombie);
                        this.affectedZombies.add((EntityLivingBase)zombie);
                    }
                    if (this.field_70170_p.field_72995_K) continue;
                    this.field_70170_p.func_72838_d((Entity)zombie);
                    continue;
                }
                catch (Exception e) {
                    EntityZombie zombie = new EntityZombie(this.field_70170_p);
                    double angle = Math.PI * 2 * (double)i / (double)zombiesToSpawn;
                    double x = this.field_70165_t + Math.cos(angle) * 5.0;
                    double z = this.field_70161_v + Math.sin(angle) * 5.0;
                    double y = this.field_70163_u;
                    BlockPos spawnPos = new BlockPos(x, y, z);
                    spawnPos = this.field_70170_p.func_175672_r(spawnPos);
                    zombie.func_70107_b((double)spawnPos.func_177958_n() + 0.5, (double)spawnPos.func_177956_o(), (double)spawnPos.func_177952_p() + 0.5);
                    zombie.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)zombie)), null);
                    if ((double)zombie.func_70032_d((Entity)this) <= 15.0) {
                        this.applyAuraEffects(zombie);
                        this.affectedZombies.add((EntityLivingBase)zombie);
                    }
                    if (this.field_70170_p.field_72995_K) continue;
                    this.field_70170_p.func_72838_d((Entity)zombie);
                }
            }
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187941_ho, SoundCategory.HOSTILE, 2.5f, 0.6f);
            this.field_70170_p.func_175718_b(2004, new BlockPos((Entity)this), 0);
        }

        @SideOnly(value=Side.CLIENT)
        private void spawnAuraParticles() {
            for (int i = 0; i < 8; ++i) {
                double offsetX = (this.field_70146_Z.nextDouble() - 0.5) * 3.0;
                double offsetY = this.field_70146_Z.nextDouble() * 4.0;
                double offsetZ = (this.field_70146_Z.nextDouble() - 0.5) * 3.0;
                if (this.field_70146_Z.nextBoolean()) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.REDSTONE, this.field_70165_t + offsetX, this.field_70163_u + offsetY, this.field_70161_v + offsetZ, 0.0, 0.0, 0.0, new int[0]);
                    continue;
                }
                this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + offsetX, this.field_70163_u + offsetY, this.field_70161_v + offsetZ, 0.0, 0.1, 0.0, new int[0]);
            }
        }

        public void func_70645_a(DamageSource cause) {
            if (!this.field_70170_p.field_72995_K) {
                this.activateVengeance();
            }
            super.func_70645_a(cause);
        }

        private void activateVengeance() {
            double radius = 20.0;
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187525_aO, SoundCategory.HOSTILE, 3.0f, 0.8f);
            if (this.field_70170_p.field_72995_K) {
                this.spawnDeathParticles();
            }
            for (EntityLivingBase zombie : this.affectedZombies) {
                if (zombie == null || zombie.field_70128_L || !(zombie instanceof EntityZombie)) continue;
                this.applyVengeanceBuff((EntityZombie)zombie);
            }
            List nearbyZombies = this.field_70170_p.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(this.field_70165_t - radius, this.field_70163_u - radius, this.field_70161_v - radius, this.field_70165_t + radius, this.field_70163_u + radius, this.field_70161_v + radius));
            for (EntityLivingBase entity : nearbyZombies) {
                EntityZombie zombie;
                if (!(entity instanceof EntityZombie) || entity == this || !entity.func_70089_S() || this.affectedZombies.contains(entity) || !((double)(zombie = (EntityZombie)entity).func_70032_d((Entity)this) <= radius)) continue;
                this.applyVengeanceBuff(zombie);
            }
            this.affectedZombies.clear();
        }

        @SideOnly(value=Side.CLIENT)
        private void spawnDeathParticles() {
            for (int i = 0; i < 100; ++i) {
                double angle = Math.PI * 2 * this.field_70146_Z.nextDouble();
                double distance = this.field_70146_Z.nextDouble() * 25.0;
                double particleX = this.field_70165_t + distance * Math.cos(angle);
                double particleZ = this.field_70161_v + distance * Math.sin(angle);
                double particleY = this.field_70163_u + this.field_70146_Z.nextDouble() * 5.0;
                this.field_70170_p.func_175688_a(EnumParticleTypes.LAVA, particleX, particleY, particleZ, 0.0, 0.1, 0.0, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, particleX, particleY, particleZ, 0.0, 0.05, 0.0, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, particleX, particleY, particleZ, 0.0, 0.1, 0.0, new int[0]);
            }
        }

        private void applyVengeanceBuff(EntityZombie zombie) {
            this.removeAuraEffects((EntityLivingBase)zombie);
            if (zombie.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111127_a(this.VENGEANCE_DAMAGE_MODIFIER_ID) == null) {
                zombie.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(new AttributeModifier(this.VENGEANCE_DAMAGE_MODIFIER_ID, "Vengeance damage boost", 0.5, 1));
            }
            if (zombie.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111127_a(this.VENGEANCE_SPEED_MODIFIER_ID) == null) {
                zombie.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(new AttributeModifier(this.VENGEANCE_SPEED_MODIFIER_ID, "Vengeance speed boost", 0.5, 1));
            }
            zombie.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 300, 2));
            zombie.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 300, 1));
            zombie.func_184195_f(false);
            zombie.getEntityData().func_74772_a("VengeanceEndTime", this.field_70170_p.func_82737_E() + 300L);
        }

        public EnumCreatureAttribute func_70668_bt() {
            return EnumCreatureAttribute.UNDEAD;
        }

        protected Item func_146068_u() {
            return Items.field_151078_bh;
        }

        public SoundEvent func_184639_G() {
            return (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("entity.zombie.ambient"));
        }

        public SoundEvent func_184601_bQ(DamageSource ds) {
            return (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("entity.zombie.hurt"));
        }

        public SoundEvent func_184615_bR() {
            return (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("entity.zombie.death"));
        }

        protected float func_70599_aP() {
            return 1.5f;
        }

        protected void func_110147_ax() {
            super.func_110147_ax();
            if (this.func_110148_a(SharedMonsterAttributes.field_188791_g) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(0.0);
            }
            if (this.func_110148_a(SharedMonsterAttributes.field_111263_d) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.23);
            }
            if (this.func_110148_a(SharedMonsterAttributes.field_111267_a) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
            }
            if (this.func_110148_a(SharedMonsterAttributes.field_111264_e) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
            }
            if (this.func_110148_a(SharedMonsterAttributes.field_111265_b) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
            }
            if (this.func_110148_a(SharedMonsterAttributes.field_111266_c) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.8);
            }
        }
    }
}

