/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.zombierush.entity;

import java.util.ArrayList;
import java.util.Iterator;
import net.mcreator.zombierush.ElementsZombieRushMod;
import net.minecraft.block.Block;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.entity.RenderBiped;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerBipedArmor;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ElementsZombieRushMod.ModElement.Tag
public class EntityZombieMiner2
extends ElementsZombieRushMod.ModElement {
    public static final int ENTITYID = 22;
    public static final int ENTITYID_RANGED = 23;

    public EntityZombieMiner2(ElementsZombieRushMod instance) {
        super(instance, 13);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EntityCustom.class).id(new ResourceLocation("zombie_rush", "zombie_miner_2"), 22).name("zombie_miner_2").tracker(64, 3, true).egg(-16764058, -13408768).build());
    }

    @Override
    public void init(FMLInitializationEvent event) {
        Biome[] spawnBiomes = this.allbiomes((RegistryNamespaced<ResourceLocation, Biome>)Biome.field_185377_q);
        EntityRegistry.addSpawn(EntityCustom.class, (int)30, (int)4, (int)4, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])spawnBiomes);
    }

    private Biome[] allbiomes(RegistryNamespaced<ResourceLocation, Biome> in) {
        Iterator itr = in.iterator();
        ArrayList ls = new ArrayList();
        while (itr.hasNext()) {
            ls.add(itr.next());
        }
        return ls.toArray(new Biome[ls.size()]);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInit(FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EntityCustom.class, renderManager -> {
            RenderBiped customRender = new RenderBiped(renderManager, new ModelBiped(){

                public void func_78087_a(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, Entity entityIn) {
                    super.func_78087_a(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, entityIn);
                    this.field_178723_h.field_78795_f = -0.9f;
                    this.field_178723_h.field_78796_g = 0.1f;
                    this.field_178724_i.field_78795_f = -0.9f;
                    this.field_178724_i.field_78796_g = -0.1f;
                }
            }, 0.5f){

                protected ResourceLocation func_110775_a(Entity entity) {
                    return new ResourceLocation("zombie_rush:textures/zombie_miner2.png");
                }
            };
            customRender.func_177094_a((LayerRenderer)new LayerBipedArmor((RenderLivingBase)customRender){

                protected void func_177177_a() {
                    this.field_177189_c = new ModelBiped(0.5f);
                    this.field_177186_d = new ModelBiped(1.0f);
                }
            });
            return customRender;
        });
    }

    public static class EntityCustom
    extends EntityZombie {
        public EntityCustom(World world) {
            super(world);
            this.func_70105_a(0.6f, 1.8f);
            this.field_70728_aV = 0;
            this.field_70178_ae = false;
            this.func_94061_f(false);
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151035_b, 1));
            this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(Blocks.field_150478_aa, 1));
        }

        protected void func_184651_r() {
            super.func_184651_r();
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIBreakBlocks(this));
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.2, false){

                protected double func_179512_a(EntityLivingBase entity) {
                    return this.field_75441_b.field_70130_N * this.field_75441_b.field_70130_N + entity.field_70130_N;
                }
            });
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
            this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
            this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIBreakDoor((EntityLiving)this));
        }

        public EnumCreatureAttribute func_70668_bt() {
            return EnumCreatureAttribute.UNDEAD;
        }

        protected Item func_146068_u() {
            return new ItemStack(Items.field_151078_bh, 1).func_77973_b();
        }

        public SoundEvent func_184639_G() {
            return (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("entity.zombie.ambient"));
        }

        public SoundEvent func_184601_bQ(DamageSource ds) {
            return (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("entity.zombie.hurt"));
        }

        public SoundEvent func_184615_bR() {
            return (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("entity.zombie.death"));
        }

        protected float func_70599_aP() {
            return 1.0f;
        }

        protected void func_110147_ax() {
            super.func_110147_ax();
            if (this.func_110148_a(SharedMonsterAttributes.field_188791_g) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(2.0);
            }
            if (this.func_110148_a(SharedMonsterAttributes.field_111263_d) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
            }
            if (this.func_110148_a(SharedMonsterAttributes.field_111267_a) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
            }
            if (this.func_110148_a(SharedMonsterAttributes.field_111264_e) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
            }
        }
    }

    public static class EntityAIBreakBlocks
    extends EntityAIBase {
        private final EntityCustom entity;
        private final World world;
        private BlockPos targetBlock;
        private int breakTime;
        private static final Block[] BREAKABLE_BLOCKS = new Block[]{Blocks.field_150347_e, Blocks.field_150348_b, Blocks.field_150344_f, Blocks.field_180407_aO, Blocks.field_180408_aP, Blocks.field_180404_aQ, Blocks.field_180403_aR, Blocks.field_180405_aT, Blocks.field_180406_aS, Blocks.field_150478_aa, Blocks.field_150468_ap, Blocks.field_150452_aw, Blocks.field_150456_au, Blocks.field_150359_w, Blocks.field_150410_aZ};

        public EntityAIBreakBlocks(EntityCustom entity) {
            this.entity = entity;
            this.world = entity.field_70170_p;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            if (this.entity.field_70173_aa % 10 != 0) {
                return false;
            }
            this.targetBlock = this.findBlockingBlock();
            return this.targetBlock != null;
        }

        public boolean func_75253_b() {
            return this.targetBlock != null && !this.world.func_175623_d(this.targetBlock) && this.isBreakableBlock(this.world.func_180495_p(this.targetBlock).func_177230_c()) && this.entity.func_174831_c(this.targetBlock) <= 9.0;
        }

        public void func_75249_e() {
            this.breakTime = 0;
            System.out.println("Zombie Miner started breaking block at: " + this.targetBlock);
        }

        public void func_75251_c() {
            this.targetBlock = null;
            this.breakTime = 0;
        }

        public void func_75246_d() {
            if (this.targetBlock == null) {
                return;
            }
            this.entity.func_70671_ap().func_75650_a((double)this.targetBlock.func_177958_n() + 0.5, (double)this.targetBlock.func_177956_o() + 0.5, (double)this.targetBlock.func_177952_p() + 0.5, 10.0f, 10.0f);
            ++this.breakTime;
            if (this.breakTime >= 20) {
                this.breakBlock();
                this.func_75251_c();
            }
        }

        private BlockPos findBlockingBlock() {
            BlockPos entityPos = new BlockPos(this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v);
            for (int y = 0; y <= 2; ++y) {
                BlockPos checkPos = entityPos.func_177972_a(this.entity.func_174811_aO()).func_177981_b(y);
                if (!this.world.func_175667_e(checkPos) || this.world.func_175623_d(checkPos) || !this.isBreakableBlock(this.world.func_180495_p(checkPos).func_177230_c())) continue;
                System.out.println("Found breakable block: " + this.world.func_180495_p(checkPos).func_177230_c() + " at " + checkPos);
                return checkPos;
            }
            BlockPos headPos = new BlockPos(this.entity.field_70165_t, this.entity.field_70163_u + 1.5, this.entity.field_70161_v);
            BlockPos sideHeadPos = headPos.func_177972_a(this.entity.func_174811_aO());
            if (this.world.func_175667_e(sideHeadPos) && !this.world.func_175623_d(sideHeadPos) && this.isBreakableBlock(this.world.func_180495_p(sideHeadPos).func_177230_c())) {
                System.out.println("Found breakable block at head level: " + this.world.func_180495_p(sideHeadPos).func_177230_c() + " at " + sideHeadPos);
                return sideHeadPos;
            }
            return null;
        }

        private boolean isBreakableBlock(Block block) {
            for (Block breakableBlock : BREAKABLE_BLOCKS) {
                if (breakableBlock != block) continue;
                return true;
            }
            return false;
        }

        private void breakBlock() {
            if (this.targetBlock != null && !this.world.func_175623_d(this.targetBlock)) {
                System.out.println("Breaking block: " + this.world.func_180495_p(this.targetBlock).func_177230_c() + " at " + this.targetBlock);
                this.world.func_175718_b(2001, this.targetBlock, Block.func_149682_b((Block)this.world.func_180495_p(this.targetBlock).func_177230_c()));
                this.world.func_175698_g(this.targetBlock);
                this.world.func_184133_a(null, this.targetBlock, SoundEvents.field_187835_fT, SoundCategory.BLOCKS, 0.8f, 1.0f);
            }
        }
    }
}

