/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.zombierush.entity;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import net.mcreator.zombierush.ElementsZombieRushMod;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ElementsZombieRushMod.ModElement.Tag
public class EntityZombiemimic2
extends ElementsZombieRushMod.ModElement {
    public static final int ENTITYID = 58;
    public static final int ENTITYID_RANGED = 59;
    private static final Set<Long> openedChests = new HashSet<Long>();

    public EntityZombiemimic2(ElementsZombieRushMod instance) {
        super(instance, 38);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EntityCustom.class).id(new ResourceLocation("zombie_rush", "zombiemimic2"), 58).name("zombiemimic2").tracker(64, 3, true).egg(-6724096, -13421824).build());
    }

    @Override
    public void init(FMLInitializationEvent event) {
        Biome[] spawnBiomes = this.allbiomes((RegistryNamespaced<ResourceLocation, Biome>)Biome.field_185377_q);
        EntityRegistry.addSpawn(EntityCustom.class, (int)0, (int)1, (int)4, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])spawnBiomes);
    }

    private Biome[] allbiomes(RegistryNamespaced<ResourceLocation, Biome> in) {
        Iterator itr = in.iterator();
        ArrayList ls = new ArrayList();
        while (itr.hasNext()) {
            ls.add(itr.next());
        }
        return ls.toArray(new Biome[ls.size()]);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInit(FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EntityCustom.class, renderManager -> new RenderLiving(renderManager, new ModelzombieMIMIK(), 0.5f){

            protected ResourceLocation func_110775_a(Entity entity) {
                return new ResourceLocation("zombie_rush:textures/untitled_11-13-2025_05-39-08.png");
            }
        });
    }

    @SubscribeEvent
    public void onChestOpen(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getWorld().field_72995_K) {
            TileEntity tileEntity;
            World world = event.getWorld();
            BlockPos pos = event.getPos();
            if (pos.func_177956_o() > 40) {
                return;
            }
            if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150486_ae && (tileEntity = world.func_175625_s(pos)) instanceof TileEntityChest) {
                Random rand;
                TileEntityChest chest = (TileEntityChest)tileEntity;
                long chestId = pos.func_177986_g();
                if (openedChests.contains(chestId)) {
                    return;
                }
                if (!this.isNaturalChest(world, pos)) {
                    return;
                }
                if (this.isChestInDungeon(world, pos) && !chest.func_191420_l() && (rand = world.field_73012_v).nextFloat() < 0.1f) {
                    openedChests.add(chestId);
                    this.spawnMimic(world, pos, event.getEntityPlayer());
                    chest.func_174888_l();
                    world.func_175698_g(pos);
                }
            }
        }
    }

    private boolean isNaturalChest(World world, BlockPos pos) {
        return this.isChestInDungeon(world, pos);
    }

    @SubscribeEvent
    public void onWorldLoad(BlockEvent event) {
    }

    private boolean isChestInDungeon(World world, BlockPos pos) {
        for (int x = -16; x <= 16; ++x) {
            for (int y = -8; y <= 8; ++y) {
                for (int z = -16; z <= 16; ++z) {
                    BlockPos checkPos = pos.func_177982_a(x, y, z);
                    if (world.func_180495_p(checkPos).func_177230_c() != Blocks.field_150474_ac) continue;
                    return true;
                }
            }
        }
        int mossyCobblestoneCount = 0;
        for (int x = -10; x <= 10; ++x) {
            for (int y = -5; y <= 5; ++y) {
                for (int z = -10; z <= 10; ++z) {
                    BlockPos checkPos = pos.func_177982_a(x, y, z);
                    if (world.func_180495_p(checkPos).func_177230_c() != Blocks.field_150341_Y || ++mossyCobblestoneCount < 5) continue;
                    return true;
                }
            }
        }
        if (pos.func_177956_o() < 60) {
            int stoneCount = 0;
            for (int x = -3; x <= 3; ++x) {
                for (int y = -2; y <= 2; ++y) {
                    for (int z = -3; z <= 3; ++z) {
                        BlockPos checkPos = pos.func_177982_a(x, y, z);
                        if (world.func_180495_p(checkPos).func_177230_c() != Blocks.field_150348_b && world.func_180495_p(checkPos).func_177230_c() != Blocks.field_150347_e || ++stoneCount < 10) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private void spawnMimic(World world, BlockPos pos, EntityPlayer player) {
        EntityCustom mimic = new EntityCustom(world);
        mimic.func_70012_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
        world.func_72838_d((Entity)mimic);
        mimic.func_70624_b((EntityLivingBase)player);
        world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)Blocks.field_150486_ae.func_176223_P()));
        mimic.func_184185_a(SoundEvents.field_187899_gZ, 1.0f, 1.0f);
    }

    public static void clearOpenedChests() {
        openedChests.clear();
    }

    public static class ModelzombieMIMIK
    extends ModelBase {
        private final ModelRenderer Waist;
        private final ModelRenderer Head;
        private final ModelRenderer Body;
        private final ModelRenderer group;
        private final ModelRenderer cube_r1;
        private final ModelRenderer cube_r2;
        private final ModelRenderer RightArm;
        private final ModelRenderer LeftArm;
        private final ModelRenderer RightLeg;
        private final ModelRenderer LeftLeg;

        public ModelzombieMIMIK() {
            this.field_78090_t = 64;
            this.field_78089_u = 128;
            this.Waist = new ModelRenderer((ModelBase)this);
            this.Waist.func_78793_a(0.0f, 12.0f, 0.0f);
            this.Head = new ModelRenderer((ModelBase)this);
            this.Head.func_78793_a(0.0f, -12.0f, 0.0f);
            this.Waist.func_78792_a(this.Head);
            this.Head.field_78804_l.add(new ModelBox(this.Head, 0, 23, -4.0f, -1.0f, -4.0f, 8, 8, 8, 0.0f, false));
            this.Body = new ModelRenderer((ModelBase)this);
            this.Body.func_78793_a(0.0f, -12.0f, 0.0f);
            this.Waist.func_78792_a(this.Body);
            this.Body.field_78804_l.add(new ModelBox(this.Body, 16, 39, -4.0f, 7.0f, -2.0f, 8, 8, 4, 0.0f, false));
            this.group = new ModelRenderer((ModelBase)this);
            this.group.func_78793_a(1.0f, 15.0f, -1.0f);
            this.Body.func_78792_a(this.group);
            this.group.field_78804_l.add(new ModelBox(this.group, 0, 89, -8.0f, -10.0f, -6.0f, 14, 10, 14, 0.0f, false));
            this.cube_r1 = new ModelRenderer((ModelBase)this);
            this.cube_r1.func_78793_a(0.0f, -22.0f, -1.0f);
            this.group.func_78792_a(this.cube_r1);
            this.setRotationAngle(this.cube_r1, -0.9599f, 0.0f, 0.0f);
            this.cube_r1.field_78804_l.add(new ModelBox(this.cube_r1, 0, 70, -2.0f, -3.0f, 0.0f, 2, 4, 2, 0.0f, false));
            this.cube_r2 = new ModelRenderer((ModelBase)this);
            this.cube_r2.func_78793_a(-1.0f, -10.0f, 8.0f);
            this.group.func_78792_a(this.cube_r2);
            this.setRotationAngle(this.cube_r2, -1.0036f, 0.0f, 0.0f);
            this.cube_r2.field_78804_l.add(new ModelBox(this.cube_r2, 0, 70, -7.0f, -4.0f, -14.0f, 14, 4, 14, 0.0f, false));
            this.RightArm = new ModelRenderer((ModelBase)this);
            this.RightArm.func_78793_a(-5.0f, -10.0f, 0.0f);
            this.Waist.func_78792_a(this.RightArm);
            this.RightArm.field_78804_l.add(new ModelBox(this.RightArm, 40, 39, -6.0f, 5.0f, -2.0f, 4, 9, 4, 0.0f, false));
            this.LeftArm = new ModelRenderer((ModelBase)this);
            this.LeftArm.func_78793_a(5.0f, -10.0f, 0.0f);
            this.Waist.func_78792_a(this.LeftArm);
            this.LeftArm.field_78804_l.add(new ModelBox(this.LeftArm, 40, 39, 2.0f, 5.0f, -2.0f, 4, 9, 4, 0.0f, false));
            this.RightLeg = new ModelRenderer((ModelBase)this);
            this.RightLeg.func_78793_a(-1.9f, 0.0f, 0.0f);
            this.Waist.func_78792_a(this.RightLeg);
            this.RightLeg.field_78804_l.add(new ModelBox(this.RightLeg, 0, 42, -2.0f, 3.0f, -2.0f, 4, 9, 4, 0.0f, false));
            this.LeftLeg = new ModelRenderer((ModelBase)this);
            this.LeftLeg.func_78793_a(1.9f, 0.0f, 0.0f);
            this.Waist.func_78792_a(this.LeftLeg);
            this.LeftLeg.field_78804_l.add(new ModelBox(this.LeftLeg, 0, 42, -2.0f, 3.0f, -2.0f, 4, 9, 4, 0.0f, false));
        }

        public void func_78088_a(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
            this.Waist.func_78785_a(f5);
        }

        public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
            modelRenderer.field_78795_f = x;
            modelRenderer.field_78796_g = y;
            modelRenderer.field_78808_h = z;
        }

        public void func_78087_a(float f, float f1, float f2, float f3, float f4, float f5, Entity e) {
            super.func_78087_a(f, f1, f2, f3, f4, f5, e);
            this.RightArm.field_78795_f = MathHelper.func_76134_b((float)(f * 0.6662f + (float)Math.PI)) * f1;
            this.LeftLeg.field_78795_f = MathHelper.func_76134_b((float)(f * 1.0f)) * -1.0f * f1;
            this.Head.field_78796_g = f3 / 57.295776f;
            this.Head.field_78795_f = f4 / 57.295776f;
            this.LeftArm.field_78795_f = MathHelper.func_76134_b((float)(f * 0.6662f)) * f1;
            this.RightLeg.field_78795_f = MathHelper.func_76134_b((float)(f * 1.0f)) * 1.0f * f1;
        }
    }

    public static class EntityCustom
    extends EntityZombie {
        public EntityCustom(World world) {
            super(world);
            this.func_70105_a(0.6f, 1.8f);
            this.field_70728_aV = 8;
            this.field_70178_ae = false;
            this.func_94061_f(false);
            this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Block)Blocks.field_150486_ae, 1));
            this.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(Items.field_151042_j, 1));
            this.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack(Items.field_151137_ax, 1));
            this.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack(Items.field_151043_k, 1));
        }

        protected void func_184651_r() {
            super.func_184651_r();
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.2, true){

                protected double func_179512_a(EntityLivingBase entity) {
                    return this.field_75441_b.field_70130_N * this.field_75441_b.field_70130_N + entity.field_70130_N;
                }
            });
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        }

        public EnumCreatureAttribute func_70668_bt() {
            return EnumCreatureAttribute.UNDEAD;
        }

        protected Item func_146068_u() {
            return new ItemStack(Items.field_151078_bh, 1).func_77973_b();
        }

        public SoundEvent func_184639_G() {
            return (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("entity.zombie.ambient"));
        }

        public SoundEvent func_184601_bQ(DamageSource ds) {
            return (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("entity.zombie.hurt"));
        }

        public SoundEvent func_184615_bR() {
            return (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("entity.zombie.death"));
        }

        protected float func_70599_aP() {
            return 1.0f;
        }

        protected void func_110147_ax() {
            super.func_110147_ax();
            if (this.func_110148_a(SharedMonsterAttributes.field_188791_g) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(5.0);
            }
            if (this.func_110148_a(SharedMonsterAttributes.field_111263_d) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
            }
            if (this.func_110148_a(SharedMonsterAttributes.field_111267_a) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
            }
            if (this.func_110148_a(SharedMonsterAttributes.field_111264_e) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
            }
        }
    }
}

