/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.config;

import me.desht.pneumaticcraft.client.pneumatic_armor.ClientArmorRegistry;
import me.desht.pneumaticcraft.common.block.entity.utility.AerialInterfaceBlockEntity;
import me.desht.pneumaticcraft.common.config.ClientConfig;
import me.desht.pneumaticcraft.common.config.CommonConfig;
import me.desht.pneumaticcraft.common.recipes.machine.PressureDisenchantingRecipe;
import me.desht.pneumaticcraft.common.worldgen.OilLakeFilter;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigHolder {
    static ClientConfig client;
    static CommonConfig common;
    private static ModConfigSpec configCommonSpec;
    private static ModConfigSpec configClientSpec;

    public static void init(ModContainer container, IEventBus modBus) {
        Pair spec1 = new ModConfigSpec.Builder().configure(ClientConfig::new);
        client = (ClientConfig)spec1.getLeft();
        configClientSpec = (ModConfigSpec)spec1.getRight();
        Pair spec2 = new ModConfigSpec.Builder().configure(CommonConfig::new);
        common = (CommonConfig)spec2.getLeft();
        configCommonSpec = (ModConfigSpec)spec2.getRight();
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)configCommonSpec);
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)configClientSpec);
        modBus.addListener(ConfigHolder::onConfigChanged);
    }

    private static void onConfigChanged(ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == configClientSpec) {
            ConfigHolder.refreshClient();
        } else if (config.getSpec() == configCommonSpec) {
            ConfigHolder.refreshCommon();
        }
    }

    static void refreshClient() {
        ClientArmorRegistry.getInstance().refreshConfig();
    }

    static void refreshCommon() {
        OilLakeFilter.DimensionFilter.clearMatcherCaches();
        AerialInterfaceBlockEntity.clearDimensionBlacklist();
        PressureDisenchantingRecipe.clearCachedBlacklist();
    }

    static void saveClient() {
        configClientSpec.save();
    }
}

