/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets.area;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.api.drone.area.AreaType;
import me.desht.pneumaticcraft.api.drone.area.AreaTypeSerializer;
import me.desht.pneumaticcraft.api.drone.area.AreaTypeWidget;
import me.desht.pneumaticcraft.api.misc.ITranslatableEnum;
import me.desht.pneumaticcraft.common.registry.ModProgWidgetAreaTypes;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public class AreaTypeTorus
extends AreaType {
    public static final MapCodec<AreaTypeTorus> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)StringRepresentable.fromEnum(AreaType.AreaAxis::values).optionalFieldOf("axis", (Object)AreaType.AreaAxis.X).forGetter(t -> t.axis), (App)StringRepresentable.fromEnum(TorusType::values).optionalFieldOf("torus_type", (Object)TorusType.FILLED).forGetter(t -> t.torusType)).apply((Applicative)builder, AreaTypeTorus::new));
    public static final StreamCodec<FriendlyByteBuf, AreaTypeTorus> STREAM_CODEC = StreamCodec.composite((StreamCodec)NeoForgeStreamCodecs.enumCodec(AreaType.AreaAxis.class), t -> t.axis, (StreamCodec)NeoForgeStreamCodecs.enumCodec(TorusType.class), t -> t.torusType, AreaTypeTorus::new);
    public static final String ID = "torus";
    private AreaType.AreaAxis axis;
    private TorusType torusType;

    public AreaTypeTorus(AreaType.AreaAxis axis, TorusType torusType) {
        super(ID);
        this.axis = axis;
        this.torusType = torusType;
    }

    @Override
    public AreaType copy() {
        return new AreaTypeTorus(this.axis, this.torusType);
    }

    public AreaTypeTorus() {
        this(AreaType.AreaAxis.X, TorusType.FILLED);
    }

    public String toString() {
        return this.getName() + "/" + String.valueOf(this.torusType) + "/" + String.valueOf(this.axis);
    }

    @Override
    public AreaTypeSerializer<? extends AreaType> getSerializer() {
        return ModProgWidgetAreaTypes.AREA_TYPE_TORUS.get();
    }

    @Override
    public void addArea(Consumer<BlockPos> areaAdder, BlockPos p1, BlockPos p2, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        switch (this.axis) {
            case X: {
                double radMajor = Math.round(PneumaticCraftUtils.distBetween(p1.getY(), (double)p1.getZ(), (double)p2.getY(), (double)p2.getZ()));
                double radMinor = Math.abs(p1.getX() - p2.getX());
                int RSq = (int)(radMajor * radMajor);
                int rSq = (int)(radMinor * radMinor);
                int rSqI = (int)((radMinor - 1.0) * (radMinor - 1.0));
                int pX = p1.getX();
                int pY = p1.getY();
                int pZ = p1.getZ();
                int apoX = (int)radMinor;
                int apoY = (int)(radMajor + radMinor);
                int apoZ = (int)(radMajor + radMinor);
                for (int y = -apoY; y <= apoY; ++y) {
                    for (int z = -apoZ; z <= apoZ; ++z) {
                        for (int x = -apoX; x <= apoX; ++x) {
                            int xSq = x * x;
                            int ySq = y * y;
                            int zSq = z * z;
                            if (this.torusType == TorusType.FILLED) {
                                if ((xSq + ySq + zSq + RSq - rSq) * (xSq + ySq + zSq + RSq - rSq) >= 4 * RSq * (ySq + zSq)) continue;
                                areaAdder.accept(new BlockPos(x + pX, y + pY, z + pZ));
                                continue;
                            }
                            if (this.torusType != TorusType.HOLLOW || (xSq + ySq + zSq + RSq - rSq) * (xSq + ySq + zSq + RSq - rSq) >= 4 * RSq * (ySq + zSq) || (xSq + ySq + zSq + RSq - rSqI) * (xSq + ySq + zSq + RSq - rSqI) < 4 * RSq * (ySq + zSq)) continue;
                            areaAdder.accept(new BlockPos(x + pX, y + pY, z + pZ));
                        }
                    }
                }
                break;
            }
            case Y: {
                double radMajor = Math.round(PneumaticCraftUtils.distBetween(p1.getX(), (double)p1.getZ(), (double)p2.getX(), (double)p2.getZ()));
                double radMinor = Math.abs(p1.getY() - p2.getY());
                int RSq = (int)(radMajor * radMajor);
                int rSq = (int)(radMinor * radMinor);
                int rSqI = (int)((radMinor - 1.0) * (radMinor - 1.0));
                int pX = p1.getX();
                int pY = p1.getY();
                int pZ = p1.getZ();
                int apoX = (int)(radMajor + radMinor);
                int apoY = (int)radMinor;
                int apoZ = (int)(radMajor + radMinor);
                for (int x = -apoX; x <= apoX; ++x) {
                    for (int z = -apoZ; z <= apoZ; ++z) {
                        for (int y = -apoY; y <= apoY; ++y) {
                            int xSq = x * x;
                            int ySq = y * y;
                            int zSq = z * z;
                            if (this.torusType == TorusType.FILLED) {
                                if ((xSq + ySq + zSq + RSq - rSq) * (xSq + ySq + zSq + RSq - rSq) >= 4 * RSq * (xSq + zSq)) continue;
                                areaAdder.accept(new BlockPos(x + pX, y + pY, z + pZ));
                                continue;
                            }
                            if (this.torusType != TorusType.HOLLOW || (xSq + ySq + zSq + RSq - rSq) * (xSq + ySq + zSq + RSq - rSq) >= 4 * RSq * (xSq + zSq) || (xSq + ySq + zSq + RSq - rSqI) * (xSq + ySq + zSq + RSq - rSqI) < 4 * RSq * (xSq + zSq)) continue;
                            areaAdder.accept(new BlockPos(x + pX, y + pY, z + pZ));
                        }
                    }
                }
                break;
            }
            case Z: {
                double radMajor = Math.round(PneumaticCraftUtils.distBetween(p1.getX(), (double)p1.getY(), (double)p2.getX(), (double)p2.getY()));
                double radMinor = Math.abs(p1.getZ() - p2.getZ());
                int RSq = (int)(radMajor * radMajor);
                int rSq = (int)(radMinor * radMinor);
                int rSqI = (int)((radMinor - 1.0) * (radMinor - 1.0));
                int pX = p1.getX();
                int pY = p1.getY();
                int pZ = p1.getZ();
                int apoX = (int)(radMajor + radMinor);
                int apoY = (int)(radMajor + radMinor);
                int apoZ = (int)radMinor;
                for (int x = -apoX; x <= apoX; ++x) {
                    for (int y = -apoY; y <= apoY; ++y) {
                        for (int z = -apoZ; z <= apoZ; ++z) {
                            int xSq = x * x;
                            int ySq = y * y;
                            int zSq = z * z;
                            if (this.torusType == TorusType.FILLED) {
                                if ((xSq + ySq + zSq + RSq - rSq) * (xSq + ySq + zSq + RSq - rSq) >= 4 * RSq * (xSq + ySq)) continue;
                                areaAdder.accept(new BlockPos(x + pX, y + pY, z + pZ));
                                continue;
                            }
                            if (this.torusType != TorusType.HOLLOW || (xSq + ySq + zSq + RSq - rSq) * (xSq + ySq + zSq + RSq - rSq) >= 4 * RSq * (xSq + ySq) || (xSq + ySq + zSq + RSq - rSqI) * (xSq + ySq + zSq + RSq - rSqI) < 4 * RSq * (xSq + ySq)) continue;
                            areaAdder.accept(new BlockPos(x + pX, y + pY, z + pZ));
                        }
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException(this.axis.toString());
            }
        }
    }

    @Override
    public void addUIWidgets(List<AreaTypeWidget> widgets) {
        super.addUIWidgets(widgets);
        widgets.add(new AreaTypeWidget.EnumSelectorField<TorusType>("pneumaticcraft.gui.progWidget.area.type.torus.torusType", TorusType.class, () -> this.torusType, torusType -> {
            this.torusType = torusType;
        }));
        widgets.add(new AreaTypeWidget.EnumSelectorField<AreaType.AreaAxis>("pneumaticcraft.gui.progWidget.area.type.general.axis", AreaType.AreaAxis.class, () -> this.axis, axis -> {
            this.axis = axis;
        }));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AreaTypeTorus that = (AreaTypeTorus)o;
        return this.axis == that.axis && this.torusType == that.torusType;
    }

    public int hashCode() {
        return Objects.hash(this.axis, this.torusType);
    }

    public static enum TorusType implements ITranslatableEnum,
    StringRepresentable
    {
        FILLED("filled"),
        HOLLOW("hollow");

        private final String name;

        private TorusType(String name) {
            this.name = name;
        }

        @Override
        public String getTranslationKey() {
            return "pneumaticcraft.gui.progWidget.area.type.torus.torusType." + this.name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

