/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.fluid;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;

public class PNCFluidRenderProps
implements IClientFluidTypeExtensions {
    private final ResourceLocation still;
    private final ResourceLocation flowing;
    private final int colorTint;

    public PNCFluidRenderProps(String still, String flowing) {
        this(still, flowing, -1);
    }

    public PNCFluidRenderProps(String still, String flowing, int colorTint) {
        this.still = still.indexOf(58) > 0 ? ResourceLocation.parse((String)still) : PneumaticRegistry.RL("block/fluid/" + still);
        this.flowing = flowing.indexOf(58) > 0 ? ResourceLocation.parse((String)flowing) : PneumaticRegistry.RL("block/fluid/" + flowing);
        this.colorTint = colorTint;
    }

    public static PNCFluidRenderProps thickFluid(int colorTint) {
        return new PNCFluidRenderProps("thick_fluid_still", "thick_fluid_flow", colorTint);
    }

    public static PNCFluidRenderProps waterLike(int colorTint) {
        return new PNCFluidRenderProps("minecraft:block/water_still", "minecraft:block/water_flow", colorTint);
    }

    public static PNCFluidRenderProps texture(String textureBase) {
        return PNCFluidRenderProps.texture(textureBase, -1);
    }

    public static PNCFluidRenderProps texture(String textureBase, int colorTint) {
        return new PNCFluidRenderProps(textureBase + "_still", textureBase + "_flowing", colorTint);
    }

    public ResourceLocation getStillTexture() {
        return this.still;
    }

    public ResourceLocation getFlowingTexture() {
        return this.flowing;
    }

    public int getTintColor() {
        return this.colorTint;
    }
}

