/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.List;
import java.util.Optional;
import me.desht.pneumaticcraft.api.item.IProgrammable;
import me.desht.pneumaticcraft.client.gui.SecurityStationHackingScreen;
import me.desht.pneumaticcraft.common.registry.ModDataComponents;
import me.desht.pneumaticcraft.common.registry.ModItems;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class NetworkComponentItem
extends Item
implements IProgrammable {
    private final NetworkComponentType type;

    public NetworkComponentItem(NetworkComponentType type) {
        super(ModItems.defaultProps());
        this.type = type;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> curInfo, TooltipFlag extraInfo) {
        super.appendHoverText(stack, context, curInfo, extraInfo);
        if (context.registries() != null) {
            SecurityStationHackingScreen.addExtraHackInfoStatic(curInfo);
        }
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (entity.getCommandSenderWorld().isClientSide && stack.has(ModDataComponents.SAVED_DRONE_PROGRAM)) {
            entity.setExtendedLifetime();
        }
        return false;
    }

    @Override
    public boolean canProgram(ItemStack stack) {
        return this.type == NetworkComponentType.NETWORK_API || this.type == NetworkComponentType.NETWORK_DATA_STORAGE;
    }

    @Override
    public boolean usesPieces(ItemStack stack) {
        return this.type == NetworkComponentType.NETWORK_API;
    }

    @Override
    public boolean showProgramTooltip() {
        return true;
    }

    public static Optional<NetworkComponentType> getType(ItemStack stack) {
        Optional<NetworkComponentType> optional;
        Item item = stack.getItem();
        if (item instanceof NetworkComponentItem) {
            NetworkComponentItem n = (NetworkComponentItem)item;
            optional = Optional.ofNullable(n.type);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isType(ItemStack stack, NetworkComponentType type) {
        Item item = stack.getItem();
        if (!(item instanceof NetworkComponentItem)) return false;
        NetworkComponentItem n = (NetworkComponentItem)item;
        if (n.type != type) return false;
        return true;
    }

    public static enum NetworkComponentType {
        DIAGNOSTIC_SUBROUTINE("diagnostic_subroutine", true),
        NETWORK_API("network_api", false),
        NETWORK_DATA_STORAGE("network_data_storage", false),
        NETWORK_IO_PORT("network_io_port", true),
        NETWORK_REGISTRY("network_registry", true),
        NETWORK_NODE("network_node", true);

        private final String name;
        private final boolean secStationComponent;

        private NetworkComponentType(String name, boolean secStationComponent) {
            this.name = name;
            this.secStationComponent = secStationComponent;
        }

        public boolean isSecStationComponent() {
            return this.secStationComponent;
        }

        public String getRegistryName() {
            return this.name;
        }
    }
}

