/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item.logistics;

import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.api.misc.Symbols;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.inventory.LogisticsMenu;
import me.desht.pneumaticcraft.common.registry.ModDataComponents;
import me.desht.pneumaticcraft.common.semiblock.SemiblockItem;
import me.desht.pneumaticcraft.common.util.FluidFilter;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.items.ItemStackHandler;

public abstract class AbstractLogisticsFrameItem
extends SemiblockItem {
    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand handIn) {
        final ItemStack stack = player.getItemInHand(handIn);
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            sp.openMenu(new MenuProvider(){

                public Component getDisplayName() {
                    return stack.getHoverName();
                }

                public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
                    return new LogisticsMenu(AbstractLogisticsFrameItem.this.getContainerType(), i, playerInventory, -1);
                }
            }, buffer -> buffer.writeVarInt(-1));
        }
        return InteractionResultHolder.success((Object)stack);
    }

    protected abstract MenuType<?> getContainerType();

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> curInfo, TooltipFlag extraInfo) {
        super.appendHoverText(stack, context, curInfo, extraInfo);
        AbstractLogisticsFrameItem.addLogisticsTooltip(stack, context, curInfo, ClientUtils.hasShiftDown());
    }

    public static List<Component> addLogisticsTooltip(ItemStack stack, Item.TooltipContext context, List<Component> curInfo, boolean sneaking) {
        HolderLookup.Provider provider = context.registries();
        if (stack.has(ModDataComponents.SEMIBLOCK_DATA) && stack.getItem() instanceof SemiblockItem && provider != null) {
            if (sneaking) {
                boolean whitelist;
                CompoundTag tag = ((CustomData)stack.getOrDefault(ModDataComponents.SEMIBLOCK_DATA, (Object)CustomData.EMPTY)).copyTag();
                if (tag.getBoolean("invisible")) {
                    curInfo.add((Component)Symbols.bullet().append((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.logistics_frame.invisible", new Object[0])).withStyle(ChatFormatting.YELLOW));
                }
                if (tag.getBoolean("matchDurability")) {
                    curInfo.add((Component)Symbols.bullet().append((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.logistics_frame.matchDurability", new Object[0])).withStyle(ChatFormatting.YELLOW));
                }
                if (tag.getBoolean("matchComponents")) {
                    curInfo.add((Component)Symbols.bullet().append((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.logistics_frame.matchNBT", new Object[0])).withStyle(ChatFormatting.YELLOW));
                }
                if (tag.getBoolean("matchModID")) {
                    curInfo.add((Component)Symbols.bullet().append((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.logistics_frame.matchModId", new Object[0])).withStyle(ChatFormatting.YELLOW));
                }
                curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.logistics_frame." + ((whitelist = tag.getBoolean("whitelist")) ? "itemWhitelist" : "itemBlacklist"), new Object[0]).append(":").withStyle(ChatFormatting.YELLOW));
                ItemStackHandler handler = new ItemStackHandler();
                handler.deserializeNBT(provider, tag.getCompound("filters"));
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                for (int i = 0; i < handler.getSlots(); ++i) {
                    if (handler.getStackInSlot(i).isEmpty()) continue;
                    stacks.add(handler.getStackInSlot(i));
                }
                int tooltipSize = curInfo.size();
                PneumaticCraftUtils.summariseItemStacks(curInfo, stacks, Component.literal((String)"\u2022 ").withStyle(ChatFormatting.GOLD));
                if (curInfo.size() == tooltipSize) {
                    curInfo.add((Component)Symbols.bullet().withStyle(ChatFormatting.GOLD).append((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.no_items", new Object[0]).withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.ITALIC})));
                }
                tooltipSize = curInfo.size();
                whitelist = tag.getBoolean("fluidWhitelist");
                curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.logistics_frame." + (whitelist ? "fluidWhitelist" : "fluidBlacklist"), new Object[0]).append(":").withStyle(ChatFormatting.YELLOW));
                FluidFilter.CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag.getCompound("fluidFilters")).ifSuccess(fluidFilter -> {
                    for (int i = 0; i < fluidFilter.size(); ++i) {
                        FluidStack fluid = fluidFilter.getFluid(i);
                        if (fluid.isEmpty()) continue;
                        curInfo.add((Component)Symbols.bullet().append(fluid.getAmount() + "mB ").append(fluid.getHoverName()).withStyle(ChatFormatting.GOLD));
                    }
                });
                if (curInfo.size() == tooltipSize) {
                    curInfo.add((Component)Symbols.bullet().withStyle(ChatFormatting.GOLD).append((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.no_fluids", new Object[0]).withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.ITALIC})));
                }
            } else {
                curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.logistics_frame.hasFilters", new Object[0]));
            }
        }
        return curInfo;
    }
}

