/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util.legacyconv;

import com.google.common.base.CaseFormat;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.drone.area.AreaType;
import me.desht.pneumaticcraft.api.drone.area.AreaTypeSerializer;
import me.desht.pneumaticcraft.api.drone.area.EnumOldAreaType;
import me.desht.pneumaticcraft.api.registry.PNCRegistries;
import me.desht.pneumaticcraft.common.drone.progwidgets.IBlockOrdered;
import me.desht.pneumaticcraft.common.drone.progwidgets.ICondition;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetCoordinateOperator;
import me.desht.pneumaticcraft.common.drone.progwidgets.area.AreaTypeBox;
import me.desht.pneumaticcraft.common.drone.progwidgets.area.AreaTypeCylinder;
import me.desht.pneumaticcraft.common.drone.progwidgets.area.AreaTypePyramid;
import me.desht.pneumaticcraft.common.drone.progwidgets.area.AreaTypeSphere;
import me.desht.pneumaticcraft.common.drone.progwidgets.area.AreaTypeTorus;
import me.desht.pneumaticcraft.common.util.legacyconv.ConversionUtil;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import org.apache.commons.lang3.mutable.MutableByte;

public class ProgWidgetLegacyConv {
    public static int determineVersion(JsonObject json) {
        if (json.has("version")) {
            return json.get("version").getAsInt();
        }
        if (json.has("pneumaticcraft:progWidgets")) {
            return 2;
        }
        if (json.has("widgets")) {
            return 1;
        }
        throw new JsonSyntaxException("can't determine saved progwidget version!");
    }

    public static void convertLegacy(JsonObject json, int oldVersion) {
        switch (oldVersion) {
            case 1: {
                ProgWidgetLegacyConv.convertV1toV2(json);
                break;
            }
            case 2: {
                ProgWidgetLegacyConv.convertV2toV3(json);
                break;
            }
        }
    }

    private static void convertV1toV2(JsonObject json) {
        JsonArray entries = json.getAsJsonObject("widgets").getAsJsonArray("value");
        for (JsonElement el : entries) {
            JsonObject oldEntry = el.getAsJsonObject();
            JsonObject nameObj = oldEntry.getAsJsonObject("name");
            String newName = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, nameObj.get("value").getAsString());
            nameObj.addProperty("value", "pneumaticcraft:" + newName);
            if (!newName.equals("area")) continue;
            JsonObject typeObj = oldEntry.getAsJsonObject("type");
            EnumOldAreaType oldType = EnumOldAreaType.values()[typeObj.get("value").getAsInt()];
            AreaType newType = LegacyAreaWidgetConverter.convertFromLegacyFormat(oldType, oldEntry.getAsJsonObject("typeInfo").get("value").getAsInt());
            typeObj.addProperty("type", (Number)8);
            typeObj.addProperty("value", newType.getName());
        }
        json.add("pneumaticcraft:progWidgets", (JsonElement)Util.make((Object)new JsonObject(), j -> {
            j.addProperty("type", (Number)9);
            j.add("value", (JsonElement)entries);
        }));
        json.remove("widgets");
    }

    private static void convertV2toV3(JsonObject json) {
        JsonArray entries = json.getAsJsonObject("pneumaticcraft:progWidgets").getAsJsonArray("value");
        JsonArray newDoc = new JsonArray();
        for (JsonElement entry : entries) {
            JsonObject oldEntry = entry.getAsJsonObject();
            JsonObject newEntry = new JsonObject();
            JsonObject pos = new JsonObject();
            JsonObject inv = new JsonObject();
            JsonObject cond = new JsonObject();
            JsonObject droneCond = new JsonObject();
            JsonObject digPlace = new JsonObject();
            Object widgetType = ConversionUtil.getString(oldEntry, "name").orElseThrow(() -> new JsonSyntaxException("no 'name' field!"));
            if (!((String)widgetType).contains(":")) {
                widgetType = "pneumaticcraft:" + (String)widgetType;
            }
            newEntry.addProperty("type", (String)widgetType);
            Object widgetBaseType = ((String)widgetType).contains(":") ? ((String)widgetType).split(":")[1] : widgetType;
            ConversionUtil.getInt(oldEntry, "x").ifPresent(val -> pos.addProperty("x", (Number)val));
            ConversionUtil.getInt(oldEntry, "y").ifPresent(val -> pos.addProperty("y", (Number)val));
            JsonObject destObj1 = ((String)widgetBaseType).equals("crafting") ? newEntry : inv;
            ConversionUtil.getInt(oldEntry, "count").ifPresent(val -> destObj1.addProperty("count", (Number)val));
            ConversionUtil.getBool(oldEntry, "useCount").ifPresent(val -> destObj1.addProperty("use_count", val));
            byte sides = ProgWidgetLegacyConv.findSides(oldEntry);
            if (sides != 0) {
                (((String)widgetBaseType).equals("emit_redstone") ? newEntry : inv).addProperty("sides", (Number)sides);
            }
            ConversionUtil.getInt(oldEntry, "order").ifPresent(val -> digPlace.addProperty("order", IBlockOrdered.Ordering.values()[val].getSerializedName()));
            ConversionUtil.getBool(oldEntry, "useMaxActions").ifPresent(val -> digPlace.addProperty("use_max_actions", val));
            ConversionUtil.getInt(oldEntry, "maxActions").ifPresent(val -> digPlace.addProperty("max_actions", (Number)val));
            ConversionUtil.getBool(oldEntry, "requireDiggingTool").ifPresent(val -> newEntry.addProperty("require_tool", val));
            ConversionUtil.getBool(oldEntry, "requireHoe").ifPresent(val -> newEntry.addProperty("require_hoe", val));
            ConversionUtil.getBool(oldEntry, "sneaking").ifPresent(val -> newEntry.addProperty("sneaking", val));
            ConversionUtil.getString(oldEntry, "clickType").ifPresent(val -> newEntry.addProperty("click_type", val.toLowerCase(Locale.ROOT)));
            ConversionUtil.getInt(oldEntry, "dir").ifPresent(val -> newEntry.addProperty("side", Direction.from3DDataValue((int)val).getSerializedName()));
            JsonObject destObj2 = ((String)widgetBaseType).startsWith("drone_condition") ? droneCond : cond;
            ConversionUtil.getBool(oldEntry, "isAndFunction").ifPresent(val -> destObj2.addProperty("and_func", val));
            ConversionUtil.getString(oldEntry, "measureVar").ifPresent(val -> destObj2.addProperty("measure_var", val));
            ConversionUtil.getInt(oldEntry, "operator").ifPresent(arg_0 -> ProgWidgetLegacyConv.lambda$convertV2toV3$16((String)widgetBaseType, destObj2, arg_0));
            ConversionUtil.getInt(oldEntry, "requiredCount").ifPresent(val -> droneCond.addProperty("required_count", (Number)val));
            ConversionUtil.getBool(oldEntry, "checkingForAir").ifPresent(val -> newEntry.addProperty("check_air", val));
            ConversionUtil.getBool(oldEntry, "checkingForLiquids").ifPresent(val -> newEntry.addProperty("check_liquid", val));
            if (oldEntry.has("coord")) {
                ConversionUtil.convXYZ(oldEntry.getAsJsonObject("coord").getAsJsonObject("value"), newEntry, "", "coord");
            }
            if (oldEntry.has("posX")) {
                ConversionUtil.convXYZ(oldEntry, newEntry, "pos", "coord");
            }
            ConversionUtil.getString(oldEntry, "variable").ifPresent(val -> newEntry.addProperty("var", val));
            ConversionUtil.getBool(oldEntry, "useVariable").ifPresent(val -> newEntry.addProperty("using_var", val));
            byte axes = ProgWidgetLegacyConv.findAxes(oldEntry);
            if (axes != 0) {
                newEntry.add("axis_options", (JsonElement)Util.make((Object)new JsonObject(), j -> j.addProperty("axes", (Number)axes)));
            }
            ConversionUtil.getInt(oldEntry, "operator").ifPresent(arg_0 -> ProgWidgetLegacyConv.lambda$convertV2toV3$23((String)widgetBaseType, newEntry, arg_0));
            ConversionUtil.getBool(oldEntry, "checkSight").ifPresent(val -> newEntry.addProperty("check_sight", val));
            ConversionUtil.getBool(oldEntry, "useMaxActions").ifPresent(val -> newEntry.addProperty("use_max_actions", val));
            ConversionUtil.getInt(oldEntry, "maxActions").ifPresent(val -> newEntry.addProperty("max_actions", (Number)val));
            if (((String)widgetBaseType).equals("area")) {
                if (oldEntry.has("pos1")) {
                    ConversionUtil.convXYZ(oldEntry.getAsJsonObject("pos1").getAsJsonObject("value"), newEntry, "", "pos1");
                    if (oldEntry.has("pos2")) {
                        ConversionUtil.convXYZ(oldEntry.getAsJsonObject("pos2").getAsJsonObject("value"), newEntry, "", "pos2");
                    }
                } else {
                    int x1 = ConversionUtil.getInt(oldEntry, "x1").orElse(0);
                    int y1 = ConversionUtil.getInt(oldEntry, "y1").orElse(0);
                    int z1 = ConversionUtil.getInt(oldEntry, "z1").orElse(0);
                    int x2 = ConversionUtil.getInt(oldEntry, "x2").orElse(0);
                    int y2 = ConversionUtil.getInt(oldEntry, "y2").orElse(0);
                    int z2 = ConversionUtil.getInt(oldEntry, "z2").orElse(0);
                    newEntry.add("pos1", (JsonElement)ConversionUtil.makeArray(x1, y1, z1));
                    newEntry.add("pos2", (JsonElement)ConversionUtil.makeArray(x2, y2, z2));
                }
                ConversionUtil.getString(oldEntry, "coord1Variable").ifPresent(val -> newEntry.addProperty("var1", val));
                ConversionUtil.getString(oldEntry, "var1").ifPresent(val -> newEntry.addProperty("var1", val));
                ConversionUtil.getString(oldEntry, "coord2Variable").ifPresent(val -> newEntry.addProperty("var2", val));
                ConversionUtil.getString(oldEntry, "var2").ifPresent(val -> newEntry.addProperty("var2", val));
                ConversionUtil.getString(oldEntry, "type").ifPresent(val -> {
                    JsonObject areaType = new JsonObject();
                    areaType.addProperty("type", "pneumaticcraft:" + val);
                    ConversionUtil.getInt(oldEntry, "axis").ifPresent(val1 -> areaType.addProperty("axis", AreaType.AreaAxis.values()[val1].getSerializedName()));
                    ConversionUtil.getInt(oldEntry, "boxType").ifPresent(val1 -> areaType.addProperty("box_type", AreaTypeBox.BoxType.values()[val1].getSerializedName()));
                    ConversionUtil.getInt(oldEntry, "cylinderType").ifPresent(val1 -> areaType.addProperty("cylinder_type", AreaTypeCylinder.CylinderType.values()[val1].getSerializedName()));
                    ConversionUtil.getInt(oldEntry, "sphereType").ifPresent(val1 -> areaType.addProperty("sphere_type", AreaTypeSphere.SphereType.values()[val1].getSerializedName()));
                    ConversionUtil.getInt(oldEntry, "pyramidType").ifPresent(val1 -> areaType.addProperty("pyramid_type", AreaTypePyramid.PyramidType.values()[val1].getSerializedName()));
                    ConversionUtil.getInt(oldEntry, "torusType").ifPresent(val1 -> areaType.addProperty("torus_type", AreaTypeTorus.TorusType.values()[val1].getSerializedName()));
                    ConversionUtil.getInt(oldEntry, "interval").ifPresent(val1 -> areaType.addProperty("interval", (Number)val1));
                    ConversionUtil.getInt(oldEntry, "pickedAmount").ifPresent(val1 -> areaType.addProperty("picked_amount", (Number)val1));
                    newEntry.add("area_type", (JsonElement)areaType);
                });
            }
            ConversionUtil.getBool(oldEntry, "shareVariables").ifPresent(val -> newEntry.addProperty("share_variables", val));
            ConversionUtil.getString(oldEntry, "doneWhenDeparting").ifPresent(val -> newEntry.addProperty("done_when_depart", val));
            ConversionUtil.getString(oldEntry, "string").ifPresent(val -> newEntry.addProperty("string", val));
            ConversionUtil.getBool(oldEntry, "back").ifPresent(val -> newEntry.addProperty("back_side", val));
            ConversionUtil.getBool(oldEntry, "dropStraight").ifPresent(val -> newEntry.addProperty("drop_straight", val));
            ConversionUtil.getBool(oldEntry, "pickupDelay").ifPresent(val -> newEntry.addProperty("pickup_delay", val));
            ConversionUtil.getBool(oldEntry, "canSteal").ifPresent(val -> newEntry.addProperty("can_steal", val));
            ConversionUtil.getBool(oldEntry, "allowStandbyPickup").ifPresent(val -> newEntry.addProperty("allow_pickup", val));
            ConversionUtil.getBool(oldEntry, "placeFluidBlocks").ifPresent(val -> newEntry.addProperty("place_fluid_blocks", val));
            if (((String)widgetBaseType).equals("item_filter")) {
                JsonObject item = new JsonObject();
                ConversionUtil.getString(oldEntry, "id").ifPresent(val -> item.addProperty("id", val));
                ConversionUtil.getInt(oldEntry, "Count").ifPresent(val -> item.addProperty("count", (Number)val));
                if (item.has("id")) {
                    newEntry.add("chk_item", (JsonElement)item);
                }
                ConversionUtil.getBool(oldEntry, "useMetadata").ifPresent(val -> newEntry.addProperty("chk_durability", val));
                ConversionUtil.getBool(oldEntry, "useNBT").ifPresent(val -> newEntry.addProperty("chk_components", val));
                ConversionUtil.getBool(oldEntry, "useModSimilarity").ifPresent(val -> newEntry.addProperty("chk_mod", val));
                ConversionUtil.getBool(oldEntry, "matchBlock").ifPresent(val -> newEntry.addProperty("chk_block", val));
            }
            if (((String)widgetBaseType).equals("liquid_filter")) {
                ConversionUtil.getString(oldEntry, "fluid").ifPresent(val -> newEntry.add("fluid", (JsonElement)Util.make((Object)new JsonObject(), j -> {
                    j.addProperty("id", val);
                    j.addProperty("amount", (Number)1000);
                })));
            }
            newEntry.add("pos", (JsonElement)pos);
            if (digPlace.size() > 0) {
                newEntry.add("dig_place", (JsonElement)digPlace);
            }
            if (inv.size() > 0) {
                newEntry.add("inv", (JsonElement)inv);
            }
            if (cond.size() > 0) {
                newEntry.add("cond", (JsonElement)cond);
            }
            if (droneCond.size() > 0) {
                newEntry.add("drone_cond", (JsonElement)cond);
            }
            newDoc.add((JsonElement)newEntry);
        }
        json.add("widgets", (JsonElement)newDoc);
        json.remove("pneumaticcraft:progWidgets");
        json.addProperty("version", (Number)3);
    }

    private static byte findAxes(JsonObject obj) {
        MutableByte res = new MutableByte((Number)0);
        ConversionUtil.getInt(obj, "checkX").ifPresent(val -> res.setValue((Number)(res.byteValue() | val)));
        ConversionUtil.getInt(obj, "checkY").ifPresent(val -> res.setValue((Number)(res.byteValue() | val << 1)));
        ConversionUtil.getInt(obj, "checkZ").ifPresent(val -> res.setValue((Number)(res.byteValue() | val << 2)));
        return res.byteValue();
    }

    private static byte findSides(JsonObject obj) {
        MutableByte res = new MutableByte((Number)0);
        ConversionUtil.getInt(obj, "DOWN").ifPresent(val -> res.setValue((Number)(res.byteValue() | val)));
        ConversionUtil.getInt(obj, "UP").ifPresent(val -> res.setValue((Number)(res.byteValue() | val << 1)));
        ConversionUtil.getInt(obj, "NORTH").ifPresent(val -> res.setValue((Number)(res.byteValue() | val << 2)));
        ConversionUtil.getInt(obj, "SOUTH").ifPresent(val -> res.setValue((Number)(res.byteValue() | val << 3)));
        ConversionUtil.getInt(obj, "WEST").ifPresent(val -> res.setValue((Number)(res.byteValue() | val << 4)));
        ConversionUtil.getInt(obj, "EAST").ifPresent(val -> res.setValue((Number)(res.byteValue() | val << 5)));
        return res.byteValue();
    }

    private static /* synthetic */ void lambda$convertV2toV3$23(String widgetBaseType, JsonObject newEntry, int val) {
        switch (widgetBaseType) {
            case "condition_coordinate": {
                newEntry.addProperty("cond_op", ICondition.Operator.values()[val].getSerializedName());
                break;
            }
            case "coordinate_operator": {
                newEntry.addProperty("coord_op", ProgWidgetCoordinateOperator.EnumOperator.values()[val].getSerializedName());
            }
        }
    }

    private static /* synthetic */ void lambda$convertV2toV3$16(String widgetBaseType, JsonObject destObj2, int val) {
        if (widgetBaseType.startsWith("condition_") || widgetBaseType.startsWith("drone_condition_")) {
            destObj2.addProperty("cond_op", ICondition.Operator.values()[val].getSerializedName());
        }
    }

    public static class LegacyAreaWidgetConverter {
        private static final Map<EnumOldAreaType, String> oldFormatToAreaTypes = new EnumMap<EnumOldAreaType, String>(EnumOldAreaType.class);

        private static void register(String id, EnumOldAreaType ... oldTypes) {
            for (EnumOldAreaType oldType : oldTypes) {
                oldFormatToAreaTypes.put(oldType, id);
            }
        }

        public static AreaType convertFromLegacyFormat(EnumOldAreaType oldType, int subTypeInfo) {
            String newTypeId = oldFormatToAreaTypes.get((Object)oldType);
            if (newTypeId == null) {
                Log.error("Legacy import: no area converter found for {}! Substituting 'box'.", new Object[]{oldType});
                return new AreaTypeBox();
            }
            AreaTypeSerializer s = (AreaTypeSerializer)PNCRegistries.AREA_TYPE_SERIALIZER_REGISTRY.get(PneumaticRegistry.RL(newTypeId));
            return s != null ? (AreaType)Util.make(s.createDefaultInstance(), t -> t.convertFromLegacy(oldType, subTypeInfo)) : new AreaTypeBox();
        }

        static {
            LegacyAreaWidgetConverter.register("box", EnumOldAreaType.FILL, EnumOldAreaType.WALL, EnumOldAreaType.FRAME);
            LegacyAreaWidgetConverter.register("sphere", EnumOldAreaType.SPHERE);
            LegacyAreaWidgetConverter.register("line", EnumOldAreaType.LINE);
            LegacyAreaWidgetConverter.register("wall", EnumOldAreaType.X_WALL, EnumOldAreaType.Y_WALL, EnumOldAreaType.Z_WALL);
            LegacyAreaWidgetConverter.register("cylinder", EnumOldAreaType.X_CYLINDER, EnumOldAreaType.Y_CYLINDER, EnumOldAreaType.Z_CYLINDER);
            LegacyAreaWidgetConverter.register("pyramid", EnumOldAreaType.X_PYRAMID, EnumOldAreaType.Y_PYRAMID, EnumOldAreaType.Z_PYRAMID);
            LegacyAreaWidgetConverter.register("grid", EnumOldAreaType.GRID);
            LegacyAreaWidgetConverter.register("random", EnumOldAreaType.RANDOM);
            if (oldFormatToAreaTypes.size() != EnumOldAreaType.values().length) {
                throw new IllegalStateException("Not all old formats are handled!");
            }
        }
    }
}

