/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.datagen;

import java.util.List;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.data.PneumaticCraftTags;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.worldgen.OilLakeFilter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.LakeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.UniformHeight;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.EnvironmentScanPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.placement.SurfaceRelativeThresholdFilter;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class ModWorldGenProvider {
    public static final ResourceKey<ConfiguredFeature<?, ?>> OIL_LAKE = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)PneumaticRegistry.RL("oil_lake"));
    public static final ResourceKey<PlacedFeature> OIL_LAKE_SURFACE = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)PneumaticRegistry.RL("oil_lake_surface"));
    public static final ResourceKey<PlacedFeature> OIL_LAKE_UNDERGROUND = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)PneumaticRegistry.RL("oil_lake_underground"));
    public static final ResourceKey<BiomeModifier> OIL_LAKE_SURFACE_BM = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)PneumaticRegistry.RL("oil_lake_surface"));
    public static final ResourceKey<BiomeModifier> OIL_LAKE_UNDERGROUND_BM = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)PneumaticRegistry.RL("oil_lake_underground"));

    static class BiomeModifiers {
        BiomeModifiers() {
        }

        public static void bootstrap(BootstrapContext<BiomeModifier> ctx) {
            HolderGetter placedFeatures = ctx.lookup(Registries.PLACED_FEATURE);
            HolderGetter biomeReg = ctx.lookup(Registries.BIOME);
            ctx.register(OIL_LAKE_SURFACE_BM, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomeReg.getOrThrow(PneumaticCraftTags.Biomes.OIL_LAKES_SURFACE), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(OIL_LAKE_SURFACE)}), GenerationStep.Decoration.LAKES));
            ctx.register(OIL_LAKE_UNDERGROUND_BM, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomeReg.getOrThrow(PneumaticCraftTags.Biomes.OIL_LAKES_UNDERGROUND), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(OIL_LAKE_UNDERGROUND)}), GenerationStep.Decoration.LAKES));
        }
    }

    static class PlacedFeatures {
        PlacedFeatures() {
        }

        public static void bootstrap(BootstrapContext<PlacedFeature> ctx) {
            HolderGetter configuredFeatures = ctx.lookup(Registries.CONFIGURED_FEATURE);
            Holder.Reference oilLakeCF = configuredFeatures.getOrThrow(OIL_LAKE);
            PlacementUtils.register(ctx, OIL_LAKE_SURFACE, (Holder)oilLakeCF, List.of(RarityFilter.onAverageOnceEvery((int)25), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome(), OilLakeFilter.oilLakeFilter()));
            PlacementUtils.register(ctx, OIL_LAKE_UNDERGROUND, (Holder)oilLakeCF, List.of(RarityFilter.onAverageOnceEvery((int)6), InSquarePlacement.spread(), HeightRangePlacement.of((HeightProvider)UniformHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)0), (VerticalAnchor)VerticalAnchor.top())), EnvironmentScanPlacement.scanningFor((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.allOf((BlockPredicate)BlockPredicate.not((BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE), (BlockPredicate)BlockPredicate.insideWorld((Vec3i)new BlockPos(0, -5, 0))), (int)32), SurfaceRelativeThresholdFilter.of((Heightmap.Types)Heightmap.Types.OCEAN_FLOOR_WG, (int)Integer.MIN_VALUE, (int)-5), BiomeFilter.biome(), OilLakeFilter.oilLakeFilter()));
        }
    }

    static class ConfiguredFeatures {
        ConfiguredFeatures() {
        }

        public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> ctx) {
            FeatureUtils.register(ctx, OIL_LAKE, (Feature)Feature.LAKE, (FeatureConfiguration)new LakeFeature.Configuration((BlockStateProvider)BlockStateProvider.simple((BlockState)((LiquidBlock)ModBlocks.OIL.get()).defaultBlockState()), (BlockStateProvider)BlockStateProvider.simple((BlockState)Blocks.AIR.defaultBlockState())));
        }
    }
}

