/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.List;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTank;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.block.entity.LiquidCompressorBlockEntity;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.fluid.FuelRegistry;
import me.desht.pneumaticcraft.common.inventory.LiquidCompressorMenu;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import org.apache.commons.lang3.tuple.Pair;

public class LiquidCompressorScreen
extends AbstractPneumaticCraftContainerScreen<LiquidCompressorMenu, LiquidCompressorBlockEntity> {
    public LiquidCompressorScreen(LiquidCompressorMenu container, Inventory inv, Component displayString) {
        super(container, inv, displayString);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new WidgetTank(this.f_97735_ + this.getFluidOffset(), this.f_97736_ + 15, ((LiquidCompressorBlockEntity)this.te).getTank()));
        WidgetAnimatedStat stat = this.addAnimatedStat((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.liquidCompressor.fuel", new Object[0]), new ItemStack((ItemLike)ModItems.LPG_BUCKET.get()), -5226496, true);
        Pair<Integer, List<Component>> p = ClientUtils.formatFuelList((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.liquidCompressor.fuelsHeader", new Object[0]), this.getGuiLeft() - 10, fluid -> FuelRegistry.getInstance().getFuelValue(ClientUtils.getClientLevel(), (Fluid)fluid) / 1000, true);
        stat.setMinimumExpandedDimensions((Integer)p.getLeft() + 30, 17);
        stat.setText((List)p.getRight());
    }

    @Override
    protected void addPressureStatInfo(List<Component> pressureStatText) {
        super.addPressureStatInfo(pressureStatText);
        pressureStatText.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.maxProduction", PneumaticCraftUtils.roundNumberTo(((LiquidCompressorBlockEntity)this.te).airPerTick, 2)).m_130940_(ChatFormatting.BLACK));
    }

    protected int getFluidOffset() {
        return 86;
    }

    @Override
    protected PointXY getInvNameOffset() {
        return new PointXY(0, -1);
    }

    @Override
    protected PointXY getGaugeLocation() {
        int xStart = (this.f_96543_ - this.f_97726_) / 2;
        int yStart = (this.f_96544_ - this.f_97727_) / 2;
        return new PointXY(xStart + this.f_97726_ * 3 / 4 + 5, yStart + this.f_97727_ / 4 + 4);
    }

    @Override
    protected String upgradeCategory() {
        return "liquid_compressor";
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_LIQUID_COMPRESSOR;
    }

    @Override
    public void addProblems(List<Component> curInfo) {
        super.addProblems(curInfo);
        if (((LiquidCompressorBlockEntity)this.te).getCapability(ForgeCapabilities.FLUID_HANDLER).isPresent()) {
            ((LiquidCompressorBlockEntity)this.te).getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(fluidHandler -> {
                if (!((LiquidCompressorBlockEntity)this.te).isActive() && fluidHandler.getFluidInTank(0).isEmpty()) {
                    curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.liquidCompressor.noFuel", new Object[0]));
                }
            });
        } else {
            curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.liquidCompressor.noFuel", new Object[0]));
        }
    }
}

