/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.ai;

import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIBlockInteraction;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIDig;
import me.desht.pneumaticcraft.common.drone.progwidgets.IBlockRightClicker;
import me.desht.pneumaticcraft.common.drone.progwidgets.ISidedWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CommandBlock;
import net.minecraft.world.level.block.StructureBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;

public class DroneAIRightClickBlock
extends DroneAIBlockInteraction<ProgWidgetAreaItemBase> {
    private final List<BlockPos> visitedPositions = new ArrayList<BlockPos>();
    private final IBlockRightClicker.RightClickType clickType;

    public DroneAIRightClickBlock(IDroneBase drone, ProgWidgetAreaItemBase widget) {
        super(drone, widget);
        if (!(widget instanceof IBlockRightClicker)) {
            throw new IllegalArgumentException("expecting a widget implementing IBlockRightClicker!");
        }
        IBlockRightClicker rc = (IBlockRightClicker)((Object)widget);
        drone.getFakePlayer().m_20260_(rc.isSneaking());
        this.clickType = rc.getClickType();
    }

    @Override
    protected boolean isValidPosition(BlockPos pos) {
        if (this.visitedPositions.contains(pos)) {
            return false;
        }
        if (this.progWidget.isItemFilterEmpty()) {
            return true;
        }
        switch (this.clickType) {
            case CLICK_ITEM: {
                for (int i = 0; i < this.drone.getInv().getSlots(); ++i) {
                    if (!this.progWidget.isItemValidForFilters(this.drone.getInv().getStackInSlot(i))) continue;
                    return true;
                }
                return false;
            }
            case CLICK_BLOCK: {
                return DroneAIDig.isBlockValidForFilter((BlockGetter)this.drone.world(), pos, this.drone, this.progWidget);
            }
        }
        return false;
    }

    @Override
    protected boolean doBlockInteraction(BlockPos pos, double squareDistToBlock) {
        this.visitedPositions.add(pos);
        if (this.rightClick(pos)) {
            if (this.drone.getFakePlayer().m_21205_().m_41613_() <= 0) {
                this.drone.getFakePlayer().m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
            }
            this.drone.getInv().setStackInSlot(0, this.drone.getFakePlayer().m_21205_());
            this.drone.getDroneItemHandler().copyFromFakePlayer();
        }
        return false;
    }

    private boolean rightClick(BlockPos pos) {
        if (this.clickType == IBlockRightClicker.RightClickType.CLICK_ITEM) {
            return this.rightClickItem(this.drone.getFakePlayer(), pos);
        }
        return this.rightClickBlock(this.drone.getFakePlayer(), pos);
    }

    private boolean rightClickItem(FakePlayer fakePlayer, BlockPos pos) {
        if (!this.progWidget.isItemValidForFilters(this.drone.getInv().getStackInSlot(0)) && !this.trySwapItem()) {
            return false;
        }
        ItemStack stack = fakePlayer.m_21205_();
        Level world = fakePlayer.m_20193_();
        try {
            Block block;
            BlockHitResult brtr = this.doTrace(world, pos, fakePlayer);
            if (brtr == null) {
                return false;
            }
            PlayerInteractEvent.RightClickBlock event = ForgeHooks.onRightClickBlock((Player)fakePlayer, (InteractionHand)InteractionHand.MAIN_HAND, (BlockPos)pos, (BlockHitResult)brtr);
            if (event.isCanceled() || event.getUseItem() == Event.Result.DENY) {
                return false;
            }
            InteractionResult ret = stack.onItemUseFirst(new UseOnContext((Player)fakePlayer, InteractionHand.MAIN_HAND, brtr));
            if (ret != InteractionResult.PASS) {
                return ret.m_19077_();
            }
            if (stack.m_41619_() || fakePlayer.m_36335_().m_41519_(stack.m_41720_())) {
                return false;
            }
            if (stack.m_41720_() instanceof BlockItem && ((block = ((BlockItem)stack.m_41720_()).m_40614_()) instanceof CommandBlock || block instanceof StructureBlock)) {
                return false;
            }
            if (event.getUseItem() != Event.Result.DENY) {
                ItemStack copyBeforeUse = stack.m_41777_();
                InteractionResult result = stack.m_41661_(new UseOnContext((Player)fakePlayer, InteractionHand.MAIN_HAND, brtr));
                if (result == InteractionResult.PASS) {
                    InteractionResultHolder rightClickResult = stack.m_41720_().m_7203_(world, (Player)fakePlayer, InteractionHand.MAIN_HAND);
                    fakePlayer.m_21008_(InteractionHand.MAIN_HAND, (ItemStack)rightClickResult.m_19095_());
                }
                if (fakePlayer.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
                    ForgeEventFactory.onPlayerDestroyItem((Player)fakePlayer, (ItemStack)copyBeforeUse, (InteractionHand)InteractionHand.MAIN_HAND);
                }
                return true;
            }
        }
        catch (Throwable e) {
            Log.error("DroneAIRightClickBlock crashed! Stacktrace: ", new Object[0]);
            e.printStackTrace();
        }
        return false;
    }

    private boolean rightClickBlock(FakePlayer fakePlayer, BlockPos pos) {
        Level world = fakePlayer.m_20193_();
        BlockState state = world.m_8055_(pos);
        BlockHitResult brtr = this.doTrace(world, pos, fakePlayer);
        if (brtr != null) {
            PlayerInteractEvent.RightClickBlock event = ForgeHooks.onRightClickBlock((Player)fakePlayer, (InteractionHand)InteractionHand.MAIN_HAND, (BlockPos)pos, (BlockHitResult)brtr);
            try {
                InteractionResult res;
                if (!event.isCanceled() && event.getUseItem() != Event.Result.DENY && event.getUseBlock() != Event.Result.DENY && (res = state.m_60664_(world, (Player)fakePlayer, InteractionHand.MAIN_HAND, brtr)).m_19077_()) {
                    world.m_7260_(pos, state, state, 3);
                    return true;
                }
            }
            catch (Throwable e) {
                Log.error("DroneAIRightClickBlock crashed! Stacktrace: ", new Object[0]);
                e.printStackTrace();
            }
        }
        return false;
    }

    private boolean trySwapItem() {
        for (int i = 1; i < this.drone.getInv().getSlots(); ++i) {
            if (!this.progWidget.isItemValidForFilters(this.drone.getInv().getStackInSlot(i))) continue;
            ItemStack tmp = this.drone.getInv().getStackInSlot(i);
            this.drone.getInv().setStackInSlot(i, this.drone.getInv().getStackInSlot(0));
            this.drone.getInv().setStackInSlot(0, tmp);
            return true;
        }
        return false;
    }

    private BlockHitResult doTrace(Level world, BlockPos pos, FakePlayer fakePlayer) {
        BlockState state = world.m_8055_(pos);
        List l = state.m_60808_((BlockGetter)world, pos).m_83299_();
        Vec3 targetVec = l.isEmpty() ? Vec3.m_82512_((Vec3i)pos) : ((AABB)l.get(0)).m_82399_().m_82549_(Vec3.m_82528_((Vec3i)pos));
        Direction side = ISidedWidget.getDirForSides(((ISidedWidget)((Object)this.progWidget)).getSides());
        Vec3 saved = new Vec3(fakePlayer.m_20185_(), fakePlayer.m_20186_(), fakePlayer.m_20189_());
        Vec3 posVec = targetVec.m_82520_((double)side.m_122429_(), (double)side.m_122430_(), (double)side.m_122431_());
        fakePlayer.m_6034_(posVec.f_82479_, posVec.f_82480_, posVec.f_82481_);
        fakePlayer.m_7618_(EntityAnchorArgument.Anchor.FEET, targetVec);
        BlockHitResult brtr = this.drone.world().m_45547_(new ClipContext(posVec, targetVec, ClipContext.Block.OUTLINE, ClipContext.Fluid.SOURCE_ONLY, (Entity)fakePlayer));
        fakePlayer.m_6034_(saved.f_82479_, saved.f_82480_, saved.f_82481_);
        if (!brtr.m_82425_().equals((Object)pos) || brtr.m_82434_() != side) {
            return null;
        }
        return brtr;
    }
}

