/*
 * Decompiled with CFR 0.152.
 */
package com.cgessinger.creaturesandbeasts.client.entity.model;

import com.cgessinger.creaturesandbeasts.entities.LizardEntity;
import com.cgessinger.creaturesandbeasts.init.CNBLizardTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

@OnlyIn(value=Dist.CLIENT)
public class LizardModel
extends GeoModel<LizardEntity> {
    private static final ResourceLocation LIZARD_MODEL = new ResourceLocation("cnb", "geo/entity/lizard/lizard.geo.json");
    private static final ResourceLocation MUSHROOM_LIZARD_MODEL = new ResourceLocation("cnb", "geo/entity/lizard/mushroom_lizard.geo.json");
    private static final ResourceLocation SAD_LIZARD_MODEL = new ResourceLocation("cnb", "geo/entity/lizard/sad_lizard.geo.json");
    private static final ResourceLocation SAD_MUSHROOM_LIZARD_MODEL = new ResourceLocation("cnb", "geo/entity/lizard/sad_mushroom_lizard.geo.json");
    private static final ResourceLocation LIZARD_ANIMATIONS = new ResourceLocation("cnb", "animations/lizard.json");

    public ResourceLocation getModelResource(LizardEntity entity) {
        if (entity.getLizardType().equals(CNBLizardTypes.MUSHROOM)) {
            return entity.getSad() ? SAD_MUSHROOM_LIZARD_MODEL : MUSHROOM_LIZARD_MODEL;
        }
        return entity.getSad() ? SAD_LIZARD_MODEL : LIZARD_MODEL;
    }

    public ResourceLocation getTextureResource(LizardEntity entity) {
        return entity.getSad() ? entity.getLizardType().getSadTextureLocation() : entity.getLizardType().getTextureLocation();
    }

    public ResourceLocation getAnimationResource(LizardEntity entity) {
        return LIZARD_ANIMATIONS;
    }

    public void setCustomAnimations(LizardEntity animatable, long instanceId, AnimationState<LizardEntity> animationState) {
        super.setCustomAnimations((GeoAnimatable)animatable, instanceId, animationState);
        CoreGeoBone head_rotation = this.getAnimationProcessor().getBone("head_rotation");
        if (head_rotation != null) {
            EntityModelData extraData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            head_rotation.setRotX(extraData.headPitch() * ((float)Math.PI / 180));
            head_rotation.setRotY(extraData.netHeadYaw() * ((float)Math.PI / 180));
        }
    }
}

