/*
 * Decompiled with CFR 0.152.
 */
package com.cgessinger.creaturesandbeasts.client.entity.model;

import com.cgessinger.creaturesandbeasts.entities.YetiEntity;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

@OnlyIn(value=Dist.CLIENT)
public class YetiModel
extends GeoModel<YetiEntity> {
    private static final ResourceLocation YETI_MODEL = new ResourceLocation("cnb", "geo/entity/yeti/yeti.geo.json");
    private static final ResourceLocation BABY_YETI_MODEL = new ResourceLocation("cnb", "geo/entity/yeti/baby_yeti.geo.json");
    private static final ResourceLocation YETI_TEXTURE = new ResourceLocation("cnb", "textures/entity/yeti/yeti.png");
    private static final ResourceLocation BABY_YETI_TEXTURE = new ResourceLocation("cnb", "textures/entity/yeti/baby_yeti.png");
    private static final ResourceLocation YETI_ANIMATIONS = new ResourceLocation("cnb", "animations/yeti.json");

    public ResourceLocation getModelResource(YetiEntity entity) {
        return entity.m_6162_() ? BABY_YETI_MODEL : YETI_MODEL;
    }

    public ResourceLocation getTextureResource(YetiEntity entity) {
        return entity.m_6162_() ? BABY_YETI_TEXTURE : YETI_TEXTURE;
    }

    public ResourceLocation getAnimationResource(YetiEntity entity) {
        return YETI_ANIMATIONS;
    }

    public void setCustomAnimations(YetiEntity animatable, long instanceId, AnimationState<YetiEntity> animationState) {
        super.setCustomAnimations((GeoAnimatable)animatable, instanceId, animationState);
        CoreGeoBone head_rotation = this.getAnimationProcessor().getBone("head_rotation");
        EntityModelData extraData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
        head_rotation.setRotX(extraData.headPitch() * ((float)Math.PI / 180));
        if (animatable.m_6162_()) {
            head_rotation.setRotZ(extraData.netHeadYaw() * ((float)Math.PI / 180));
        } else {
            head_rotation.setRotY(extraData.netHeadYaw() * ((float)Math.PI / 180));
        }
    }
}

