/*
 * Decompiled with CFR 0.152.
 */
package com.cgessinger.creaturesandbeasts.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.toml.TomlFormat;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;

public record EntitySpawnData(ResourceLocation entityType, ResourceLocation biome, MobCategory spawnCategory, int spawnWeight, int minCount, int maxCount, double mobCost, double energyBudget) {
    public ResourceLocation getEntityTypeLocation() {
        return this.entityType;
    }

    @Nullable
    public EntityType<? extends Entity> getEntityType() {
        return (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(this.getEntityTypeLocation());
    }

    public ResourceLocation getBiomeLocation() {
        return this.biome;
    }

    @Nullable
    public ResourceKey<Biome> getBiome() {
        if (this.biome == null) {
            return null;
        }
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)this.biome);
    }

    public String getCategoryName() {
        return this.spawnCategory.m_21607_();
    }

    @Nullable
    public MobCategory getCategory() {
        return this.spawnCategory;
    }

    public int getMinCount() {
        return this.minCount;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public int getSpawnWeight() {
        return this.spawnWeight;
    }

    public double getMobCost() {
        return this.mobCost;
    }

    public double getEnergyBudget() {
        return this.energyBudget;
    }

    public Config toConfig() {
        CommentedConfig config = CommentedConfig.of(() -> new HashMap(6), (ConfigFormat)TomlFormat.instance());
        config.set("entityType", (Object)this.getEntityTypeLocation().toString());
        config.set("biome", (Object)this.getBiomeLocation().toString());
        config.set("spawnCategory", (Object)this.getCategoryName());
        config.set("spawnWeight", (Object)this.getSpawnWeight());
        config.set("minCount", (Object)this.getMinCount());
        config.set("maxCount", (Object)this.getMaxCount());
        config.set("mobCost", (Object)this.getMobCost());
        config.set("energyBudget", (Object)this.getEnergyBudget());
        config.setComment("entityType", " Determines what entity this spawn is applied to.");
        config.setComment("biome", " Determines what biome this entity should spawn in.");
        config.setComment("spawnCategory", "Determines what spawn category this entity should use.");
        config.setComment("spawnWeight", "Determines the spawn weight of the entity.\n Range: [0, 1000000]");
        config.setComment("minCount", "Determines the minimum number of entities to spawn.\n Range: [0, 1000000]");
        config.setComment("maxCount", "Determines the maximum number of entities to spawn.\n Range: [0, 1000000]");
        config.setComment("mobCost", "Determines the spawn cost for the entity.");
        config.setComment("energyBudget", "Determines the maximum cost for the entity in a given area.");
        return config;
    }

    @Override
    public String toString() {
        return "SpawnData [entityType=" + this.entityType + ", biome=" + this.biome + ", spawnCategory=" + this.spawnCategory + ", spawnWeight=" + this.spawnWeight + ", minCount=" + this.minCount + ", maxCount=" + this.maxCount + "]";
    }

    public static EntitySpawnData fromConfig(Config config) {
        Number number;
        double mobCost = 0.0;
        double energyBudget = 0.0;
        Object object = config.get("mobCost");
        if (object instanceof Number) {
            number = (Number)object;
            mobCost = number.doubleValue();
        }
        if ((object = config.get("energyBudget")) instanceof Number) {
            number = (Number)object;
            energyBudget = number.doubleValue();
        }
        return new EntitySpawnData(ResourceLocation.m_135820_((String)((String)config.get("entityType"))), ResourceLocation.m_135820_((String)((String)config.get("biome"))), (MobCategory)config.getEnum("spawnCategory", MobCategory.class), config.getInt("spawnWeight"), config.getInt("minCount"), config.getInt("maxCount"), mobCost, energyBudget);
    }

    public static EntitySpawnData of(EntityType<? extends Entity> entityType, ResourceKey<Biome> biome, MobCategory category, int spawnWeight, int minCount, int maxCount, double mobCost, double energyBudget) {
        return new EntitySpawnData(ForgeRegistries.ENTITY_TYPES.getKey(entityType), biome.m_135782_(), category, spawnWeight, minCount, maxCount, mobCost, energyBudget);
    }

    public static EntitySpawnData of(ResourceLocation entityType, ResourceKey<Biome> biome, MobCategory category, int spawnWeight, int minCount, int maxCount, double mobCost, double energyBudget) {
        return new EntitySpawnData(entityType, biome.m_135782_(), category, spawnWeight, minCount, maxCount, mobCost, energyBudget);
    }

    public static EntitySpawnData of(ResourceLocation entityType, ResourceLocation biome, MobCategory category, int spawnWeight, int minCount, int maxCount, double mobCost, double energyBudget) {
        return new EntitySpawnData(entityType, biome, category, spawnWeight, minCount, maxCount, mobCost, energyBudget);
    }
}

