/*
 * Decompiled with CFR 0.152.
 */
package com.cgessinger.creaturesandbeasts.entities;

import com.cgessinger.creaturesandbeasts.entities.EndWhaleEntity;
import com.cgessinger.creaturesandbeasts.entities.ai.ConvertItemGoal;
import com.cgessinger.creaturesandbeasts.init.CNBItems;
import com.cgessinger.creaturesandbeasts.init.CNBSoundEvents;
import com.cgessinger.creaturesandbeasts.init.CNBSporelingTypes;
import com.cgessinger.creaturesandbeasts.init.CNBTags;
import com.cgessinger.creaturesandbeasts.util.SporelingType;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.ForgeEventFactory;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationProcessor;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SporelingEntity
extends TamableAnimal
implements GeoAnimatable {
    private static final EntityDataAccessor<String> TYPE = SynchedEntityData.m_135353_(SporelingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(SporelingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> WAVING = SynchedEntityData.m_135353_(SporelingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> INSPECTING = SynchedEntityData.m_135353_(SporelingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final SporelingAttackGoal attackGoal = new SporelingAttackGoal(this, 1.3, false);
    private final NearestAttackableTargetGoal<Player> nearestAttackableTargetGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
    private final HurtByTargetGoal hurtByTargetGoal = new HurtByTargetGoal((PathfinderMob)this, new Class[0]);
    private final WaveGoal waveGoal = new WaveGoal(this, Player.class, 8.0f);
    private final TemptGoal temptGoal = new SporelingTemptGoal(this, 1.0, Ingredient.m_204132_(CNBTags.Items.SPORELING_FOOD), false);
    private final PanicGoal panicGoal = new PanicGoal((PathfinderMob)this, 1.25);
    private final ConvertItemGoal convertItemGoal = new ConvertItemGoal(this, 16.0, 1.3);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int attackTimer = 0;
    private int waveTimer = 0;
    private float targetYaw = 0.0f;
    private float targetPitch = 0.0f;

    public SporelingEntity(EntityType<SporelingEntity> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TYPE, (Object)CNBSporelingTypes.RED_OVERWORLD.getId().toString());
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
        this.f_19804_.m_135372_(WAVING, (Object)false);
        this.f_19804_.m_135372_(INSPECTING, (Object)false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("SporelingType", this.getSporelingType().getId().toString());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        SporelingType type = SporelingType.getById(compound.m_128461_("SporelingType"));
        if (type == null) {
            type = CNBSporelingTypes.RED_OVERWORLD;
        }
        this.setSporelingType(type);
        this.reassessGoals();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 16.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22281_, 3.0);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_20202_() != null) {
            this.f_20907_ = 0.0;
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(3, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    private void reassessGoals() {
        this.f_21345_.m_25363_((Goal)this.panicGoal);
        this.f_21345_.m_25363_((Goal)this.convertItemGoal);
        this.f_21345_.m_25363_((Goal)this.temptGoal);
        this.f_21345_.m_25363_((Goal)this.waveGoal);
        this.f_21345_.m_25363_((Goal)this.attackGoal);
        this.f_21346_.m_25363_(this.nearestAttackableTargetGoal);
        this.f_21346_.m_25363_((Goal)this.hurtByTargetGoal);
        if (this.getSporelingType().getHostility() == SporelingType.SporelingHostility.FRIENDLY) {
            this.f_21345_.m_25352_(2, (Goal)this.panicGoal);
            this.f_21345_.m_25352_(2, (Goal)this.convertItemGoal);
            this.f_21345_.m_25352_(3, (Goal)this.temptGoal);
            this.f_21345_.m_25352_(6, (Goal)this.waveGoal);
        } else if (this.getSporelingType().getHostility() == SporelingType.SporelingHostility.HOSTILE) {
            this.f_21345_.m_25352_(2, (Goal)this.attackGoal);
            this.f_21346_.m_25352_(2, this.nearestAttackableTargetGoal);
        } else {
            this.f_21345_.m_25352_(2, (Goal)this.attackGoal);
            this.f_21346_.m_25352_(1, (Goal)this.hurtByTargetGoal);
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.isAttacking()) {
            --this.attackTimer;
        }
        if (this.isWaving()) {
            --this.waveTimer;
            this.f_21344_.m_26573_();
        }
        if (this.attackTimer == 0) {
            this.setAttacking(false);
        }
        if (this.waveTimer == 0) {
            this.setWaving(false);
        }
    }

    public boolean m_21525_() {
        return super.m_21525_() || this.m_20202_() != null;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.m_9236_().f_46443_) {
            InteractionResult interactionresult;
            if (this.m_21824_() && !(interactionresult = super.m_6071_(player, hand)).m_19077_() && this.m_21830_((LivingEntity)player) && player.m_36341_() && player.m_20197_().isEmpty() && player.m_6844_(EquipmentSlot.CHEST).m_150930_((Item)CNBItems.SPORELING_BACKPACK.get())) {
                this.m_20329_((Entity)player);
                return InteractionResult.SUCCESS;
            }
            boolean flag = this.m_21830_((LivingEntity)player) || this.m_21824_() || itemstack.m_150930_(Items.f_42500_) && !this.m_21824_();
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_21824_()) {
            if ((itemstack.m_150930_(Items.f_41953_) || itemstack.m_150930_(Items.f_41952_)) && this.m_21223_() < this.m_21233_()) {
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.m_5634_(2.0f);
                this.m_146852_(GameEvent.f_157806_, (Entity)this);
                return InteractionResult.SUCCESS;
            }
            InteractionResult interactionresult = super.m_6071_(player, hand);
            if (!interactionresult.m_19077_() && this.m_21830_((LivingEntity)player)) {
                if (player.m_36341_() && player.m_20197_().isEmpty() && player.m_6844_(EquipmentSlot.CHEST).m_150930_((Item)CNBItems.SPORELING_BACKPACK.get())) {
                    this.m_20329_((Entity)player);
                } else {
                    this.m_21839_(!this.m_21827_());
                    this.f_20899_ = false;
                    this.f_21344_.m_26573_();
                    this.m_6710_(null);
                }
                return InteractionResult.SUCCESS;
            }
            return interactionresult;
        }
        if (this.getSporelingType().getHostility() == SporelingType.SporelingHostility.FRIENDLY && itemstack.m_150930_(Items.f_42499_)) {
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                this.m_21828_(player);
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                this.m_21839_(true);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public boolean m_6898_(ItemStack stack) {
        return false;
    }

    public ItemStack getPickedResult(HitResult target) {
        if (this.getSporelingType().getHostility().equals((Object)SporelingType.SporelingHostility.FRIENDLY)) {
            return new ItemStack((ItemLike)CNBItems.SPORELING_OVERWORLD_EGG.get());
        }
        return new ItemStack((ItemLike)CNBItems.SPORELING_NETHER_EGG.get());
    }

    protected void m_6475_(DamageSource damageSource, float damage) {
        if (damageSource.m_276093_(DamageTypes.f_268631_) && this.getSporelingType().getHostility() != SporelingType.SporelingHostility.FRIENDLY) {
            return;
        }
        super.m_6475_(damageSource, damage);
    }

    public boolean m_5825_() {
        SporelingType.SporelingHostility hostility = this.getSporelingType().getHostility();
        return hostility.equals((Object)SporelingType.SporelingHostility.HOSTILE) || hostility.equals((Object)SporelingType.SporelingHostility.NEUTRAL) || super.m_5825_();
    }

    public MobCategory getClassification(boolean forSpawnCount) {
        return this.getSporelingType().getHostility() == SporelingType.SporelingHostility.FRIENDLY ? MobCategory.CREATURE : MobCategory.MONSTER;
    }

    public static boolean checkSporelingSpawnRules(EntityType<SporelingEntity> entity, LevelAccessor worldIn, MobSpawnType mobSpawnType, BlockPos pos, RandomSource rand) {
        if (worldIn.m_204166_(pos).m_203656_(BiomeTags.f_207612_)) {
            return worldIn.m_46791_() != Difficulty.PEACEFUL;
        }
        return worldIn.m_45524_(pos, 0) > 8;
    }

    public float m_5610_(BlockPos pos, LevelReader level) {
        if (this.getSporelingType().getHostility() == SporelingType.SporelingHostility.FRIENDLY) {
            return level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50195_) ? 10.0f : level.m_220419_(pos);
        }
        return 10.0f;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        Holder biome = worldIn.m_204166_(this.m_20183_());
        if (reason == MobSpawnType.SPAWN_EGG && dataTag != null && dataTag.m_128441_("EggType")) {
            String eggType = dataTag.m_128461_("EggType");
            if (eggType.equals("Nether")) {
                if (biome.m_203565_(Biomes.f_48200_)) {
                    this.setSporelingType(CNBSporelingTypes.CRIMSON_FUNGUS);
                } else if (biome.m_203565_(Biomes.f_48201_)) {
                    this.setSporelingType(CNBSporelingTypes.WARPED_FUNGUS);
                } else if (this.f_19796_.m_188499_()) {
                    this.setSporelingType(CNBSporelingTypes.RED_NETHER);
                } else {
                    this.setSporelingType(CNBSporelingTypes.BROWN_NETHER);
                }
            } else if (this.f_19796_.m_188499_()) {
                this.setSporelingType(CNBSporelingTypes.RED_OVERWORLD);
            } else {
                this.setSporelingType(CNBSporelingTypes.BROWN_OVERWORLD);
            }
        } else if (biome.m_203565_(Biomes.f_48200_)) {
            this.setSporelingType(CNBSporelingTypes.CRIMSON_FUNGUS);
        } else if (biome.m_203565_(Biomes.f_48201_)) {
            this.setSporelingType(CNBSporelingTypes.WARPED_FUNGUS);
        } else if (biome.m_203656_(BiomeTags.f_207612_)) {
            if (this.f_19796_.m_188499_()) {
                this.setSporelingType(CNBSporelingTypes.RED_NETHER);
            } else {
                this.setSporelingType(CNBSporelingTypes.BROWN_NETHER);
            }
        } else if (this.f_19796_.m_188499_()) {
            this.setSporelingType(CNBSporelingTypes.RED_OVERWORLD);
        } else {
            this.setSporelingType(CNBSporelingTypes.BROWN_OVERWORLD);
        }
        this.reassessGoals();
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob mob) {
        return null;
    }

    public boolean isRunning() {
        return this.m_21566_().m_24999_() >= 1.3;
    }

    public void setAttacking(boolean isAttacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)isAttacking);
        this.attackTimer = isAttacking ? 7 : 0;
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    public boolean isWaving() {
        return (Boolean)this.f_19804_.m_135370_(WAVING);
    }

    public void setWaving(boolean isWaving) {
        this.f_19804_.m_135381_(WAVING, (Object)isWaving);
        this.waveTimer = isWaving ? 41 : 0;
    }

    public boolean isInspecting() {
        return (Boolean)this.f_19804_.m_135370_(INSPECTING);
    }

    public void setInspecting(boolean isInspecting) {
        this.f_19804_.m_135381_(INSPECTING, (Object)isInspecting);
    }

    public ItemStack getHolding() {
        return this.m_6844_(EquipmentSlot.MAINHAND);
    }

    public void setHolding(ItemStack stack) {
        this.m_8061_(EquipmentSlot.MAINHAND, stack);
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        switch (this.getSporelingType().getHostility()) {
            case HOSTILE: {
                return (SoundEvent)CNBSoundEvents.SPORELING_NETHER_HURT.get();
            }
            case NEUTRAL: {
                return (SoundEvent)CNBSoundEvents.SPORELING_WARPED_HURT.get();
            }
        }
        return (SoundEvent)CNBSoundEvents.SPORELING_OVERWORLD_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        switch (this.getSporelingType().getHostility()) {
            case HOSTILE: {
                return (SoundEvent)CNBSoundEvents.SPORELING_NETHER_HURT.get();
            }
            case NEUTRAL: {
                return (SoundEvent)CNBSoundEvents.SPORELING_WARPED_HURT.get();
            }
        }
        return (SoundEvent)CNBSoundEvents.SPORELING_OVERWORLD_HURT.get();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        switch (this.getSporelingType().getHostility()) {
            case HOSTILE: {
                return (SoundEvent)CNBSoundEvents.SPORELING_NETHER_AMBIENT.get();
            }
            case NEUTRAL: {
                return (SoundEvent)CNBSoundEvents.SPORELING_WARPED_AMBIENT.get();
            }
        }
        return (SoundEvent)CNBSoundEvents.SPORELING_OVERWORLD_AMBIENT.get();
    }

    protected boolean m_8028_() {
        return this.getSporelingType().getHostility() == SporelingType.SporelingHostility.HOSTILE;
    }

    public void m_6083_() {
        Entity entity;
        super.m_6083_();
        if (this.m_20159_() && (this.m_20202_().m_5833_() || this.m_204036_(FluidTags.f_13131_) > this.m_20204_() || this.m_20202_().m_20202_() instanceof EndWhaleEntity || this.m_20202_().m_6067_())) {
            this.m_8127_();
            this.m_21839_(false);
        }
        if ((entity = this.m_20202_()) instanceof Player) {
            Player player = (Player)entity;
            double offsetX = 0.0;
            double offsetY = 0.8;
            double offsetZ = -0.5;
            float yaw = player.f_20883_ * ((float)Math.PI / 180);
            double xOffset = offsetX * Math.cos(yaw) - offsetZ * Math.sin(yaw);
            double zOffset = offsetX * Math.sin(yaw) + offsetZ * Math.cos(yaw);
            this.m_6034_(player.m_20185_() + xOffset, player.m_20186_() + (double)player.m_20192_() - 1.2 + offsetY, player.m_20189_() + zOffset);
            if (this.m_9236_().m_46467_() % (long)(60 + this.f_19796_.m_188503_(40)) == 0L) {
                this.targetYaw = player.f_20883_ + (float)((this.f_19796_.m_188500_() - 0.5) * 60.0);
                this.targetPitch = (float)((this.f_19796_.m_188500_() - 0.5) * 20.0);
            }
            this.m_146922_(Mth.m_14189_((float)0.05f, (float)this.m_146908_(), (float)this.targetYaw));
            this.m_146926_(Mth.m_14179_((float)0.05f, (float)this.m_146909_(), (float)this.targetPitch));
            this.f_19859_ = Mth.m_14189_((float)0.05f, (float)this.f_19859_, (float)this.targetYaw);
            this.f_19860_ = Mth.m_14179_((float)0.05f, (float)this.f_19860_, (float)this.targetPitch);
        }
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return !this.getSporelingType().getHostility().equals((Object)SporelingType.SporelingHostility.FRIENDLY);
    }

    public void setSporelingType(SporelingType shroomloinType) {
        this.f_19804_.m_135381_(TYPE, (Object)shroomloinType.getId().toString());
    }

    public SporelingType getSporelingType() {
        return SporelingType.getById((String)this.f_19804_.m_135370_(TYPE));
    }

    private <E extends GeoAnimatable> PlayState animationPredicate(AnimationState<E> event) {
        AnimationProcessor.QueuedAnimation currentAnimation = event.getController().getCurrentAnimation();
        if (this.m_20159_()) {
            return PlayState.STOP;
        }
        if (this.m_21825_()) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("sporeling_sitting"));
        } else if (currentAnimation != null && (currentAnimation.animation().name().equals("sporeling_sitting") || currentAnimation.animation().name().equals("sporeling_stand")) && !this.m_21825_()) {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("sporeling_stand"));
        } else if (this.isAttacking()) {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("sporeling_bite"));
        } else if (this.isWaving() && this.getHolding().m_41619_()) {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("sporeling_wave"));
        } else if (this.isInspecting()) {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("sporeling_convert"));
        } else if (!(this.f_267362_.m_267731_() > -0.15f) || !(this.f_267362_.m_267731_() < 0.15f)) {
            if (this.isRunning()) {
                event.getController().setAnimation(RawAnimation.begin().thenLoop("sporeling_run"));
            } else {
                event.getController().setAnimation(RawAnimation.begin().thenLoop("sporeling_walk"));
            }
        } else {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("sporeling_idle"));
        }
        return PlayState.CONTINUE;
    }

    private <E extends GeoAnimatable> PlayState backpackAnimationPredicate(AnimationState<E> event) {
        Entity vehicle = this.m_20202_();
        if (vehicle != null) {
            if (!vehicle.m_20096_() && vehicle.f_19789_ > 0.1f) {
                event.getController().setAnimation(RawAnimation.begin().thenLoop("sporeling_backpack_air"));
            } else {
                event.getController().setAnimation(RawAnimation.begin().thenLoop("sporeling_backpack_idle"));
            }
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::animationPredicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "backpackController", 6, this::backpackAnimationPredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object animatable) {
        return this.f_19797_;
    }

    static class SporelingAttackGoal
    extends MeleeAttackGoal {
        private final SporelingEntity goalOwner;

        public SporelingAttackGoal(SporelingEntity sporeling, double speedModifier, boolean followWithoutLineOfSight) {
            super((PathfinderMob)sporeling, speedModifier, followWithoutLineOfSight);
            this.goalOwner = sporeling;
        }

        protected void m_6739_(LivingEntity entity, double distance) {
            double d0 = this.m_6639_(entity);
            if (distance <= d0 && this.goalOwner.attackTimer <= 0 && this.f_25548_ <= 0) {
                this.m_25563_();
                this.goalOwner.m_5496_((SoundEvent)CNBSoundEvents.SPORELING_BITE.get(), 1.0f, 1.0f);
                this.goalOwner.m_7327_((Entity)entity);
            }
        }

        protected void m_25563_() {
            super.m_25563_();
            this.goalOwner.setAttacking(true);
        }
    }

    static class WaveGoal
    extends LookAtPlayerGoal {
        private final SporelingEntity sporeling;

        public WaveGoal(SporelingEntity entityIn, Class<? extends LivingEntity> watchTargetClass, float maxDistance) {
            super((Mob)entityIn, watchTargetClass, maxDistance);
            this.sporeling = entityIn;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.sporeling.isInspecting() && this.sporeling.f_19796_.m_188500_() <= 0.25 && !this.sporeling.m_21825_();
        }

        public void m_8056_() {
            super.m_8056_();
            this.sporeling.setWaving(true);
        }

        public boolean m_8045_() {
            return super.m_8045_() && this.sporeling.isWaving();
        }
    }

    static class SporelingTemptGoal
    extends TemptGoal {
        private final SporelingEntity sporelingEntity;

        public SporelingTemptGoal(SporelingEntity sporeling, double speedModifier, Ingredient temptItems, boolean canScare) {
            super((PathfinderMob)sporeling, speedModifier, temptItems, canScare);
            this.sporelingEntity = sporeling;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.sporelingEntity.m_21824_();
        }
    }
}

