/*
 * Decompiled with CFR 0.152.
 */
package com.cgessinger.creaturesandbeasts.items;

import com.cgessinger.creaturesandbeasts.entities.ThrownCactemSpearEntity;
import com.cgessinger.creaturesandbeasts.init.CNBSoundEvents;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.enchantment.DamageEnchantment;
import net.minecraft.world.item.enchantment.DigDurabilityEnchantment;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.FireAspectEnchantment;
import net.minecraft.world.item.enchantment.KnockbackEnchantment;
import net.minecraft.world.item.enchantment.MendingEnchantment;
import net.minecraft.world.item.enchantment.MultiShotEnchantment;
import net.minecraft.world.item.enchantment.TridentLoyaltyEnchantment;
import net.minecraft.world.item.enchantment.VanishingCurseEnchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class SpearItem
extends Item
implements Vanishable {
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;

    public SpearItem(Item.Properties properties) {
        super(properties);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", 5.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", -2.9, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public boolean m_6777_(BlockState state, Level level, BlockPos pos, Player player) {
        return !player.m_7500_();
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment instanceof TridentLoyaltyEnchantment || enchantment instanceof MendingEnchantment || enchantment instanceof DigDurabilityEnchantment || enchantment instanceof VanishingCurseEnchantment || enchantment instanceof FireAspectEnchantment || enchantment instanceof DamageEnchantment || enchantment instanceof KnockbackEnchantment || enchantment instanceof MultiShotEnchantment || enchantment.equals(Enchantments.f_44982_)) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.SPEAR;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int useTicks) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            int i = this.m_8105_(stack) - useTicks;
            if (i >= 10 && !level.f_46443_) {
                stack.m_41622_(1, (LivingEntity)player, broadcastPlayer -> broadcastPlayer.m_21190_(entity.m_7655_()));
                this.spawnSpears(stack, player, level);
                if (!player.m_150110_().f_35937_) {
                    player.m_150109_().m_36057_(stack);
                }
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        }
    }

    private void spawnSpears(ItemStack stack, Player player, Level level) {
        int i;
        int multishotLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)stack);
        int numberOfSpears = multishotLevel == 0 ? 1 : 3;
        float[] afloat = SpearItem.getShotPitches(player.m_217043_());
        ItemStack noLoyaltyStack = stack.m_41777_();
        ResourceLocation loyaltyResource = EnchantmentHelper.m_182432_((Enchantment)Enchantments.f_44955_);
        ListTag listtag = noLoyaltyStack.m_41785_();
        for (i = 0; i < listtag.size(); ++i) {
            CompoundTag compoundtag = listtag.m_128728_(i);
            ResourceLocation tagEnchantment = EnchantmentHelper.m_182446_((CompoundTag)compoundtag);
            if (tagEnchantment == null || !tagEnchantment.equals((Object)loyaltyResource)) continue;
            listtag.remove((Object)compoundtag);
        }
        for (i = 0; i < numberOfSpears; ++i) {
            if (i == 0) {
                this.shootProjectile(level, player, stack, afloat[i], 0.0f, true);
                continue;
            }
            if (i == 1) {
                this.shootProjectile(level, player, noLoyaltyStack, afloat[i], -10.0f, false);
                continue;
            }
            this.shootProjectile(level, player, noLoyaltyStack, afloat[i], 10.0f, false);
        }
    }

    private void shootProjectile(Level level, Player player, ItemStack stack, float soundVariation, float randomization, boolean canPickup) {
        ThrownCactemSpearEntity thrownSpear = new ThrownCactemSpearEntity(level, (LivingEntity)player, stack);
        Vec3 upVector = player.m_20289_(1.0f);
        Vec3 viewVector = player.m_20252_(1.0f);
        float randomPitch = (level.f_46441_.m_188501_() - 0.5f) * randomization;
        float randomYaw = (level.f_46441_.m_188501_() - 0.5f) * randomization;
        viewVector = viewVector.m_82496_(randomPitch).m_82524_(randomYaw);
        thrownSpear.m_6686_(viewVector.m_7096_(), viewVector.m_7098_(), viewVector.m_7094_(), 1.6f, 1.0f);
        thrownSpear.f_36705_ = player.m_150110_().f_35937_ ? AbstractArrow.Pickup.CREATIVE_ONLY : (canPickup ? AbstractArrow.Pickup.ALLOWED : AbstractArrow.Pickup.DISALLOWED);
        level.m_7967_((Entity)thrownSpear);
        level.m_6269_(null, (Entity)thrownSpear, (SoundEvent)CNBSoundEvents.SPEAR_THROW.get(), SoundSource.PLAYERS, 1.0f, soundVariation);
    }

    private static float[] getShotPitches(RandomSource rand) {
        boolean flag = rand.m_188499_();
        return new float[]{1.0f, SpearItem.getRandomShotPitch(flag, rand), SpearItem.getRandomShotPitch(!flag, rand)};
    }

    private static float getRandomShotPitch(boolean chance, RandomSource rand) {
        float f = chance ? 0.63f : 0.43f;
        return 1.0f / (rand.m_188501_() * 0.5f + 1.8f) + f;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41773_() >= itemstack.m_41776_() - 1) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity hurtEntity, LivingEntity owner) {
        stack.m_41622_(1, owner, player -> player.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public boolean m_6813_(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity entity) {
        if ((double)state.m_60800_((BlockGetter)level, pos) != 0.0) {
            stack.m_41622_(2, entity, player -> player.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        return slot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(slot);
    }

    public int m_6473_() {
        return 1;
    }
}

