/*
 * Decompiled with CFR 0.152.
 */
package com.cgessinger.creaturesandbeasts.util;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import org.apache.commons.lang3.tuple.Pair;

public class LizardType {
    private static final Map<ResourceLocation, LizardType> LIZARD_TYPES = new LinkedHashMap<ResourceLocation, LizardType>();
    private ResourceLocation id;
    private Pair<ResourceLocation, ResourceLocation> textures;
    private Supplier<Item> spawnItem;

    public LizardType(@Nullable Item spawnItem, ResourceLocation id, ResourceLocation texture, ResourceLocation sadTexture) {
        this(() -> spawnItem, id, texture, sadTexture);
    }

    public LizardType(@Nullable Supplier<Item> spawnItem, ResourceLocation id, ResourceLocation texture, ResourceLocation sadTexture) {
        this(spawnItem, id, (Pair<ResourceLocation, ResourceLocation>)Pair.of((Object)texture, (Object)sadTexture));
    }

    public LizardType(@Nullable Supplier<Item> spawnItem, ResourceLocation id, Pair<ResourceLocation, ResourceLocation> textures) {
        this.id = id;
        this.textures = textures;
        this.spawnItem = spawnItem;
    }

    @CheckForNull
    public Item getSpawnItem() {
        Item item = this.spawnItem.get();
        if (item == null || item.equals(Items.f_41852_)) {
            return null;
        }
        return item;
    }

    public void setSpawnItem(@Nullable Item spawnItem) {
        this.spawnItem = () -> spawnItem;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public void setId(ResourceLocation id) {
        this.id = id;
    }

    public ResourceLocation getTextureLocation() {
        return (ResourceLocation)this.textures.getLeft();
    }

    public void setTextureLocation(ResourceLocation textureLocation) {
        this.textures = Pair.of((Object)textureLocation, (Object)((ResourceLocation)this.textures.getRight()));
    }

    public ResourceLocation getSadTextureLocation() {
        return (ResourceLocation)this.textures.getRight();
    }

    public void setSadTextureLocation(ResourceLocation textureLocation) {
        this.textures = Pair.of((Object)((ResourceLocation)this.textures.getLeft()), (Object)textureLocation);
    }

    public static LizardType registerLizardType(LizardType lizardType) {
        ResourceLocation id = lizardType.getId();
        if (LIZARD_TYPES.containsKey(id)) {
            throw new IllegalStateException(String.format("%s already exists in the LizardType registry.", id.toString()));
        }
        LIZARD_TYPES.put(id, lizardType);
        return lizardType;
    }

    @Nullable
    public static LizardType getById(@Nullable String id) {
        if (id == null) {
            return null;
        }
        return LizardType.getById(ResourceLocation.m_135820_((String)id));
    }

    @Nullable
    public static LizardType getById(@Nullable ResourceLocation id) {
        return LIZARD_TYPES.get(id);
    }

    public boolean equals(Object obj) {
        if (obj instanceof LizardType) {
            LizardType type = (LizardType)obj;
            return type.getId().equals((Object)this.getId()) && type.getTextureLocation().equals((Object)this.getTextureLocation());
        }
        return false;
    }
}

