/*
 * Decompiled with CFR 0.152.
 */
package net.mokus.snowy_season.blocks.custom;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_156;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2429;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public class XmasLights
extends class_2248 {
    public static final MapCodec<XmasLights> CODEC = XmasLights.method_54094(XmasLights::new);
    public static final class_2746 UP = class_2429.field_11327;
    public static final class_2746 NORTH = class_2429.field_11332;
    public static final class_2746 EAST = class_2429.field_11335;
    public static final class_2746 SOUTH = class_2429.field_11331;
    public static final class_2746 WEST = class_2429.field_11328;
    public static final Map<class_2350, class_2746> FACING_PROPERTIES = (Map)class_2429.field_11329.entrySet().stream().filter(entry -> entry.getKey() != class_2350.field_11033).collect(class_156.method_664());
    protected static final float field_31275 = 1.0f;
    private static final class_265 UP_SHAPE = class_2248.method_9541((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final class_265 EAST_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final class_265 WEST_SHAPE = class_2248.method_9541((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final class_265 SOUTH_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final class_265 NORTH_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private final Map<class_2680, class_265> shapesByState;

    public XmasLights(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)UP, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)NORTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)EAST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)SOUTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WEST, (Comparable)Boolean.valueOf(false)));
        this.shapesByState = ImmutableMap.copyOf(this.field_10647.method_11662().stream().collect(Collectors.toMap(Function.identity(), XmasLights::getShapeForState)));
    }

    public MapCodec<XmasLights> method_53969() {
        return CODEC;
    }

    private static class_265 getShapeForState(class_2680 state) {
        class_265 voxelShape = class_259.method_1073();
        if (((Boolean)state.method_11654((class_2769)UP)).booleanValue()) {
            voxelShape = UP_SHAPE;
        }
        if (((Boolean)state.method_11654((class_2769)NORTH)).booleanValue()) {
            voxelShape = class_259.method_1084((class_265)voxelShape, (class_265)SOUTH_SHAPE);
        }
        if (((Boolean)state.method_11654((class_2769)SOUTH)).booleanValue()) {
            voxelShape = class_259.method_1084((class_265)voxelShape, (class_265)NORTH_SHAPE);
        }
        if (((Boolean)state.method_11654((class_2769)EAST)).booleanValue()) {
            voxelShape = class_259.method_1084((class_265)voxelShape, (class_265)WEST_SHAPE);
        }
        if (((Boolean)state.method_11654((class_2769)WEST)).booleanValue()) {
            voxelShape = class_259.method_1084((class_265)voxelShape, (class_265)EAST_SHAPE);
        }
        return voxelShape.method_1110() ? class_259.method_1077() : voxelShape;
    }

    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.shapesByState.get(state);
    }

    protected boolean method_9579(class_2680 state, class_1922 world, class_2338 pos) {
        return true;
    }

    protected boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        return this.hasAdjacentBlocks(this.getPlacementShape(state, (class_1922)world, pos));
    }

    private boolean hasAdjacentBlocks(class_2680 state) {
        return this.getAdjacentBlockCount(state) > 0;
    }

    private int getAdjacentBlockCount(class_2680 state) {
        int i = 0;
        for (class_2746 booleanProperty : FACING_PROPERTIES.values()) {
            if (!((Boolean)state.method_11654((class_2769)booleanProperty)).booleanValue()) continue;
            ++i;
        }
        return i;
    }

    private boolean shouldHaveSide(class_1922 world, class_2338 pos, class_2350 side) {
        if (side == class_2350.field_11033) {
            return false;
        }
        class_2338 blockPos = pos.method_10093(side);
        if (side.method_10166() == class_2350.class_2351.field_11052) {
            return false;
        }
        class_2746 booleanProperty = FACING_PROPERTIES.get(side);
        class_2680 blockState = world.method_8320(pos.method_10084());
        return blockState.method_27852((class_2248)this) && (Boolean)blockState.method_11654((class_2769)booleanProperty) != false;
    }

    private class_2680 getPlacementShape(class_2680 state, class_1922 world, class_2338 pos) {
        class_2338 blockPos = pos.method_10084();
        class_2680 blockState = null;
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            class_2746 booleanProperty = XmasLights.getFacingProperty(direction);
            if (!((Boolean)state.method_11654((class_2769)booleanProperty)).booleanValue()) continue;
            boolean bl = this.shouldHaveSide(world, pos, direction);
            if (!bl) {
                if (blockState == null) {
                    blockState = world.method_8320(blockPos);
                }
                bl = blockState.method_27852((class_2248)this) && (Boolean)blockState.method_11654((class_2769)booleanProperty) != false;
            }
            state = (class_2680)state.method_11657((class_2769)booleanProperty, (Comparable)Boolean.valueOf(bl));
        }
        return state;
    }

    protected class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (direction == class_2350.field_11033) {
            return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
        }
        class_2680 blockState = this.getPlacementShape(state, (class_1922)world, pos);
        return !this.hasAdjacentBlocks(blockState) ? class_2246.field_10124.method_9564() : blockState;
    }

    private boolean hasHorizontalSide(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)NORTH) != false || (Boolean)state.method_11654((class_2769)EAST) != false || (Boolean)state.method_11654((class_2769)SOUTH) != false || (Boolean)state.method_11654((class_2769)WEST) != false;
    }

    protected boolean method_9616(class_2680 state, class_1750 context) {
        class_2680 blockState = context.method_8045().method_8320(context.method_8037());
        return blockState.method_27852((class_2248)this) ? this.getAdjacentBlockCount(blockState) < FACING_PROPERTIES.size() : super.method_9616(state, context);
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_2680 blockState = ctx.method_8045().method_8320(ctx.method_8037());
        boolean bl = blockState.method_27852((class_2248)this);
        class_2680 blockState2 = bl ? blockState : this.method_9564();
        for (class_2350 direction : ctx.method_7718()) {
            boolean bl2;
            if (direction == class_2350.field_11033) continue;
            class_2746 booleanProperty = XmasLights.getFacingProperty(direction);
            boolean bl3 = bl2 = bl && (Boolean)blockState.method_11654((class_2769)booleanProperty) != false;
            if (bl2 || !this.shouldHaveSide((class_1922)ctx.method_8045(), ctx.method_8037(), direction)) continue;
            return (class_2680)blockState2.method_11657((class_2769)booleanProperty, (Comparable)Boolean.valueOf(true));
        }
        return bl ? blockState2 : null;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{UP, NORTH, EAST, SOUTH, WEST});
    }

    protected class_2680 method_9598(class_2680 state, class_2470 rotation) {
        switch (rotation) {
            case field_11464: {
                return (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)NORTH, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH)))).method_11657((class_2769)EAST, (Comparable)((Boolean)state.method_11654((class_2769)WEST)))).method_11657((class_2769)SOUTH, (Comparable)((Boolean)state.method_11654((class_2769)NORTH)))).method_11657((class_2769)WEST, (Comparable)((Boolean)state.method_11654((class_2769)EAST)));
            }
            case field_11465: {
                return (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)NORTH, (Comparable)((Boolean)state.method_11654((class_2769)EAST)))).method_11657((class_2769)EAST, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH)))).method_11657((class_2769)SOUTH, (Comparable)((Boolean)state.method_11654((class_2769)WEST)))).method_11657((class_2769)WEST, (Comparable)((Boolean)state.method_11654((class_2769)NORTH)));
            }
            case field_11463: {
                return (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657((class_2769)NORTH, (Comparable)((Boolean)state.method_11654((class_2769)WEST)))).method_11657((class_2769)EAST, (Comparable)((Boolean)state.method_11654((class_2769)NORTH)))).method_11657((class_2769)SOUTH, (Comparable)((Boolean)state.method_11654((class_2769)EAST)))).method_11657((class_2769)WEST, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH)));
            }
        }
        return state;
    }

    protected class_2680 method_9569(class_2680 state, class_2415 mirror) {
        switch (mirror) {
            case field_11300: {
                return (class_2680)((class_2680)state.method_11657((class_2769)NORTH, (Comparable)((Boolean)state.method_11654((class_2769)SOUTH)))).method_11657((class_2769)SOUTH, (Comparable)((Boolean)state.method_11654((class_2769)NORTH)));
            }
            case field_11301: {
                return (class_2680)((class_2680)state.method_11657((class_2769)EAST, (Comparable)((Boolean)state.method_11654((class_2769)WEST)))).method_11657((class_2769)WEST, (Comparable)((Boolean)state.method_11654((class_2769)EAST)));
            }
        }
        return super.method_9569(state, mirror);
    }

    public static class_2746 getFacingProperty(class_2350 direction) {
        return FACING_PROPERTIES.get(direction);
    }
}

