/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ophidiophobia.network;

import java.util.function.Supplier;
import net.mcreator.ophidiophobia.OphidiophobiaMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class OphidiophobiaModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        OphidiophobiaMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.InlandTaipanGUI = message.data.InlandTaipanGUI;
                    variables.BlackMambaGUI = message.data.BlackMambaGUI;
                    variables.RattlesnakeGUI = message.data.RattlesnakeGUI;
                    variables.SandViperGUI = message.data.SandViperGUI;
                    variables.GaboonViperGUI = message.data.GaboonViperGUI;
                    variables.TigerPythonGUI = message.data.TigerPythonGUI;
                    variables.KingCobraGUI = message.data.KingCobraGUI;
                    variables.AnacondaGUI = message.data.AnacondaGUI;
                    variables.GreenTreeSnakeGUI = message.data.GreenTreeSnakeGUI;
                    variables.CoralSnakeGUI = message.data.CoralSnakeGUI;
                    variables.TitanoboaGUI = message.data.TitanoboaGUI;
                    variables.BoomslangGUI = message.data.BoomslangGUI;
                    variables.EyelashVIperGUI = message.data.EyelashVIperGUI;
                    variables.RainbowSnakeGUI = message.data.RainbowSnakeGUI;
                    variables.EuropeanAdderGUI = message.data.EuropeanAdderGUI;
                    variables.BoneSnakeGUI = message.data.BoneSnakeGUI;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double InlandTaipanGUI = 0.0;
        public double BlackMambaGUI = 0.0;
        public double RattlesnakeGUI = 0.0;
        public double SandViperGUI = 0.0;
        public double GaboonViperGUI = 0.0;
        public double TigerPythonGUI = 0.0;
        public double KingCobraGUI = 0.0;
        public double AnacondaGUI = 0.0;
        public double GreenTreeSnakeGUI = 0.0;
        public double CoralSnakeGUI = 0.0;
        public double TitanoboaGUI = 0.0;
        public double BoomslangGUI = 0.0;
        public double EyelashVIperGUI = 0.0;
        public double RainbowSnakeGUI = 0.0;
        public double EuropeanAdderGUI = 0.0;
        public double BoneSnakeGUI = 0.0;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                OphidiophobiaMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("InlandTaipanGUI", this.InlandTaipanGUI);
            nbt.m_128347_("BlackMambaGUI", this.BlackMambaGUI);
            nbt.m_128347_("RattlesnakeGUI", this.RattlesnakeGUI);
            nbt.m_128347_("SandViperGUI", this.SandViperGUI);
            nbt.m_128347_("GaboonViperGUI", this.GaboonViperGUI);
            nbt.m_128347_("TigerPythonGUI", this.TigerPythonGUI);
            nbt.m_128347_("KingCobraGUI", this.KingCobraGUI);
            nbt.m_128347_("AnacondaGUI", this.AnacondaGUI);
            nbt.m_128347_("GreenTreeSnakeGUI", this.GreenTreeSnakeGUI);
            nbt.m_128347_("CoralSnakeGUI", this.CoralSnakeGUI);
            nbt.m_128347_("TitanoboaGUI", this.TitanoboaGUI);
            nbt.m_128347_("BoomslangGUI", this.BoomslangGUI);
            nbt.m_128347_("EyelashVIperGUI", this.EyelashVIperGUI);
            nbt.m_128347_("RainbowSnakeGUI", this.RainbowSnakeGUI);
            nbt.m_128347_("EuropeanAdderGUI", this.EuropeanAdderGUI);
            nbt.m_128347_("BoneSnakeGUI", this.BoneSnakeGUI);
            return nbt;
        }

        public void readNBT(Tag Tag2) {
            CompoundTag nbt = (CompoundTag)Tag2;
            this.InlandTaipanGUI = nbt.m_128459_("InlandTaipanGUI");
            this.BlackMambaGUI = nbt.m_128459_("BlackMambaGUI");
            this.RattlesnakeGUI = nbt.m_128459_("RattlesnakeGUI");
            this.SandViperGUI = nbt.m_128459_("SandViperGUI");
            this.GaboonViperGUI = nbt.m_128459_("GaboonViperGUI");
            this.TigerPythonGUI = nbt.m_128459_("TigerPythonGUI");
            this.KingCobraGUI = nbt.m_128459_("KingCobraGUI");
            this.AnacondaGUI = nbt.m_128459_("AnacondaGUI");
            this.GreenTreeSnakeGUI = nbt.m_128459_("GreenTreeSnakeGUI");
            this.CoralSnakeGUI = nbt.m_128459_("CoralSnakeGUI");
            this.TitanoboaGUI = nbt.m_128459_("TitanoboaGUI");
            this.BoomslangGUI = nbt.m_128459_("BoomslangGUI");
            this.EyelashVIperGUI = nbt.m_128459_("EyelashVIperGUI");
            this.RainbowSnakeGUI = nbt.m_128459_("RainbowSnakeGUI");
            this.EuropeanAdderGUI = nbt.m_128459_("EuropeanAdderGUI");
            this.BoneSnakeGUI = nbt.m_128459_("BoneSnakeGUI");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("ophidiophobia", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.InlandTaipanGUI = original.InlandTaipanGUI;
            clone.BlackMambaGUI = original.BlackMambaGUI;
            clone.RattlesnakeGUI = original.RattlesnakeGUI;
            clone.SandViperGUI = original.SandViperGUI;
            clone.GaboonViperGUI = original.GaboonViperGUI;
            clone.TigerPythonGUI = original.TigerPythonGUI;
            clone.KingCobraGUI = original.KingCobraGUI;
            clone.AnacondaGUI = original.AnacondaGUI;
            clone.GreenTreeSnakeGUI = original.GreenTreeSnakeGUI;
            clone.CoralSnakeGUI = original.CoralSnakeGUI;
            clone.TitanoboaGUI = original.TitanoboaGUI;
            clone.BoomslangGUI = original.BoomslangGUI;
            clone.EyelashVIperGUI = original.EyelashVIperGUI;
            clone.RainbowSnakeGUI = original.RainbowSnakeGUI;
            clone.EuropeanAdderGUI = original.EuropeanAdderGUI;
            clone.BoneSnakeGUI = original.BoneSnakeGUI;
            if (!event.isWasDeath()) {
                // empty if block
            }
        }
    }
}

