/*
 * Decompiled with CFR 0.152.
 */
package com.fej1fun.potentials.fluid;

import com.fej1fun.potentials.fluid.UniversalFluidStorage;
import dev.architectury.fluid.FluidStack;
import java.util.Iterator;
import net.minecraft.core.NonNullList;
import org.jetbrains.annotations.NotNull;

public class BaseFluidStorage
implements UniversalFluidStorage {
    private final int tanks;
    protected final long capacity;
    protected final NonNullList<FluidStack> fluidStacks;
    protected final long maxFill;
    protected final long maxDrain;

    public BaseFluidStorage(int tanks, long capacity, long maxFill, long maxDrain) {
        this.tanks = tanks;
        this.capacity = capacity;
        this.fluidStacks = NonNullList.create();
        for (int i = 0; i < tanks; ++i) {
            this.fluidStacks.add((Object)FluidStack.empty());
        }
        this.maxFill = maxFill;
        this.maxDrain = maxDrain;
    }

    public BaseFluidStorage(int tanks, long capacity) {
        this(tanks, capacity, capacity, capacity);
    }

    @Override
    public int getTanks() {
        return this.tanks;
    }

    @Override
    public FluidStack getFluidInTank(int tank) {
        return ((FluidStack)this.fluidStacks.get(tank)).copy();
    }

    public long getFluidValueInTank(int tank) {
        return ((FluidStack)this.fluidStacks.get(tank)).getAmount();
    }

    public void setFluidInTank(int tank, FluidStack stack) {
        stack.setAmount(Math.clamp(stack.getAmount(), 0L, this.getTankCapacity(tank)));
        this.fluidStacks.set(tank, (Object)stack);
    }

    @Override
    public long getTankCapacity(int tank) {
        return this.capacity;
    }

    @Override
    public boolean isFluidValid(int tank, FluidStack stack) {
        return true;
    }

    @Override
    public long fill(FluidStack stack, boolean simulate) {
        long filled = 0L;
        for (int i = 0; i < this.getTanks(); ++i) {
            if (!this.isFluidValid(i, stack) || ((FluidStack)this.fluidStacks.get(i)).getFluid() != stack.getFluid() && !((FluidStack)this.fluidStacks.get(i)).isEmpty() || ((FluidStack)this.fluidStacks.get(i)).getAmount() >= this.capacity) continue;
            filled = Math.clamp(this.capacity - this.getFluidValueInTank(i), 0L, Math.min(this.maxFill, stack.getAmount()));
            if (simulate) break;
            this.fluidStacks.set(i, (Object)stack.copyWithAmount(this.getFluidValueInTank(i) + filled));
            break;
        }
        return filled;
    }

    @Override
    public FluidStack drain(FluidStack stack, boolean simulate) {
        long drained = 0L;
        for (int i = 0; i < this.getTanks(); ++i) {
            if (!this.isFluidValid(i, stack) || this.getFluidInTank(i).isEmpty() || this.getFluidInTank(i).getFluid() != stack.getFluid()) continue;
            drained = Math.min(this.getFluidValueInTank(i), Math.min(this.maxDrain, stack.getAmount()));
            if (simulate) break;
            this.setFluidInTank(i, FluidStack.create((FluidStack)this.getFluidInTank(i), (long)(this.getFluidValueInTank(i) - drained)));
            break;
        }
        return FluidStack.create((FluidStack)stack, (long)drained);
    }

    public long fillWithoutLimits(FluidStack stack, boolean simulate) {
        long filled = 0L;
        for (int i = 0; i < this.getTanks(); ++i) {
            if (!this.isFluidValid(i, stack) || ((FluidStack)this.fluidStacks.get(i)).getFluid() != stack.getFluid() && !((FluidStack)this.fluidStacks.get(i)).isEmpty() || ((FluidStack)this.fluidStacks.get(i)).getAmount() >= this.capacity) continue;
            filled = Math.clamp(this.capacity - this.getFluidValueInTank(i), 0L, stack.getAmount());
            if (simulate) break;
            this.fluidStacks.set(i, (Object)stack.copyWithAmount(this.getFluidValueInTank(i) + filled));
            break;
        }
        return filled;
    }

    public FluidStack drainWithoutLimits(FluidStack stack, boolean simulate) {
        long drained = 0L;
        for (int i = 0; i < this.getTanks(); ++i) {
            if (!this.isFluidValid(i, stack) || this.getFluidInTank(i).isEmpty() || this.getFluidInTank(i).getFluid() != stack.getFluid()) continue;
            drained = Math.min(this.getFluidValueInTank(i), stack.getAmount());
            if (simulate) break;
            ((FluidStack)this.fluidStacks.get(i)).shrink(drained);
            break;
        }
        return FluidStack.create((FluidStack)stack, (long)drained);
    }

    @Override
    @NotNull
    public Iterator<FluidStack> iterator() {
        return this.fluidStacks.iterator();
    }
}

