/*
 * Decompiled with CFR 0.152.
 */
package com.fej1fun.potentials.neoforge.capabilities.holders;

import com.fej1fun.potentials.capabilities.types.NoProviderEntityCapabilityHolder;
import com.fej1fun.potentials.fluid.UniversalFluidStorage;
import com.fej1fun.potentials.neoforge.capabilities.Registerable;
import com.fej1fun.potentials.neoforge.fluid.NeoForgeFluidStorage;
import com.fej1fun.potentials.neoforge.fluid.UniversalFluidHandler;
import com.fej1fun.potentials.providers.FluidProvider;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class FluidEntityHolder
implements NoProviderEntityCapabilityHolder<UniversalFluidStorage, Direction>,
Registerable {
    public static final FluidEntityHolder INSTANCE = new FluidEntityHolder();
    private final Set<Supplier<EntityType<? extends Entity>>> registeredEntities = new HashSet<Supplier<EntityType<? extends Entity>>>();

    private FluidEntityHolder() {
        this.registerSelf();
    }

    @Override
    @Nullable
    public UniversalFluidStorage getCapability(Entity entity, Direction direction) {
        IFluidHandler fluidTank = (IFluidHandler)entity.getCapability(Capabilities.FluidHandler.ENTITY, (Object)direction);
        return fluidTank == null ? null : new UniversalFluidHandler(fluidTank);
    }

    @Override
    public void registerForEntity(Supplier<EntityType<? extends Entity>> entity) {
        this.registeredEntities.add(entity);
    }

    @Override
    public ResourceLocation getIdentifier() {
        return Capabilities.FluidHandler.BLOCK.name();
    }

    @Override
    public void register(RegisterCapabilitiesEvent event) {
        this.registeredEntities.forEach(entityType -> event.registerEntity(Capabilities.FluidHandler.ENTITY, (EntityType)entityType.get(), (entity, ctx) -> {
            if (entity instanceof FluidProvider.ENTITY) {
                FluidProvider.ENTITY provider = (FluidProvider.ENTITY)entity;
                UniversalFluidStorage fluidTank = provider.getFluidTank((Direction)ctx);
                return fluidTank == null ? null : new NeoForgeFluidStorage(fluidTank);
            }
            return null;
        }));
    }
}

