/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens;

import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.client.screens.components.ConfigList;
import com.st0x0ef.stellaris.client.screens.components.StateButton;
import com.st0x0ef.stellaris.common.config.CommonConfig;
import com.st0x0ef.stellaris.common.config.ConfigManager;
import com.st0x0ef.stellaris.common.utils.ResourceLocationUtils;
import dev.architectury.platform.Platform;
import java.io.BufferedWriter;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.SpriteIconButton;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ConfigScreen
extends Screen {
    public static final ResourceLocation TEXTURE = ResourceLocationUtils.texture("/item/engine_fan");
    private final Screen parent;
    public final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this);
    protected ConfigList configList;

    public ConfigScreen(Screen parent) {
        super((Component)Component.literal((String)"Stellaris Option"));
        this.parent = parent;
    }

    protected void init() {
        this.addTitle();
        this.addFooter();
        this.configList = (ConfigList)this.layout.addToContents((LayoutElement)new ConfigList(this.minecraft, this.width, this));
        Class<?> clazz = Stellaris.CONFIG.getClass();
        this.addFields(clazz.getFields(), Stellaris.CONFIG, this.configList, 0);
        this.layout.visitWidgets(arg_0 -> ((ConfigScreen)this).addRenderableWidget(arg_0));
        this.layout.arrangeElements();
    }

    protected void addTitle() {
        this.layout.addTitleHeader(this.title, this.font);
    }

    protected void addFooter() {
        this.layout.addToFooter((LayoutElement)Button.builder((Component)CommonComponents.GUI_DONE, button -> this.onClose()).width(200).build());
    }

    private void addFields(Field[] fields, Object object, ConfigList configList, int recursionDepth) {
        for (Field field : fields) {
            try {
                Object value = field.get(object);
                String name = field.getName();
                if (field.isAnnotationPresent(ConfigManager.InnerConfig.class)) {
                    configList.addBig((AbstractWidget)new StringWidget((Component)Component.translatable((String)("config.stellaris." + name)).withStyle(ChatFormatting.BOLD), this.font));
                    this.addFields(field.getType().getFields(), field.get(object), configList, recursionDepth + 1);
                    continue;
                }
                configList.addSmall((AbstractWidget)new StringWidget((Component)Component.translatable((String)("config.stellaris." + name)), this.font), this.addTypeWidget(field, object, value, (Component)Component.translatable((String)("config.stellaris." + name + ".desc"))));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void repositionElements() {
        this.layout.arrangeElements();
        if (this.configList != null) {
            this.configList.updateSize(this.width, this.layout);
        }
    }

    public void onClose() {
        this.saveConfig();
        this.playToast((Component)Component.literal((String)"Config Saved"), (Component)Component.literal((String)"The Stellaris config has been saved"));
        this.minecraft.setScreen(this.parent);
    }

    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        super.render(guiGraphics, i, j, f);
    }

    public void removed() {
        this.minecraft.options.save();
    }

    public void playToast(Component title, Component description) {
        this.minecraft.getToasts().addToast((Toast)new SystemToast(SystemToast.SystemToastId.PERIODIC_NOTIFICATION, title, description));
    }

    private AbstractWidget addTypeWidget(Field field, Object configInstance, Object value, Component description) {
        String fieldName = field.getName();
        if (value instanceof Boolean) {
            Boolean boolVal = (Boolean)value;
            StateButton button = new StateButton(0, 0, 150, 20, (Component)Component.literal((String)"StateButton"), boolVal);
            button.setTooltip(Tooltip.create((Component)description));
            return button;
        }
        if (value instanceof Number || value instanceof String) {
            EditBox editBox = new EditBox(this.font, 100, 15, (Component)Component.literal((String)fieldName));
            editBox.setTooltip(Tooltip.create((Component)description));
            editBox.setValue(value.toString());
            editBox.setResponder(str -> {
                try {
                    Object converted = this.convertValue((String)str, field.getType());
                    field.set(configInstance, converted);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            return editBox;
        }
        SpriteIconButton unsupported = this.stellarisConfigButton(20);
        unsupported.setTooltip(Tooltip.create((Component)Component.literal((String)"Unsupported field type")));
        return unsupported;
    }

    private Object convertValue(String str, Class<?> type) {
        return switch (type.getSimpleName()) {
            case "int", "Integer" -> Integer.parseInt(str);
            case "long", "Long" -> Long.parseLong(str);
            case "double", "Double" -> Double.parseDouble(str);
            case "float", "Float" -> Float.valueOf(Float.parseFloat(str));
            default -> str;
        };
    }

    private void saveConfig() {
        Path configPath = Platform.getConfigFolder().resolve("stellaris-config.json");
        try (BufferedWriter writer = Files.newBufferedWriter(configPath, new OpenOption[0]);){
            Stellaris.GSON.toJson((Object)Stellaris.CONFIG, CommonConfig.class, (Appendable)writer);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.playToast((Component)Component.literal((String)"Config Error"), (Component)Component.literal((String)"Failed to save Stellaris config"));
        }
    }

    private SpriteIconButton stellarisConfigButton(int i) {
        return SpriteIconButton.builder((Component)Component.literal((String)"Config"), button -> {
            Path path = Path.of(String.valueOf(Platform.getConfigFolder()) + "/stellaris.json", new String[0]);
            Util.getPlatform().openUri(path.toUri());
        }, (boolean)true).width(i).sprite(TEXTURE, 16, 16).build();
    }
}

