/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens.windows;

import com.mojang.blaze3d.systems.RenderSystem;
import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.client.screens.GUISprites;
import com.st0x0ef.stellaris.client.screens.PlanetSelectionScreen;
import com.st0x0ef.stellaris.client.screens.components.CustomCheckBox;
import com.st0x0ef.stellaris.client.screens.components.SpaceStationList;
import com.st0x0ef.stellaris.client.screens.components.TexturedButton;
import com.st0x0ef.stellaris.client.screens.info.CelestialBody;
import com.st0x0ef.stellaris.client.screens.windows.MoveableWindow;
import com.st0x0ef.stellaris.common.data.planets.Planet;
import com.st0x0ef.stellaris.common.data.recipes.SpaceStationRecipesManager;
import com.st0x0ef.stellaris.common.launchpads.LaunchPad;
import com.st0x0ef.stellaris.common.launchpads.LaunchPadUtils;
import com.st0x0ef.stellaris.common.utils.PlanetUtil;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

public class SpaceStationWindow
extends MoveableWindow {
    public final PlanetSelectionScreen parent;
    public SpaceStationRecipesManager.SpaceStationRecipeState spaceStationSelected;
    public CelestialBody celestialBody;
    private SpaceStationList stationList;
    private EditBox nameBox;
    private CustomCheckBox publicCheckBox;
    private TexturedButton launchButton;

    public SpaceStationWindow(int width, int height, Component message, PlanetSelectionScreen parent) {
        super(width, height, message, (Screen)parent);
        this.parent = parent;
    }

    @Override
    public void init() {
        this.stationList = new SpaceStationList(this.getWindowX() + 60, this.getWindowY() + 75, this.getWidth() - 120, this.getHeight() - 130, (Component)Component.translatable((String)"gui.stellaris.launchpads"), this);
        this.addWidget(this.stationList);
        this.nameBox = new EditBox(Minecraft.getInstance().font, 150, 20, (Component)Component.literal((String)"name"));
        this.nameBox.setPosition(this.stationList.getX(), this.getWindowY() + 50);
        this.nameBox.setSprites(new WidgetSprites(GUISprites.EDIT_BAR, GUISprites.EDIT_BAR));
        this.addWidget(this.nameBox);
        this.publicCheckBox = new CustomCheckBox(this.nameBox.getX() + this.stationList.getWidth() - 21, this.getWindowY() + 50, 20, (Component)Component.translatable((String)"gui.stellaris.public"), Minecraft.getInstance().font, false).setTexture(GUISprites.CHECKBOX, GUISprites.CHECKBOX_SELECTED).showText(false);
        this.addWidget(this.publicCheckBox);
        this.launchButton = new TexturedButton((this.getWindowX() + this.getWidth()) / 2 + 25 - 3, this.stationList.getY() + this.stationList.getHeight(), 50, 20, button -> this.onStationCreated()).tex(ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)"textures/gui/util/buttons/launch_button.png"), ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)"textures/gui/util/buttons/launch_button_hovered.png"));
        this.addWidget(this.launchButton);
    }

    @Override
    public void renderWindow(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        RenderSystem.clear((int)256, (boolean)Minecraft.ON_OSX);
        guiGraphics.blit(ResourceLocation.parse((String)"stellaris:textures/gui/util/window/window_large.png"), this.getWindowX(), this.getWindowY(), 0.0f, 0.0f, this.getWidth(), this.getHeight(), this.getWidth(), this.getHeight());
        guiGraphics.drawCenteredString(Minecraft.getInstance().font, "Create a Space Station", this.getWindowX() + this.getWidth() / 2, this.getWindowY() + 23, -1);
        this.parent.dragging = false;
        guiGraphics.flush();
    }

    @Override
    public void close() {
        GLFW.glfwSetScrollCallback((long)Minecraft.getInstance().getWindow().getWindow(), this.parent::onMouseScroll);
    }

    @Override
    public Consumer<MoveableWindow> resize(Minecraft minecraft, int width, int height) {
        return window -> {
            if (window instanceof SpaceStationWindow) {
                this.stationList.spaceStationRecipeStates = SpaceStationList.getSpaceStationRecipeStates();
            }
        };
    }

    public void onStationCreated() {
        Stellaris.LOG.info("Creating space station with name: {}", (Object)this.celestialBody);
        if (!this.nameBox.getValue().isEmpty() && this.spaceStationSelected != null && this.celestialBody != null && PlanetUtil.getPlanet(this.celestialBody.dimension) != null) {
            Planet planet = PlanetUtil.getPlanet(this.celestialBody.dimension);
            LaunchPad pad = new LaunchPad(LaunchPadUtils.getNextLaunchPadId(), new Vec3(0.0, 0.0, 0.0), (ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)PlanetUtil.getSpaceStationDimension(planet)), this.nameBox.getValue(), this.publicCheckBox.selected, this.parent.getPlayer().getName().getString(), List.of());
            this.parent.onSpaceStationButtonClick(this.celestialBody, this.spaceStationSelected, pad);
        }
    }

    public void setCelestialBody(@Nullable CelestialBody celestialBody) {
        this.celestialBody = celestialBody;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.close();
            return true;
        }
        if (this.nameBox.isFocused() || this.nameBox.isHovered() || keyCode == 32) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.stationList.isHovered()) {
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    @Override
    public int getMoveLimit() {
        return 15;
    }
}

