/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.blocks.entities.machines;

import com.fej1fun.potentials.components.FluidAmountMapDataComponent;
import com.fej1fun.potentials.fluid.UniversalFluidStorage;
import com.fej1fun.potentials.providers.FluidProvider;
import com.st0x0ef.stellaris.common.blocks.entities.machines.BaseEnergyContainerBlockEntity;
import com.st0x0ef.stellaris.common.blocks.machines.CoalGeneratorBlock;
import com.st0x0ef.stellaris.common.menus.PumpjackMenu;
import com.st0x0ef.stellaris.common.network.packets.SyncFluidPacketWithoutDirection;
import com.st0x0ef.stellaris.common.network.packets.SyncOilLevelPacket;
import com.st0x0ef.stellaris.common.registry.BlockEntityRegistry;
import com.st0x0ef.stellaris.common.registry.FluidRegistry;
import com.st0x0ef.stellaris.common.utils.capabilities.fluid.FluidUtil;
import com.st0x0ef.stellaris.common.utils.capabilities.fluid.SingleFluidStorage;
import dev.architectury.fluid.FluidStack;
import dev.architectury.networking.NetworkManager;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class PumpjackBlockEntity
extends BaseEnergyContainerBlockEntity
implements FluidProvider.BLOCK {
    private boolean isGenerating = false;
    private static final long oilToExtract = 10L;
    public final SingleFluidStorage resultTank = new SingleFluidStorage(10000L){

        @Override
        protected void onChange() {
            PumpjackBlockEntity.this.setChanged();
            if (PumpjackBlockEntity.this.level != null && PumpjackBlockEntity.this.level.getServer() != null && !PumpjackBlockEntity.this.level.getServer().getPlayerList().getPlayers().isEmpty()) {
                NetworkManager.sendToPlayers((Iterable)PumpjackBlockEntity.this.level.getServer().getPlayerList().getPlayers(), (CustomPacketPayload)new SyncFluidPacketWithoutDirection(new FluidAmountMapDataComponent(List.of(this.getFluidInTank(0).getFluid()), List.of(Long.valueOf(this.getFluidValueInTank()))), 0, PumpjackBlockEntity.this.getBlockPos()));
            }
        }
    };

    public PumpjackBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntityRegistry.PUMPJACK.get(), pos, state);
    }

    @Override
    public void tick() {
        FluidUtil.moveFluidToItem(0, this.resultTank, 0, (NonNullList<ItemStack>)this.items, 1000L);
        ChunkAccess access = this.level.getChunk(this.worldPosition);
        if (!this.level.isClientSide()) {
            ChunkPos pos = access.getPos();
            NetworkManager.sendToPlayers((Iterable)this.level.getServer().getPlayerList().getPlayers(), (CustomPacketPayload)new SyncOilLevelPacket(access.stellaris$getChunkOilLevel(), pos.x, pos.z));
        }
        int actualOilToExtract = 10;
        if ((long)access.stellaris$getChunkOilLevel() < 10L && (actualOilToExtract = access.stellaris$getChunkOilLevel()) == 0) {
            return;
        }
        if (this.energyContainer.getEnergy() >= 2 * actualOilToExtract) {
            if (this.resultTank.getFluidValueInTank() + (long)actualOilToExtract <= this.resultTank.getTankCapacity(0)) {
                access.stellaris$setChunkOilLevel(access.stellaris$getChunkOilLevel() - actualOilToExtract);
                this.resultTank.fill(FluidStack.create((Fluid)((Fluid)FluidRegistry.OIL_STILL.get()), (long)actualOilToExtract), false);
                this.energyContainer.extract(2 * actualOilToExtract, false);
                this.isGenerating = true;
                this.setChanged();
            } else {
                this.isGenerating = false;
            }
        }
        BlockState state = this.isGenerating ? (BlockState)this.getBlockState().setValue((Property)CoalGeneratorBlock.LIT, (Comparable)Boolean.valueOf(true)) : (BlockState)this.getBlockState().setValue((Property)CoalGeneratorBlock.LIT, (Comparable)Boolean.valueOf(false));
        this.level.setBlock(this.getBlockPos(), state, 3);
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"block.stellaris.pumpjack");
    }

    protected AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
        return new PumpjackMenu(containerId, inventory, (Container)this, this);
    }

    @Override
    public int getContainerSize() {
        return 2;
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.resultTank.load(tag, provider, "oil");
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        this.resultTank.save(tag, provider, "oil");
    }

    public SingleFluidStorage getResultTank() {
        return this.resultTank;
    }

    public int chunkOilLevel(Level level) {
        return level.getChunk(this.getBlockPos()).stellaris$getChunkOilLevel();
    }

    @Nullable
    public UniversalFluidStorage getFluidTank(@Nullable Direction direction) {
        return this.resultTank;
    }
}

