/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.menus;

import com.st0x0ef.stellaris.common.blocks.entities.machines.WaterSeparatorBlockEntity;
import com.st0x0ef.stellaris.common.menus.BaseContainer;
import com.st0x0ef.stellaris.common.menus.slot.ResultSlot;
import com.st0x0ef.stellaris.common.menus.slot.SpecificFluidContainerSlot;
import com.st0x0ef.stellaris.common.registry.FluidRegistry;
import com.st0x0ef.stellaris.common.registry.MenuTypesRegistry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class WaterSeparatorMenu
extends BaseContainer {
    private final Container container;
    private final WaterSeparatorBlockEntity blockEntity;

    public static WaterSeparatorMenu create(int containerId, Inventory inventory, FriendlyByteBuf buf) {
        WaterSeparatorBlockEntity blockEntity = (WaterSeparatorBlockEntity)inventory.player.level().getBlockEntity(buf.readBlockPos());
        return new WaterSeparatorMenu(containerId, inventory, (Container)new SimpleContainer(4), blockEntity);
    }

    public WaterSeparatorMenu(int containerId, Inventory inventory, Container container, WaterSeparatorBlockEntity blockEntity) {
        super((MenuType)MenuTypesRegistry.WATER_SEPARATOR_MENU.get(), containerId, 4, inventory, 10, 142);
        this.container = container;
        this.blockEntity = blockEntity;
        this.addSlot(new ResultSlot(container, 0, 106, 113));
        this.addSlot(new SpecificFluidContainerSlot(container, (Fluid)Fluids.WATER, 1, 60, 113, false));
        this.addSlot(new SpecificFluidContainerSlot(container, (Fluid)FluidRegistry.HYDROGEN_STILL.get(), 2, 20, 113, true));
        this.addSlot(new SpecificFluidContainerSlot(container, (Fluid)FluidRegistry.OXYGEN_STILL.get(), 3, 144, 113, true));
    }

    @Override
    public boolean stillValid(Player player) {
        return this.container.stillValid(player);
    }

    public WaterSeparatorBlockEntity getBlockEntity() {
        return this.blockEntity;
    }
}

