/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.mixin.client;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.systems.RenderSystem;
import com.st0x0ef.stellaris.common.registry.EffectsRegistry;
import com.st0x0ef.stellaris.common.registry.SoundRegistry;
import com.st0x0ef.stellaris.common.registry.TagRegistry;
import com.st0x0ef.stellaris.common.utils.ResourceLocationUtils;
import com.st0x0ef.stellaris.common.utils.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public class LevelRendererMixin {
    @Unique
    private static final ResourceLocation stellaris$TEXTURE = ResourceLocationUtils.texture("environment/sandstorm");
    @Final
    @Shadow
    @Mutable
    private Minecraft minecraft;
    @Shadow
    @Nullable
    private ClientLevel level;

    @Inject(method={"renderSnowAndRain(Lnet/minecraft/client/renderer/LightTexture;FDDD)V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;setShaderTexture(ILnet/minecraft/resources/ResourceLocation;)V", shift=At.Shift.AFTER, ordinal=0)})
    public void renderSandStorm(LightTexture lightTexture, float partialTick, double camX, double camY, double camZ, CallbackInfo ci, @Local BlockPos.MutableBlockPos mutableBlockPos) {
        if (this.level != null && this.level.getBiome((BlockPos)mutableBlockPos).is(TagRegistry.SANDSTORM_BIOMES_TAG)) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)stellaris$TEXTURE);
            LocalPlayer player = this.minecraft.player;
            if (player != null && Utils.entityHasBlockAbove((LivingEntity)player, null, null)) {
                player.addEffect(new MobEffectInstance(EffectsRegistry.getHolder(EffectsRegistry.SANDSTORM), 30));
            }
        }
    }

    @ModifyExpressionValue(method={"tickRain(Lnet/minecraft/client/Camera;)V"}, at={@At(value="FIELD", target="Lnet/minecraft/sounds/SoundEvents;WEATHER_RAIN:Lnet/minecraft/sounds/SoundEvent;")})
    private SoundEvent replaceRainSound(SoundEvent original, @Local(ordinal=1) BlockPos pos) {
        if (this.level != null && pos != null && this.level.getBiome(pos).is(TagRegistry.SANDSTORM_BIOMES_TAG)) {
            return (SoundEvent)SoundRegistry.WIND_SOUND.get();
        }
        return original;
    }
}

