/*
 * Decompiled with CFR 0.152.
 */
package com.fej1fun.potentials.fabric.energy;

import com.fej1fun.potentials.energy.UniversalEnergyStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import team.reborn.energy.api.EnergyStorage;

public class UniversalEnergyWrapper
implements UniversalEnergyStorage {
    private final EnergyStorage energyStorage;

    public UniversalEnergyWrapper(EnergyStorage energyStorage) {
        this.energyStorage = energyStorage;
    }

    @Override
    public int getEnergy() {
        return (int)this.energyStorage.getAmount();
    }

    @Override
    public int getMaxEnergy() {
        return (int)this.energyStorage.getCapacity();
    }

    @Override
    public int insert(int amount, boolean simulate) {
        try (Transaction transaction = Transaction.openOuter();){
            long inserted = this.energyStorage.insert((long)amount, (TransactionContext)transaction);
            if (simulate) {
                transaction.close();
            } else {
                transaction.commit();
            }
            int n = (int)inserted;
            return n;
        }
    }

    @Override
    public int extract(int amount, boolean simulate) {
        try (Transaction transaction = Transaction.openOuter();){
            long extracted = this.energyStorage.extract((long)amount, (TransactionContext)transaction);
            if (simulate) {
                transaction.close();
            } else {
                transaction.commit();
            }
            int n = (int)extracted;
            return n;
        }
    }

    @Override
    public boolean canInsertEnergy() {
        return this.energyStorage.supportsInsertion();
    }

    @Override
    public boolean canExtractEnergy() {
        return this.energyStorage.supportsExtraction();
    }
}

