/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.ToNumberPolicy;
import com.google.gson.ToNumberStrategy;
import com.st0x0ef.stellaris.common.config.CommonConfig;
import com.st0x0ef.stellaris.common.config.ConfigManager;
import com.st0x0ef.stellaris.common.data.planets.StellarisData;
import com.st0x0ef.stellaris.common.data.recipes.SpaceStationRecipesManager;
import com.st0x0ef.stellaris.common.data.screen.MoonPack;
import com.st0x0ef.stellaris.common.data.screen.PlanetPack;
import com.st0x0ef.stellaris.common.data.screen.StarPack;
import com.st0x0ef.stellaris.common.data.screen.TabletPack;
import com.st0x0ef.stellaris.common.events.Events;
import com.st0x0ef.stellaris.common.network.NetworkRegistry;
import com.st0x0ef.stellaris.common.network.packets.SyncPlanetsDatapackPacket;
import com.st0x0ef.stellaris.common.network.packets.SyncSpaceStationDatapackPacket;
import com.st0x0ef.stellaris.common.registry.ArmorMaterialsRegistry;
import com.st0x0ef.stellaris.common.registry.BlockEntityRegistry;
import com.st0x0ef.stellaris.common.registry.BlocksRegistry;
import com.st0x0ef.stellaris.common.registry.CapabilitiesRegistry;
import com.st0x0ef.stellaris.common.registry.CommandsRegistry;
import com.st0x0ef.stellaris.common.registry.CreativeTabsRegistry;
import com.st0x0ef.stellaris.common.registry.DataComponentsRegistry;
import com.st0x0ef.stellaris.common.registry.EffectsRegistry;
import com.st0x0ef.stellaris.common.registry.EntityRegistry;
import com.st0x0ef.stellaris.common.registry.FeaturesRegistry;
import com.st0x0ef.stellaris.common.registry.FluidRegistry;
import com.st0x0ef.stellaris.common.registry.ItemsRegistry;
import com.st0x0ef.stellaris.common.registry.MenuTypesRegistry;
import com.st0x0ef.stellaris.common.registry.ParticleRegistry;
import com.st0x0ef.stellaris.common.registry.ProcessorsRegistry;
import com.st0x0ef.stellaris.common.registry.RecipesRegistry;
import com.st0x0ef.stellaris.common.registry.SoundRegistry;
import com.st0x0ef.stellaris.common.registry.StatsRegistry;
import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.ReloadListenerRegistry;
import java.util.function.BiConsumer;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3302;
import net.minecraft.class_8710;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Stellaris {
    public static final String MODID = "stellaris";
    public static final Logger LOG = LoggerFactory.getLogger((String)"Stellaris");
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().setLenient().setObjectToNumberStrategy((ToNumberStrategy)ToNumberPolicy.LONG_OR_DOUBLE).create();
    public static CommonConfig CONFIG;

    public static void init() {
        NetworkRegistry.init();
        CONFIG = ConfigManager.loadOrGenerateDefaults();
        ProcessorsRegistry.STRUCTURE_PROCESSORS.register();
        SoundRegistry.SOUNDS.register();
        DataComponentsRegistry.DATA_COMPONENT_TYPE.register();
        FluidRegistry.init();
        ParticleRegistry.PARTICLES.register();
        BlocksRegistry.BLOCKS.register();
        EntityRegistry.ENTITY_TYPE.register();
        EntityRegistry.SENSOR.register();
        BlockEntityRegistry.BLOCK_ENTITY_TYPE.register();
        ItemsRegistry.ITEMS.register();
        ArmorMaterialsRegistry.ARMOR_MATERIAL.register();
        CreativeTabsRegistry.TABS.register();
        MenuTypesRegistry.MENU_TYPE.register();
        FeaturesRegistry.FEATURES.register();
        StatsRegistry.STATS.register();
        CommandsRegistry.register();
        Events.registerEvents();
        CapabilitiesRegistry.init();
        RecipesRegistry.register();
        EntityRegistry.registerSpawnPlacements();
        EffectsRegistry.register();
        ReloadListenerRegistry.register((class_3264)class_3264.field_14190, (class_3302)new StellarisData());
    }

    public static void onDatapackSyncEvent(class_3222 player, boolean joined) {
        if (joined) {
            NetworkManager.sendToPlayer((class_3222)player, (class_8710)new SyncPlanetsDatapackPacket(StellarisData.getPlanets()));
            NetworkManager.sendToPlayer((class_3222)player, (class_8710)new SyncSpaceStationDatapackPacket(SpaceStationRecipesManager.getSpaceStationRecipes()));
        }
    }

    public static void onAddReloadListenerEvent(BiConsumer<class_2960, class_3302> registry) {
        registry.accept(class_2960.method_60655((String)MODID, (String)"planets"), (class_3302)new StellarisData());
        registry.accept(class_2960.method_60655((String)MODID, (String)"space_stations"), (class_3302)new SpaceStationRecipesManager());
    }

    public static void onAddReloadClientListenerEvent(BiConsumer<class_2960, class_3302> registry) {
        registry.accept(class_2960.method_60655((String)MODID, (String)"stars_pack"), (class_3302)new StarPack());
        registry.accept(class_2960.method_60655((String)MODID, (String)"planets_pack"), (class_3302)new PlanetPack());
        registry.accept(class_2960.method_60655((String)MODID, (String)"moon_packs"), (class_3302)new MoonPack());
        registry.accept(class_2960.method_60655((String)MODID, (String)"tablet_pack"), (class_3302)new TabletPack());
    }
}

