/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.data.planets;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.st0x0ef.stellaris.common.data.planets.PlanetTextures;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_9129;

public record Planet(String system, String translatable, String name, class_2960 dimension, Optional<class_2960> orbit, Optional<class_2960> mainPlanet, boolean oxygen, float temperature, int distanceFromEarth, float gravity, Optional<StormParameters> stormParameters, PlanetTextures textures) {
    public static final Codec<Planet> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("system").forGetter(Planet::system), (App)Codec.STRING.fieldOf("translatable").forGetter(Planet::translatable), (App)Codec.STRING.fieldOf("name").forGetter(Planet::name), (App)class_2960.field_25139.fieldOf("level").forGetter(Planet::dimension), (App)class_2960.field_25139.optionalFieldOf("orbit").forGetter(Planet::orbit), (App)class_2960.field_25139.optionalFieldOf("mainPlanet").forGetter(Planet::mainPlanet), (App)Codec.BOOL.fieldOf("oxygen").forGetter(Planet::oxygen), (App)Codec.FLOAT.fieldOf("temperature").forGetter(Planet::temperature), (App)Codec.INT.fieldOf("distanceFromEarth").forGetter(Planet::distanceFromEarth), (App)Codec.FLOAT.fieldOf("gravity").forGetter(Planet::gravity), (App)StormParameters.CODEC.optionalFieldOf("stormParameters").forGetter(Planet::stormParameters), (App)PlanetTextures.CODEC.fieldOf("textures").forGetter(Planet::textures)).apply((Applicative)instance, Planet::new));

    public static class_9129 toBuffer(List<Planet> planets, class_9129 buffer) {
        buffer.method_53002(planets.size());
        planets.forEach(planet -> {
            buffer.method_10814(planet.system);
            buffer.method_10814(planet.translatable);
            buffer.method_10814(planet.name);
            buffer.method_10812(planet.dimension);
            buffer.method_37435(planet.orbit, class_2540::method_10812);
            buffer.method_37435(planet.mainPlanet, class_2540::method_10812);
            buffer.method_52964(planet.oxygen);
            buffer.method_52941(planet.temperature);
            buffer.method_53002(planet.distanceFromEarth);
            buffer.method_52941(planet.gravity);
            buffer.method_37435(planet.stormParameters, (buf, parameters) -> parameters.toNetwork(buffer));
            planet.textures.toNetwork(buffer);
        });
        return buffer;
    }

    public static List<Planet> readFromBuffer(class_9129 buffer) {
        ArrayList<Planet> planets = new ArrayList<Planet>();
        int k = buffer.readInt();
        for (int i = 0; i < k; ++i) {
            planets.add(new Planet(buffer.method_19772(), buffer.method_19772(), buffer.method_19772(), buffer.method_10810(), buffer.method_37436(class_2540::method_10810), buffer.method_37436(class_2540::method_10810), buffer.readBoolean(), buffer.readFloat(), buffer.readInt(), buffer.readFloat(), buffer.method_37436(StormParameters::readBuffer), PlanetTextures.fromNetwork(buffer)));
        }
        return planets;
    }

    public class_2561 getTranslation() {
        return class_2561.method_43471((String)this.translatable);
    }

    public record StormParameters(int lightningFrequency, class_243 lightningColor) {
        public static final Codec<StormParameters> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("lightningFrequency").forGetter(StormParameters::lightningFrequency), (App)class_243.field_38277.fieldOf("color").forGetter(StormParameters::lightningColor)).apply((Applicative)instance, StormParameters::new));

        public class_9129 toNetwork(class_9129 buffer) {
            buffer.method_53002(this.lightningFrequency());
            buffer.method_52955(this.lightningColor());
            return buffer;
        }

        public static StormParameters readBuffer(class_2540 buffer) {
            return new StormParameters(buffer.readInt(), buffer.method_52996());
        }
    }
}

