/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.items;

import com.st0x0ef.stellaris.client.renderers.entities.vehicle.rocket.RocketModel;
import com.st0x0ef.stellaris.common.blocks.RocketLaunchPad;
import com.st0x0ef.stellaris.common.data_components.RocketComponent;
import com.st0x0ef.stellaris.common.entities.vehicles.RocketEntity;
import com.st0x0ef.stellaris.common.registry.DataComponentsRegistry;
import com.st0x0ef.stellaris.common.registry.EntityRegistry;
import com.st0x0ef.stellaris.common.vehicle_upgrade.FuelType;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_4538;
import net.minecraft.class_9331;

public class RocketItem
extends class_1792 {
    public RocketItem(class_1792.class_1793 properties) {
        super(properties.method_7889(1));
    }

    public class_1269 method_7884(class_1838 context) {
        class_1937 class_19372;
        class_1657 player = context.method_8036();
        class_2338 pos = context.method_8037();
        class_2680 state = context.method_8045().method_8320(pos);
        class_1268 hand = context.method_20287();
        class_1799 itemStack = context.method_8041();
        if (state.method_26204() instanceof RocketLaunchPad && ((Boolean)state.method_11654((class_2769)RocketLaunchPad.STAGE)).booleanValue() && (class_19372 = context.method_8045()) instanceof class_3218) {
            class_3218 level = (class_3218)class_19372;
            class_1750 blockplacecontext = new class_1750(context);
            class_2338 blockpos = blockplacecontext.method_8037();
            class_243 vec3 = class_243.method_26410((class_2382)blockpos, (double)this.getRocketPlaceHigh());
            class_238 aabb = ((class_1299)EntityRegistry.BIG_ROCKET.get()).method_18386().method_30231(vec3.method_10216(), vec3.method_10214(), vec3.method_10215());
            if (level.method_18026(aabb)) {
                int x = pos.method_10263();
                int y = pos.method_10264();
                int z = pos.method_10260();
                class_238 scanAbove = new class_238((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
                List entities = player.method_5770().method_18467(class_1297.class, scanAbove);
                if (entities.isEmpty()) {
                    RocketEntity rocket = this.getRocket(context.method_8045(), itemStack);
                    rocket.method_5814((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.0, (double)pos.method_10260() + 0.5);
                    double d0 = RocketItem.getYOffset((class_4538)level, pos, true, rocket.method_5829());
                    float f = (float)class_3532.method_15375((float)((class_3532.method_15393((float)(context.method_8044() - 180.0f)) + 45.0f) / 90.0f)) * 90.0f;
                    rocket.method_5808((double)pos.method_10263() + 0.5, (double)pos.method_10264() + d0, (double)pos.method_10260() + 0.5, f, 0.0f);
                    rocket.field_5982 = rocket.method_36454();
                    if (level.method_8649((class_1297)rocket)) {
                        if (!player.method_31549().field_7477) {
                            player.method_6122(hand, class_1799.field_8037);
                        }
                        this.rocketPlaceSound(pos, (class_1937)level);
                        return class_1269.field_5812;
                    }
                }
            }
        }
        return super.method_7884(context);
    }

    public class_1299<? extends RocketEntity> getEntityType(class_1799 stack) {
        RocketComponent rocketComponent = (RocketComponent)stack.method_57824((class_9331)DataComponentsRegistry.ROCKET_COMPONENT.get());
        return switch (rocketComponent.getModel().toString()) {
            case "small" -> (class_1299)EntityRegistry.SMALL_ROCKET.get();
            case "normal" -> (class_1299)EntityRegistry.NORMAL_ROCKET.get();
            case "big" -> (class_1299)EntityRegistry.BIG_ROCKET.get();
            default -> (class_1299)EntityRegistry.TINY_ROCKET.get();
        };
    }

    public RocketEntity getRocket(class_1937 level, class_1799 stack) {
        RocketEntity rocket = new RocketEntity(this.getEntityType(stack), level);
        RocketComponent rocketComponent = (RocketComponent)stack.method_57824((class_9331)DataComponentsRegistry.ROCKET_COMPONENT.get());
        if (rocketComponent != null) {
            rocket.setRocketComponent(new RocketComponent(rocket.SKIN_UPGRADE.getRocketSkinLocation().toString(), RocketModel.fromString(rocket.MODEL_UPGRADE.getModel().toString()), rocketComponent.fuelType(), Math.max(rocketComponent.fuel(), 0), rocketComponent.getFuelType().getFuelTexture(), rocket.TANK_UPGRADE.getTankCapacity()));
        }
        return rocket;
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltipComponents, class_1836 tooltipFlag) {
        RocketComponent rocketComponent = (RocketComponent)stack.method_57824((class_9331)DataComponentsRegistry.ROCKET_COMPONENT.get());
        if (rocketComponent == null) {
            return;
        }
        tooltipComponents.add((class_2561)class_2561.method_43469((String)"tooltip.item.stellaris.rocket.fuel", (Object[])new Object[]{rocketComponent.fuel()}).method_27692(class_124.field_1080));
    }

    public float getRocketPlaceHigh() {
        return -0.6f;
    }

    public void rocketPlaceSound(class_2338 pos, class_1937 world) {
        world.method_8396(null, pos, class_3417.field_15026, class_3419.field_15245, 1.0f, 1.0f);
    }

    protected static double getYOffset(class_4538 reader, class_2338 pos, boolean p_20628_, class_238 p_20629_) {
        class_238 aabb = new class_238(pos);
        if (p_20628_) {
            aabb = aabb.method_1012(0.0, -1.0, 0.0);
        }
        Iterable iterable = reader.method_8600(null, aabb);
        return 1.0 + class_259.method_1085((class_2350.class_2351)class_2350.class_2351.field_11052, (class_238)p_20629_, (Iterable)iterable, (double)(p_20628_ ? -2.0 : -1.0));
    }

    public boolean method_31567(class_1799 stack) {
        return true;
    }

    public int method_31569(class_1799 stack) {
        RocketComponent rocketComponent = (RocketComponent)stack.method_57824((class_9331)DataComponentsRegistry.ROCKET_COMPONENT.get());
        int value = 13 * rocketComponent.fuel() / rocketComponent.getTankCapacity();
        if (value < 0) {
            value = 0;
        } else if (value > 13) {
            value = 13;
        }
        return value;
    }

    public int method_31571(class_1799 stack) {
        RocketComponent rocketComponent = (RocketComponent)stack.method_57824((class_9331)DataComponentsRegistry.ROCKET_COMPONENT.get());
        FuelType.Type type = rocketComponent.getFuelType();
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"FUEL", "DIESEL", "HYDROGEN", "RADIOACTIVE", "URANIUM", "NEPTUNIUM", "PLUTONIUM"}, (FuelType.Type)type, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> 11003629;
            case 1 -> 5975060;
            case 2 -> 55551;
            case 3, 4, 5, 6 -> 49455;
            case -1 -> 11003629;
        };
    }
}

