/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.entities.layers;

import java.util.function.Supplier;
import net.mehvahdjukaar.supplementaries.api.IQuiverEntity;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1738;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_572;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_918;

public class QuiverLayer<T extends class_1309, M extends class_572<T>>
extends class_3887<T, M> {
    private final class_918 itemRenderer = class_310.method_1551().method_1480();
    private final Supplier<QuiverMode> quiverMode;
    private final boolean skeleton;

    public QuiverLayer(class_3883<T, M> parent, boolean isSkeleton) {
        super(parent);
        this.skeleton = isSkeleton;
        this.quiverMode = isSkeleton ? ClientConfigs.Items.QUIVER_SKELETON_RENDER_MODE : ClientConfigs.Items.QUIVER_RENDER_MODE;
    }

    public void render(class_4587 poseStack, class_4597 buffer, int packedLight, T livingEntity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        class_1799 quiver;
        QuiverMode mode = this.quiverMode.get();
        if (mode == QuiverMode.HIDDEN) {
            return;
        }
        if (!this.skeleton) {
            quiver = ((IQuiverEntity)livingEntity).supplementaries$getQuiver();
            if (livingEntity.method_6047() == quiver || livingEntity.method_6079() == quiver) {
                return;
            }
        } else if (((IQuiverEntity)livingEntity).supplementaries$hasQuiver()) {
            quiver = ModRegistry.QUIVER_ITEM.get().method_7854();
        } else {
            return;
        }
        if (!quiver.method_7960()) {
            poseStack.method_22903();
            ((class_572)this.method_17165()).field_3391.method_22703(poseStack);
            boolean flipped = livingEntity.method_6068() == class_1306.field_6183;
            double o = 0.001;
            if (mode == QuiverMode.THIGH) {
                boolean hasArmor = livingEntity.method_6118(class_1304.field_6172).method_7909() instanceof class_1738;
                double offset = hasArmor ? ClientConfigs.Items.QUIVER_ARMOR_OFFSET.get() : 0.0;
                boolean sneaking = livingEntity.method_18276();
                if (sneaking) {
                    poseStack.method_22904(0.0, -0.125, -0.275);
                }
                o += offset == -1.0 ? 0.21875 : 0.1875 + offset;
                if (flipped) {
                    float old = ((class_572)this.method_17165()).field_3397.field_3654;
                    ((class_572)this.method_17165()).field_3397.field_3654 = old * 0.3f;
                    ((class_572)this.method_17165()).field_3397.method_22703(poseStack);
                    ((class_572)this.method_17165()).field_3397.field_3654 = old;
                    poseStack.method_22904(0.0, -0.0625, -0.15625);
                    poseStack.method_22904(o, 0.0, 0.0);
                } else {
                    float old = ((class_572)this.method_17165()).field_3392.field_3654;
                    ((class_572)this.method_17165()).field_3392.field_3654 = old * 0.3f;
                    ((class_572)this.method_17165()).field_3392.method_22703(poseStack);
                    ((class_572)this.method_17165()).field_3392.field_3654 = old;
                    poseStack.method_22904(0.0, -0.0625, -0.15625);
                    poseStack.method_22904(-o, 0.0, 0.0);
                }
            } else {
                double offset;
                boolean hasArmor = livingEntity.method_6118(class_1304.field_6174).method_7909() instanceof class_1738;
                double d = offset = hasArmor ? ClientConfigs.Items.QUIVER_ARMOR_OFFSET.get() : 0.0;
                if (mode == QuiverMode.HIP) {
                    poseStack.method_22904(0.0, 0.1, o += offset == -1.0 ? 0.21875 : 0.1875 + offset);
                    poseStack.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
                    if (flipped) {
                        poseStack.method_22905(-1.0f, 1.0f, -1.0f);
                    }
                    poseStack.method_22904(0.0, 0.4, -0.1875);
                    poseStack.method_22907(class_7833.field_40713.rotationDegrees(-22.5f));
                } else {
                    poseStack.method_22904(0.0, 0.1, o += offset == -1.0 ? 0.25 : 0.1875 + offset);
                    poseStack.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
                    if (flipped) {
                        poseStack.method_22905(-1.0f, 1.0f, -1.0f);
                    }
                    poseStack.method_22904(0.0, 0.0, -0.125);
                }
            }
            this.itemRenderer.method_23177(livingEntity, quiver, class_811.field_4316, false, poseStack, buffer, livingEntity.method_37908(), packedLight, class_4608.field_21444, 0);
            poseStack.method_22909();
        }
    }

    public static enum QuiverMode {
        HIDDEN,
        BACK,
        HIP,
        THIGH;

    }
}

