/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import com.google.common.base.Suppliers;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.block.IPistonMotionReact;
import net.mehvahdjukaar.moonlight.api.block.ISoftFluidConsumer;
import net.mehvahdjukaar.moonlight.api.block.IWashable;
import net.mehvahdjukaar.moonlight.api.block.WaterBlock;
import net.mehvahdjukaar.moonlight.api.fluids.MLBuiltinSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.util.FakePlayerManager;
import net.mehvahdjukaar.moonlight.api.util.PotionBottleType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BambooSpikesBlockTile;
import net.mehvahdjukaar.supplementaries.common.items.BambooSpikesTippedItem;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.QuarkCompat;
import net.mehvahdjukaar.supplementaries.reg.ModComponents;
import net.mehvahdjukaar.supplementaries.reg.ModDamageSources;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1803;
import net.minecraft.class_181;
import net.minecraft.class_1844;
import net.minecraft.class_1922;
import net.minecraft.class_1934;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2669;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5328;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7;
import net.minecraft.class_8567;
import net.minecraft.class_9062;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class BambooSpikesBlock
extends WaterBlock
implements ISoftFluidConsumer,
class_2343,
IWashable,
IPistonMotionReact {
    protected static final class_265 SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0);
    protected static final class_265 SHAPE_UP = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    protected static final class_265 SHAPE_DOWN = class_2248.method_9541((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final class_265 SHAPE_NORTH = class_2248.method_9541((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final class_265 SHAPE_SOUTH = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    protected static final class_265 SHAPE_WEST = class_2248.method_9541((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final class_265 SHAPE_EAST = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    public static final class_2753 FACING = class_2318.field_10927;
    public static final class_2746 TIPPED = ModBlockProperties.TIPPED;
    private static final GameProfile SPIKE_PLAYER = new GameProfile(UUID.randomUUID(), "Spike Fake Player");
    private static final Supplier<Boolean> TIPPED_ENABLED = Suppliers.memoize(CommonConfigs.Functional.TIPPED_SPIKES_ENABLED::get);

    public BambooSpikesBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)TIPPED, (Comparable)Boolean.valueOf(false)));
    }

    public static class_1282 getDamageSource(class_1937 level) {
        if (CommonConfigs.Functional.BAMBOO_SPIKES_DROP_LOOT.get().booleanValue()) {
            class_1657 fakePlayer = FakePlayerManager.get((GameProfile)SPIKE_PLAYER, (class_1937)level);
            if (fakePlayer instanceof class_3222) {
                class_3222 sp = (class_3222)fakePlayer;
                sp.method_14236().method_12881();
                sp.method_7336(class_1934.field_9219);
            }
            return ModDamageSources.spikePlayer(fakePlayer);
        }
        return ModDamageSources.spike(level);
    }

    public class_2680 method_9598(class_2680 state, class_2470 rot) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rot.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirrorIn) {
        return state.method_26186(mirrorIn.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9605(class_1750 context) {
        class_1799 stack = context.method_8041();
        Integer charges = (Integer)stack.method_57825(ModComponents.CHARGES.get(), (Object)0);
        boolean hasPotion = stack.method_57826(class_9334.field_49651);
        return (class_2680)((class_2680)super.method_9605(context).method_11657((class_2769)FACING, (Comparable)context.method_8038())).method_11657((class_2769)TIPPED, (Comparable)Boolean.valueOf(charges != 0 && hasPotion));
    }

    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        ArrayList<class_1799> list = new ArrayList<class_1799>();
        list.add(this.getSpikeItem((class_2586)builder.method_51876(class_181.field_1228)));
        return list;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return switch ((class_2350)state.method_11654((class_2769)FACING)) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11033 -> SHAPE_DOWN;
            case class_2350.field_11036 -> SHAPE_UP;
            case class_2350.field_11034 -> SHAPE_EAST;
            case class_2350.field_11039 -> SHAPE_WEST;
            case class_2350.field_11043 -> SHAPE_NORTH;
            case class_2350.field_11035 -> SHAPE_SOUTH;
        };
    }

    public class_265 method_9584(class_2680 state, class_1922 worldIn, class_2338 pos) {
        return class_259.method_1077();
    }

    public void method_9548(class_2680 state, class_1937 level, class_2338 pos, class_1297 entityIn) {
        class_1657 player;
        if (entityIn instanceof class_1657 && (player = (class_1657)entityIn).method_7337()) {
            return;
        }
        if (entityIn instanceof class_1309) {
            class_1309 le = (class_1309)entityIn;
            if (entityIn.method_5805()) {
                boolean up = state.method_11654((class_2769)FACING) == class_2350.field_11036;
                double vy = up ? 0.45 : 0.95;
                float fall = entityIn.field_6017;
                entityIn.method_5844(state, new class_243(0.95, vy, 0.95));
                entityIn.field_6017 = fall;
                if (!level.field_9236) {
                    BambooSpikesBlockTile te;
                    class_2586 class_25862;
                    if (up && entityIn instanceof class_1657 && entityIn.method_5715()) {
                        return;
                    }
                    float damage = entityIn.method_23318() > (double)pos.method_10264() + 0.0625 ? 3.0f : 1.5f;
                    entityIn.method_5643(BambooSpikesBlock.getDamageSource(level), damage);
                    if (((Boolean)state.method_11654((class_2769)TIPPED)).booleanValue() && (class_25862 = level.method_8321(pos)) instanceof BambooSpikesBlockTile && (te = (BambooSpikesBlockTile)class_25862).interactWithEntity(le, level)) {
                        level.method_8652(pos, (class_2680)state.method_11657((class_2769)TIPPED, (Comparable)Boolean.valueOf(false)), 3);
                        level.method_33596(entityIn, (class_6880)class_5712.field_28733, pos);
                    }
                }
            }
        }
    }

    @Nullable
    public class_7 getBlockPathType(class_2680 state, class_1922 level, class_2338 pos, @Nullable class_1308 mob) {
        return class_7.field_17;
    }

    @Nullable
    public class_7 getAdjacentBlockPathType(class_2680 state, class_1922 level, class_2338 pos, @Nullable class_1308 mob, class_7 originalType) {
        return class_7.field_17;
    }

    protected class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hitResult) {
        if (!TIPPED_ENABLED.get().booleanValue() || ((Boolean)state.method_11654((class_2769)TIPPED)).booleanValue()) {
            return class_9062.field_47731;
        }
        if (stack.method_7909() instanceof class_1803) {
            class_1844 potion = BambooSpikesTippedItem.getPotion(stack);
            if (BambooSpikesBlock.tryAddingPotion(state, (class_1936)level, pos, potion, (class_1297)player) && !player.method_7337()) {
                player.method_6122(hand, class_5328.method_30270((class_1799)stack.method_7972(), (class_1657)player, (class_1799)new class_1799((class_1935)class_1802.field_8469), (boolean)false));
            }
            return class_9062.method_55644((boolean)level.field_9236);
        }
        return class_9062.field_47731;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, WATERLOGGED, TIPPED});
    }

    public class_1799 method_9574(class_4538 level, class_2338 pos, class_2680 state) {
        return this.getSpikeItem(level.method_8321(pos));
    }

    @Nullable
    public class_2586 method_10123(class_2338 pPos, class_2680 pState) {
        return (Boolean)pState.method_11654((class_2769)TIPPED) != false ? new BambooSpikesBlockTile(pPos, pState) : null;
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        class_2586 class_25862;
        if (0.01 > (double)random.method_43057() && ((Boolean)state.method_11654((class_2769)TIPPED)).booleanValue() && (class_25862 = world.method_8321(pos)) instanceof BambooSpikesBlockTile) {
            BambooSpikesBlockTile tile = (BambooSpikesBlockTile)class_25862;
            tile.makeParticle(world);
        }
    }

    public boolean tryAcceptingFluid(class_1937 world, class_2680 state, class_2338 pos, SoftFluidStack fluid) {
        if (!TIPPED_ENABLED.get().booleanValue() || ((Boolean)state.method_11654((class_2769)TIPPED)).booleanValue()) {
            return false;
        }
        if (fluid.is(MLBuiltinSoftFluids.POTION) && PotionBottleType.getOrDefault((SoftFluidStack)fluid) == PotionBottleType.LINGERING) {
            class_1844 content = BambooSpikesTippedItem.getPotion(fluid);
            return BambooSpikesBlock.tryAddingPotion(state, (class_1936)world, pos, content, null);
        }
        return false;
    }

    public static boolean tryAddingPotion(class_2680 state, class_1936 world, class_2338 pos, class_1844 potion, @Nullable class_1297 adder) {
        BambooSpikesBlockTile tile;
        world.method_8652(pos, (class_2680)state.method_11657((class_2769)TIPPED, (Comparable)Boolean.valueOf(true)), 0);
        class_2586 te = world.method_8321(pos);
        if (te instanceof BambooSpikesBlockTile && (tile = (BambooSpikesBlockTile)te).tryApplyPotion(potion)) {
            world.method_8396(null, pos, class_3417.field_21071, class_3419.field_15245, 0.5f, 1.5f);
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)TIPPED, (Comparable)Boolean.valueOf(true)), 3);
            world.method_33596(adder, (class_6880)class_5712.field_28733, pos);
            return true;
        }
        if (te != null) {
            te.method_11012();
        }
        world.method_8652(pos, (class_2680)state.method_11657((class_2769)TIPPED, (Comparable)Boolean.valueOf(false)), 0);
        return false;
    }

    public boolean tryWash(class_1937 level, class_2338 pos, class_2680 state, class_243 hitVec) {
        if (((Boolean)state.method_11654((class_2769)TIPPED)).booleanValue()) {
            if (!level.field_9236) {
                class_2586 te = level.method_8321(pos);
                if (te != null) {
                    te.method_11012();
                }
                level.method_8652(pos, (class_2680)state.method_11657((class_2769)TIPPED, (Comparable)Boolean.valueOf(false)), 3);
            }
            return true;
        }
        return false;
    }

    public boolean ticksWhileMoved() {
        return true;
    }

    public void moveTick(class_1937 level, class_2338 pos, class_2680 movedState, class_238 aabb, class_2669 tile) {
        boolean sameDir = ((class_2350)movedState.method_11654((class_2769)FACING)).equals((Object)tile.method_11498());
        if (CompatHandler.QUARK) {
            QuarkCompat.tickPiston(level, pos, movedState, aabb, sameDir, (class_2586)tile);
        }
    }

    public class_1799 getSpikeItem(@Nullable class_2586 te) {
        if (te instanceof BambooSpikesBlockTile) {
            BambooSpikesBlockTile tile = (BambooSpikesBlockTile)te;
            return Utils.saveTileToItem((class_2586)tile);
        }
        return ModRegistry.BAMBOO_SPIKES_ITEM.get().method_7854();
    }
}

