/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.block.WaterBlock;
import net.minecraft.class_156;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2349;
import net.minecraft.class_2350;
import net.minecraft.class_2389;
import net.minecraft.class_2415;
import net.minecraft.class_247;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_4778;
import net.minecraft.class_4970;
import org.jetbrains.annotations.NotNull;

public class WickerFenceBlock
extends WaterBlock {
    public static final class_2754<class_4778> EAST_WALL = class_2741.field_22174;
    public static final class_2754<class_4778> NORTH_WALL = class_2741.field_22175;
    public static final class_2754<class_4778> SOUTH_WALL = class_2741.field_22176;
    public static final class_2754<class_4778> WEST_WALL = class_2741.field_22177;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    private final Map<class_2680, class_265> shapeByIndex;
    private final Map<class_2680, class_265> collisionShapeByIndex;
    private static final class_265 NORTH_TEST = class_2248.method_9541((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)9.0);
    private static final class_265 SOUTH_TEST = class_2248.method_9541((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)16.0);
    private static final class_265 WEST_TEST = class_2248.method_9541((double)0.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final class_265 EAST_TEST = class_2248.method_9541((double)7.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);
    public static final Map<class_2350, class_2754<class_4778>> PROPERTY_BY_DIRECTION = ImmutableMap.copyOf((Map)((Map)class_156.method_654((Object)Maps.newEnumMap(class_2350.class), enumMap -> {
        enumMap.put(class_2350.field_11043, NORTH_WALL);
        enumMap.put(class_2350.field_11034, EAST_WALL);
        enumMap.put(class_2350.field_11035, SOUTH_WALL);
        enumMap.put(class_2350.field_11039, WEST_WALL);
    })));

    public WickerFenceBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657(NORTH_WALL, (Comparable)class_4778.field_22178)).method_11657(EAST_WALL, (Comparable)class_4778.field_22178)).method_11657(SOUTH_WALL, (Comparable)class_4778.field_22178)).method_11657(WEST_WALL, (Comparable)class_4778.field_22178));
        this.shapeByIndex = this.makeShapes(1.0f, 1.0f, 16.0f, 0.0f, 14.0f, 16.0f);
        this.collisionShapeByIndex = this.makeShapes(1.0f, 1.0f, 24.0f, 0.0f, 24.0f, 24.0f);
    }

    private static class_265 applyWallShape(class_265 baseShape, class_4778 height, class_265 lowShape, class_265 tallShape) {
        if (height == class_4778.field_22180) {
            return class_259.method_1084((class_265)baseShape, (class_265)tallShape);
        }
        return height == class_4778.field_22179 ? class_259.method_1084((class_265)baseShape, (class_265)lowShape) : baseShape;
    }

    private Map<class_2680, class_265> makeShapes(float width, float depth, float wallPostHeight, float wallMinY, float wallLowHeight, float wallTallHeight) {
        float f = 8.0f - width;
        float g = 8.0f + width;
        float h = 8.0f - depth;
        float i = 8.0f + depth;
        class_265 postShape = class_2248.method_9541((double)f, (double)0.0, (double)f, (double)g, (double)wallPostHeight, (double)g);
        class_265 northShape = class_2248.method_9541((double)h, (double)wallMinY, (double)0.0, (double)i, (double)wallLowHeight, (double)i);
        class_265 southShape = class_2248.method_9541((double)h, (double)wallMinY, (double)h, (double)i, (double)wallLowHeight, (double)16.0);
        class_265 westShape = class_2248.method_9541((double)0.0, (double)wallMinY, (double)h, (double)i, (double)wallLowHeight, (double)i);
        class_265 eastShape = class_2248.method_9541((double)h, (double)wallMinY, (double)h, (double)16.0, (double)wallLowHeight, (double)i);
        class_265 northShapeTall = class_2248.method_9541((double)h, (double)wallMinY, (double)0.0, (double)i, (double)wallTallHeight, (double)i);
        class_265 southShapeTall = class_2248.method_9541((double)h, (double)wallMinY, (double)h, (double)i, (double)wallTallHeight, (double)16.0);
        class_265 weastShapeTall = class_2248.method_9541((double)0.0, (double)wallMinY, (double)h, (double)i, (double)wallTallHeight, (double)i);
        class_265 eastShapeTall = class_2248.method_9541((double)h, (double)wallMinY, (double)h, (double)16.0, (double)wallTallHeight, (double)i);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (class_4778 east : EAST_WALL.method_11898()) {
            for (class_4778 north : NORTH_WALL.method_11898()) {
                for (class_4778 west : WEST_WALL.method_11898()) {
                    for (class_4778 south : SOUTH_WALL.method_11898()) {
                        class_265 conbinedShape = class_259.method_1073();
                        conbinedShape = WickerFenceBlock.applyWallShape(conbinedShape, east, eastShape, eastShapeTall);
                        conbinedShape = WickerFenceBlock.applyWallShape(conbinedShape, west, westShape, weastShapeTall);
                        conbinedShape = WickerFenceBlock.applyWallShape(conbinedShape, north, northShape, northShapeTall);
                        conbinedShape = WickerFenceBlock.applyWallShape(conbinedShape, south, southShape, southShapeTall);
                        conbinedShape = class_259.method_1084((class_265)conbinedShape, (class_265)postShape);
                        class_2680 blockState = (class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657(EAST_WALL, (Comparable)east)).method_11657(WEST_WALL, (Comparable)west)).method_11657(NORTH_WALL, (Comparable)north)).method_11657(SOUTH_WALL, (Comparable)south);
                        builder.put((Object)((class_2680)blockState.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))), (Object)conbinedShape);
                        builder.put((Object)((class_2680)blockState.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(true))), (Object)conbinedShape);
                    }
                }
            }
        }
        return builder.build();
    }

    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return this.shapeByIndex.get(state);
    }

    public class_265 method_9549(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return this.collisionShapeByIndex.get(state);
    }

    private boolean connectsTo(class_2680 state, boolean sideSolid, class_2350 direction) {
        class_2248 block = state.method_26204();
        boolean fenceGate = block instanceof class_2349 && class_2349.method_16703((class_2680)state, (class_2350)direction);
        return state.method_27852((class_2248)this) || !WickerFenceBlock.method_9581((class_2680)state) && sideSolid || block instanceof class_2389 || fenceGate;
    }

    public class_2680 method_9605(class_1750 context) {
        class_1937 levelReader = context.method_8045();
        class_2338 blockPos = context.method_8037();
        class_2680 state = super.method_9605(context);
        return this.allUpdate(state, blockPos, (class_4538)levelReader);
    }

    @NotNull
    private class_2680 allUpdate(class_2680 state, class_2338 blockPos, class_4538 levelReader) {
        class_2338 northPos = blockPos.method_10095();
        class_2338 eastPos = blockPos.method_10078();
        class_2338 southPos = blockPos.method_10072();
        class_2338 westPos = blockPos.method_10067();
        class_2338 abovePos = blockPos.method_10084();
        class_2680 northState = levelReader.method_8320(northPos);
        class_2680 eastState = levelReader.method_8320(eastPos);
        class_2680 southState = levelReader.method_8320(southPos);
        class_2680 westState = levelReader.method_8320(westPos);
        class_2680 aboveState = levelReader.method_8320(abovePos);
        boolean north = this.connectsTo(northState, northState.method_26206((class_1922)levelReader, northPos, class_2350.field_11035), class_2350.field_11035);
        boolean east = this.connectsTo(eastState, eastState.method_26206((class_1922)levelReader, eastPos, class_2350.field_11039), class_2350.field_11039);
        boolean south = this.connectsTo(southState, southState.method_26206((class_1922)levelReader, southPos, class_2350.field_11043), class_2350.field_11043);
        boolean weast = this.connectsTo(westState, westState.method_26206((class_1922)levelReader, westPos, class_2350.field_11034), class_2350.field_11034);
        if (!(east || weast || north || south)) {
            class_2680 belowState = levelReader.method_8320(blockPos.method_10074());
            if (belowState.method_27852((class_2248)this)) {
                east = belowState.method_11654(EAST_WALL) != class_4778.field_22178;
                weast = belowState.method_11654(WEST_WALL) != class_4778.field_22178;
                north = belowState.method_11654(NORTH_WALL) != class_4778.field_22178;
                south = belowState.method_11654(SOUTH_WALL) != class_4778.field_22178;
            } else {
                east = true;
                weast = true;
                north = true;
                south = true;
            }
        }
        return this.getCorrectShape(levelReader, state, abovePos, aboveState, north, east, south, weast);
    }

    private class_2680 getCorrectShape(class_4538 level, class_2680 state, class_2338 pos, class_2680 upState, boolean northConnection, boolean eastConnection, boolean southConnection, boolean westConnection) {
        class_265 voxelShape = upState.method_26220((class_1922)level, pos).method_20538(class_2350.field_11033);
        return this.updateSides(state, northConnection, eastConnection, southConnection, westConnection, voxelShape);
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 level, class_2338 currentPos, class_2338 neighborPos) {
        state = super.method_9559(state, direction, neighborState, level, currentPos, neighborPos);
        return switch (direction) {
            case class_2350.field_11033 -> this.allUpdate(state, currentPos, (class_4538)level);
            case class_2350.field_11036 -> this.topUpdate((class_4538)level, state, neighborPos, neighborState);
            default -> this.allUpdate(state, currentPos, (class_4538)level);
        };
    }

    private static boolean isConnected(class_2680 state, class_2769<class_4778> heightProperty) {
        return state.method_11654(heightProperty) != class_4778.field_22178;
    }

    private static boolean isCovered(class_265 firstShape, class_265 secondShape) {
        return !class_259.method_1074((class_265)secondShape, (class_265)firstShape, (class_247)class_247.field_16886);
    }

    private class_2680 topUpdate(class_4538 level, class_2680 state, class_2338 pos, class_2680 secondState) {
        boolean north = WickerFenceBlock.isConnected(state, NORTH_WALL);
        boolean east = WickerFenceBlock.isConnected(state, EAST_WALL);
        boolean south = WickerFenceBlock.isConnected(state, SOUTH_WALL);
        boolean west = WickerFenceBlock.isConnected(state, WEST_WALL);
        return this.getCorrectShape(level, state, pos, secondState, north, east, south, west);
    }

    private class_2680 updateSides(class_2680 state, boolean northConnection, boolean eastConnection, boolean southConnection, boolean westConnection, class_265 wallShape) {
        return (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657(NORTH_WALL, (Comparable)this.makeWallState(northConnection, wallShape, NORTH_TEST))).method_11657(EAST_WALL, (Comparable)this.makeWallState(eastConnection, wallShape, EAST_TEST))).method_11657(SOUTH_WALL, (Comparable)this.makeWallState(southConnection, wallShape, SOUTH_TEST))).method_11657(WEST_WALL, (Comparable)this.makeWallState(westConnection, wallShape, WEST_TEST));
    }

    private class_4778 makeWallState(boolean allowConnection, class_265 shape, class_265 neighbourShape) {
        if (allowConnection) {
            return WickerFenceBlock.isCovered(shape, neighbourShape) ? class_4778.field_22180 : class_4778.field_22179;
        }
        return class_4778.field_22178;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{NORTH_WALL, EAST_WALL, WEST_WALL, SOUTH_WALL});
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return switch (rotation) {
            case class_2470.field_11464 -> (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657(NORTH_WALL, (Comparable)((class_4778)state.method_11654(SOUTH_WALL)))).method_11657(EAST_WALL, (Comparable)((class_4778)state.method_11654(WEST_WALL)))).method_11657(SOUTH_WALL, (Comparable)((class_4778)state.method_11654(NORTH_WALL)))).method_11657(WEST_WALL, (Comparable)((class_4778)state.method_11654(EAST_WALL)));
            case class_2470.field_11465 -> (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657(NORTH_WALL, (Comparable)((class_4778)state.method_11654(EAST_WALL)))).method_11657(EAST_WALL, (Comparable)((class_4778)state.method_11654(SOUTH_WALL)))).method_11657(SOUTH_WALL, (Comparable)((class_4778)state.method_11654(WEST_WALL)))).method_11657(WEST_WALL, (Comparable)((class_4778)state.method_11654(NORTH_WALL)));
            case class_2470.field_11463 -> (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657(NORTH_WALL, (Comparable)((class_4778)state.method_11654(WEST_WALL)))).method_11657(EAST_WALL, (Comparable)((class_4778)state.method_11654(NORTH_WALL)))).method_11657(SOUTH_WALL, (Comparable)((class_4778)state.method_11654(EAST_WALL)))).method_11657(WEST_WALL, (Comparable)((class_4778)state.method_11654(SOUTH_WALL)));
            default -> state;
        };
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return switch (mirror) {
            case class_2415.field_11300 -> (class_2680)((class_2680)state.method_11657(NORTH_WALL, (Comparable)((class_4778)state.method_11654(SOUTH_WALL)))).method_11657(SOUTH_WALL, (Comparable)((class_4778)state.method_11654(NORTH_WALL)));
            case class_2415.field_11301 -> (class_2680)((class_2680)state.method_11657(EAST_WALL, (Comparable)((class_4778)state.method_11654(WEST_WALL)))).method_11657(WEST_WALL, (Comparable)((class_4778)state.method_11654(EAST_WALL)));
            default -> super.method_9569(state, mirror);
        };
    }
}

