/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.faucet;

import com.google.common.base.Preconditions;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.mehvahdjukaar.moonlight.api.misc.SidedInstance;
import net.mehvahdjukaar.moonlight.api.misc.fake_level.FakeLevelManager;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.FakePlayerManager;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.faucet.APIFluidTankInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.BeehiveInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.BrewingStandInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.ConcreteInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.ContainerItemInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.DataFluidInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.DataItemInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FaucetItemSource;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FaucetSource;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FaucetTarget;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FiniteFluidInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FullBucketCauldronInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.LiquidBlockInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.MudInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.PowderSnowCauldronInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.SappyLogInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.SoftFluidProviderInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.SoftFluidTankInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.SpongeInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.WaterCauldronInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.XPDroppingInteraction;
import net.mehvahdjukaar.supplementaries.common.utils.fake_level.BlockTestLevel;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_4309;
import net.minecraft.class_5556;
import net.minecraft.class_5620;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FaucetBehaviorsManager
extends class_4309 {
    private static final Codec<Either<DataItemInteraction, DataFluidInteraction>> CODEC = Codec.either(DataItemInteraction.CODEC, DataFluidInteraction.CODEC);
    private static final Set<Consumer<IFaucetEvent>> SERVER_LISTENERS = new HashSet<Consumer<IFaucetEvent>>();
    private static final SidedInstance<FaucetBehaviorsManager> INSTANCES = SidedInstance.of(FaucetBehaviorsManager::new);
    private final List<FaucetSource.BlState> blockInteractions = new ArrayList<FaucetSource.BlState>();
    private final List<FaucetSource.Tile> tileInteraction = new ArrayList<FaucetSource.Tile>();
    private final List<FaucetSource.Fluid> sourceFluidInteractions = new ArrayList<FaucetSource.Fluid>();
    private final List<FaucetItemSource> itemInteractions = new ArrayList<FaucetItemSource>();
    private final List<FaucetTarget.BlState> targetBlockInteractions = new ArrayList<FaucetTarget.BlState>();
    private final List<FaucetTarget.Tile> targetTileInteractions = new ArrayList<FaucetTarget.Tile>();
    private final List<FaucetTarget.Fluid> targetFluidInteractions = new ArrayList<FaucetTarget.Fluid>();
    private final class_7225.class_7874 registryAccess;

    public static FaucetBehaviorsManager getInstance(class_7225.class_7874 ra) {
        return (FaucetBehaviorsManager)((Object)INSTANCES.get(ra));
    }

    public static FaucetBehaviorsManager getInstance(@NotNull class_1937 level) {
        Preconditions.checkNotNull((Object)level);
        return FaucetBehaviorsManager.getInstance((class_7225.class_7874)level.method_30349());
    }

    public static synchronized void addRegisterFaucetInteractions(Consumer<IFaucetEvent> listener) {
        SERVER_LISTENERS.add(listener);
    }

    public FaucetBehaviorsManager(class_7225.class_7874 ra) {
        super(new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create(), "faucet_interactions");
        this.registryAccess = ra;
        INSTANCES.set(ra, (Object)this);
    }

    public Iterable<FaucetSource.BlState> getBlockInteractions() {
        return this.blockInteractions;
    }

    public Iterable<FaucetSource.Tile> getTileInteractions() {
        return this.tileInteraction;
    }

    public Iterable<FaucetSource.Fluid> getSourceFluidInteractions() {
        return this.sourceFluidInteractions;
    }

    public Iterable<FaucetItemSource> getItemInteractions() {
        return this.itemInteractions;
    }

    public Iterable<FaucetTarget.BlState> getTargetBlockInteractions() {
        return this.targetBlockInteractions;
    }

    public Iterable<FaucetTarget.Tile> getTargetTileInteractions() {
        return this.targetTileInteractions;
    }

    public Iterable<FaucetTarget.Fluid> getTargetFluidInteractions() {
        return this.targetFluidInteractions;
    }

    protected void apply(Map<class_2960, JsonElement> map, class_3300 resourceManager, class_3695 profiler) {
        this.tileInteraction.clear();
        this.sourceFluidInteractions.clear();
        this.itemInteractions.clear();
        this.targetBlockInteractions.clear();
        this.targetTileInteractions.clear();
        this.targetFluidInteractions.clear();
        class_6903 ops = ForgeHelper.conditionalOps((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)this.registryAccess, (class_4080)this);
        Codec codec = ForgeHelper.conditionalCodec(CODEC);
        ArrayList dataInteractions = new ArrayList();
        ArrayList dataFluidInteractions = new ArrayList();
        map.forEach((key, json) -> {
            try {
                Either either = (Either)((Optional)codec.parse((DynamicOps)ops, json).getOrThrow()).get();
                if (either.left().isPresent()) {
                    DataItemInteraction interaction = (DataItemInteraction)either.left().get();
                    dataInteractions.add(interaction);
                } else if (either.right().isPresent()) {
                    DataFluidInteraction interaction = (DataFluidInteraction)either.right().get();
                    dataFluidInteractions.add(interaction);
                }
            }
            catch (Exception e) {
                Supplementaries.LOGGER.error("Failed to parse JSON object for faucet interaction {}", key, (Object)e);
            }
        });
        if (!dataFluidInteractions.isEmpty()) {
            Supplementaries.LOGGER.info("Loaded  {} custom faucet interactions", (Object)(dataFluidInteractions.size() + dataInteractions.size()));
        }
        dataInteractions.forEach(this::registerInteraction);
        dataFluidInteractions.forEach(this::registerInteraction);
        this.registerInteraction(new SoftFluidProviderInteraction());
        this.registerInteraction(new WaterCauldronInteraction());
        this.registerInteraction(new FullBucketCauldronInteraction(class_2246.field_27098.method_9564(), class_1802.field_8187.method_7854()));
        this.registerInteraction(new PowderSnowCauldronInteraction());
        this.registerInteraction(new BeehiveInteraction());
        this.registerInteraction(new SoftFluidTankInteraction());
        this.registerInteraction(new APIFluidTankInteraction());
        this.registerInteraction(new BrewingStandInteraction());
        this.registerInteraction(new FiniteFluidInteraction());
        this.registerInteraction(new LiquidBlockInteraction());
        this.registerInteraction(new SpongeInteraction());
        this.registerInteraction(new XPDroppingInteraction());
        this.registerInteraction(new ConcreteInteraction());
        this.registerInteraction(new MudInteraction());
        this.registerInteraction(new ContainerItemInteraction());
        if (CompatHandler.AUTUMNITY) {
            this.registerInteraction(new SappyLogInteraction());
        }
        SERVER_LISTENERS.forEach(l -> l.accept(this::registerInteraction));
        MinecraftServer currentServer = PlatHelper.getCurrentServer();
        if (currentServer == null) {
            return;
        }
        class_3218 overworld = currentServer.method_30002();
        this.onLevelLoad(overworld);
    }

    public void onLevelLoad(class_3218 level) {
        BlockTestLevel testLevel = BlockTestLevel.get(level);
        class_1657 player = FakePlayerManager.getDefault((class_1937)testLevel);
        class_1268 hand = class_1268.field_5808;
        class_2680 emptyCauldron = class_2246.field_10593.method_9564();
        for (Map.Entry e : class_5620.field_27775.comp_1982().entrySet()) {
            class_1792 i = (class_1792)e.getKey();
            class_5620 interaction = (class_5620)e.getValue();
            if (Utils.getID((class_1792)i).method_12836().equals("minecraft")) continue;
            testLevel.setup();
            class_1799 fullBucket = i.method_7854();
            class_1799 fullBucketCopy = fullBucket.method_7972();
            player.method_6122(hand, fullBucket);
            interaction.interact(emptyCauldron, (class_1937)testLevel, class_2338.field_10980, player, hand, fullBucket);
            class_2680 fullCauldron = testLevel.blockState;
            if (fullCauldron == null || fullCauldron.method_28498((class_2769)class_5556.field_27206) && PlatHelper.getPlatform().isForge()) continue;
            this.registerInteraction(new FullBucketCauldronInteraction(fullCauldron, fullBucketCopy));
        }
        FakeLevelManager.invalidate((class_1937)testLevel);
    }

    protected void registerInteraction(Object interaction) {
        FaucetSource<class_2680> bs;
        boolean success = false;
        if (interaction instanceof FaucetSource.BlState) {
            bs = (FaucetSource.BlState)interaction;
            this.blockInteractions.add((FaucetSource.BlState)bs);
            success = true;
        }
        if (interaction instanceof FaucetSource.Tile) {
            FaucetSource.Tile ts = (FaucetSource.Tile)interaction;
            this.tileInteraction.add(ts);
            success = true;
        }
        if (interaction instanceof FaucetSource.Fluid) {
            bs = (FaucetSource.Fluid)interaction;
            this.sourceFluidInteractions.add((FaucetSource.Fluid)bs);
            success = true;
        }
        if (interaction instanceof FaucetTarget.BlState) {
            FaucetTarget.BlState tb = (FaucetTarget.BlState)interaction;
            this.targetBlockInteractions.add(tb);
            success = true;
        }
        if (interaction instanceof FaucetTarget.Tile) {
            FaucetTarget.Tile tt = (FaucetTarget.Tile)interaction;
            this.targetTileInteractions.add(tt);
            success = true;
        }
        if (interaction instanceof FaucetTarget.Fluid) {
            FaucetTarget.Fluid tf = (FaucetTarget.Fluid)interaction;
            this.targetFluidInteractions.add(tf);
            success = true;
        }
        if (interaction instanceof FaucetItemSource) {
            FaucetItemSource is = (FaucetItemSource)interaction;
            this.itemInteractions.add(is);
            success = true;
        }
        if (!success) {
            throw new UnsupportedOperationException("Unsupported faucet interaction class: " + interaction.getClass().getSimpleName());
        }
    }

    @Deprecated(forRemoval=true)
    public static void prepareToTransferBottle(SoftFluidTank tempFluidHolder, SoftFluid softFluid, @Nullable class_2487 tag) {
    }

    public static interface IFaucetEvent {
        public void registerInteraction(Object var1);
    }
}

