/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import com.mojang.serialization.DynamicOps;
import java.util.Set;
import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.block.IOneUserInteractable;
import net.mehvahdjukaar.moonlight.api.block.OpenableContainerBlockTile;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.CannonBlock;
import net.mehvahdjukaar.supplementaries.common.block.cannon.CannonAccess;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.IBallisticBehavior;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.IFireItemBehavior;
import net.mehvahdjukaar.supplementaries.common.inventories.CannonContainerMenu;
import net.mehvahdjukaar.supplementaries.common.items.CannonBallItem;
import net.mehvahdjukaar.supplementaries.common.items.components.CannonballWhitelist;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundCannonAnimationPacket;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModComponents;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_8710;
import org.jetbrains.annotations.Nullable;

public class CannonBlockTile
extends OpenableContainerBlockTile
implements IOneUserInteractable {
    public static final int MAX_POWER_LEVEL = 4;
    public Object ccHack = null;
    @Nullable
    private Set<class_2248> breakWhitelist = null;
    private float pitch = 0.0f;
    private float prevPitch = 0.0f;
    private float yaw = 0.0f;
    private float prevYaw = 0.0f;
    private int cooldownTimer = 0;
    private int fuseTimer = 0;
    private byte powerLevel = 1;
    private IBallisticBehavior.Data trajectoryData = IBallisticBehavior.LINE;
    private class_1792 trajectoryFor = class_1802.field_8162;
    @Nullable
    private UUID playerWhoIgnitedUUID = null;
    @Nullable
    private UUID controllingEntity = null;
    public final CannonAccess selfAccess = CannonAccess.block(this);

    public CannonBlockTile(class_2338 pos, class_2680 blockState) {
        super(ModRegistry.CANNON_TILE.get(), pos, blockState, 2);
    }

    public CannonBlockTile(class_2338 pos, class_2680 blockState, float initialYaw) {
        this(pos, blockState);
        this.yaw = initialYaw;
        this.prevYaw = initialYaw;
    }

    public void tick(CannonAccess access) {
        this.prevYaw = this.yaw;
        this.prevPitch = this.pitch;
        if (this.cooldownTimer > 0) {
            --this.cooldownTimer;
        }
        if (this.fuseTimer > 0) {
            --this.fuseTimer;
            if (this.fuseTimer <= 0) {
                this.fire(access);
            }
        }
    }

    private void fire(CannonAccess access) {
        class_3218 sl;
        if (!this.hasRequiredFuelAndProjectiles()) {
            return;
        }
        class_1937 class_19372 = this.method_10997();
        if (class_19372 instanceof class_3218 && this.shootProjectile(sl = (class_3218)class_19372, access)) {
            access.applyRecoil();
            class_1657 p = this.getPlayerWhoFired();
            if (p == null || !p.method_7337()) {
                class_1799 fuel = this.getFuel();
                fuel.method_7934((int)this.powerLevel);
                this.setFuel(fuel);
                class_1799 projectile = this.getProjectile();
                projectile.method_7934(1);
                this.setProjectile(projectile);
                this.method_5431();
                access.updateClients();
                this.field_11863.method_43275((class_1297)p, (class_6880)class_5712.field_28178, access.getCannonGlobalPosition(1.0f));
            }
            NetworkHelper.sendToAllClientPlayersInRange((class_3218)sl, (class_2338)class_2338.method_49638((class_2374)access.getCannonGlobalPosition(1.0f)), (double)128.0, (class_8710)new ClientBoundCannonAnimationPacket(access.makeNetworkTarget(), true));
        }
        this.cooldownTimer = CommonConfigs.Functional.CANNON_COOLDOWN.get();
    }

    protected void method_11007(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11007(tag, registries);
        tag.method_10548("yaw", this.yaw);
        tag.method_10548("pitch", this.pitch);
        tag.method_10569("cooldown", this.cooldownTimer);
        tag.method_10569("fuse_timer", this.fuseTimer);
        tag.method_10567("fire_power", this.powerLevel);
        if (this.playerWhoIgnitedUUID != null) {
            tag.method_25927("player_ignited", this.playerWhoIgnitedUUID);
        }
        if (this.breakWhitelist != null) {
            CannonBlockTile.saveBreakWhitelist(this.breakWhitelist, tag, registries);
        }
        tag.method_10566("trajectory", (class_2520)IBallisticBehavior.Data.CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.trajectoryData).getOrThrow());
    }

    public static void saveBreakWhitelist(Set<class_2248> breakWhitelist, class_2487 tag, class_7225.class_7874 registries) {
        CannonballWhitelist.CODEC.encodeStart((DynamicOps)registries.method_57093((DynamicOps)class_2509.field_11560), (Object)new CannonballWhitelist(breakWhitelist)).ifSuccess(t -> tag.method_10566("break_whitelist", t));
    }

    protected void method_11014(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11014(tag, registries);
        this.yaw = tag.method_10583("yaw");
        this.pitch = tag.method_10583("pitch");
        this.cooldownTimer = tag.method_10550("cooldown");
        this.fuseTimer = Math.max(this.fuseTimer, tag.method_10550("fuse_timer"));
        this.setPowerLevel(tag.method_10571("fire_power"));
        if (tag.method_10545("player_ignited")) {
            this.playerWhoIgnitedUUID = tag.method_25926("player_ignited");
        }
        this.breakWhitelist = CannonBlockTile.readBreakWhitelist(tag, registries);
        if (tag.method_10545("trajectory")) {
            this.trajectoryData = (IBallisticBehavior.Data)IBallisticBehavior.Data.CODEC.parse((DynamicOps)class_2509.field_11560, (Object)tag.method_10580("trajectory")).getOrThrow();
        }
    }

    private void fixRotation(class_1937 level) {
        class_2680 state = this.method_11010();
        class_2470 rot = (class_2470)state.method_11654(ModBlockProperties.ROTATE_TILE);
        if (rot != class_2470.field_11467 && level != null && !level.field_9236) {
            this.setYaw(this.selfAccess, this.yaw + (float)(rot.ordinal() * 90));
            level.method_8501(this.field_11867, (class_2680)state.method_11657(ModBlockProperties.ROTATE_TILE, (Comparable)class_2470.field_11467));
        }
    }

    @Nullable
    public static Set<class_2248> readBreakWhitelist(class_2487 tag, class_7225.class_7874 registries) {
        if (tag.method_10545("break_whitelist")) {
            return CannonballWhitelist.CODEC.parse((DynamicOps)registries.method_57093((DynamicOps)class_2509.field_11560), (Object)tag.method_10580("break_whitelist")).result().map(CannonballWhitelist::blocks).orElse(Set.of());
        }
        return null;
    }

    public void method_5431() {
        super.method_5431();
        this.recomputeTrajectoryData();
    }

    private void computeTrajectoryData() {
        class_1799 proj = this.getProjectile();
        IFireItemBehavior behavior = CannonBlock.getCannonBehavior((class_1935)this.getProjectile().method_7909());
        if (behavior instanceof IBallisticBehavior) {
            IBallisticBehavior b = (IBallisticBehavior)behavior;
            this.trajectoryData = b.calculateData(proj, this.field_11863);
        } else {
            this.trajectoryData = IBallisticBehavior.LINE;
        }
        if (this.trajectoryData == null) {
            Supplementaries.error();
        }
        this.trajectoryFor = proj.method_7909();
    }

    public boolean readyToFire() {
        return !this.isOnCooldown() && this.fuseTimer == 0 && this.hasRequiredFuelAndProjectiles();
    }

    public boolean hasRequiredFuelAndProjectiles() {
        return !this.getProjectile().method_7960() && !this.getFuel().method_7960() && this.getFuel().method_7947() >= this.powerLevel;
    }

    public boolean hasSomeFuelAndProjectiles() {
        return !this.getProjectile().method_7960() && !this.getFuel().method_7960();
    }

    public boolean isFiring() {
        return this.fuseTimer > 0;
    }

    public float getFiringAnimation(float partialTicks) {
        if (this.fuseTimer <= 0) {
            return 0.0f;
        }
        return ((float)this.fuseTimer - partialTicks) / (float)CommonConfigs.Functional.CANNON_FUSE_TIME.get().intValue();
    }

    public boolean isOnCooldown() {
        return this.cooldownTimer > 0;
    }

    public float getCooldownAnimation(float partialTicks) {
        if (this.cooldownTimer <= 0) {
            return 0.0f;
        }
        return ((float)this.cooldownTimer - partialTicks) / (float)CommonConfigs.Functional.CANNON_COOLDOWN.get().intValue();
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registries) {
        return this.method_38244(registries);
    }

    public class_1799 getProjectile() {
        return this.method_5438(1);
    }

    public void setProjectile(class_1799 stack) {
        this.method_5447(1, stack);
    }

    public class_1799 getFuel() {
        return this.method_5438(0);
    }

    public void setFuel(class_1799 stack) {
        this.method_5447(0, stack);
    }

    public IBallisticBehavior.Data getTrajectoryData() {
        return this.trajectoryData;
    }

    private void recomputeTrajectoryData() {
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return;
        }
        if (this.trajectoryFor != this.getProjectile().method_7909()) {
            this.computeTrajectoryData();
        }
    }

    public byte getPowerLevel() {
        return this.powerLevel;
    }

    public void setPowerLevel(byte powerLevel) {
        this.powerLevel = (byte)Math.clamp((long)powerLevel, 1, 4);
    }

    public float getFirePower() {
        return (float)Math.pow(this.powerLevel, CommonConfigs.Functional.CANNON_FIRE_POWER.get());
    }

    private float getStructureYaw() {
        return ((class_2470)this.method_11010().method_11654(CannonBlock.ROTATE_TILE)).ordinal() * 90;
    }

    public float getYaw(float partialTicks) {
        return class_3532.method_17821((float)partialTicks, (float)this.prevYaw, (float)this.yaw) + this.getStructureYaw();
    }

    public float getYaw() {
        return this.yaw + this.getStructureYaw();
    }

    public float getPitch(float partialTicks) {
        return class_3532.method_17821((float)partialTicks, (float)this.prevPitch, (float)this.pitch);
    }

    public float getPitch() {
        return this.pitch;
    }

    public void setAttributes(float yaw, float pitch, byte firePower, boolean fire, class_1657 controllingPlayer, CannonAccess access) {
        this.setYaw(access, yaw);
        this.setPitch(access, pitch);
        this.setPowerLevel(firePower);
        if (fire) {
            this.ignite((class_1297)controllingPlayer, access);
        }
    }

    public void setPitch(CannonAccess access, float relativePitch) {
        CannonAccess.Restraint r = access.getPitchAndYawRestrains();
        this.pitch = MthUtils.clampDegrees((float)relativePitch, (float)r.minPitch(), (float)r.maxPitch());
    }

    public void setYaw(CannonAccess access, float relativeYaw) {
        CannonAccess.Restraint r = access.getPitchAndYawRestrains();
        this.yaw = MthUtils.clampDegrees((float)relativeYaw, (float)r.minYaw(), (float)r.maxYaw()) - this.getStructureYaw();
    }

    public void setRenderYaw(CannonAccess access, float relativeYaw) {
        this.setYaw(access, relativeYaw);
        this.prevYaw = this.yaw;
    }

    public void setRenderPitch(CannonAccess access, float pitch) {
        this.setPitch(access, pitch);
        this.prevPitch = this.pitch;
    }

    protected void updateBlockState(class_2680 state, boolean b) {
    }

    protected void playOpenSound(class_2680 state) {
    }

    protected void playCloseSound(class_2680 state) {
    }

    public boolean method_5437(int index, class_1799 stack) {
        if (index == 0) {
            return stack.method_31574(class_1802.field_8054);
        }
        return !stack.method_31573(ModTags.CANNON_BLACKLIST);
    }

    public boolean method_5492(int index, class_1799 itemStack, @Nullable class_2350 direction) {
        return this.method_5437(direction == null || direction.method_10166().method_10179() ? 1 : 0, itemStack);
    }

    public boolean method_5493(int index, class_1799 stack, class_2350 direction) {
        return true;
    }

    public int[] method_5494(class_2350 side) {
        return new int[]{side.method_10166().method_10179() ? 1 : 0};
    }

    public void ignite(@Nullable class_1297 entityWhoIgnited, CannonAccess access) {
        if (this.fuseTimer > 0) {
            return;
        }
        if (this.getProjectile().method_7960()) {
            return;
        }
        this.fuseTimer = CommonConfigs.Functional.CANNON_FUSE_TIME.get();
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            NetworkHelper.sendToAllClientPlayersInDefaultRange((class_3218)serverLevel, (class_2338)class_2338.method_49638((class_2374)access.getCannonGlobalPosition(1.0f)), (class_8710)new ClientBoundCannonAnimationPacket(access.makeNetworkTarget(), false));
        }
        this.playerWhoIgnitedUUID = entityWhoIgnited != null ? entityWhoIgnited.method_5667() : null;
        this.method_5431();
        access.updateClients();
    }

    protected boolean shootProjectile(class_3218 serverLevel, CannonAccess access) {
        class_243 facing = access.getCannonGlobalFacing(1.0f).method_1021(-1.0);
        class_1799 projectile = this.getProjectile().method_7972();
        if (projectile.method_7909() instanceof CannonBallItem && this.breakWhitelist != null) {
            projectile.method_57379(ModComponents.CANNONBALL_WHITELIST.get(), (Object)new CannonballWhitelist(this.breakWhitelist));
        }
        IFireItemBehavior behavior = CannonBlock.getCannonBehavior((class_1935)this.getProjectile().method_7909());
        float firePower = this.getFirePower();
        return behavior.fire(projectile.method_7972(), serverLevel, access.getCannonGlobalPosition(1.0f), 0.5f, facing, firePower, 0, this.getPlayerWhoFired());
    }

    @Nullable
    protected class_1657 getPlayerWhoFired() {
        UUID uuid = this.controllingEntity;
        if (uuid == null && this.playerWhoIgnitedUUID != null) {
            uuid = this.playerWhoIgnitedUUID;
        }
        if (uuid == null) {
            return null;
        }
        return this.field_11863.method_18470(uuid);
    }

    public void setCurrentUser(@Nullable UUID uuid) {
        this.controllingEntity = uuid;
    }

    @Nullable
    public UUID getCurrentUser() {
        return this.controllingEntity;
    }

    public class_1703 method_5465(int id, class_1661 inv) {
        if (inv.field_7546.method_7325()) {
            return null;
        }
        return new CannonContainerMenu(id, inv, this.selfAccess);
    }

    public void method_54873(@Nullable class_1657 player) {
        class_5321 resourceKey = this.method_54869();
        super.method_54873(player);
        if (resourceKey != this.method_54869()) {
            class_1799 currentFuel;
            class_1799 currentAmmo = this.getProjectile();
            if (currentAmmo.method_31574((currentFuel = this.getFuel()).method_7909())) {
                currentFuel.method_7939(currentFuel.method_7947() + currentAmmo.method_7947());
                currentAmmo = class_1799.field_8037;
            }
            if (!this.method_5437(0, currentFuel) || !this.method_5437(1, currentFuel)) {
                if (this.method_5437(0, currentAmmo) && this.method_5437(1, currentFuel)) {
                    class_1799 temp = currentAmmo;
                    currentAmmo = currentFuel;
                    currentFuel = temp;
                } else {
                    currentFuel = class_1799.field_8037;
                    currentAmmo = class_1799.field_8037;
                }
            }
            this.setFuel(currentFuel);
            this.setProjectile(currentAmmo);
        }
    }
}

