/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities;

import net.mehvahdjukaar.moonlight.api.client.util.ParticleUtil;
import net.mehvahdjukaar.moonlight.api.entity.IExtraClientSpawnData;
import net.mehvahdjukaar.moonlight.api.entity.ImprovedProjectileEntity;
import net.mehvahdjukaar.moonlight.api.entity.ParticleTrailEmitter;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.supplementaries.common.misc.explosion.BombExplosion;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.CompatObjects;
import net.mehvahdjukaar.supplementaries.integration.FlanCompat;
import net.mehvahdjukaar.supplementaries.reg.ModEntities;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1674;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3231;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5819;
import net.minecraft.class_9129;

public class BombEntity
extends ImprovedProjectileEntity
implements IExtraClientSpawnData {
    private final boolean hasFuse = CommonConfigs.Tools.BOMB_FUSE.get() != 0;
    private BombType type = BombType.NORMAL;
    private boolean active = true;
    private int changeTimer = -1;
    private boolean superCharged = false;
    private final ParticleTrailEmitter trailEmitter = ParticleTrailEmitter.builder().spacing(0.25).maxParticlesPerTick(20).minParticlesPerTick(1).build();

    public BombEntity(class_1299<? extends BombEntity> type, class_1937 world) {
        super(type, world);
        this.maxAge = this.hasFuse ? CommonConfigs.Tools.BOMB_FUSE.get() : 200;
    }

    public BombEntity(class_1937 worldIn, class_1309 throwerIn, BombType type) {
        super(ModEntities.BOMB.get(), throwerIn, worldIn);
        this.type = type;
        this.maxAge = this.hasFuse ? CommonConfigs.Tools.BOMB_FUSE.get() : 300;
    }

    public BombEntity(class_1937 worldIn, double x, double y, double z, BombType type) {
        super(ModEntities.BOMB.get(), x, y, z, worldIn);
        this.type = type;
        this.maxAge = this.hasFuse ? CommonConfigs.Tools.BOMB_FUSE.get() : 300;
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10556("Active", this.active);
        compound.method_10569("Type", this.type.ordinal());
        compound.method_10569("Timer", this.changeTimer);
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.active = compound.method_10577("Active");
        this.type = BombType.values()[compound.method_10550("Type")];
        this.changeTimer = compound.method_10550("Timer");
    }

    public void readSpawnData(class_9129 buffer) {
        this.type = (BombType)buffer.method_10818(BombType.class);
    }

    public void writeSpawnData(class_9129 buffer) {
        buffer.method_10817((Enum)this.type);
    }

    public class_2596<class_2602> method_18002(class_3231 serverEntity) {
        return PlatHelper.getEntitySpawnPacket((class_1297)this, (class_3231)serverEntity);
    }

    protected class_1792 method_16942() {
        return ModRegistry.BOMB_ITEM.get();
    }

    private void spawnBreakParticles() {
        for (int i = 0; i < 8; ++i) {
            this.method_37908().method_8406((class_2394)new class_2392(class_2398.field_11218, this.method_7495()), this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0);
        }
    }

    public void method_5711(byte id) {
        switch (id) {
            case 3: {
                this.spawnBreakParticles();
                this.method_31472();
                break;
            }
            case 10: {
                this.spawnBreakParticles();
                this.method_31472();
                break;
            }
            case 68: {
                this.method_37908().method_8406((class_2394)class_2398.field_38908, this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0);
                break;
            }
            case 67: {
                class_5819 random = this.method_37908().method_8409();
                for (int i = 0; i < 10; ++i) {
                    this.method_37908().method_8406((class_2394)class_2398.field_11251, this.method_23317() + 0.25 - (double)(random.method_43057() * 0.5f), this.method_23318() + (double)0.45f - (double)(random.method_43057() * 0.5f), this.method_23321() + 0.25 - (double)(random.method_43057() * 0.5f), 0.0, 0.005, 0.0);
                }
                this.active = false;
                break;
            }
            default: {
                super.method_5711(id);
            }
        }
    }

    public boolean hasReachedEndOfLife() {
        return super.hasReachedEndOfLife() || this.changeTimer == 0;
    }

    public void method_5773() {
        if (this.active && this.method_5799() && this.type != BombType.BLUE) {
            this.turnOff();
        }
        super.method_5773();
    }

    public void spawnTrailParticles() {
        this.trailEmitter.tick((class_1297)this, (p, v) -> this.method_37908().method_8406((class_2394)class_2398.field_11251, p.field_1352, 0.25 + p.field_1351, p.field_1350, 0.0, 0.02, 0.0));
    }

    public void turnOff() {
        class_1937 level = this.method_37908();
        if (!level.method_8608()) {
            level.method_8421((class_1297)this, (byte)67);
            this.method_36975();
        }
        this.active = false;
    }

    public void method_5694(class_1657 entityIn) {
        if (!this.method_37908().field_9236 && !this.active && entityIn.method_31548().method_7394(this.method_7495())) {
            entityIn.method_6103((class_1297)this, 1);
            this.method_5650(class_1297.class_5529.field_26999);
        }
    }

    protected void method_7454(class_3966 hit) {
        super.method_7454(hit);
        hit.method_17782().method_5643(this.method_37908().method_48963().method_48811((class_1297)this, this.method_24921()), 1.0f);
        if (hit.method_17782() instanceof class_1674) {
            this.superCharged = true;
            hit.method_17782().method_5650(class_1297.class_5529.field_26999);
        }
        this.activateBomb();
    }

    protected void method_24920(class_3965 hit) {
        super.method_24920(hit);
        class_2680 state = this.method_37908().method_8320(hit.method_17777());
        if (!state.method_26164(ModTags.BOUNCY_BLOCKS) || hit.method_17780() != class_2350.field_11036) {
            this.method_18799(class_243.field_1353);
            this.method_24830(true);
            this.activateBomb();
        }
    }

    private void activateBomb() {
        class_1937 level = this.method_37908();
        if (!level.field_9236 && !this.hasFuse) {
            boolean isInstantlyActivated = this.type.isInstantlyActivated();
            if (!isInstantlyActivated && this.changeTimer == -1) {
                this.changeTimer = 5;
                level.method_8421((class_1297)this, (byte)68);
                level.method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_15145, class_3419.field_15254, 1.5f, 1.3f);
            }
            if (!this.method_31481() && (isInstantlyActivated || this.superCharged)) {
                this.reachedEndOfLife();
            }
        }
    }

    protected void method_26962() {
    }

    public float getDefaultShootVelocity() {
        return 1.25f;
    }

    public double method_7490() {
        return 0.04f;
    }

    public void reachedEndOfLife() {
        class_1937 level = this.method_37908();
        level.method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_21919, class_3419.field_15254, 1.5f, 1.5f);
        if (!level.field_9236) {
            if (this.active) {
                this.createExplosion();
                level.method_8421((class_1297)this, (byte)10);
            } else {
                level.method_8421((class_1297)this, (byte)3);
            }
            this.method_31472();
        }
    }

    private void createExplosion() {
        class_1657 p;
        class_1297 class_12972;
        boolean breaks;
        boolean bl = breaks = this.method_24921() instanceof class_1657 || PlatHelper.isMobGriefingOn((class_1937)this.method_37908(), (class_1297)this.method_24921());
        if (CompatHandler.FLAN && (class_12972 = this.method_24921()) instanceof class_1657 && !FlanCompat.canBreak(p = (class_1657)class_12972, class_2338.method_49638((class_2374)this.method_19538()))) {
            breaks = false;
        }
        if (this.superCharged) {
            this.method_37908().method_8537((class_1297)this, this.method_23317(), this.method_23318(), this.method_23321(), 6.0f, breaks, this.method_24921() instanceof class_1657 ? class_1937.class_7867.field_40891 : class_1937.class_7867.field_40890);
        }
        if ((class_12972 = this.method_37908()) instanceof class_3218) {
            class_3218 sl = (class_3218)class_12972;
            BombExplosion.createExplosion((class_1297)this, sl, this.method_23317(), this.method_23318() + 0.25, this.method_23321(), this.type, breaks);
        }
    }

    public static enum BombType {
        NORMAL,
        BLUE,
        SPIKY;


        public double getRadius() {
            return this == BLUE ? CommonConfigs.Tools.BOMB_BLUE_RADIUS.get() : CommonConfigs.Tools.BOMB_RADIUS.get();
        }

        public BreakingMode breakMode() {
            return this == BLUE ? CommonConfigs.Tools.BOMB_BLUE_BREAKS.get() : CommonConfigs.Tools.BOMB_BREAKS.get();
        }

        public float volume() {
            return this == BLUE ? 5.0f : 3.0f;
        }

        public void applyStatusEffects(class_1309 entity, double distSq) {
            switch (this.ordinal()) {
                case 1: {
                    entity.method_6092(new class_1293(class_1294.field_5911, 600));
                    entity.method_5639(10.0f);
                    break;
                }
            }
        }

        public boolean isInstantlyActivated() {
            return this != BLUE;
        }

        public void spawnExtraParticles(double x, double y, double z, class_1937 level) {
            switch (this.ordinal()) {
                case 1: {
                    ParticleUtil.spawnParticleInASphere((class_1937)level, (double)x, (double)y, (double)z, () -> class_2398.field_11240, (int)40, (float)0.4f, (float)0.01f, (float)0.15f);
                    break;
                }
                case 2: {
                    class_5819 random = level.method_8409();
                    class_2396 particle = (class_2396)CompatObjects.SHARPNEL.get();
                    if (particle instanceof class_2394) {
                        class_2394 p = (class_2394)particle;
                        for (int i = 0; i < 80; ++i) {
                            float dx = (float)(random.method_43059() * 2.0);
                            float dy = (float)(random.method_43059() * 2.0);
                            float dz = (float)(random.method_43059() * 2.0);
                            level.method_8406(p, x, y, z, (double)dx, (double)dy, (double)dz);
                        }
                        break;
                    }
                    ParticleUtil.spawnParticleInASphere((class_1937)level, (double)x, (double)y, (double)z, () -> class_2398.field_11205, (int)100, (float)5.0f, (float)0.01f, (float)0.15f);
                }
            }
        }
    }

    public static enum BreakingMode {
        ALL,
        WEAK,
        NONE;

    }
}

