/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities.controllers;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.class_10;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1922;
import net.minecraft.class_1941;
import net.minecraft.class_1950;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_4459;
import net.minecraft.class_7;
import net.minecraft.class_8;
import net.minecraft.class_9;
import net.minecraft.class_9316;
import org.jetbrains.annotations.Nullable;

public class BoatNodeEvaluator
extends class_8 {
    private static final float ON_LAND_MALUS = 1000.0f;
    public static final double SPACE_BETWEEN_WALL_POSTS = 0.5;
    private static final double DEFAULT_MOB_JUMP_HEIGHT = 1.125;
    private final Long2ObjectMap<class_7> pathTypesByPosCacheByMob = new Long2ObjectOpenHashMap();
    private final Object2BooleanMap<class_238> collisionCache = new Object2BooleanOpenHashMap();
    private final class_9[] reusableNeighbors = new class_9[class_2350.class_2353.field_11062.method_57092()];

    public BoatNodeEvaluator() {
        this.field_25 = true;
    }

    private boolean isCanStandOnFluid(class_3610 fluidState) {
        if (fluidState.method_15767(class_3486.field_15517)) {
            return true;
        }
        return this.field_33.method_26319(fluidState);
    }

    private float getPathfindingMalus(class_7 type) {
        return this.getPathfindingMalus(type, this.field_33);
    }

    public float getPathfindingMalus(class_7 type, class_1308 mob) {
        if (type == class_7.field_18) {
            return 0.0f;
        }
        float malus = mob.method_5944(type);
        return malus == -1.0f ? -1.0f : malus + 1000.0f;
    }

    public static double getWaterHeightLevel(class_1922 level, class_2338 pos) {
        class_2338 belowPos = pos.method_10074();
        class_2680 stateBelow = level.method_8320(belowPos);
        class_3610 fluidState = stateBelow.method_26227();
        class_265 voxelShape = stateBelow.method_26220(level, belowPos);
        double solidShape = (double)belowPos.method_10264() + (voxelShape.method_1110() ? 0.0 : voxelShape.method_1105(class_2350.class_2351.field_11052));
        float fluidHeight = fluidState.method_15763(level, belowPos);
        return Math.max(solidShape, (double)fluidHeight);
    }

    public void method_14(boolean canFloat) {
    }

    protected double getFloorLevel(class_2338 pos) {
        class_1941 blockGetter = this.field_49416.method_57621();
        return (this.method_22() || this.isAmphibious()) && blockGetter.method_8316(pos).method_15767(class_3486.field_15517) ? (double)pos.method_10264() + 0.5 : BoatNodeEvaluator.getFloorLevel((class_1922)blockGetter, pos);
    }

    public void method_12(class_1950 level, class_1308 mob) {
        super.method_12(level, mob);
        mob.method_51504();
        class_1297 vehicle = mob.method_5854();
        if (vehicle != null) {
            this.field_31 = class_3532.method_15375((float)(vehicle.method_17681() + 1.0f));
            this.field_30 = class_3532.method_15375((float)(vehicle.method_17682() + 1.0f));
            this.field_28 = class_3532.method_15375((float)(vehicle.method_17681() + 1.0f));
        }
    }

    public void method_19() {
        this.field_33.method_51503();
        this.pathTypesByPosCacheByMob.clear();
        this.collisionCache.clear();
        super.method_19();
    }

    public class_9 method_21() {
        int i;
        class_2338.class_2339 mutableBlockPos;
        block11: {
            mutableBlockPos = new class_2338.class_2339();
            i = this.field_33.method_31478();
            class_2680 blockState = this.field_49416.method_57623((class_2338)mutableBlockPos.method_10102(this.field_33.method_23317(), (double)i, this.field_33.method_23321()));
            if (!this.isCanStandOnFluid(blockState.method_26227())) {
                if (this.method_22() && this.field_33.method_5799()) {
                    while (true) {
                        if (!blockState.method_27852(class_2246.field_10382) && blockState.method_26227() != class_3612.field_15910.method_15729(false)) {
                            --i;
                            break block11;
                        }
                        blockState = this.field_49416.method_57623((class_2338)mutableBlockPos.method_10102(this.field_33.method_23317(), (double)(++i), this.field_33.method_23321()));
                    }
                }
                if (this.field_33.method_24828()) {
                    i = class_3532.method_15357((double)(this.field_33.method_23318() + 0.5));
                } else {
                    mutableBlockPos.method_10102(this.field_33.method_23317(), this.field_33.method_23318() + 1.0, this.field_33.method_23321());
                    while (mutableBlockPos.method_10264() > this.field_49416.method_57621().method_31607()) {
                        i = mutableBlockPos.method_10264();
                        mutableBlockPos.method_33098(mutableBlockPos.method_10264() - 1);
                        class_2680 blockState2 = this.field_49416.method_57623((class_2338)mutableBlockPos);
                        if (blockState2.method_26215() || blockState2.method_26171(class_10.field_48)) continue;
                        break;
                    }
                }
            } else {
                while (this.isCanStandOnFluid(blockState.method_26227())) {
                    blockState = this.field_49416.method_57623((class_2338)mutableBlockPos.method_10102(this.field_33.method_23317(), (double)(++i), this.field_33.method_23321()));
                }
                --i;
            }
        }
        class_2338 blockPos = this.field_33.method_24515();
        if (!this.canStartAt((class_2338)mutableBlockPos.method_10103(blockPos.method_10263(), i, blockPos.method_10260()))) {
            class_238 aABB = this.field_33.method_5829();
            if (this.canStartAt((class_2338)mutableBlockPos.method_10102(aABB.field_1323, (double)i, aABB.field_1321)) || this.canStartAt((class_2338)mutableBlockPos.method_10102(aABB.field_1323, (double)i, aABB.field_1324)) || this.canStartAt((class_2338)mutableBlockPos.method_10102(aABB.field_1320, (double)i, aABB.field_1321)) || this.canStartAt((class_2338)mutableBlockPos.method_10102(aABB.field_1320, (double)i, aABB.field_1324))) {
                return this.getStartNode((class_2338)mutableBlockPos);
            }
        }
        return this.getStartNode(new class_2338(blockPos.method_10263(), i, blockPos.method_10260()));
    }

    protected class_9 getStartNode(class_2338 pos) {
        class_9 node = this.method_27137(pos);
        node.field_41 = this.getCachedPathType(node.field_40, node.field_39, node.field_38);
        node.field_43 = this.getPathfindingMalus(node.field_41);
        return node;
    }

    protected boolean canStartAt(class_2338 pos) {
        class_7 pathType = this.getCachedPathType(pos.method_10263(), pos.method_10264(), pos.method_10260());
        return pathType != class_7.field_7 && this.getPathfindingMalus(pathType) >= 0.0f;
    }

    public class_4459 method_16(double x, double y, double z) {
        return this.method_57083(x, y, z);
    }

    public int method_18(class_9[] outputArray, class_9 node) {
        int i = 0;
        int j = 0;
        class_7 pathType = this.getCachedPathType(node.field_40, node.field_39 + 1, node.field_38);
        class_7 pathType2 = this.getCachedPathType(node.field_40, node.field_39, node.field_38);
        if (this.getPathfindingMalus(pathType) >= 0.0f && pathType2 != class_7.field_21326) {
            j = class_3532.method_15375((float)Math.max(1.0f, this.field_33.method_49476()));
        }
        double d = this.getFloorLevel(new class_2338(node.field_40, node.field_39, node.field_38));
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            class_9 node2;
            this.reusableNeighbors[direction.method_10161()] = node2 = this.findAcceptedNode(node.field_40 + direction.method_10148(), node.field_39, node.field_38 + direction.method_10165(), j, d, direction, pathType2);
            if (!this.isNeighborValid(node2, node)) continue;
            outputArray[i++] = node2;
        }
        for (class_2350 horizontalDir : class_2350.class_2353.field_11062) {
            class_9 node3;
            class_2350 direction2 = horizontalDir.method_10170();
            if (!this.isDiagonalValid(node, this.reusableNeighbors[horizontalDir.method_10161()], this.reusableNeighbors[direction2.method_10161()]) || !this.isDiagonalValid(node3 = this.findAcceptedNode(node.field_40 + horizontalDir.method_10148() + direction2.method_10148(), node.field_39, node.field_38 + horizontalDir.method_10165() + direction2.method_10165(), j, d, horizontalDir, pathType2))) continue;
            outputArray[i++] = node3;
        }
        return i;
    }

    protected boolean isNeighborValid(@Nullable class_9 neighbor, class_9 node) {
        return neighbor != null && !neighbor.field_42 && (neighbor.field_43 >= 0.0f || node.field_43 < 0.0f);
    }

    protected boolean isDiagonalValid(class_9 root, @Nullable class_9 xNode, @Nullable class_9 zNode) {
        if (zNode == null || xNode == null || zNode.field_39 > root.field_39 || xNode.field_39 > root.field_39) {
            return false;
        }
        if (xNode.field_41 != class_7.field_26446 && zNode.field_41 != class_7.field_26446) {
            boolean bl = zNode.field_41 == class_7.field_10 && xNode.field_41 == class_7.field_10 && (double)this.field_33.method_17681() < 0.5;
            return (zNode.field_39 < root.field_39 || zNode.field_43 >= 0.0f || bl) && (xNode.field_39 < root.field_39 || xNode.field_43 >= 0.0f || bl);
        }
        return false;
    }

    protected boolean isDiagonalValid(@Nullable class_9 node) {
        if (node == null || node.field_42) {
            return false;
        }
        return node.field_41 == class_7.field_26446 ? false : node.field_43 >= 0.0f;
    }

    private static boolean doesBlockHavePartialCollision(class_7 pathType) {
        return pathType == class_7.field_10 || pathType == class_7.field_23 || pathType == class_7.field_8;
    }

    private boolean canReachWithoutCollision(class_9 node) {
        class_238 aABB = this.field_33.method_5829();
        class_243 vec3 = new class_243((double)node.field_40 - this.field_33.method_23317() + aABB.method_17939() / 2.0, (double)node.field_39 - this.field_33.method_23318() + aABB.method_17940() / 2.0, (double)node.field_38 - this.field_33.method_23321() + aABB.method_17941() / 2.0);
        int i = class_3532.method_15384((double)(vec3.method_1033() / aABB.method_995()));
        vec3 = vec3.method_1021((double)(1.0f / (float)i));
        for (int j = 1; j <= i; ++j) {
            if (!this.hasCollisions(aABB = aABB.method_997(vec3))) continue;
            return false;
        }
        return true;
    }

    public static double getFloorLevel(class_1922 level, class_2338 pos) {
        class_2338 blockPos = pos.method_10074();
        class_265 voxelShape = level.method_8320(blockPos).method_26220(level, blockPos);
        return (double)blockPos.method_10264() + (voxelShape.method_1110() ? 0.0 : voxelShape.method_1105(class_2350.class_2351.field_11052));
    }

    protected boolean isAmphibious() {
        return false;
    }

    @Nullable
    protected class_9 findAcceptedNode(int x, int y, int z, int verticalDeltaLimit, double nodeFloorLevel, class_2350 direction, class_7 pathType) {
        class_9 node = null;
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        double d = this.getFloorLevel((class_2338)mutableBlockPos.method_10103(x, y, z));
        if (d - nodeFloorLevel > this.getMobJumpHeight()) {
            return null;
        }
        class_7 pathType2 = this.getCachedPathType(x, y, z);
        float f = this.getPathfindingMalus(pathType2);
        if (f >= 0.0f) {
            node = this.getNodeAndUpdateCostToMax(x, y, z, pathType2, f);
        }
        if (BoatNodeEvaluator.doesBlockHavePartialCollision(pathType) && node != null && node.field_43 >= 0.0f && !this.canReachWithoutCollision(node)) {
            node = null;
        }
        if (!(pathType2 == class_7.field_12 || this.isAmphibious() && pathType2 == class_7.field_18)) {
            if ((node == null || node.field_43 < 0.0f) && verticalDeltaLimit > 0 && (pathType2 != class_7.field_10 || this.method_46738()) && pathType2 != class_7.field_25418 && pathType2 != class_7.field_19 && pathType2 != class_7.field_33534) {
                node = this.tryJumpOn(x, y, z, verticalDeltaLimit, nodeFloorLevel, direction, pathType, mutableBlockPos);
            } else if (!this.isAmphibious() && pathType2 == class_7.field_18 && !this.method_22()) {
                node = this.tryFindFirstNonWaterBelow(x, y, z, node);
            } else if (pathType2 == class_7.field_7) {
                node = this.tryFindFirstGroundNodeBelow(x, y, z);
            } else if (BoatNodeEvaluator.doesBlockHavePartialCollision(pathType2) && node == null) {
                node = this.getClosedNode(x, y, z, pathType2);
            }
            return node;
        }
        return node;
    }

    private double getMobJumpHeight() {
        return Math.max(1.125, (double)this.field_33.method_49476());
    }

    private class_9 getNodeAndUpdateCostToMax(int x, int y, int z, class_7 pathType, float malus) {
        class_9 node = this.method_13(x, y, z);
        node.field_41 = pathType;
        node.field_43 = Math.max(node.field_43, malus);
        return node;
    }

    private class_9 getBlockedNode(int x, int y, int z) {
        class_9 node = this.method_13(x, y, z);
        node.field_41 = class_7.field_22;
        node.field_43 = -1.0f;
        return node;
    }

    private class_9 getClosedNode(int x, int y, int z, class_7 pathType) {
        class_9 node = this.method_13(x, y, z);
        node.field_42 = true;
        node.field_41 = pathType;
        node.field_43 = pathType.method_11();
        return node;
    }

    @Nullable
    private class_9 tryJumpOn(int x, int y, int z, int verticalDeltaLimit, double nodeFloorLevel, class_2350 direction, class_7 pathType, class_2338.class_2339 pos) {
        class_9 node = this.findAcceptedNode(x, y + 1, z, verticalDeltaLimit - 1, nodeFloorLevel, direction, pathType);
        if (node == null) {
            return null;
        }
        if (this.field_33.method_17681() >= 1.0f) {
            return node;
        }
        if (node.field_41 != class_7.field_7 && node.field_41 != class_7.field_12) {
            return node;
        }
        double d = (double)(x - direction.method_10148()) + 0.5;
        double e = (double)(z - direction.method_10165()) + 0.5;
        double f = (double)this.field_33.method_17681() / 2.0;
        class_238 aABB = new class_238(d - f, this.getFloorLevel((class_2338)pos.method_10102(d, (double)(y + 1), e)) + 0.001, e - f, d + f, (double)this.field_33.method_17682() + this.getFloorLevel((class_2338)pos.method_10102((double)node.field_40, (double)node.field_39, (double)node.field_38)) - 0.002, e + f);
        return this.hasCollisions(aABB) ? null : node;
    }

    @Nullable
    private class_9 tryFindFirstNonWaterBelow(int x, int y, int z, @Nullable class_9 node) {
        --y;
        while (y > this.field_33.method_37908().method_31607()) {
            class_7 pathType = this.getCachedPathType(x, y, z);
            if (pathType != class_7.field_18) {
                return node;
            }
            node = this.getNodeAndUpdateCostToMax(x, y, z, pathType, this.getPathfindingMalus(pathType));
            --y;
        }
        return node;
    }

    private class_9 tryFindFirstGroundNodeBelow(int x, int y, int z) {
        for (int i = y - 1; i >= this.field_33.method_37908().method_31607(); --i) {
            if (y - i > this.field_33.method_5850()) {
                return this.getBlockedNode(x, i, z);
            }
            class_7 pathType = this.getCachedPathType(x, i, z);
            float f = this.getPathfindingMalus(pathType);
            if (pathType == class_7.field_7) continue;
            if (f >= 0.0f) {
                return this.getNodeAndUpdateCostToMax(x, i, z, pathType, f);
            }
            return this.getBlockedNode(x, i, z);
        }
        return this.getBlockedNode(x, y, z);
    }

    private boolean hasCollisions(class_238 boundingBox) {
        return this.collisionCache.computeIfAbsent((Object)boundingBox, object -> !this.field_49416.method_57621().method_8587((class_1297)this.field_33, boundingBox));
    }

    protected class_7 getCachedPathType(int x, int y, int z) {
        return (class_7)this.pathTypesByPosCacheByMob.computeIfAbsent(class_2338.method_10064((int)x, (int)y, (int)z), l -> this.method_25(this.field_49416, x, y, z, this.field_33));
    }

    public class_7 method_25(class_9316 context, int x, int y, int z, class_1308 mob) {
        Set<class_7> set = this.getPathTypeWithinMobBB(context, x, y, z);
        if (set.contains(class_7.field_10)) {
            return class_7.field_10;
        }
        if (set.contains(class_7.field_25418)) {
            return class_7.field_25418;
        }
        class_7 pathType = class_7.field_22;
        for (class_7 pathType2 : set) {
            if (mob.method_5944(pathType2) < 0.0f) {
                return pathType2;
            }
            if (!(mob.method_5944(pathType2) >= mob.method_5944(pathType))) continue;
            pathType = pathType2;
        }
        return this.field_31 <= 1 && pathType != class_7.field_7 && mob.method_5944(pathType) == 0.0f && this.method_17(context, x, y, z) == class_7.field_7 ? class_7.field_7 : pathType;
    }

    public Set<class_7> getPathTypeWithinMobBB(class_9316 context, int x, int y, int z) {
        EnumSet<class_7> enumSet = EnumSet.noneOf(class_7.class);
        for (int i = 0; i < this.field_31; ++i) {
            for (int j = 0; j < this.field_30; ++j) {
                for (int k = 0; k < this.field_28; ++k) {
                    int l = i + x;
                    int m = j + y;
                    int n = k + z;
                    class_7 pathType = this.method_17(context, l, m, n);
                    class_2338 blockPos = this.field_33.method_24515();
                    boolean bl = this.method_23();
                    if (pathType == class_7.field_23 && this.method_24() && bl) {
                        pathType = class_7.field_26446;
                    }
                    if (pathType == class_7.field_15 && !bl) {
                        pathType = class_7.field_22;
                    }
                    if (pathType == class_7.field_21 && this.method_17(context, blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260()) != class_7.field_21 && this.method_17(context, blockPos.method_10263(), blockPos.method_10264() - 1, blockPos.method_10260()) != class_7.field_21) {
                        pathType = class_7.field_25418;
                    }
                    enumSet.add(pathType);
                }
            }
        }
        return enumSet;
    }

    public class_7 method_17(class_9316 context, int x, int y, int z) {
        return BoatNodeEvaluator.getPathTypeStatic(context, new class_2338.class_2339(x, y, z));
    }

    public static class_7 getPathTypeStatic(class_1308 mob, class_2338 pos) {
        return BoatNodeEvaluator.getPathTypeStatic(new class_9316((class_1941)mob.method_37908(), mob), pos.method_25503());
    }

    public static class_7 getPathTypeStatic(class_9316 context, class_2338.class_2339 pos) {
        int k;
        int j;
        int i = pos.method_10263();
        class_7 pathType = context.method_57622(i, j = pos.method_10264(), k = pos.method_10260());
        if (pathType == class_7.field_7 && j >= context.method_57621().method_31607() + 1) {
            return switch (context.method_57622(i, j - 1, k)) {
                case class_7.field_7, class_7.field_18, class_7.field_14, class_7.field_12 -> class_7.field_7;
                case class_7.field_3 -> class_7.field_3;
                case class_7.field_17 -> class_7.field_17;
                case class_7.field_21326 -> class_7.field_21326;
                case class_7.field_33534 -> class_7.field_36432;
                case class_7.field_43351 -> class_7.field_43351;
                case class_7.field_19 -> class_7.field_47413;
                default -> BoatNodeEvaluator.checkNeighbourBlocks(context, i, j, k, class_7.field_12);
            };
        }
        return pathType;
    }

    public static class_7 checkNeighbourBlocks(class_9316 context, int x, int y, int z, class_7 pathType) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    if (i == 0 && k == 0) continue;
                    class_7 pathType2 = context.method_57622(x + i, y + j, z + k);
                    if (pathType2 == class_7.field_17) {
                        return class_7.field_5;
                    }
                    if (pathType2 == class_7.field_3 || pathType2 == class_7.field_14) {
                        return class_7.field_9;
                    }
                    if (pathType2 == class_7.field_18) {
                        return class_7.field_4;
                    }
                    if (pathType2 != class_7.field_43351) continue;
                    return class_7.field_43351;
                }
            }
        }
        return pathType;
    }
}

