/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mehvahdjukaar.moonlight.api.item.ILeftClickReact;
import net.mehvahdjukaar.supplementaries.SuppPlatformStuff;
import net.mehvahdjukaar.supplementaries.common.items.SelectableContainerItem;
import net.mehvahdjukaar.supplementaries.common.items.components.LunchBaskedContent;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.common.utils.SlotReference;
import net.mehvahdjukaar.supplementaries.common.utils.VibeChecker;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.mixins.LivingEntityAccessor;
import net.mehvahdjukaar.supplementaries.reg.ModComponents;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1796;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4174;
import net.minecraft.class_9331;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LunchBoxItem
extends SelectableContainerItem<LunchBaskedContent, LunchBaskedContent.Mutable>
implements ILeftClickReact {
    public LunchBoxItem(class_1792.class_1793 properties) {
        super(properties);
    }

    @Override
    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltipComponents, class_1836 tooltipFlag) {
        super.method_7851(stack, context, tooltipComponents, tooltipFlag);
        if (MiscUtils.showsHints(tooltipFlag)) {
            LunchBoxItem.addClientTooltip(tooltipComponents);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static void addClientTooltip(List<class_2561> list) {
        list.add((class_2561)class_2561.method_43469((String)"message.supplementaries.lunch_box.tooltip", (Object[])new Object[]{class_310.method_1551().field_1690.field_1886.method_16007()}).method_27692(class_124.field_1056).method_27692(class_124.field_1080));
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        VibeChecker.assertSameLevel(level, player);
        class_1799 basket = player.method_5998(hand);
        LunchBaskedContent data = (LunchBaskedContent)basket.method_57824(this.getComponentType());
        if (data != null && data.canEatFrom()) {
            class_1799 food = data.getSelected();
            if (food.method_7960()) {
                return class_1271.method_22431((Object)basket);
            }
            if (player.method_7357().method_7904(food.method_7909())) {
                return class_1271.method_22431((Object)basket);
            }
            player.method_6122(hand, food);
            class_1792 foodItem = food.method_7909();
            class_1271 result = food.method_7913(level, player, hand);
            this.maybeAddCooldowns(player, foodItem);
            class_1799 resItem = (class_1799)result.method_5466();
            LunchBaskedContent.Mutable mutable = data.toMutable();
            boolean success = LunchBoxItem.swapWithSelected((class_1309)player, resItem, mutable, food);
            if (success) {
                basket.method_57379(this.getComponentType(), (Object)mutable.toImmutable());
            }
            ((LivingEntityAccessor)player).setUseItem(basket);
            player.method_6122(hand, basket);
            return new class_1271(result.method_5467(), (Object)basket);
        }
        return super.method_7836(level, player, hand);
    }

    public boolean onLeftClick(class_1799 stack, class_1657 player, class_1268 hand) {
        LunchBaskedContent data = (LunchBaskedContent)stack.method_57824(this.getComponentType());
        if (data == null) {
            return false;
        }
        boolean open = data.canEatFrom();
        if (open) {
            player.method_5783(ModSounds.LUNCH_BASKET_CLOSE.get(), 0.3f, 1.0f + player.method_37908().method_8409().method_43057() * 0.3f);
        } else {
            player.method_5783(ModSounds.LUNCH_BASKET_OPEN.get(), 0.3f, 1.6f + player.method_37908().method_8409().method_43057() * 0.3f);
        }
        LunchBaskedContent.Mutable mutable = data.toMutable();
        mutable.switchMode();
        stack.method_57379(this.getComponentType(), (Object)mutable.toImmutable());
        return true;
    }

    public boolean method_7885(class_2680 state, class_1937 level, class_2338 pos, class_1657 player) {
        return false;
    }

    @Nullable
    public class_4174 getFoodProperties(class_1799 stack, @Nullable class_1309 entity) {
        LunchBaskedContent data = (LunchBaskedContent)stack.method_57824(this.getComponentType());
        if (data != null && data.canEatFrom()) {
            return SuppPlatformStuff.getFoodProperties(data.getSelected(), entity);
        }
        return null;
    }

    public boolean allowComponentsUpdateAnimation(class_1657 player, class_1268 hand, class_1799 oldStack, class_1799 newStack) {
        return false;
    }

    @Override
    public int method_7881(class_1799 stack, class_1309 livingEntity) {
        LunchBaskedContent data = (LunchBaskedContent)stack.method_57824(this.getComponentType());
        if (data != null && data.canEatFrom()) {
            return data.getSelected().method_7935(livingEntity);
        }
        return super.method_7881(stack, livingEntity);
    }

    public class_1839 method_7853(class_1799 stack) {
        LunchBaskedContent data = (LunchBaskedContent)stack.method_57824(this.getComponentType());
        if (data != null && data.canEatFrom()) {
            return data.getSelected().method_7976();
        }
        return super.method_7853(stack);
    }

    public class_1799 method_7861(class_1799 stack, class_1937 level, class_1309 livingEntity) {
        LunchBaskedContent data = (LunchBaskedContent)stack.method_57824(this.getComponentType());
        if (data != null && data.canEatFrom()) {
            boolean success;
            LunchBaskedContent.Mutable mutable = data.toMutable();
            class_1799 selected = data.getSelected();
            class_1792 selItem = selected.method_7909();
            class_1799 copy = selected.method_46651(1);
            class_1799 result = SuppPlatformStuff.finishUsingItem(copy, level, livingEntity);
            if (livingEntity instanceof class_1657) {
                class_1657 p = (class_1657)livingEntity;
                this.maybeAddCooldowns(p, selItem);
            }
            if (success = LunchBoxItem.swapWithSelected(livingEntity, result, mutable, selected)) {
                stack.method_57379(this.getComponentType(), (Object)mutable.toImmutable());
            }
            return stack;
        }
        return super.method_7861(stack, level, livingEntity);
    }

    private void maybeAddCooldowns(class_1657 p, class_1792 item) {
        class_1796.class_1797 foodCooldown = (class_1796.class_1797)p.method_7357().field_8024.get(item);
        if (foodCooldown != null) {
            p.method_7357().method_7906((class_1792)this, foodCooldown.field_8027 - foodCooldown.field_8028);
        }
    }

    public void onStopUsing(class_1799 stack, class_1309 entity, int count) {
        LunchBaskedContent data = (LunchBaskedContent)stack.method_57824(this.getComponentType());
        if (data != null && data.canEatFrom()) {
            class_1799 selected = data.getSelected();
            SuppPlatformStuff.releaseUsingItem(selected, entity);
        }
    }

    private static boolean swapWithSelected(class_1309 livingEntity, class_1799 result, LunchBaskedContent.Mutable data, class_1799 currentStack) {
        boolean success = false;
        if (result.method_7960()) {
            data.getSelected().method_7934(1);
            success = true;
        } else if (!class_1799.method_31577((class_1799)result, (class_1799)currentStack)) {
            class_1657 p;
            data.getSelected().method_7934(1);
            class_1799 remaining = data.tryAdding(result);
            success = true;
            if (!remaining.method_7960() && livingEntity instanceof class_1657 && !(p = (class_1657)livingEntity).method_31548().method_7394(remaining)) {
                p.method_7328(remaining, false);
            }
        }
        return success;
    }

    @Override
    protected void playInsertSound(class_1297 pEntity) {
        pEntity.method_5783(ModSounds.LUNCH_BASKET_INSERT.get(), 0.8f, 0.8f + pEntity.method_37908().method_8409().method_43057() * 0.4f);
    }

    @Override
    public class_9331<LunchBaskedContent> getComponentType() {
        return ModComponents.LUNCH_BASKET_CONTENT.get();
    }

    @Override
    public int getMaxSlots() {
        return CommonConfigs.Tools.LUNCH_BOX_SLOTS.get();
    }

    @NotNull
    public static class_1799 findActiveLunchBox(class_1309 entity) {
        return LunchBoxItem.findActiveLunchBoxSlot(entity).get(entity);
    }

    @NotNull
    public static SlotReference findActiveLunchBoxSlot(class_1309 entity) {
        return SuppPlatformStuff.getFirstInInventory(entity, i -> i.method_7909() instanceof LunchBoxItem);
    }

    public static boolean canAcceptItem(class_1799 toInsert) {
        if (!toInsert.method_7909().method_31568()) {
            return false;
        }
        if (toInsert.method_31573(ModTags.LUNCH_BASKET_BLACKLIST)) {
            return false;
        }
        class_1839 animation = toInsert.method_7909().method_7853(toInsert);
        return animation == class_1839.field_8946 || animation == class_1839.field_8950;
    }
}

