/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items.components;

import com.google.common.collect.HashBiMap;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.util.math.colors.RGBColor;
import net.mehvahdjukaar.supplementaries.client.renderers.color.ColorHelper;
import net.mehvahdjukaar.supplementaries.integration.CompatObjects;
import net.minecraft.class_124;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9282;
import net.minecraft.class_9299;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class ConfettiColors
implements class_9299 {
    protected static final HashBiMap<class_1767, Integer> COLOR_TO_DIFFUSE = Arrays.stream(class_1767.values()).collect(Collectors.toMap(Function.identity(), ConfettiColors::dyeToRGB, (color, color2) -> color2, HashBiMap::create));
    public static final Codec<ConfettiColors> CODEC = Codec.INT.listOf().xmap(list -> new ConfettiColors(list.stream().mapToInt(i -> i).toArray()), colors -> colors.colors);
    public static final class_9139<class_9129, ConfettiColors> STREAM_CODEC = class_9139.method_56434((class_9139)class_9135.field_49675.method_56433(class_9135.method_56363()), v -> v.colors, ConfettiColors::new);
    public static final ConfettiColors EMPTY = new ConfettiColors(new int[0]);
    private final IntList colors;

    private static int dyeToRGB(class_1767 dyeColor) {
        return ColorHelper.prettyfyColor(new RGBColor(dyeColor.method_16357()).asHSL()).asRGB().toInt();
    }

    public static ConfettiColors of(int ... colors) {
        return new ConfettiColors(colors);
    }

    public static ConfettiColors of(class_1767 ... colors) {
        IntList list = IntList.of();
        for (class_1767 c : colors) {
            list.add(ConfettiColors.dyeToRGB(c));
        }
        return new ConfettiColors(list.toIntArray());
    }

    @Nullable
    public static Integer getRgbColor(class_1799 stack) {
        class_9282 colorComp;
        if (CompatObjects.DYE_BOTTLE.is((Object)stack.method_7909()) && (colorComp = (class_9282)stack.method_57824(class_9334.field_49644)) != null) {
            return colorComp.comp_2384();
        }
        class_1767 c = ForgeHelper.getColor((class_1799)stack);
        if (c != null) {
            return ConfettiColors.dyeToRGB(c);
        }
        return null;
    }

    ConfettiColors(List<Integer> colors) {
        this(colors.stream().mapToInt(i -> i).toArray());
    }

    ConfettiColors(int ... colors) {
        this.colors = IntList.of((int[])colors);
    }

    public Collection<Integer> getColors() {
        return this.colors;
    }

    public ConfettiColors withAddedColor(int color) {
        IntArrayList newColors = new IntArrayList();
        newColors.addAll(this.colors);
        newColors.add(color);
        return new ConfettiColors(newColors.toIntArray());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ConfettiColors)) {
            return false;
        }
        ConfettiColors that = (ConfettiColors)object;
        return Objects.equals(this.colors, that.colors);
    }

    public int hashCode() {
        return Objects.hashCode(this.colors);
    }

    public int size() {
        return this.colors.size();
    }

    public void method_57409(class_1792.class_9635 context, Consumer<class_2561> tooltipAdder, class_1836 tooltipFlag) {
        IntListIterator intListIterator = this.colors.iterator();
        while (intListIterator.hasNext()) {
            int colorInt = (Integer)intListIterator.next();
            class_1767 dye = (class_1767)COLOR_TO_DIFFUSE.inverse().get((Object)colorInt);
            if (dye != null) {
                tooltipAdder.accept((class_2561)class_2561.method_43471((String)("color.minecraft." + dye.method_7792())).method_27692(class_124.field_1080));
                continue;
            }
            if (tooltipFlag.method_8035()) {
                tooltipAdder.accept((class_2561)class_2561.method_43469((String)"item.color", (Object[])new Object[]{String.format(Locale.ROOT, "#%06X", colorInt)}).method_27692(class_124.field_1080));
                continue;
            }
            tooltipAdder.accept((class_2561)class_2561.method_43471((String)"item.dyed").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}));
        }
    }
}

