/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.worldgen.ISpawnBoxStructure;
import net.mehvahdjukaar.moonlight.api.worldgen.SpawnBoxSettings;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModWorldgen;
import net.minecraft.class_124;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2582;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3778;
import net.minecraft.class_3785;
import net.minecraft.class_3902;
import net.minecraft.class_5434;
import net.minecraft.class_5539;
import net.minecraft.class_5742;
import net.minecraft.class_6544;
import net.minecraft.class_6880;
import net.minecraft.class_7138;
import net.minecraft.class_7151;
import net.minecraft.class_7446;
import net.minecraft.class_7871;
import net.minecraft.class_8891;
import net.minecraft.class_9307;
import net.minecraft.class_9334;
import net.minecraft.class_9778;
import net.minecraft.class_9822;
import org.jetbrains.annotations.NotNull;

public class GalleonStructure
extends class_3195
implements ISpawnBoxStructure {
    public static final MapCodec<GalleonStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)GalleonStructure.method_42697((RecordCodecBuilder.Instance)instance), (App)class_3785.field_24954.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)class_2960.field_25139.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.INT.optionalFieldOf("y_offset", (Object)0).forGetter(structure -> structure.yOffset), (App)class_6544.class_4762.field_24679.optionalFieldOf("biome_point").forGetter(structure -> structure.biomePoint), (App)Codec.BOOL.optionalFieldOf("require_sea_level", (Object)true).forGetter(structure -> structure.requireSeaLevel), (App)class_9778.field_51952.optionalFieldOf("dimension_padding", (Object)class_5434.field_51911).forGetter(structure -> structure.dimensionPadding), (App)class_9822.field_52239.optionalFieldOf("liquid_settings", (Object)class_5434.field_52235).forGetter(structure -> structure.liquidSettings), (App)SpawnBoxSettings.CODEC.optionalFieldOf("spawn_boxes", (Object)SpawnBoxSettings.EMPTY).forGetter(structure -> structure.spawnBoxSettings)).apply((Applicative)instance, GalleonStructure::new));
    private final class_6880<class_3785> startPool;
    private final Optional<class_2960> startJigsawName;
    private final int yOffset;
    private final Optional<class_6544.class_4762> biomePoint;
    private final boolean requireSeaLevel;
    private final class_9778 dimensionPadding;
    private final class_9822 liquidSettings;
    private final SpawnBoxSettings spawnBoxSettings;
    private static final class_2561 OMINOUS_FLAG_PATTERN_NAME = class_2561.method_43471((String)"block.supplementaries.ominous_flag").method_27692(class_124.field_1065);

    public GalleonStructure(class_3195.class_7302 config, class_6880<class_3785> startPool, Optional<class_2960> startJigsawName, int yOffset, Optional<class_6544.class_4762> biomePoint, boolean requireSeaLevel, class_9778 dimensionPadding, class_9822 liquidSettings, SpawnBoxSettings spawnBoxSettings) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.yOffset = yOffset;
        this.biomePoint = biomePoint;
        this.requireSeaLevel = requireSeaLevel;
        this.dimensionPadding = dimensionPadding;
        this.liquidSettings = liquidSettings;
        this.spawnBoxSettings = spawnBoxSettings;
    }

    public class_7151<?> method_41618() {
        return ModWorldgen.GALLEON_STRUCTURE.get();
    }

    @NotNull
    public SpawnBoxSettings ml$getSpawnBoxSettings() {
        return this.spawnBoxSettings;
    }

    public Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        Optional<class_2338> suitablePosition = this.getSuitablePosition(context);
        if (suitablePosition.isEmpty()) {
            return Optional.empty();
        }
        class_2338 blockPos = suitablePosition.get();
        return class_3778.method_30419((class_3195.class_7149)context, this.startPool, this.startJigsawName, (int)10, (class_2338)blockPos, (boolean)false, Optional.empty(), (int)64, (class_8891)class_8891.field_46826, (class_9778)this.dimensionPadding, (class_9822)this.liquidSettings);
    }

    private Optional<class_2338> getSuitablePosition(class_3195.class_7149 context) {
        class_1923 chunkPos = context.comp_568();
        class_2794 generator = context.comp_562();
        class_5539 levelHeightAccessor = context.comp_569();
        class_7138 randomState = context.comp_564();
        int x = chunkPos.method_33940();
        int z = chunkPos.method_33942();
        int y = generator.method_18028(x, z, class_2902.class_2903.field_13194, levelHeightAccessor, randomState) + 1;
        int seaLevel = context.comp_562().method_16398();
        if (this.requireSeaLevel && y != seaLevel) {
            return Optional.empty();
        }
        class_6544.class_6553 paramAtPos = context.comp_564().method_42371().method_40444(class_5742.method_33100((int)x), class_5742.method_33100((int)y), class_5742.method_33100((int)z));
        if (this.biomePoint.isPresent() && !GalleonStructure.containsPoint(this.biomePoint.get(), paramAtPos)) {
            return Optional.empty();
        }
        return Optional.of(new class_2338(x, y + this.yOffset, z));
    }

    private static boolean containsPoint(class_6544.class_4762 cube, class_6544.class_6553 point) {
        return cube.comp_107().comp_103() <= point.comp_114() && cube.comp_107().comp_104() >= point.comp_114() && cube.comp_108().comp_103() <= point.comp_115() && cube.comp_108().comp_104() >= point.comp_115() && cube.comp_105().comp_103() <= point.comp_112() && cube.comp_105().comp_104() >= point.comp_112() && cube.comp_106().comp_103() <= point.comp_113() && cube.comp_106().comp_104() >= point.comp_113() && cube.comp_110().comp_103() <= point.comp_117() && cube.comp_110().comp_104() >= point.comp_117() && cube.comp_109().comp_103() <= point.comp_116() && cube.comp_109().comp_104() >= point.comp_116();
    }

    public static class_1799 getGalleonFlag(class_7871<class_2582> patternRegistry) {
        class_1799 itemStack = new class_1799((class_1935)ModRegistry.FLAGS.get(class_1767.field_7952).get());
        class_9307 bannerPatternLayers = new class_9307.class_3750().method_58124(patternRegistry, class_7446.field_39176, class_1767.field_7942).method_58124(patternRegistry, class_7446.field_39158, class_1767.field_7944).method_58124(patternRegistry, class_7446.field_39170, class_1767.field_7944).method_58124(patternRegistry, class_7446.field_39169, class_1767.field_7944).method_58124(patternRegistry, class_7446.field_39166, class_1767.field_7963).method_58124(patternRegistry, class_7446.field_39138, class_1767.field_7944).method_58124(patternRegistry, class_7446.field_39140, class_1767.field_7963).method_57573();
        itemStack.method_57379(class_9334.field_49619, (Object)bannerPatternLayers);
        itemStack.method_57379(class_9334.field_49638, (Object)class_3902.field_17274);
        itemStack.method_57379(class_9334.field_50239, (Object)OMINOUS_FLAG_PATTERN_NAME);
        return itemStack;
    }

    public static class Type
    implements class_7151<GalleonStructure> {
        public MapCodec<GalleonStructure> codec() {
            return CODEC;
        }
    }
}

