/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.worldgen;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.util.math.CircularGridUtils;
import net.mehvahdjukaar.moonlight.api.util.math.Vec2i;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.worldgen.FairRingIterator;
import net.mehvahdjukaar.supplementaries.common.worldgen.LocatedStructure;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2806;
import net.minecraft.class_2810;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3449;
import net.minecraft.class_4076;
import net.minecraft.class_4538;
import net.minecraft.class_5138;
import net.minecraft.class_6833;
import net.minecraft.class_6862;
import net.minecraft.class_6871;
import net.minecraft.class_6872;
import net.minecraft.class_6874;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7869;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructureLocator {
    @Nullable
    public static LocatedStructure findNearestStructure(class_3218 level, @NotNull class_6885<class_3195> targetStructures, class_2338 searchCenter, int maximumChunkSearchRadius, boolean findNewlyGeneratedOnly, int maxStructuresToConsider, boolean stopSearchWhenFound) {
        List<LocatedStructure> foundStructures = StructureLocator.findNearestStructures(level, targetStructures, searchCenter, maximumChunkSearchRadius, findNewlyGeneratedOnly, 1, maxStructuresToConsider, stopSearchWhenFound);
        if (!foundStructures.isEmpty()) {
            return foundStructures.get(0);
        }
        return null;
    }

    public static List<LocatedStructure> findNearestStructures(class_3218 level, @NotNull class_6862<class_3195> structureTag, class_2338 searchCenter, int maximumChunkSearchRadius, boolean findNewlyGeneratedOnly, int requiredStructureCount, int maxStructuresToConsider, boolean stopSearchWhenFound) {
        class_6885 targetStructures = level.method_30349().method_30530(class_7924.field_41246).method_40266(structureTag).orElse(null);
        return StructureLocator.findNearestStructures(level, (class_6885<class_3195>)targetStructures, searchCenter, maximumChunkSearchRadius, findNewlyGeneratedOnly, requiredStructureCount, maxStructuresToConsider, stopSearchWhenFound);
    }

    public static List<LocatedStructure> findNearestStructures(class_3218 level, class_6885<class_3195> targetStructureSet, class_2338 searchCenter, int maximumChunkSearchRadius, boolean findNewlyGeneratedOnly, int requiredStructureCount, int maxStructuresToConsider, boolean stopSearchWhenFound) {
        if (targetStructureSet == null) {
            return List.of();
        }
        if (targetStructureSet.method_40247() > maxStructuresToConsider) {
            ArrayList structureList = new ArrayList(targetStructureSet.method_40239().toList());
            Collections.shuffle(structureList);
            targetStructureSet = class_6885.method_40242(structureList.subList(0, maxStructuresToConsider));
        }
        List<LocatedStructure> foundStructures = new ArrayList<LocatedStructure>();
        if (!level.method_8503().method_27728().method_28057().method_28029()) {
            return foundStructures;
        }
        if (targetStructureSet.method_40247() == 0) {
            Supplementaries.LOGGER.error("Found empty target structures for structure map. It's likely some mod broke some vanilla tag. Check your logs!");
            return foundStructures;
        }
        List selectedStructures = targetStructureSet.method_40239().toList();
        class_2794 chunkGenerator = level.method_14178().method_12129();
        double closestDistanceSquared = Double.MAX_VALUE;
        selectedStructures = new ArrayList(selectedStructures);
        Collections.shuffle(selectedStructures);
        Supplementaries.LOGGER.info("Searching for closest structure among {} from position {}", (Object)Arrays.toString(selectedStructures.stream().map(class_6880::method_55840).toArray()), (Object)searchCenter);
        Object2ObjectArrayMap structuresByPlacement = new Object2ObjectArrayMap();
        class_7869 structureState = level.method_14178().method_46642();
        for (class_6880 structureHolder : selectedStructures) {
            for (class_6874 class_68742 : structureState.method_46708(structureHolder)) {
                structuresByPlacement.computeIfAbsent(class_68742, p -> new ObjectArraySet()).add(structureHolder);
            }
        }
        if (structuresByPlacement.isEmpty()) {
            return foundStructures;
        }
        Int2ObjectAVLTreeMap spreadToStructures = new Int2ObjectAVLTreeMap();
        class_5138 structureManager = level.method_27056();
        for (Map.Entry entry : structuresByPlacement.entrySet()) {
            class_6874 placement = (class_6874)entry.getKey();
            if (placement instanceof class_6871) {
                double distanceSquared;
                class_6871 ringsPlacement = (class_6871)placement;
                Pair foundStructurePair = chunkGenerator.method_40148((Set)entry.getValue(), level, structureManager, searchCenter, findNewlyGeneratedOnly, ringsPlacement);
                if (foundStructurePair == null || !((distanceSquared = searchCenter.method_10262((class_2382)foundStructurePair.getFirst())) < closestDistanceSquared)) continue;
                closestDistanceSquared = distanceSquared;
                foundStructures.add(new LocatedStructure((class_2338)foundStructurePair.getFirst(), (class_6880<class_3195>)((class_6880)foundStructurePair.getSecond()), null, distanceSquared));
                continue;
            }
            if (!(placement instanceof class_6872)) continue;
            class_6872 randomPlacement = (class_6872)placement;
            int spacing = randomPlacement.method_41632();
            List list = (List)spreadToStructures.computeIfAbsent(spacing, s -> new ArrayList());
            for (class_6880 struct : (Set)entry.getValue()) {
                list.add(new StructureAndPlacement((class_6880<class_3195>)struct, randomPlacement));
            }
        }
        if (!spreadToStructures.isEmpty()) {
            int centerChunkX = class_4076.method_18675((int)searchCenter.method_10263());
            int n = class_4076.method_18675((int)searchCenter.method_10260());
            long worldSeed = level.method_8412();
            class_5138 manager = level.method_27056();
            FairRingIterator ringIterator = new FairRingIterator(new ArrayList<Integer>((Collection<Integer>)spreadToStructures.keySet()), maximumChunkSearchRadius, true);
            int lastIteration = 0;
            ArrayList<Pair<class_1923, StructureAndPlacement>> candidatePosThisIteration = new ArrayList<Pair<class_1923, StructureAndPlacement>>();
            block4: while (ringIterator.hasNext()) {
                boolean useLessPreciseSearch;
                FairRingIterator.Ring ring = ringIterator.next();
                int gridScale = ring.gridSize();
                List placementsInGrid = (List)spreadToStructures.get(gridScale);
                int radius = ring.radius();
                boolean bl = useLessPreciseSearch = stopSearchWhenFound || radius * 16 > 2000;
                if (lastIteration != ring.commonIterationsIndex()) {
                    lastIteration = ring.commonIterationsIndex();
                    StructureLocator.flushCandidates(level, searchCenter, findNewlyGeneratedOnly, candidatePosThisIteration, manager, foundStructures);
                    if (foundStructures.size() >= requiredStructureCount) break;
                }
                Iterator cellsInRing = CircularGridUtils.iterateInRing((int)0, (int)0, (int)radius, (int)gridScale);
                while (cellsInRing.hasNext()) {
                    Vec2i cell = (Vec2i)cellsInRing.next();
                    for (StructureAndPlacement placementInfo : placementsInGrid) {
                        class_6872 placement = placementInfo.placement;
                        class_6880<class_3195> structure = placementInfo.structure;
                        int potentialChunkX = centerChunkX + cell.x();
                        int potentialChunkZ = n + cell.y();
                        class_1923 structureChunk = placement.method_40169(worldSeed, potentialChunkX, potentialChunkZ);
                        candidatePosThisIteration.add((Pair<class_1923, StructureAndPlacement>)Pair.of((Object)structureChunk, (Object)new StructureAndPlacement(structure, placement)));
                    }
                    if (!useLessPreciseSearch) continue;
                    StructureLocator.flushCandidates(level, searchCenter, findNewlyGeneratedOnly, candidatePosThisIteration, manager, foundStructures);
                    if (foundStructures.size() < requiredStructureCount) continue;
                    break block4;
                }
            }
            StructureLocator.flushCandidates(level, searchCenter, findNewlyGeneratedOnly, candidatePosThisIteration, manager, foundStructures);
        }
        foundStructures.sort(Comparator.comparingDouble(LocatedStructure::distSqrt));
        if (foundStructures.size() >= requiredStructureCount) {
            foundStructures = (List)Lists.partition(foundStructures, (int)requiredStructureCount).getFirst();
        }
        if (findNewlyGeneratedOnly) {
            for (LocatedStructure locatedStructure : foundStructures) {
                if (locatedStructure.start() == null || !locatedStructure.start().method_14979()) continue;
                structureManager.method_39784(locatedStructure.start());
            }
        }
        Supplementaries.LOGGER.info("\n Structure locator found {} structures: \n{}", (Object)foundStructures.size(), (Object)String.join((CharSequence)"\n", (CharSequence[])foundStructures.stream().map(LocatedStructure::toString).toArray(CharSequence[]::new)));
        return foundStructures;
    }

    private static void flushCandidates(class_3218 level, class_2338 searchCenter, boolean findNewlyGeneratedOnly, List<Pair<class_1923, StructureAndPlacement>> candidatePosThisIteration, class_5138 manager, List<LocatedStructure> found) {
        Iterator<Pair<class_1923, StructureAndPlacement>> iterator = candidatePosThisIteration.iterator();
        while (iterator.hasNext()) {
            Pair<class_1923, StructureAndPlacement> entry;
            class_6880<class_3195> structure = ((StructureAndPlacement)entry.getSecond()).structure;
            class_6872 placement = ((StructureAndPlacement)entry.getSecond()).placement;
            entry = iterator.next();
            class_1923 chunkPos = (class_1923)entry.getFirst();
            LocatedStructure located = StructureLocator.getStructureThatWillSpawnAt(structure, (class_4538)level, manager, findNewlyGeneratedOnly, placement, chunkPos, searchCenter);
            if (located == null) continue;
            found.add(located);
        }
        candidatePosThisIteration.clear();
    }

    @Nullable
    private static LocatedStructure getStructureThatWillSpawnAt(class_6880<class_3195> targetStructures, class_4538 level, class_5138 structureManager, boolean skipKnownStructures, class_6872 placement, class_1923 chunkPosition, class_2338 searchCenter) {
        LocatedStructure foundStructures = null;
        class_6833 checkResult = structureManager.method_39783(chunkPosition, (class_3195)targetStructures.comp_349(), (class_6874)placement, skipKnownStructures);
        if (checkResult != class_6833.field_36240) {
            if (!skipKnownStructures && checkResult == class_6833.field_36239) {
                foundStructures = LocatedStructure.relativeTo(placement.method_41636(chunkPosition), targetStructures, null, searchCenter);
            } else {
                class_2791 chunk = level.method_22342(chunkPosition.field_9181, chunkPosition.field_9180, class_2806.field_16423);
                class_3449 structureStart = structureManager.method_26975(class_4076.method_33705((class_2791)chunk), (class_3195)targetStructures.comp_349(), (class_2810)chunk);
                if (structureStart != null && structureStart.method_16657() && (!skipKnownStructures || structureStart.method_14979())) {
                    foundStructures = LocatedStructure.relativeTo(placement.method_41636(structureStart.method_34000()), targetStructures, structureStart, searchCenter);
                }
            }
        }
        if (foundStructures != null) {
            // empty if block
        }
        return foundStructures;
    }

    @Nullable
    public class_2338 findRandomStructure(class_6862<class_3195> structureTag, class_2338 searchCenter, int searchRadius, boolean findUnexploredOnly, class_3218 level) {
        if (!level.method_8503().method_27728().method_28057().method_28029()) {
            return null;
        }
        Optional structureSet = level.method_30349().method_30530(class_7924.field_41246).method_40266(structureTag);
        if (structureSet.isEmpty()) {
            return null;
        }
        class_6885.class_6888 structures = (class_6885.class_6888)structureSet.get();
        List structureList = structures.method_40239().toList();
        class_6880 chosenStructure = (class_6880)structureList.get(level.field_9229.method_43048(structureList.size()));
        Pair foundPair = level.method_14178().method_12129().method_12103(level, (class_6885)class_6885.method_40246((class_6880[])new class_6880[]{chosenStructure}), searchCenter, searchRadius, findUnexploredOnly);
        return foundPair != null ? (class_2338)foundPair.getFirst() : null;
    }

    private record StructureAndPlacement(class_6880<class_3195> structure, class_6872 placement) {
    }
}

