/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.integration;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.block.IBlockHolder;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BambooSpikesBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BambooSpikesBlockTile;
import net.mehvahdjukaar.supplementaries.common.items.JarItem;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.fabric.QuarkCompatImpl;
import net.mehvahdjukaar.supplementaries.integration.quark.TaterInAJarBlock;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.RegUtils;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1621;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1838;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9701;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.addons.oddities.block.be.MagnetizedBlockBlockEntity;
import org.violetmoon.quark.addons.oddities.block.be.TinyPotatoBlockEntity;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.automation.module.PistonsMoveTileEntitiesModule;
import org.violetmoon.quark.content.building.block.StoolBlock;
import org.violetmoon.quark.content.client.module.UsesForCursesModule;
import org.violetmoon.quark.content.management.module.ExpandedItemInteractionsModule;
import org.violetmoon.quark.content.tools.module.SlimeInABucketModule;
import org.violetmoon.quark.content.tweaks.module.DoubleDoorOpeningModule;
import org.violetmoon.quark.content.tweaks.module.EnhancedLaddersModule;
import org.violetmoon.quark.content.tweaks.module.MoreBannerLayersModule;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.load.ZGatherAdvancementModifiers;
import org.violetmoon.zeta.util.ItemNBTHelper;

public class QuarkCompat {
    public static final String TATER_IN_A_JAR_NAME = "tater_in_a_jar";
    public static final Supplier<class_2248> TATER_IN_A_JAR = RegUtils.regWithItem("tater_in_a_jar", TaterInAJarBlock::new, new class_1792.class_1793().method_7894(class_1814.field_8907));
    public static final Supplier<class_2591<TaterInAJarBlock.Tile>> TATER_IN_A_JAR_TILE = RegUtils.regTile("tater_in_a_jar", () -> class_2591.class_2592.method_20528(TaterInAJarBlock.Tile::new, (class_2248[])new class_2248[]{TATER_IN_A_JAR.get()}).method_11034(null));
    public static final Supplier<class_1792> CARTOGRAPHERS_QUILL = null;
    private static Boolean oldFenceValue = null;

    public static void init() {
        Quark.ZETA.loadBus.subscribe(QuarkCompat.class);
    }

    @LoadEvent
    public static void gatherAdvModifiersEvent(ZGatherAdvancementModifiers event) {
        if (CommonConfigs.Tools.CANDY_ENABLED.get().booleanValue()) {
            event.register(event.createBalancedDietMod(Set.of((class_1935)ModRegistry.CANDY_ITEM.get())));
        }
        if (CommonConfigs.Functional.SACK_PENALTY.get().booleanValue() && CommonConfigs.Functional.SACK_ENABLED.get().booleanValue()) {
            event.register(event.createFuriousCocktailMod(() -> false, Set.of((class_1291)ModRegistry.OVERENCUMBERED.get())));
        }
        if (CommonConfigs.Functional.FLAX_ENABLED.get().booleanValue()) {
            event.register(event.createASeedyPlaceMod(Set.of(ModRegistry.FLAX.get())));
        }
    }

    public static boolean isFastSlideModuleEnabled() {
        return Quark.ZETA.modules.isEnabled(EnhancedLaddersModule.class) && EnhancedLaddersModule.allowSliding;
    }

    public static boolean isDoubleDoorEnabled() {
        return Quark.ZETA.modules.isEnabled(DoubleDoorOpeningModule.class);
    }

    public static boolean canMoveBlockEntity(class_2680 state) {
        return !PistonsMoveTileEntitiesModule.shouldMoveTE((boolean)true, (class_2680)state);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static float getEncumbermentFromBackpack(class_1799 stack) {
        return QuarkCompatImpl.getEncumbermentFromBackpack(stack);
    }

    public static boolean shouldHideOverlay(class_1799 stack) {
        return UsesForCursesModule.staticEnabled && class_1890.method_60142((class_1799)stack, (class_9331)class_9701.field_51655);
    }

    public static int getBannerPatternLimit(int current) {
        return MoreBannerLayersModule.getLimit((int)current);
    }

    public static void tickPiston(class_1937 level, class_2338 pos, class_2680 spikes, class_238 pistonBB, boolean sameDir, class_2586 movingTile) {
        List list = level.method_8335(null, pistonBB);
        for (class_1297 entity : list) {
            class_2586 class_25862;
            class_238 entityBB;
            class_1657 player;
            if (entity instanceof class_1657 && (player = (class_1657)entity).method_7337()) {
                return;
            }
            if (!(entity instanceof class_1309)) continue;
            class_1309 livingEntity = (class_1309)entity;
            if (!entity.method_5805() || !pistonBB.method_994(entityBB = entity.method_5829())) continue;
            if (CompatHandler.QUARK && (class_25862 = QuarkCompat.getMovingBlockEntity(pos, spikes, level)) instanceof BambooSpikesBlockTile) {
                IBlockHolder te;
                class_2680 state;
                BambooSpikesBlockTile tile = (BambooSpikesBlockTile)class_25862;
                if (tile.interactWithEntity(livingEntity, level) && movingTile instanceof IBlockHolder && (state = (te = (IBlockHolder)movingTile).getHeldBlock()).method_26204() instanceof BambooSpikesBlock) {
                    te.setHeldBlock((class_2680)state.method_11657((class_2769)BambooSpikesBlock.TIPPED, (Comparable)Boolean.valueOf(false)));
                }
                PistonsMoveTileEntitiesModule.setMovingBlockEntityData((class_1937)level, (class_2338)pos, (class_2487)tile.method_38242((class_7225.class_7874)level.method_30349()));
            }
            entity.method_5643(BambooSpikesBlock.getDamageSource(level), sameDir ? 3.0f : 1.0f);
        }
    }

    public static class_2586 getMovingBlockEntity(class_2338 pos, class_2680 state, class_1937 level) {
        class_2248 class_22482 = state.method_26204();
        if (!(class_22482 instanceof class_2343)) {
            return null;
        }
        class_2343 eb = (class_2343)class_22482;
        class_2586 tile = eb.method_10123(pos, state);
        if (tile == null) {
            return null;
        }
        class_2487 tileTag = PistonsMoveTileEntitiesModule.getMovingBlockEntityData((class_1937)level, (class_2338)pos);
        if (tileTag != null && tile.method_11017() == class_7923.field_41181.method_10223(class_2960.method_12829((String)tileTag.method_10558("id")))) {
            tile.method_58690(tileTag, (class_7225.class_7874)level.method_30349());
        }
        return tile;
    }

    public static class_1269 tryCaptureTater(JarItem item, class_1838 context) {
        class_1799 stack;
        TinyPotatoBlockEntity te;
        class_2338 pos = context.method_8037();
        class_1937 world = context.method_8045();
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof TinyPotatoBlockEntity && (te = (TinyPotatoBlockEntity)class_25862).getType() != TATER_IN_A_JAR_TILE.get() && !(stack = context.method_8041()).method_57826(class_9334.field_49611)) {
            if (!world.field_9236) {
                class_1657 player = context.method_8036();
                item.playCatchSound(player);
                class_1799 returnItem = new class_1799((class_1935)TATER_IN_A_JAR.get());
                if (te.hasCustomName()) {
                    returnItem.method_57379(class_9334.field_49631, (Object)te.getCustomName());
                }
                Utils.swapItemNBT((class_1657)player, (class_1268)context.method_20287(), (class_1799)stack, (class_1799)returnItem);
                world.method_8650(pos, false);
            }
            return class_1269.method_29236((boolean)world.field_9236);
        }
        return class_1269.field_5811;
    }

    public static class_2680 getMagnetStateForFlintBlock(class_2586 be, class_2350 dir) {
        MagnetizedBlockBlockEntity magnet;
        if (be instanceof MagnetizedBlockBlockEntity && dir == (magnet = (MagnetizedBlockBlockEntity)be).getFacing()) {
            return magnet.getMagnetState();
        }
        return null;
    }

    public static class_1799 getSlimeBucket(class_1297 entity) {
        if (Quark.ZETA.modules.isEnabled(SlimeInABucketModule.class) && entity.method_5864() == class_1299.field_6069 && ((class_1621)entity).method_7152() == 1 && entity.method_5805()) {
            class_1799 outStack = new class_1799((class_1935)SlimeInABucketModule.slime_in_a_bucket);
            class_2487 cmp = new class_2487();
            entity.method_5662(cmp);
            ItemNBTHelper.setCompound((class_1799)outStack, (String)"slime_nbt", (class_2487)cmp);
            return outStack;
        }
        return class_1799.field_8037;
    }

    public static boolean isShulkerDropInOn() {
        return Quark.ZETA.modules.isEnabled(ExpandedItemInteractionsModule.class) && ExpandedItemInteractionsModule.enableShulkerBoxInteraction;
    }

    public static boolean tryRotateStool(class_1937 level, class_2680 state, class_2338 pos) {
        if (state.method_26204() instanceof StoolBlock) {
            level.method_8501(pos, (class_2680)state.method_28493((class_2769)StoolBlock.BIG));
            return true;
        }
        return false;
    }

    public static class_1799 makeAdventurerQuill(class_3218 serverLevel, @Nullable class_6862<class_3195> destination, int radius, boolean skipKnown, int zoom, class_2960 destinationType, @Nullable String name, int color) {
        class_6885 targets = null;
        if (destination != null) {
            Optional v = serverLevel.method_30349().method_30530(class_7924.field_41246).method_40266(destination);
            if (v.isEmpty()) {
                return class_1799.field_8037;
            }
            targets = (class_6885)v.get();
        }
        return QuarkCompat.makeAdventurerQuill(serverLevel, targets, radius, skipKnown, zoom, destinationType, name, color);
    }

    public static class_1799 makeAdventurerQuill(class_3218 serverLevel, class_6885<class_3195> targets, int radius, boolean skipKnown, int zoom, class_2960 destinationType, @Nullable String name, int color) {
        return null;
    }

    public static void disableFenceGateStuff() {
        oldFenceValue = DoubleDoorOpeningModule.enableFenceGates;
    }

    public static void enableFenceGateStuff() {
        if (oldFenceValue != null) {
            DoubleDoorOpeningModule.enableFenceGates = oldFenceValue;
        }
    }

    public static boolean isGoldBarsOn() {
        return true;
    }
}

